/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.wizard;

import java.awt.BorderLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;
import org.netbeans.modules.distributed.remotefs.propertyeditor.FileEditor;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteMultipleRootPanel;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteRootJPanel;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteRootPanel;
import org.openide.util.NbBundle;

public class RemoteRootVisualPanel
extends RemoteRootJPanel
implements PropertyChangeListener {
    private final RemoteRootPanel panel;

    public RemoteRootVisualPanel(RemoteRootPanel panel, FileSystemView fsv) {
        super("Network Drive Root", "Remote Root", "Remote Directory:", fsv);
        this.panel = panel;
        this.setName(NbBundle.getMessage(RemoteRootJPanel.class, (String)"TITLE_remote_root"));
    }

    public RemoteRootVisualPanel(RemoteRootPanel panel) {
        super("Network Drive Root", "Remote Root", "Remote Directory:");
        this.panel = panel;
        this.setName(NbBundle.getMessage(RemoteRootJPanel.class, (String)"TITLE_remote_root"));
    }

    public RemoteRootVisualPanel(RemoteMultipleRootPanel panel, boolean hide, boolean editable) {
        super("Network Drive Root", "Remote Root", "Remote Directory:", hide, false, null);
        this.panel = panel;
        if (!editable) {
            FileEditor.recursiveDisableComponentStatic(this, false);
        }
        this.setName(NbBundle.getMessage(RemoteRootJPanel.class, (String)"TITLE_remote_root"));
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public void propertyChange(PropertyChangeEvent e) {
        boolean update = false;
        String prop = e.getPropertyName();
        if ("directoryChanged".equals(prop) || "SelectedFileChangedProperty".equals(prop) || prop.equals("ancestor")) {
            JFileChooser fileChooser = this.getFileChooser();
            File selFile = "directoryChanged".equals(prop) ? fileChooser.getCurrentDirectory() : ("SelectedFileChangedProperty".equals(prop) ? fileChooser.getSelectedFile() : fileChooser.getCurrentDirectory());
            if (selFile == null) {
                this.panel.fireChangeState();
                return;
            }
            this.getTextField().setText("");
            String remoteDir = this.panel.getRemoteDirectory(selFile.getAbsolutePath());
            if (!remoteDir.equals("")) {
                this.getTextField().setText(remoteDir);
            }
            this.panel.fireChangeState();
        }
    }

    public void createRemoteDirectory() {
        this.getFileChooser().addPropertyChangeListener(this);
        this.getTextField().addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RemoteRootVisualPanel.this.panel.fireChangeState();
                    }
                });
            }
        });
    }
}

