/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.remotefs.ftpfs.DisconnectCallBack;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPDialogs;
import org.netbeans.modules.distributed.remotefs.ftpfs.LogInfo;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteClient;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileAttributes;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileName;
import org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient.FTPException;
import org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient.FTPFileAttributes;
import org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient.FTPFileName;
import org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient.FTPLogInfo;
import org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient.FTPResponse;

public class FTPClient
implements RemoteClient {
    private static final FTPFileAttributes[] EMPTY_LIST = new FTPFileAttributes[0];
    private BufferedReader in;
    private BufferedOutputStream out;
    private PrintWriter log = null;
    private File logfile = null;
    private RandomAccessFile rafile = null;
    private Socket socket;
    private ServerSocket serversocket;
    private FTPResponse response;
    private String host;
    private int port;
    private String user;
    private char[] password;
    private String serversystem = null;
    private boolean connected = false;
    private boolean passiveMode = false;
    private boolean sshForward = false;
    private String rwd;
    private DisconnectCallBack dc;
    public static final int DEFAULT_PORT = 21;
    private static final int BUFFER = 1024;
    private int TIMEOUT = 300000;
    private static FTPFileName remoteRootName;
    private static final String VMS_DIR = "dir;";
    private Object lock;
    private boolean isMultiNet;
    private static List failedAttempts;

    public FTPClient(FTPLogInfo loginfo, String rwd, DisconnectCallBack dc) {
        this.host = loginfo.getHost();
        this.port = loginfo.getPort();
        this.user = loginfo.getUser();
        this.password = loginfo.getPassword();
        this.rwd = rwd;
        this.dc = dc;
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToFailedAttempts(String host, String user) {
        List list = failedAttempts;
        synchronized (list) {
            failedAttempts.add(host.toLowerCase() + user.toLowerCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFromFailedAttempts(String host, String user) {
        List list = failedAttempts;
        synchronized (list) {
            failedAttempts.remove(host.toLowerCase() + user.toLowerCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsInFailedAttempts(String host, String user) {
        List list = failedAttempts;
        synchronized (list) {
            return failedAttempts.contains(host.toLowerCase() + user.toLowerCase());
        }
    }

    public void setSocketTimeout(int timeout) {
        this.TIMEOUT = timeout;
    }

    public int compare(LogInfo loginfo) {
        return -1;
    }

    private void writeLog(StringBuffer text) {
        if (this.log != null) {
            this.log.println(new Date().toString() + " " + text.toString());
            this.log.flush();
        }
    }

    private void writeLog(String text) {
        if (this.log != null) {
            this.log.println(new Date().toString() + " " + text);
            this.log.flush();
        }
    }

    public void setLog(PrintWriter log) {
        this.log = log;
    }

    public void setLog(OutputStream log) {
        this.log = new PrintWriter(new OutputStreamWriter(log));
        this.log.println("\n---------------------------------------------------------------------------\nFTP Log Session: " + new Date().toString() + "\n---------------------------------------------------------------------------");
    }

    public void setLog(File logfile) throws IOException {
        if (!logfile.exists()) {
            logfile.createNewFile();
        }
        this.logfile = logfile;
    }

    public boolean isPassiveMode() {
        return this.passiveMode;
    }

    public void setPassiveMode(boolean passiveMode) {
        this.passiveMode = passiveMode;
    }

    public boolean isSSHForward() {
        return this.sshForward;
    }

    public void setSSHForward(boolean sshForward) {
        this.sshForward = sshForward;
    }

    protected FTPResponse getResponse() {
        return this.response;
    }

    protected void setResponse() throws IOException {
        this.response = new FTPResponse(this.in);
        this.response.writeLog(this.log);
    }

    protected void setResponse(BufferedReader in) throws IOException {
        this.response = new FTPResponse(in);
        this.response.writeLog(this.log);
    }

    protected boolean isUnixType() {
        if (this.serversystem != null) {
            return this.serversystem.toUpperCase().startsWith("UNIX TYPE: L8");
        }
        return false;
    }

    protected boolean isVMSType() {
        if (this.serversystem != null) {
            return this.serversystem.toUpperCase().startsWith("VMS");
        }
        return false;
    }

    protected boolean isMultiNet() {
        return this.isMultiNet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteFileName getRoot() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isVMSType() && this.isConnected()) {
                try {
                    this.pwd();
                    FTPResponse ftpResp = this.getResponse();
                    if (ftpResp.isPositiveCompletion()) {
                        String respStr = ftpResp.getResponse();
                        respStr = respStr.substring(respStr.indexOf(34) + 1, respStr.lastIndexOf(34));
                        String unixRespStr = FileUtility.openVMSPathToUnixPath(respStr, true);
                        remoteRootName = new FTPFileName("", unixRespStr, true);
                        return remoteRootName;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return FTPFileName.getRoot();
        }
    }

    private void keepConnectionAlive() {
        Thread thr = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block7: {
                    try {
                        while (true) {
                            Object object = FTPClient.this.lock;
                            synchronized (object) {
                                if (!FTPClient.this.connected) {
                                    break block7;
                                }
                                FTPClient.this.processSimpleCommand("NOOP", false);
                            }
                            Thread.currentThread();
                            Thread.sleep(60000L);
                        }
                    }
                    catch (Exception e) {}
                    {
                    }
                }
            }
        };
        thr.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (FTPClient.containsInFailedAttempts(this.host, this.user)) {
                return;
            }
            if (this.log == null && this.logfile != null) {
                this.rafile = new RandomAccessFile(this.logfile, "rw");
                this.rafile.seek(this.rafile.length());
                this.setLog(new FileOutputStream(this.rafile.getFD()));
            }
            try {
                this.socket = new Socket(this.isSSHForward() ? "localhost" : this.host, this.port);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
            this.socket.setSoTimeout(this.TIMEOUT);
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.out = new BufferedOutputStream(this.socket.getOutputStream());
            this.setResponse();
            while (this.getResponse().isPositivePreliminary()) {
                this.setResponse();
            }
            if (!this.getResponse().isPositiveCompletion()) {
                throw new FTPException(this.getResponse());
            }
            try {
                this.login();
            }
            catch (FTPException e) {
                if (e.getResponse().getCode() == 530) {
                    FTPClient.addToFailedAttempts(this.host, this.user);
                }
                throw e;
            }
            this.ascii();
            this.cwd(this.rwd);
            this.keepConnectionAlive();
        }
    }

    private void reconnect() throws IOException {
        this.close();
        this.connect();
    }

    private StringBuffer toLowerCase(StringBuffer s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < 'A' || c > 'Z') continue;
            s.setCharAt(i, Character.toLowerCase(c));
        }
        return s;
    }

    protected void sendCommand(StringBuffer command) throws IOException {
        for (int i = 0; i < command.length(); ++i) {
            this.out.write(command.charAt(i));
        }
        this.out.write(10);
        this.out.flush();
        this.toLowerCase(command);
        if (command.substring(0, 4).startsWith("pass")) {
            this.writeLog("PASS *****");
        } else {
            this.writeLog(command);
        }
        this.setResponse();
    }

    protected void processSimpleCommand(StringBuffer command, boolean retry) throws IOException {
        this.processSimpleCommand(command, 2, retry);
    }

    protected void processSimpleCommand(String command, boolean retry) throws IOException {
        StringBuffer s = new StringBuffer(command);
        this.processSimpleCommand(s, 2, retry);
    }

    protected void processSimpleCommand(String command, int reply, boolean retry) throws IOException {
        StringBuffer s = new StringBuffer(command);
        this.processSimpleCommand(s, reply, retry);
    }

    protected boolean startsWith(StringBuffer sb, String substr) {
        return sb.substring(0, substr.length() - 1).equals(substr);
    }

    protected void processSimpleCommand(StringBuffer command, int reply, boolean retry) throws IOException {
        try {
            this.sendCommand(command);
            if (this.getResponse().getFirstDigit() != reply) {
                throw new FTPException(this.getResponse());
            }
        }
        catch (SocketTimeoutException e) {
            if (retry) {
                try {
                    this.reconnect();
                    this.processSimpleCommand(command, reply, false);
                }
                catch (IOException ie) {
                    this.close();
                    FTPDialogs.ftpConnectionError(e.getMessage(), this.host);
                    if (this.dc != null) {
                        this.dc.disconnected();
                    }
                    throw new IOException(e.getMessage());
                }
            }
            throw new IOException(e.getMessage());
        }
        catch (IOException e) {
            if (retry && this.connLostException(e)) {
                try {
                    this.reconnect();
                    this.processSimpleCommand(command, reply, false);
                }
                catch (IOException ie) {
                    this.close();
                    FTPDialogs.ftpConnectionError(e.getMessage(), this.host);
                    if (this.dc != null) {
                        this.dc.disconnected();
                    }
                    throw e;
                }
            }
            if (this.DirNotFoundException(e)) {
                if (this.startsWith(command, "RMD") || this.startsWith(command, "DELE")) {
                    return;
                }
                throw e;
            }
            throw e;
        }
    }

    protected void processSimpleCommand_afterDataconnection(StringBuffer command, int reply, boolean retry) throws IOException {
        try {
            this.sendCommand(command);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        if (this.getResponse().getFirstDigit() != reply) {
            throw new FTPException(this.getResponse());
        }
    }

    private boolean connLostException(IOException e) {
        boolean lost;
        boolean bl = lost = e instanceof SocketException || e instanceof FTPException && ((FTPException)e).getResponse().getCode() == 421;
        if (lost) {
            this.connected = false;
        }
        return lost;
    }

    private boolean DirNotFoundException(IOException e) {
        boolean dirFound = e instanceof FTPException && ((FTPException)e).getResponse().getCode() == 550;
        return dirFound;
    }

    private boolean DirAlreadyExistException(IOException e) {
        boolean dirFound = e instanceof FTPException && ((FTPException)e).getResponse().getCode() == 550;
        return dirFound;
    }

    protected void clearStringBuffer(StringBuffer s) {
        for (int i = 0; i < s.length(); ++i) {
            s.setCharAt(i, '\u0000');
        }
    }

    protected void login() throws IOException {
        StringBuffer cmd = new StringBuffer("USER ");
        cmd.append(this.user);
        this.sendCommand(cmd);
        if (this.getResponse().isPositiveCompletion()) {
            return;
        }
        if (!this.getResponse().isPositiveIntermediate()) {
            throw new FTPException(this.getResponse());
        }
        StringBuffer spwd = new StringBuffer("PASS ");
        try {
            spwd.append(this.password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.processSimpleCommand(spwd, false);
        this.clearStringBuffer(spwd);
        this.connected = true;
        cmd.setLength(0);
        cmd.append("SYST");
        this.processSimpleCommand(cmd, false);
        if (this.getResponse().getResponse().length() >= 5) {
            this.serversystem = this.getResponse().getResponse().substring(4);
            this.isMultiNet = this.serversystem.startsWith("VMS MultiNet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.lock;
        synchronized (object) {
            return this.connected;
        }
    }

    protected Socket openData(String command) throws IOException {
        this.writeLog(command);
        try {
            if (this.isPassiveMode()) {
                return this.openDataPassive(command);
            }
            return this.openDataActive(command);
        }
        catch (SocketTimeoutException e) {
            try {
                this.reconnect();
                if (this.isPassiveMode()) {
                    return this.openDataPassive(command);
                }
                return this.openDataActive(command);
            }
            catch (IOException e1) {
                this.close();
                FTPDialogs.ftpConnectionError(e1.getMessage(), this.host);
                if (this.dc != null) {
                    this.dc.disconnected();
                }
                throw e1;
            }
        }
        catch (IOException e) {
            try {
                this.reconnect();
                if (this.isPassiveMode()) {
                    return this.openDataPassive(command);
                }
                return this.openDataActive(command);
            }
            catch (IOException e1) {
                this.close();
                FTPDialogs.ftpConnectionError(e1.getMessage(), this.host);
                if (this.dc != null) {
                    this.dc.disconnected();
                }
                throw e1;
            }
        }
    }

    private String getIPAddress(String hostName) {
        try {
            return InetAddress.getByName(Utils.getIntendedHostAddress()).getHostAddress();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    protected Socket openDataActive(String command) throws IOException {
        this.serversocket = new ServerSocket(0);
        int port = this.serversocket.getLocalPort();
        String param = this.getIPAddress(Utils.getIntendedHostAddress()).replace('.', ',') + "," + port / 256 + "," + port % 256;
        this.processSimpleCommand("PORT " + param, true);
        this.processSimpleCommand_afterDataconnection(new StringBuffer(command), 1, true);
        Socket datasocket = this.serversocket.accept();
        return datasocket;
    }

    protected Socket openDataPassive(String command) throws IOException {
        long l = System.currentTimeMillis();
        this.processSimpleCommand("PASV", true);
        String resp = this.getResponse().getResponse();
        String host = "";
        int port = 0;
        boolean success = false;
        if (this.getResponse().getCode() == 227) {
            String hostport;
            StringTokenizer st;
            int openbar = resp.indexOf(40);
            int closebar = resp.indexOf(41);
            if (openbar > 3 && closebar > 3 && openbar < closebar && (st = new StringTokenizer(hostport = resp.substring(openbar + 1, closebar), ",")).countTokens() == 6) {
                for (int i = 0; i < 4; ++i) {
                    host = host + st.nextToken() + (i < 3 ? "." : "");
                }
                try {
                    port = Integer.parseInt(st.nextToken()) * 256 + Integer.parseInt(st.nextToken());
                    success = true;
                }
                catch (NumberFormatException e) {
                    success = false;
                }
            }
        }
        if (!success) {
            throw new IOException("Can't recognize PASV command response. Use active mode.\n" + this.response);
        }
        Socket datasocket = new Socket(host, port);
        datasocket.setSoTimeout(this.TIMEOUT);
        this.processSimpleCommand_afterDataconnection(new StringBuffer(command), 1, true);
        return datasocket;
    }

    protected void closeData(Socket datasocket) throws IOException {
        while (this.getResponse().isPositivePreliminary()) {
            this.setResponse();
        }
        if (!this.getResponse().isPositiveCompletion()) {
            throw new FTPException(this.getResponse());
        }
        datasocket.close();
        if (this.serversocket != null) {
            this.serversocket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(RemoteFileName what, File where, boolean isAscii) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int count = 0;
            while (count++ < 2) {
                try {
                    int len;
                    if (isAscii) {
                        this.ascii();
                    } else {
                        this.binary();
                    }
                    Socket datasocket = this.isMultiNet() && ((FTPFileName)what).getFullName().startsWith("/") ? this.openData("RETR " + FileUtility.unixPathToOpenVMSPath(((FTPFileName)what).getFullName(), false)) : this.openData("RETR " + ((FTPFileName)what).getFullName());
                    InputStream datain = datasocket.getInputStream();
                    FileOutputStream fileout = new FileOutputStream(where);
                    byte[] buffer = new byte[1024];
                    while ((len = datain.read(buffer)) != -1) {
                        ((OutputStream)fileout).write(buffer, 0, len);
                    }
                    datain.close();
                    ((OutputStream)fileout).close();
                    this.closeData(datasocket);
                    break;
                }
                catch (IOException se) {
                    if (count < 2 && this.connLostException(se)) {
                        this.reconnect();
                        continue;
                    }
                    throw se;
                }
            }
        }
    }

    public void get(RemoteFileName what, File where) throws IOException {
        this.get(what, where, false);
    }

    public void put(File what, RemoteFileName where) throws IOException {
        this.put(what, where, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(File what, RemoteFileName where, boolean isAscii) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            long l = System.currentTimeMillis();
            int count = 0;
            while (count++ < 2) {
                try {
                    int len;
                    if (isAscii) {
                        this.ascii();
                    } else {
                        this.binary();
                    }
                    Socket datasocket = this.isMultiNet() && ((FTPFileName)where).getFullName().startsWith("/") ? this.openData("STOR " + FileUtility.unixPathToOpenVMSPath(((FTPFileName)where).getFullName(), false)) : this.openData("STOR " + ((FTPFileName)where).getFullName());
                    FileInputStream filein = new FileInputStream(what);
                    OutputStream dataout = datasocket.getOutputStream();
                    byte[] buffer = new byte[1024];
                    while ((len = ((InputStream)filein).read(buffer)) != -1) {
                        dataout.write(buffer, 0, len);
                    }
                    dataout.close();
                    ((InputStream)filein).close();
                    this.closeData(datasocket);
                    break;
                }
                catch (IOException se) {
                    if (count < 2 && this.connLostException(se)) {
                        this.reconnect();
                        continue;
                    }
                    throw se;
                }
                finally {
                    System.out.println("time take for " + (System.currentTimeMillis() - l));
                }
            }
        }
    }

    private FTPFileAttributes[] parseList(StringTokenizer stoken, String name, boolean isDirectory) {
        if (this.isVMSType()) {
            if (this.isMultiNet()) {
                return this.parseListVMSMultiNet(stoken, name, isDirectory);
            }
            return this.parseListVMS(stoken, name, isDirectory);
        }
        return this.parseListUnix(stoken, name);
    }

    private FTPFileAttributes[] parseListVMS(StringTokenizer stoken, String name, boolean isDirectory) {
        Object attrib = null;
        HashSet<FTPFileAttributes> attribSet = null;
        FTPFileAttributes at = null;
        String prevLine = "";
        boolean skip = false;
        boolean error = false;
        boolean anyerror = false;
        boolean merge = false;
        int count = 0;
        String month = null;
        String year = null;
        int day = 0;
        int lines = stoken.countTokens();
        while (stoken.hasMoreTokens()) {
            String tmp = stoken.nextToken();
            if (merge) {
                tmp = prevLine + " " + tmp;
                merge = false;
                prevLine = "";
            }
            StringTokenizer line = new StringTokenizer(tmp);
            int col = 0;
            at = new FTPFileAttributes();
            if (line.countTokens() == 1) {
                prevLine = tmp;
                merge = true;
                continue;
            }
            while (line.hasMoreTokens()) {
                String word = line.nextToken();
                switch (col) {
                    case 0: {
                        if (count == 0 && word.equals("Directory")) {
                            skip = true;
                            break;
                        }
                        if (word.equals("Total")) {
                            skip = true;
                            break;
                        }
                        int dotIndex = word.lastIndexOf(".");
                        if (word.regionMatches(true, dotIndex + 1, VMS_DIR, 0, 4)) {
                            at.setIsDirectory(true);
                        } else {
                            at.setIsDirectory(false);
                        }
                        int sepChar = at.isDirectory() ? 46 : 59;
                        String fword = word.substring(0, word.lastIndexOf(sepChar));
                        if (!at.isDirectory() && fword.indexOf(46) < 0) {
                            fword = fword + '.';
                        }
                        String winName = FileUtility.openVMSPathToWinPath(fword, at.isDirectory(), "", "");
                        at.setName(new FTPFileName(name, winName.substring(1), at.isDirectory()));
                        break;
                    }
                    case 1: {
                        if (word.indexOf(47) >= 0) {
                            try {
                                at.setSize(Integer.parseInt(word.substring(0, word.indexOf(47))));
                            }
                            catch (NumberFormatException e) {
                                skip = true;
                            }
                            break;
                        }
                        skip = true;
                        break;
                    }
                    case 2: {
                        try {
                            day = Integer.parseInt(word.substring(0, word.indexOf(45)));
                            month = word.substring(word.indexOf(45) + 1, word.lastIndexOf(45));
                            year = word.substring(word.lastIndexOf(45) + 1, word.length());
                        }
                        catch (NumberFormatException e) {
                            error = true;
                        }
                        break;
                    }
                    case 3: {
                        if (at.setDate(month, day, year, word)) break;
                        error = true;
                        break;
                    }
                }
                if (skip || error) break;
                ++col;
            }
            if (skip || error) {
                if (error) {
                    anyerror = true;
                }
                skip = false;
                error = false;
                continue;
            }
            if (isDirectory) {
                if (attribSet == null) {
                    attribSet = new HashSet();
                }
                if (attribSet.contains(at)) continue;
                attribSet.add(at);
                ++count;
                continue;
            }
            attribSet = new HashSet();
            attribSet.add(at);
            break;
        }
        if (attribSet == null) {
            attribSet = new HashSet<FTPFileAttributes>();
        }
        return attribSet.toArray(new FTPFileAttributes[0]);
    }

    private FTPFileAttributes[] parseListVMSMultiNet(StringTokenizer stoken, String name, boolean isDirectory) {
        Object attrib = null;
        HashSet<FTPFileAttributes> attribSet = null;
        FTPFileAttributes at = null;
        String prevLine = "";
        boolean skip = false;
        boolean error = false;
        boolean anyerror = false;
        boolean merge = false;
        int count = 0;
        String month = null;
        String year = null;
        int day = 0;
        int lines = stoken.countTokens();
        boolean parseBegin = true;
        while (stoken.hasMoreTokens()) {
            String tmp = stoken.nextToken();
            if (merge) {
                tmp = prevLine + " " + tmp;
                merge = false;
                prevLine = "";
            }
            StringTokenizer line = new StringTokenizer(tmp);
            int col = 0;
            at = new FTPFileAttributes();
            if (line.countTokens() == 1) {
                if (!parseBegin) {
                    prevLine = tmp;
                    merge = true;
                    continue;
                }
                parseBegin = false;
                continue;
            }
            while (line.hasMoreTokens()) {
                String word = line.nextToken();
                switch (col) {
                    case 0: {
                        if (count == 0 && word.equals("150 List started")) {
                            skip = true;
                            break;
                        }
                        if (word.equals("Total")) {
                            skip = true;
                            break;
                        }
                        int dotIndex = word.lastIndexOf(".");
                        if (word.regionMatches(true, dotIndex + 1, VMS_DIR, 0, 4)) {
                            at.setIsDirectory(true);
                        } else {
                            at.setIsDirectory(false);
                        }
                        int sepChar = at.isDirectory() ? 46 : 59;
                        String fword = word.substring(0, word.lastIndexOf(sepChar));
                        if (!at.isDirectory() && fword.indexOf(46) < 0) {
                            fword = fword + '.';
                        }
                        String winName = FileUtility.openVMSPathToWinPath(fword, at.isDirectory(), "", "");
                        at.setName(new FTPFileName(name, winName.substring(1), at.isDirectory()));
                        break;
                    }
                    case 1: {
                        try {
                            at.setSize(Integer.parseInt(word));
                        }
                        catch (NumberFormatException e) {
                            skip = true;
                        }
                        break;
                    }
                    case 2: {
                        try {
                            day = Integer.parseInt(word.substring(0, word.indexOf(45)));
                            month = word.substring(word.indexOf(45) + 1, word.lastIndexOf(45));
                            year = word.substring(word.lastIndexOf(45) + 1, word.length());
                        }
                        catch (NumberFormatException e) {
                            error = true;
                        }
                        break;
                    }
                    case 3: {
                        if (at.setDate(month, day, year, word)) break;
                        error = true;
                        break;
                    }
                }
                if (skip || error) break;
                ++col;
            }
            if (skip || error) {
                if (error) {
                    anyerror = true;
                }
                skip = false;
                error = false;
                continue;
            }
            if (isDirectory) {
                if (attribSet == null) {
                    attribSet = new HashSet();
                }
                if (attribSet.contains(at)) continue;
                attribSet.add(at);
                ++count;
                continue;
            }
            attribSet = new HashSet();
            attribSet.add(at);
            break;
        }
        if (attribSet == null) {
            attribSet = new HashSet<FTPFileAttributes>();
        }
        return attribSet.toArray(new FTPFileAttributes[0]);
    }

    private FTPFileAttributes[] parseListUnix(StringTokenizer stoken, String name) {
        FTPFileAttributes[] attrib = null;
        FTPFileAttributes at = null;
        boolean skip = false;
        boolean error = false;
        boolean anyerror = false;
        int count = 0;
        String month = null;
        int day = 0;
        int lines = stoken.countTokens();
        while (stoken.hasMoreTokens()) {
            String tmp = stoken.nextToken();
            StringTokenizer line = new StringTokenizer(tmp);
            int col = 0;
            at = new FTPFileAttributes();
            while (line.hasMoreTokens()) {
                String word = line.nextToken();
                switch (col) {
                    case 0: {
                        if (count == 0 && word.equals("total")) {
                            skip = true;
                            break;
                        }
                        if (word.startsWith("d")) {
                            at.setIsDirectory(true);
                        } else if (word.startsWith("-")) {
                            at.setIsDirectory(false);
                        } else {
                            skip = true;
                        }
                        at.setRights(word.substring(1));
                        break;
                    }
                    case 1: {
                        try {
                            at.setLinks(Integer.parseInt(word));
                        }
                        catch (NumberFormatException e) {
                            error = true;
                        }
                        break;
                    }
                    case 2: {
                        at.setUser(word);
                        break;
                    }
                    case 3: {
                        at.setGroup(word);
                        break;
                    }
                    case 4: {
                        try {
                            at.setSize(Integer.parseInt(word));
                        }
                        catch (NumberFormatException e) {
                            error = true;
                        }
                        break;
                    }
                    case 5: {
                        month = word;
                        break;
                    }
                    case 6: {
                        try {
                            day = Integer.parseInt(word);
                        }
                        catch (NumberFormatException e) {
                            error = true;
                        }
                        if (day >= 1 && day <= 31) break;
                        error = true;
                        break;
                    }
                    case 7: {
                        if (at.setDate(month, day, word)) break;
                        error = true;
                        break;
                    }
                    case 8: {
                        at.setName(new FTPFileName(name, word));
                        if (!word.equals(".") && !word.equals("..") || count > 2) break;
                        skip = true;
                    }
                }
                if (skip || error) break;
                ++col;
            }
            if (skip || error) {
                if (error) {
                    anyerror = true;
                }
                skip = false;
                error = false;
                continue;
            }
            if (attrib == null) {
                attrib = new FTPFileAttributes[stoken.countTokens() + 1];
            }
            attrib[count] = at;
            ++count;
        }
        if (attrib == null) {
            attrib = EMPTY_LIST;
        }
        return attrib;
    }

    public void addParser(ListParser parser) {
        throw new Error("Not implemented yet");
    }

    public void addParser(String type, ListParser parser) {
        throw new Error("Not implemented yet");
    }

    public boolean removeParser(ListParser parser) {
        return false;
    }

    public void removeAllParsers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteFileAttributes listFile(String parent, RemoteFileName file) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            StringTokenizer stoken;
            FTPFileAttributes[] rfa;
            StringBuffer sbuffer = new StringBuffer();
            int count = 0;
            if (!this.isConnected()) {
                return null;
            }
            while (count++ < 2) {
                try {
                    int len;
                    Socket datasocket;
                    if (!this.isVMSType()) {
                        datasocket = this.openData(file == null ? "LIST" : "LIST " + file.getFullName());
                    } else if (this.isMultiNet() && file != null && file.getFullName().startsWith("/")) {
                        String fname = file.getFullName();
                        fname = file.isDirectory() ? FileUtility.unixPathToOpenVMSPath(fname + ".dir", false) : FileUtility.unixPathToOpenVMSPath(fname, false);
                        datasocket = this.openData(file == null ? "LIST" : "LIST " + fname);
                    } else {
                        datasocket = this.openData(file == null ? "LIST" : "LIST " + file.getFullName());
                    }
                    InputStreamReader datain = new InputStreamReader(datasocket.getInputStream());
                    char[] buffer = new char[1024];
                    while ((len = datain.read(buffer)) != -1) {
                        sbuffer.append(buffer, 0, len);
                    }
                    datain.close();
                    this.closeData(datasocket);
                    break;
                }
                catch (IOException se) {
                    if (count < 2 && this.connLostException(se)) {
                        this.reconnect();
                        continue;
                    }
                    throw se;
                }
            }
            if ((rfa = this.parseList(stoken = new StringTokenizer(sbuffer.toString(), "\r\n"), parent, false)) == null || rfa.length == 0) {
                return new RemoteFileAttributes();
            }
            return rfa[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteFileAttributes[] list(RemoteFileName directory) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            StringBuffer sbuffer = new StringBuffer();
            int count = 0;
            if (!this.isConnected()) {
                return new RemoteFileAttributes[0];
            }
            if (count++ < 2) {
                try {
                    int len;
                    Socket datasocket = !this.isVMSType() ? this.openData(directory == null ? "LIST" : "LIST " + ((FTPFileName)directory).getFullName()) : (this.isMultiNet() && ((FTPFileName)directory).getFullName().startsWith("/") ? (directory.isDirectory() ? this.openData(directory == null ? "LIST" : "LIST " + FileUtility.unixPathToOpenVMSPath(((FTPFileName)directory).getFullName(), true) + "*.*;0") : this.openData(directory == null ? "LIST" : "LIST " + FileUtility.unixPathToOpenVMSPath(((FTPFileName)directory).getFullName(), false) + ";0")) : (directory.isDirectory() ? this.openData(directory == null ? "LIST" : "LIST " + ((FTPFileName)directory).getFullName() + "/*.*;0") : this.openData(directory == null ? "LIST" : "LIST " + ((FTPFileName)directory).getFullName() + ";0")));
                    InputStreamReader datain = new InputStreamReader(datasocket.getInputStream());
                    char[] buffer = new char[1024];
                    while ((len = datain.read(buffer)) != -1) {
                        sbuffer.append(buffer, 0, len);
                    }
                    datain.close();
                    this.closeData(datasocket);
                }
                catch (IOException se) {
                    if (count < 2 && this.connLostException(se)) {
                        try {
                            this.reconnect();
                        }
                        catch (IOException e) {
                            return null;
                        }
                    }
                    if (count < 2 && this.DirNotFoundException(se)) {
                        return null;
                    }
                    throw se;
                }
            }
            StringTokenizer stoken = new StringTokenizer(sbuffer.toString(), "\r\n");
            return this.parseList(stoken, ((FTPFileName)directory).getFullName(), directory.isDirectory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(RemoteFileName from, String to) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            FTPFileName newname = new FTPFileName(((FTPFileName)from).getDirectory(), to, from.isDirectory());
            int count = 0;
            while (count++ < 2) {
                try {
                    if (this.isMultiNet() && ((FTPFileName)from).getFullName().startsWith("/")) {
                        this.processSimpleCommand("RNFR " + FileUtility.unixPathToOpenVMSPath(from.getFullName(), from.isDirectory()), 3, true);
                        this.processSimpleCommand("RNTO " + FileUtility.unixPathToOpenVMSPath(newname.getFullName(), from.isDirectory()), 2, true);
                        break;
                    }
                    this.processSimpleCommand("RNFR " + from.getFullName(), 3, true);
                    this.processSimpleCommand("RNTO " + newname.getFullName(), 2, true);
                    break;
                }
                catch (IOException se) {
                    if (count < 2 && this.connLostException(se)) {
                        this.reconnect();
                        continue;
                    }
                    throw se;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(RemoteFileName path) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isVMSType()) {
                if (this.isMultiNet() && ((FTPFileName)path).getFullName().startsWith("/")) {
                    this.processSimpleCommand("DELE " + FileUtility.unixPathToOpenVMSPath(((FTPFileName)path).getFullName(), false) + ";*", true);
                } else {
                    this.processSimpleCommand("DELE " + ((FTPFileName)path).getFullName() + ";*", true);
                }
            } else {
                this.processSimpleCommand("DELE " + ((FTPFileName)path).getFullName(), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mkdir(RemoteFileName name) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.isMultiNet() && ((FTPFileName)name).getFullName().startsWith("/")) {
                    this.processSimpleCommand("MKD " + FileUtility.unixPathToOpenVMSPath(((FTPFileName)name).getFullName(), true), true);
                } else {
                    this.processSimpleCommand("MKD " + name.getFullName(), true);
                }
            }
            catch (IOException e) {
                if (this.DirAlreadyExistException(e)) {
                    return;
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rmdir(RemoteFileName path) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isMultiNet() && ((FTPFileName)path).getFullName().startsWith("/")) {
                this.processSimpleCommand("RMD " + FileUtility.unixPathToOpenVMSPath(((FTPFileName)path).getFullName(), true), true);
            } else {
                this.processSimpleCommand("RMD " + ((FTPFileName)path).getFullName(), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pwd() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.processSimpleCommand("PWD", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cwd(String path) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (path == null) {
                return;
            }
            this.rwd = new String(path);
            if (this.isMultiNet() && path.startsWith("/")) {
                path = FileUtility.unixPathToOpenVMSPath(path, true);
            }
            this.processSimpleCommand("CWD " + path, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void system() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.processSimpleCommand("SYST", true);
        }
    }

    private void ascii() throws IOException {
        this.processSimpleCommand("TYPE A", true);
    }

    private void binary() throws IOException {
        this.processSimpleCommand("TYPE I", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.sendCommand(new StringBuffer("QUIT"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.connected = false;
                if (this.in != null) {
                    this.in.close();
                    this.in = null;
                }
                if (this.out != null) {
                    this.out.close();
                    this.out = null;
                }
                if (this.socket != null) {
                    this.socket.close();
                    this.socket = null;
                }
                if (this.log != null) {
                    this.log.close();
                    this.log = null;
                }
                if (this.rafile != null) {
                    this.rafile.close();
                    this.rafile = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        failedAttempts = new ArrayList();
    }

    public static interface ListParser {
        public RemoteFileAttributes parseList(StringTokenizer var1);
    }

    public static interface Reconnect {
        public boolean notifyReconnect(String var1);
    }
}

