/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteexecute;

import java.io.BufferedReader;
import java.io.StringReader;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;
import org.apache.regexp.ReaderCharacterIterator;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.remotefs.RemoteFSUtils;
import org.openide.ErrorManager;
import org.openide.compiler.ExternalCompiler;
import org.openide.filesystems.FileObject;

public final class RemoteOutputParser {
    private static RemoteOutputParser antOutputParser;

    public static synchronized RemoteOutputParser getDefault() {
        if (antOutputParser == null) {
            antOutputParser = new RemoteOutputParser();
        }
        return antOutputParser;
    }

    private RemoteOutputParser() {
    }

    private static String trimString(String s) {
        char c;
        int idx = 0;
        int slen = s.length();
        if (slen == 0) {
            return s;
        }
        while (((c = s.charAt(idx++)) == '\n' || c == '\r') && idx < slen) {
        }
        --idx;
        if ((idx = (s = s.substring(idx)).length() - 1) < 0) {
            return s;
        }
        while (((c = s.charAt(idx--)) == '\n' || c == '\r') && idx >= 0) {
        }
        return s.substring(0, idx + 2);
    }

    private static RE getErrorPattern(ExternalCompiler.ErrorExpression err) {
        String regexp = err.getErrorExpression();
        try {
            RECompiler rec = new RECompiler();
            REProgram rep = rec.compile(regexp);
            RE errRE = new RE(rep, 2);
            return errRE;
        }
        catch (RESyntaxException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
    }

    public Result parse(String iline, ExternalCompiler.ErrorExpression err, String prevFile, FileObject prevFileObject) {
        RE errorPattern = RemoteOutputParser.getErrorPattern(err);
        ReaderCharacterIterator chi = new ReaderCharacterIterator(new BufferedReader(new StringReader(iline)));
        String msg = null;
        int idx = 0;
        if (errorPattern.match(chi, idx)) {
            String sg;
            int column;
            int line;
            if (err.getFilePos() < 0) {
                return null;
            }
            int lowerBound = 0;
            int upperBound = errorPattern.getParenCount() - 1;
            String file = errorPattern.getParen(err.getFilePos());
            if (err.getLinePos() < lowerBound || err.getLinePos() > upperBound) {
                line = 1;
            } else {
                try {
                    line = Integer.parseInt(errorPattern.getParen(err.getLinePos()));
                }
                catch (NumberFormatException ex) {
                    line = 1;
                }
            }
            if (line > 0) {
                --line;
            }
            if (err.getColumnPos() < lowerBound || err.getColumnPos() > upperBound) {
                column = 1;
            } else {
                try {
                    column = Integer.parseInt(errorPattern.getParen(err.getColumnPos()));
                }
                catch (NumberFormatException ex) {
                    column = 1;
                }
            }
            msg = err.getDescriptionPos() < lowerBound || err.getDescriptionPos() > upperBound ? "" : ((sg = errorPattern.getParen(err.getDescriptionPos())) == null ? "" : sg.trim());
            String refText = "";
            String rst = chi.substring(idx, errorPattern.getParenStart(0));
            if (!rst.equals("")) {
                return null;
            }
            FileObject fo = null;
            if (!prevFile.equals("") && prevFile.equalsIgnoreCase(file)) {
                fo = prevFileObject;
            } else {
                FileObject fileObject = fo = file != null ? this.findFO(file) : null;
            }
            if (fo == null) {
                return null;
            }
            return new Result(fo, file, line, column, -1, -1, msg + " " + refText);
        }
        return null;
    }

    private FileObject findFO(String name) {
        FileObject[] fo;
        if (name.charAt(0) != '/') {
            name = FileUtility.openVMSPathToUnixPath(name, false);
        }
        if ((fo = RemoteFSUtils.fromFile(name)).length > 0) {
            return fo[0];
        }
        return null;
    }

    public static final class Result {
        private FileObject fo;
        private int line1;
        private int col1;
        private int line2;
        private int col2;
        private String message;
        private String fname;

        public Result(FileObject fo, String fname, int line1, int col1, int line2, int col2, String message) {
            this.fo = fo;
            this.fname = fname;
            this.line1 = line1;
            this.col1 = col1;
            this.line2 = line2;
            this.col2 = col2;
            this.message = message;
        }

        public FileObject getFileObject() {
            return this.fo;
        }

        public String getFileName() {
            return this.fname;
        }

        public int getLineStart() {
            return this.line1;
        }

        public int getLineEnd() {
            return this.line2;
        }

        public int getColumnStart() {
            return this.col1;
        }

        public int getColumnEnd() {
            return this.col2;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

