/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.model;

import com.hp.openvms.netbeans.debugsupport.debugger.RemoteDebugger;
import com.hp.openvms.netbeans.debugsupport.model.RemoteWatchModel;
import com.hp.openvms.netbeans.exesupport.ExeDataObject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.loaders.DataObject;

public class ViewModelListener
implements PropertyChangeListener {
    private String viewType;
    private JComponent view;
    private String propertiesHelpID = null;
    RemoteWatchModel rwm;
    List modelList;
    ArrayList dobjCache;

    ViewModelListener(String viewType, JComponent view, String propertiesHelpID, DataObject[] dobjs, ArrayList dobjCache) {
        this.viewType = viewType;
        this.view = view;
        this.propertiesHelpID = propertiesHelpID;
        this.dobjCache = dobjCache;
        if (dobjs != null) {
            for (int i = 0; i < dobjs.length; ++i) {
                if (!dobjCache.contains(dobjs[i])) {
                    dobjCache.add(dobjs[i]);
                }
                ((ExeDataObject)dobjs[i]).addViewModelListener(this);
            }
            this.createModels(dobjs, null);
            this.updateModel();
        }
    }

    public void createModels(DataObject[] dobjs, RemoteDebugger remoteDebugger) {
        this.rwm = new RemoteWatchModel(dobjs, remoteDebugger, this.dobjCache);
        this.modelList = new ArrayList();
        this.modelList.add(this.rwm);
        this.modelList.add(new ColumnModel(){

            public String getID() {
                return "valueID";
            }

            public String getDisplayName() {
                return "Value";
            }

            public Class getType() {
                return String.class;
            }
        });
    }

    void destroy() {
        Models.setModelsToView((JComponent)this.view, (Models.CompoundModel)Models.EMPTY_MODEL);
    }

    public void propertyChange(PropertyChangeEvent e) {
        DataObject dobj = (DataObject)e.getSource();
        RemoteDebugger remoteDebugger = (RemoteDebugger)e.getOldValue();
        if (!this.dobjCache.contains(dobj)) {
            this.dobjCache.add(dobj);
        }
        Iterator itr = this.dobjCache.iterator();
        while (itr.hasNext()) {
            if (((DataObject)itr.next()).isValid()) continue;
            itr.remove();
        }
        this.createModels(this.dobjCache.toArray(new DataObject[0]), remoteDebugger);
        this.updateModel();
    }

    private void updateModel() {
        Models.setModelsToView((JComponent)this.view, (Models.CompoundModel)Models.createCompoundModel((List)this.modelList));
    }

    private static class EmptyModel
    implements NodeModel {
        public String getDisplayName(Object node) throws UnknownTypeException {
            if (node == "Root") {
                return "Name";
            }
            throw new UnknownTypeException(node);
        }

        public String getIconBase(Object node) throws UnknownTypeException {
            if (node == "Root") {
                return "org/netbeans/modules/debugger/resources/DebuggerTab";
            }
            throw new UnknownTypeException(node);
        }

        public String getShortDescription(Object node) throws UnknownTypeException {
            throw new UnknownTypeException(node);
        }

        public void addModelListener(ModelListener l) {
        }

        public void removeModelListener(ModelListener l) {
        }
    }
}

