/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.model;

import com.hp.openvms.netbeans.debugsupport.debugger.CallStackFrameImpl;
import com.hp.openvms.netbeans.debugsupport.debugger.LocalVariable;
import com.hp.openvms.netbeans.debugsupport.debugger.RemoteDebugger;
import com.hp.openvms.netbeans.debugsupport.debugger.Variable;
import com.hp.openvms.netbeans.debugsupport.model.AbstractVariable;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;

public class LocalsTreeModel
implements TreeModel,
PropertyChangeListener {
    private static boolean verbose = false;
    private static final int ARRAY_CHILDREN_NESTED_LENGTH = 100;
    private RemoteDebugger debugger;
    private Listener listener;
    private Vector listeners = new Vector();
    private Map cachedLocals = new WeakHashMap();
    private Map cachedArrayChildren = new WeakHashMap();
    private ModelListener modelListener = null;

    public LocalsTreeModel(ContextProvider lookupProvider) {
        this.debugger = (RemoteDebugger)lookupProvider.lookupFirst(null, RemoteDebugger.class);
        this.debugger.registerLocalsModel(this);
    }

    public Object getRoot() {
        return "Root";
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.fireTableValueChangedChanged(evt.getSource(), null);
    }

    public Object[] getChildren(Object o, int from, int to) throws UnknownTypeException {
        Object[] ch = this.getChildrenImpl(o, from, to);
        for (int i = 0; i < ch.length; ++i) {
            if (!(ch[i] instanceof Customizer)) continue;
            ((Customizer)ch[i]).addPropertyChangeListener(this);
        }
        return ch;
    }

    public Object[] getChildrenImpl(Object o, int from, int to) throws UnknownTypeException {
        if (o.equals("Root")) {
            Object[] os = this.getLocalVariables(from, to);
            return os;
        }
        if (o instanceof AbstractVariable) {
            AbstractVariable abstractVariable = (AbstractVariable)o;
            return abstractVariable.getFields(from, to);
        }
        return new Object[0];
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if (node.equals("Root")) {
            CallStackFrameImpl callStackFrame = (CallStackFrameImpl)this.debugger.getCurrentCallStackFrame();
            if (callStackFrame == null) {
                return 1;
            }
            LocalVariable[] lv = callStackFrame.visibleVariables();
            return lv.length;
        }
        if (node instanceof AbstractVariable) {
            AbstractVariable abstractVariable = (AbstractVariable)node;
            return abstractVariable.getFieldsCount();
        }
        return 0;
    }

    public boolean isLeaf(Object o) throws UnknownTypeException {
        if (o.equals("Root")) {
            return false;
        }
        if (o instanceof AbstractVariable) {
            int i = ((AbstractVariable)o).getFieldsCount();
            return i <= 0;
        }
        if (o instanceof LocalVariable) {
            return true;
        }
        if (o.equals("NoInfo")) {
            return true;
        }
        if (o.equals("No current thread")) {
            return true;
        }
        throw new UnknownTypeException(o);
    }

    public void addModelListener(ModelListener l) {
        this.modelListener = l;
        this.listeners.add(l);
        if (this.listener == null) {
            this.listener = new Listener(this, this.debugger);
        }
        this.debugger.registerLocalsListener(l);
    }

    public void removeModelListener(ModelListener l) {
        this.debugger.registerLocalsListener(null);
        this.modelListener = null;
        this.listeners.remove(l);
        if (this.listeners.size() == 0) {
            this.listener.destroy();
            this.listener = null;
        }
    }

    void fireTreeChanged() {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    private void fireTableValueChangedChanged(Object node, String propertyName) {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)new ModelEvent.TableValueChanged((Object)this, node, propertyName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getLocalVariables(int from, int to) {
        Object object = this.debugger.LOCK;
        synchronized (object) {
            CallStackFrameImpl callStackFrame = (CallStackFrameImpl)this.debugger.getCurrentCallStackFrame();
            if (callStackFrame == null) {
                return new String[]{"No current thread"};
            }
            return callStackFrame.getLocalVariables();
        }
    }

    LocalVariable[] getLocalVariables(CallStackFrameImpl callStackFrame, int from, int to) {
        LocalVariable[] locals = callStackFrame.getLocalVariables();
        int n = locals.length;
        to = Math.min(n, to);
        if ((from = Math.min(n, from)) != 0 || to != n) {
            LocalVariable[] subLocals = new LocalVariable[to - from];
            for (int i = from; i < to; ++i) {
                subLocals[i - from] = locals[i];
            }
            locals = subLocals;
        }
        return locals;
    }

    public Variable getVariable(String v) {
        return new AbstractVariable(this.debugger, v, null, null, null);
    }

    RemoteDebugger getDebugger() {
        return this.debugger;
    }

    private static class Listener
    implements PropertyChangeListener {
        private RemoteDebugger debugger;
        private WeakReference model;
        private RequestProcessor.Task task;

        public Listener(LocalsTreeModel tm, RemoteDebugger debugger) {
            this.debugger = debugger;
            this.model = new WeakReference<LocalsTreeModel>(tm);
            debugger.addPropertyChangeListener(this);
        }

        void destroy() {
            this.debugger.removePropertyChangeListener(this);
            if (this.task != null) {
                this.task.cancel();
                if (verbose) {
                    System.out.println("LTM cancel old task " + this.task);
                }
                this.task = null;
            }
        }

        private LocalsTreeModel getModel() {
            LocalsTreeModel tm = (LocalsTreeModel)this.model.get();
            if (tm == null) {
                this.destroy();
            }
            return tm;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void propertyChange(PropertyChangeEvent e) {
            block9: {
                block8: {
                    if (e.getPropertyName() == "currentCallStackFrame") break block8;
                    if (e.getPropertyName() != "state") break block9;
                }
                if (this.debugger.getState() == "state_stopped") {
                    final LocalsTreeModel ltm = this.getModel();
                    if (ltm == null) {
                        return;
                    }
                    if (this.task != null) {
                        this.task.cancel();
                        if (verbose) {
                            System.out.println("LTM cancel old task " + this.task);
                        }
                        this.task = null;
                    }
                    this.task = RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            String string = Listener.this.debugger.getState();
                            Listener.this.debugger;
                            if (string != "state_stopped") {
                                if (verbose) {
                                    System.out.println("LTM cancel started task " + Listener.this.task);
                                }
                                return;
                            }
                            if (verbose) {
                                System.out.println("LTM do task " + Listener.this.task);
                            }
                            ltm.fireTreeChanged();
                        }
                    }, 500);
                    if (!verbose) return;
                    System.out.println("LTM  create task " + this.task);
                    return;
                }
            }
            if (e.getPropertyName() != "state") return;
            if (this.debugger.getState() == "state_stopped") return;
            if (this.task == null) return;
            this.task.cancel();
            if (verbose) {
                System.out.println("LTM cancel task " + this.task);
            }
            this.task = null;
        }
    }
}

