/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.breakpoints;

import com.hp.openvms.netbeans.debugsupport.breakpoints.RemoteBreakpoint;
import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.modules.distributed.rmi.protocol.debug.LookupLinePacket;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Utilities;

public class LineBreakpoint
extends RemoteBreakpoint {
    public static final String PROP_LINE_NUMBER = "lineNumber";
    public static final String PROP_URL = "url";
    public static final String PROP_CONDITION = "condition";
    private String url = "";
    private String path = "";
    private int lineNumber;
    private String condition = "";
    private LookupLinePacket linePacket;
    private String vmsFilePath;

    public static LineBreakpoint create(String url, int lineNumber) {
        LineBreakpointComparable b = new LineBreakpointComparable();
        b.setID();
        b.setURL(url);
        b.setLineNumber(lineNumber);
        return b;
    }

    public String getURL() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURL(String url) {
        String old;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            block10: {
                if (url == this.url || url != null && this.url != null && url.equals(this.url)) {
                    return;
                }
                try {
                    assert (url != null || !Boolean.getBoolean("gdb.assertions.enabled"));
                    FileObject fo = URLMapper.findFileObject((URL)new URL(url));
                    if (fo != null) {
                        this.path = Utilities.isWindows() ? fo.getPath() : "/" + fo.getPath();
                    }
                }
                catch (MalformedURLException mue) {
                    assert (!Boolean.getBoolean("gdb.assertions.enabled"));
                    return;
                }
                catch (Exception ex) {
                    if ($assertionsDisabled || !Boolean.getBoolean("gdb.assertions.enabled")) break block10;
                    throw new AssertionError();
                }
            }
            old = this.url;
            this.url = url;
        }
        this.firePropertyChange(PROP_URL, old, url);
    }

    public LookupLinePacket getLookupLinePacket() {
        return this.linePacket;
    }

    public void setLookupLinePacket(LookupLinePacket linePacket) {
        this.linePacket = linePacket;
    }

    public String getVmsFilePath() {
        return this.vmsFilePath;
    }

    public void setVmsFilePath(String vmsFilePath) {
        this.vmsFilePath = vmsFilePath;
    }

    public String getPath() {
        return this.path;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineNumber(int ln) {
        int old;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (ln == this.lineNumber) {
                return;
            }
            old = this.lineNumber;
            this.lineNumber = ln;
        }
        this.firePropertyChange(PROP_LINE_NUMBER, new Integer(old), new Integer(ln));
    }

    public String getCondition() {
        return this.condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCondition(String c) {
        String old;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (c == null) {
                c = "";
            }
            if ((c = c.trim()) == this.condition || c != null && this.condition != null && this.condition.equals(c)) {
                return;
            }
            old = this.condition;
            this.condition = c;
        }
        this.firePropertyChange(PROP_CONDITION, old, c);
    }

    public String toString() {
        return "LineBreakpoint " + this.url + " : " + this.lineNumber;
    }

    private static class LineBreakpointComparable
    extends LineBreakpoint
    implements Comparable {
        public int compareTo(Object o) {
            if (o instanceof LineBreakpointComparable) {
                LineBreakpointComparable lbthis = this;
                LineBreakpoint lb = (LineBreakpoint)((Object)o);
                int uc = ((LineBreakpoint)lbthis).url.compareTo(lb.url);
                if (uc != 0) {
                    return uc;
                }
                return ((LineBreakpoint)lbthis).lineNumber - lb.lineNumber;
            }
            return -1;
        }
    }
}

