/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.dclsupport.dcl.datasys;

import com.hp.openvms.netbeans.dclsupport.dcl.RemotePropertiesAction;
import com.hp.openvms.netbeans.dclsupport.dcl.datasys.DCLBuildSupport;
import com.hp.openvms.netbeans.dclsupport.dcl.datasys.DCLRemoteExecSupport;
import com.hp.openvms.netbeans.dclsupport.dcl.datasys.SHDataLoader;
import com.hp.openvms.netbeans.dclsupport.dcl.datasys.SHDataNode;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.distributed.common.cookies.RemoteCookie;
import org.netbeans.modules.distributed.common.cookies.RemotePropertyCookie;
import org.netbeans.modules.distributed.remotefs.smb.NetworkFileSystem;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.windows.CloneableOpenSupport;

public class SHDataObject
extends MultiDataObject {
    public SHDataObject(FileObject pf, SHDataLoader loader) throws DataObjectExistsException {
        super(pf, (MultiFileLoader)loader);
        this.init();
    }

    private void init() {
        SHEditorSupport de = new SHEditorSupport(this);
        this.getCookieSet().add((Node.Cookie)de);
        this.getCookieSet().add((Node.Cookie)new DCLBuildSupport.Compile(this.getPrimaryEntry()));
        this.getCookieSet().add((Node.Cookie)new DCLRemoteExecSupport(this.getPrimaryEntry()));
        this.getCookieSet().add((Node.Cookie)new RemoteCookie(){

            public void operations() {
            }
        });
        this.getCookieSet().add((Node.Cookie)new RemotePropertyCookie(){

            public void operations(Node[] nodes) {
                RemotePropertiesAction.doAction(nodes);
            }
        });
    }

    protected Node createNodeDelegate() {
        return new SHDataNode(this);
    }

    void addSaveCookie(SaveCookie save) {
        if (this.getCookie(SaveCookie.class) == null) {
            this.getCookieSet().add((Node.Cookie)save);
            this.setModified(true);
        }
    }

    void removeSaveCookie(SaveCookie save) {
        if (this.getCookie(SaveCookie.class) == save) {
            this.getCookieSet().remove((Node.Cookie)save);
            this.setModified(false);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("com.hp.openvms.netbeans.dclsupport.dcl.datasys.DCLSource");
    }

    private static class SHEditorSupport
    extends DataEditorSupport
    implements OpenCookie,
    EditCookie,
    EditorCookie,
    PrintCookie {
        private boolean ftpFS;

        public SHEditorSupport(SHDataObject obj) {
            super((DataObject)obj, (CloneableEditorSupport.Env)new SHEnv(obj));
            FileObject fobj = obj.getPrimaryFile();
            try {
                this.ftpFS = !(fobj.getFileSystem() instanceof NetworkFileSystem);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            this.setMIMEType("text/x-sh");
        }

        protected boolean notifyModified() {
            if (!super.notifyModified()) {
                return false;
            }
            SHEnv e = (SHEnv)this.env;
            e.getSHDataObject().addSaveCookie(e);
            return true;
        }

        protected void notifyUnmodified() {
            super.notifyUnmodified();
            SHEnv e = (SHEnv)this.env;
            e.getSHDataObject().removeSaveCookie(e);
        }

        protected void saveFromKitToStream(StyledDocument doc, EditorKit kit, OutputStream stream) throws IOException, BadLocationException {
            kit.write(stream, (Document)doc, 0, doc.getLength());
            if (doc.getLength() > 1 && !this.ftpFS && !doc.getText(doc.getLength() - 1, 1).equals("\n")) {
                stream.write(10);
            }
        }

        private static class SHEnv
        extends DataEditorSupport.Env
        implements SaveCookie {
            public SHEnv(SHDataObject obj) {
                super((DataObject)obj);
            }

            SHDataObject getSHDataObject() {
                return (SHDataObject)this.getDataObject();
            }

            protected FileObject getFile() {
                return this.getDataObject().getPrimaryFile();
            }

            protected FileLock takeLock() throws IOException {
                return this.getDataObject().getPrimaryFile().lock();
            }

            public void save() throws IOException {
                ((SHEditorSupport)this.findCloneableOpenSupport()).saveDocument();
                this.getDataObject().setModified(false);
            }

            public CloneableOpenSupport findCloneableOpenSupport() {
                return (CloneableOpenSupport)this.getDataObject().getCookie(EditCookie.class);
            }
        }
    }
}

