/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.dclsupport.dcl;

import com.hp.openvms.netbeans.baseclasses.compiler.AlphaVMSCompilerGroup;
import com.hp.openvms.netbeans.dclsupport.dcl.BaseCompilerType;
import com.hp.openvms.netbeans.dclsupport.dcl.DCLCompiler;
import com.hp.openvms.netbeans.dclsupport.dcl.datasys.DCLBuildSupport;
import com.hp.openvms.netbeans.utils.DCLExecutor;
import com.hp.openvms.netbeans.utils.FileUtilityLang;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Vector;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.remoteexecute.RemoteProcessDescriptor;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.compiler.Compiler;
import org.openide.compiler.ExternalCompiler;
import org.openide.compiler.ExternalCompilerGroup;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class DCLCompilerGroup
extends AlphaVMSCompilerGroup {
    private BaseCompilerType compilerSvcType = null;
    protected boolean isRemote = false;

    private static String getString(String x) {
        return NbBundle.getMessage(DCLCompilerGroup.class, (String)x);
    }

    protected String getStatusLineText() {
        ExternalCompiler[] cs = this.getAllCompilers();
        if (cs.length > 1) {
            return "Executing ...";
        }
        return "Executing " + cs[0].getFileName();
    }

    public boolean getIsRemote() {
        return this.isRemote;
    }

    public void add(Compiler c) throws IllegalArgumentException {
        super.add(c);
        this.compilerSvcType = ((DCLCompiler)c).getCompilerSvcType();
        this.isRemote = ((DCLCompiler)c).isRemote();
    }

    protected Process createProcess(NbProcessDescriptor desc, String[] files) throws IOException {
        ExternalCompiler[] ec = this.getAllCompilers();
        FileObject[] fileObjects = new FileObject[ec.length];
        RemoteRuntimeType rrt = null;
        boolean useX = false;
        for (int i = 0; i < ec.length; ++i) {
            fileObjects[i] = ((DCLCompiler)ec[i]).getFileObject0();
            FileObject fo = fileObjects[i];
            if (!this.getIsRemote()) continue;
            try {
                AbstractNetworkFileSystem nfs = (AbstractNetworkFileSystem)fo.getFileSystem();
                rrt = nfs.getRemoteRuntimeType();
                Boolean bobj = (Boolean)fo.getAttribute("useXtermExecution");
                if (bobj != null) {
                    useX = bobj;
                    continue;
                }
                useX = nfs.getUseXtermExecution();
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        DCLFormat dclformat = new DCLFormat(ec, this.getIsRemote());
        if (this.getIsRemote()) {
            IOException ioe;
            String clientIP = Utils.getIntendedHostAddress();
            if (dclformat.getUseDECterm() && Utilities.isWindows()) {
                String cmd = DistributedSettings.getDefault().getXServer();
                try {
                    Runtime.getRuntime().exec(cmd);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(2500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (rrt == null) {
                ioe = new IOException("");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"No matching remote server is found.\nPlease go to Services Tab and add remote server", 2));
                ErrorManager.getDefault().annotate((Throwable)ioe, 1, null, null, null, null);
                throw ioe;
            }
            if (rrt.getRemoteRuntime() == null) {
                ioe = new IOException("");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)("Remote server \"" + rrt.getHostName() + "\" " + " is disconnected.\nPlease go to Services Tab and make connection using \"" + rrt.getUserName() + "\""), 1));
                ErrorManager.getDefault().annotate((Throwable)ioe, 1, null, null, null, null);
                throw ioe;
            }
            RemoteProcessDescriptor rpd = new RemoteProcessDescriptor("", "");
            return rpd.exec(dclformat.getCmds(), rrt, null, null, useX, clientIP, rrt.getSecurityContext());
        }
        File tmpDCLFile = File.createTempFile("compilerparams", ".bat");
        tmpDCLFile.deleteOnExit();
        return DCLExecutor.execute(tmpDCLFile.getAbsolutePath(), dclformat.getCmds(), dclformat.getUseDECterm() ? 0 : 1);
    }

    public void makeAbstract() {
    }

    public static class DCLFormat
    extends ExternalCompilerGroup.Format {
        public static final String TAG_DCL = "file";
        public static final String TAG_ARG = "arguments";
        public static final String TAG_TARGET = "target";
        private Vector Cmds;
        private boolean useDECterm = false;
        private boolean isRemote = false;

        public DCLFormat(ExternalCompiler[] files, boolean isRemote) {
            super(new String[0]);
            this.isRemote = isRemote;
            this.composeCmds(files);
        }

        private boolean getIsRemote() {
            return this.isRemote;
        }

        private String createDCLArgument(String argument, String descArg) {
            Map map = this.getMap();
            if (argument != null && argument.indexOf(34) >= 0) {
                int beginIndex = 0;
                StringBuffer sb = new StringBuffer(argument);
                while ((beginIndex = sb.toString().indexOf(34, beginIndex)) >= 0) {
                    sb.insert(beginIndex, '\"');
                    beginIndex += 2;
                }
                argument = sb.toString();
            }
            map.put(TAG_ARG, argument == null ? "" : argument);
            return this.format(descArg);
        }

        private String createProcessName(String argument, String filePath) {
            Map map = this.getMap();
            map.put(TAG_DCL, filePath);
            return this.format(argument);
        }

        private String createDCLCmdLine(String processName) {
            return processName;
        }

        protected void composeCmds(ExternalCompiler[] files) {
            this.Cmds = new Vector(files.length);
            for (int i = 0; i < files.length; ++i) {
                DataObject doj;
                FileObject fo = ((DCLCompiler)files[i]).getFileObject0();
                try {
                    doj = DataObject.find((FileObject)fo);
                }
                catch (DataObjectNotFoundException ex) {
                    continue;
                }
                Node.Cookie cookie = doj.getCookie(DCLBuildSupport.class);
                if (cookie == null) continue;
                DCLBuildSupport dclSupport = (DCLBuildSupport)cookie;
                File file = FileUtil.toFile((FileObject)fo);
                String filePath = this.getIsRemote() ? (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384 ? FileUtilityLang.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fo) : FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, fo)) : (Utilities.getOperatingSystem() == 16384 ? FileUtilityLang.unixPathToOpenVMSPath(files[i].getFileName(), false) : files[i].getFileName());
                String desc = dclSupport.getExternalCompiler();
                String processName = this.createProcessName(desc, filePath);
                String buildDirectory = dclSupport.getBuildDirectory() == null ? "" : dclSupport.getBuildDirectory().getAbsolutePath();
                String buildDir = this.calculateObjectDir(buildDirectory, fo, filePath);
                this.Cmds.add("set default " + buildDir);
                this.Cmds.add(this.createDCLCmdLine(processName));
                this.useDECterm = dclSupport.getOutputSwitch();
            }
        }

        private String calculateObjectDir(String buildDir, FileObject fobj, String filePath) {
            String buildDirectory = buildDir.trim();
            if ((buildDirectory.trim().equals("") || buildDirectory.trim().equals(".")) && filePath != null && !filePath.equals("")) {
                File pfile = FileUtil.toFile((FileObject)fobj.getParent());
                if (this.getIsRemote()) {
                    if (Utilities.isWindows()) {
                        return FileUtilityLang._winPathToOpenVMSPath(pfile.getAbsolutePath(), true, fobj.getParent());
                    }
                    return FileUtilityLang.unixPathToOpenVMSPath(pfile.getAbsolutePath(), true, fobj.getParent());
                }
                return FileUtilityLang.unixPathToOpenVMSPath(pfile.getAbsolutePath(), true);
            }
            if (this.getIsRemote()) {
                if (buildDirectory.startsWith("/")) {
                    buildDirectory = FileUtilityLang.unixPathToOpenVMSPath(buildDirectory, true);
                }
            } else {
                buildDirectory = FileUtilityLang.unixPathToOpenVMSPath(buildDirectory, true);
            }
            return buildDirectory;
        }

        public String[] getCmds() {
            String[] strs = new String[this.Cmds.size()];
            System.arraycopy(this.Cmds.toArray(), 0, strs, 0, this.Cmds.size());
            return strs;
        }

        public boolean getUseDECterm() {
            return this.useDECterm;
        }
    }
}

