/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.cppsupport.prop;

import com.hp.openvms.netbeans.cppsupport.prop.SheetButtonListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.openide.awt.MouseUtils;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class SheetButton
extends JPanel {
    static final long serialVersionUID = -5681433767155127558L;
    static final String RIGHT_MOUSE_COMMAND = "rightMouseActionCommand";
    private transient Vector listeners = new Vector(1, 5);
    private String actionCommand = "click";
    private String label;
    private Dimension preferredSize;
    private boolean pressed;
    private boolean focusTransferable;
    private boolean isPlastic;
    private IL innerListener;
    private JComponent innerComponent;
    private boolean plasticNotify;
    private Color foreground;
    private Color inForeground;
    private boolean invalidMark;
    private boolean modifiedMark;
    private boolean flat;

    public SheetButton() {
        this("", false, false);
    }

    public SheetButton(String aLabel) {
        this(aLabel, false, false);
    }

    public SheetButton(String aLabel, boolean isPlasticButton) {
        this(aLabel, isPlasticButton, false);
    }

    public SheetButton(String aLabel, boolean isPlasticButton, boolean plasticActionNotify) {
        this.setDoubleBuffered(false);
        this.setOpaque(true);
        this.label = aLabel == null ? "" : aLabel;
        this.isPlastic = isPlasticButton;
        this.plasticNotify = plasticActionNotify;
        this.innerListener = new IL();
        this.addMouseListener(this.innerListener);
        this.addKeyListener(this.innerListener);
        this.foreground = UIManager.getColor("controlText");
        this.inForeground = UIManager.getColor("Button.disabledText");
    }

    public boolean isFocusTraversable() {
        return this.focusTransferable;
    }

    public void setFocusTraversable(boolean ft) {
        if (this.isFocusTraversable() == ft) {
            return;
        }
        this.focusTransferable = ft;
        if (ft) {
            this.addFocusListener(this.innerListener);
        } else {
            this.removeFocusListener(this.innerListener);
        }
    }

    public void setToolTipText(String str) {
        if (this.invalidMark) {
            str = NbBundle.getMessage(SheetButton.class, (String)"CTL_InvalidValue", (Object)str);
        }
        if (this.innerComponent != null) {
            this.innerComponent.setToolTipText(str);
        }
        super.setToolTipText(str);
    }

    public Dimension getPreferredSize() {
        if (this.preferredSize == null) {
            this.updatePreferredSize();
        }
        return this.preferredSize == null ? new Dimension(10, 10) : this.preferredSize;
    }

    public void setFont(Font aFont) {
        super.setFont(aFont);
        this.updatePreferredSize();
    }

    public Color getActiveForeground() {
        return this.foreground;
    }

    public void setActiveForeground(Color color) {
        this.foreground = color;
        this.repaint();
    }

    public Color getInactiveForeground() {
        return this.inForeground;
    }

    public void setInactiveForeground(Color color) {
        this.inForeground = color;
        this.repaint();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String aLabel) {
        this.label = aLabel;
        if (this.isShowing()) {
            this.updatePreferredSize();
            this.repaint();
        }
    }

    public void setPressed(boolean aPressed) {
        if (this.pressed == aPressed) {
            return;
        }
        this.pressed = aPressed;
        if (this.pressed) {
            this.setBorder(new EmptyBorder(2, 2, 0, 0));
        } else {
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
        }
        this.repaint();
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public void setPlastic(boolean plastic) {
        this.isPlastic = plastic;
        this.repaint();
    }

    public boolean isPlastic() {
        return this.isPlastic;
    }

    public void setActionCommand(String command) {
        this.actionCommand = command;
    }

    public Component add(Component innerComponent) {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.add(innerComponent, "Center");
        this.removeMouseListener(this.innerListener);
        innerComponent.addMouseListener(this.innerListener);
        this.innerComponent = (JComponent)innerComponent;
        return this.innerComponent;
    }

    void setInvalidMark(boolean invalid) {
        this.invalidMark = invalid;
        this.repaint();
    }

    void setModifiedMark(boolean modified) {
        this.modifiedMark = modified;
        this.repaint();
    }

    void setFlat(boolean f) {
        this.flat = f;
    }

    private Image getInvalidImage() {
        return Utilities.loadImage((String)"org/openide/resources/propertysheet/invalid.gif");
    }

    private Image getModifiedImage() {
        return Utilities.loadImage((String)"org/openide/resources/propertysheet/modified.gif");
    }

    private void updatePreferredSize() {
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        Font font = null;
        font = this.getFont();
        if (font == null) {
            return;
        }
        FontMetrics fontMetrics = g.getFontMetrics(font);
        this.preferredSize = new Dimension(fontMetrics.stringWidth(this.label) + 10, fontMetrics.getHeight() + 6);
    }

    public void paint(Graphics g) {
        super.paint(g);
        Dimension size = this.getSize();
        Color color = g.getColor();
        Font theFont = g.getFont();
        int xShift = 0;
        if (this.invalidMark) {
            xShift += this.getInvalidImage().getWidth(null) + 2;
        }
        if (this.modifiedMark) {
            xShift += this.getModifiedImage().getWidth(null) + 2;
        }
        g.setFont(this.getFont());
        FontMetrics fontMetrics = g.getFontMetrics();
        if (this.flat || this.pressed) {
            if (this.innerComponent == null) {
                g.setColor(this.isEnabled() ? this.getActiveForeground() : this.getInactiveForeground());
                g.drawString(this.label, 6 + xShift, (size.height - fontMetrics.getHeight()) / 2 + 1 + fontMetrics.getMaxAscent());
                if (this.invalidMark) {
                    g.drawImage(this.getInvalidImage(), 5, (size.height - this.getInvalidImage().getHeight(null)) / 2 + 1, null);
                }
                if (this.modifiedMark) {
                    g.drawImage(this.getModifiedImage(), this.invalidMark ? this.getInvalidImage().getWidth(null) + 7 : 5, (size.height - this.getModifiedImage().getHeight(null)) / 2 + 1, null);
                }
            }
        } else {
            g.setColor(UIManager.getColor("controlLtHighlight"));
            g.drawLine(0, 0, size.width - 1, 0);
            g.drawLine(0, 0, 0, size.height - 1);
            g.setColor(UIManager.getColor("controlDkShadow"));
            g.drawLine(size.width - 1, 0, size.width - 1, size.height - 1);
            g.drawLine(0, size.height - 1, size.width - 1, size.height - 1);
            if (this.innerComponent == null) {
                g.setColor(this.isEnabled() ? this.getActiveForeground() : this.getInactiveForeground());
                g.drawString(this.label, 5 + xShift, (size.height - fontMetrics.getHeight()) / 2 + fontMetrics.getMaxAscent());
                if (this.invalidMark) {
                    g.drawImage(this.getInvalidImage(), 4, (size.height - this.getInvalidImage().getHeight(null)) / 2, null);
                }
                if (this.modifiedMark) {
                    g.drawImage(this.getModifiedImage(), this.invalidMark ? this.getInvalidImage().getWidth(null) + 6 : 4, (size.height - this.getModifiedImage().getHeight(null)) / 2, null);
                }
            }
        }
        if (this.hasFocus()) {
            g.setColor(UIManager.getColor("Button.focus"));
            g.drawRect(2, 1, size.width - 5, size.height - 4);
        }
        g.setFont(theFont);
        g.setColor(color);
    }

    public String toString() {
        return this.getClass().getName() + "[ \"" + this.label + "\" ]";
    }

    void addSheetButtonListener(SheetButtonListener sheetButtonListener) {
        if (!this.listeners.contains(sheetButtonListener)) {
            this.listeners.addElement(sheetButtonListener);
        }
    }

    void removeSheetButtonListener(SheetButtonListener sheetButtonListener) {
        this.listeners.removeElement(sheetButtonListener);
    }

    public void notifySheetButtonListenersAboutClick(ActionEvent e) {
        Vector l = (Vector)this.listeners.clone();
        int k = l.size();
        for (int i = 0; i < k; ++i) {
            ((SheetButtonListener)l.elementAt(i)).sheetButtonClicked(e);
        }
    }

    public void notifySheetButtonListenersAboutEntered(ActionEvent e) {
        Vector l = (Vector)this.listeners.clone();
        int k = l.size();
        for (int i = 0; i < k; ++i) {
            ((SheetButtonListener)l.elementAt(i)).sheetButtonEntered(e);
        }
    }

    public void notifySheetButtonListenersAboutExited(ActionEvent e) {
        Vector l = (Vector)this.listeners.clone();
        int k = l.size();
        for (int i = 0; i < k; ++i) {
            ((SheetButtonListener)l.elementAt(i)).sheetButtonExited(e);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSheetButton();
        }
        return this.accessibleContext;
    }

    class AccessibleSheetButton
    extends JComponent.AccessibleJComponent {
        AccessibleSheetButton() {
            super(SheetButton.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }

        public String getAccessibleName() {
            String name = super.getAccessibleName();
            if (name == null && SheetButton.this.innerComponent != null) {
                name = SheetButton.this.innerComponent.getAccessibleContext().getAccessibleName();
            }
            if (name == null && SheetButton.this.label != null) {
                name = SheetButton.this.label;
            }
            return NbBundle.getMessage(SheetButton.class, (String)"ACS_SheetButton", (Object)new Integer(SheetButton.this.invalidMark ? 0 : 1), (Object)name);
        }

        public String getAccessibleDescription() {
            String name = super.getAccessibleDescription();
            if (name == null && SheetButton.this.innerComponent != null) {
                name = SheetButton.this.innerComponent.getAccessibleContext().getAccessibleDescription();
            }
            if (name == null && SheetButton.this.label != null) {
                name = SheetButton.this.label;
            }
            return NbBundle.getMessage(SheetButton.class, (String)"ACS_SheetButton", (Object)new Integer(SheetButton.this.invalidMark ? 0 : 1), (Object)name);
        }
    }

    private class IL
    extends MouseMotionAdapter
    implements MouseListener,
    KeyListener,
    FocusListener {
        IL() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (!SheetButton.this.isPlastic) {
                SheetButton.this.pressed = true;
                SheetButton.this.setBorder(new EmptyBorder(2, 2, 0, 0));
                SheetButton.this.notifySheetButtonListenersAboutEntered(new ActionEvent(SheetButton.this, 1001, SheetButton.this.actionCommand));
                if (SheetButton.this.innerComponent != null) {
                    SheetButton.this.invalidate();
                    if (SheetButton.this.getParent() != null) {
                        SheetButton.this.getParent().validate();
                    }
                    SheetButton.this.innerComponent.addMouseMotionListener(SheetButton.this.innerListener);
                } else {
                    SheetButton.this.addMouseMotionListener(SheetButton.this.innerListener);
                }
                SheetButton.this.repaint();
            }
        }

        public void mouseReleased(MouseEvent e) {
            boolean isRightClick = MouseUtils.isRightMouseButton((MouseEvent)e);
            if (SheetButton.this.innerComponent != null) {
                SheetButton.this.innerComponent.removeMouseMotionListener(SheetButton.this.innerListener);
                SheetButton.this.invalidate();
                if (SheetButton.this.getParent() != null) {
                    SheetButton.this.getParent().validate();
                }
            } else {
                SheetButton.this.removeMouseMotionListener(SheetButton.this.innerListener);
            }
            SheetButton.this.repaint();
            if (SheetButton.this.isEnabled()) {
                SheetButton.this.notifySheetButtonListenersAboutClick(new ActionEvent(SheetButton.this, e.getClickCount() % 2 == 1 ? 1002 : 1003, isRightClick ? SheetButton.RIGHT_MOUSE_COMMAND : SheetButton.this.actionCommand));
                SheetButton.this.notifySheetButtonListenersAboutExited(new ActionEvent(SheetButton.this, 1001, SheetButton.this.actionCommand));
            }
            SheetButton.this.pressed = false;
            SheetButton.this.setBorder(new EmptyBorder(1, 1, 1, 1));
        }

        public void mouseEntered(MouseEvent e) {
            if (SheetButton.this.isPlastic) {
                SheetButton.this.pressed = true;
                SheetButton.this.setBorder(new EmptyBorder(2, 2, 0, 0));
                SheetButton.this.repaint();
                if (SheetButton.this.plasticNotify) {
                    SheetButton.this.notifySheetButtonListenersAboutEntered(new ActionEvent(SheetButton.this, 1001, SheetButton.this.actionCommand));
                }
            }
        }

        public void mouseExited(MouseEvent e) {
            if (SheetButton.this.isPlastic) {
                SheetButton.this.pressed = false;
                SheetButton.this.setBorder(new EmptyBorder(1, 1, 1, 1));
                SheetButton.this.repaint();
                if (SheetButton.this.plasticNotify) {
                    SheetButton.this.notifySheetButtonListenersAboutExited(new ActionEvent(SheetButton.this, 1001, SheetButton.this.actionCommand));
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (new Rectangle(SheetButton.this.getSize()).contains(e.getPoint()) == SheetButton.this.pressed) {
                return;
            }
            if (SheetButton.this.pressed) {
                SheetButton.this.notifySheetButtonListenersAboutExited(new ActionEvent(SheetButton.this, 1001, SheetButton.this.actionCommand));
            } else {
                SheetButton.this.notifySheetButtonListenersAboutEntered(new ActionEvent(SheetButton.this, 1001, SheetButton.this.actionCommand));
            }
            SheetButton.this.pressed = !SheetButton.this.pressed;
            if (SheetButton.this.pressed) {
                SheetButton.this.setBorder(new EmptyBorder(2, 2, 0, 0));
            } else {
                SheetButton.this.setBorder(new EmptyBorder(1, 1, 1, 1));
            }
            if (SheetButton.this.innerComponent != null) {
                SheetButton.this.invalidate();
                if (SheetButton.this.getParent() != null) {
                    SheetButton.this.getParent().validate();
                }
            }
            SheetButton.this.repaint();
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (e.isControlDown()) {
                return;
            }
            if (e.getKeyCode() == 32 || e.getKeyCode() == 10) {
                SheetButton.this.notifySheetButtonListenersAboutClick(new ActionEvent(SheetButton.this, 1002, SheetButton.this.actionCommand));
            }
            if (e.getKeyCode() == 40) {
                FocusManager fm = FocusManager.getCurrentManager();
                fm.focusNextComponent(SheetButton.this);
                e.consume();
            } else if (e.getKeyCode() == 38) {
                FocusManager fm = FocusManager.getCurrentManager();
                fm.focusPreviousComponent(SheetButton.this);
                e.consume();
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void focusGained(FocusEvent fe) {
            SheetButton.this.notifySheetButtonListenersAboutEntered(new ActionEvent(SheetButton.this, 1002, SheetButton.this.actionCommand));
            Container c = SheetButton.this;
            Rectangle r = SheetButton.this.getBounds();
            while (c != null && !(c instanceof JViewport)) {
                if ((c = c.getParent()) == null) continue;
                r.x += c.getX();
                r.y += c.getY();
            }
            if (c != null) {
                JViewport jvp = (JViewport)c;
                jvp.scrollRectToVisible(r);
            }
            SheetButton.this.repaint();
        }

        public void focusLost(FocusEvent fe) {
            if (SheetButton.this.isPlastic) {
                SheetButton.this.pressed = false;
                SheetButton.this.setBorder(new EmptyBorder(1, 1, 1, 1));
            }
            SheetButton.this.notifySheetButtonListenersAboutExited(new ActionEvent(SheetButton.this, 1002, SheetButton.this.actionCommand));
            SheetButton.this.repaint();
        }
    }
}

