/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.cppsupport.prop;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.WeakListeners;

final class ProxyNode
extends AbstractNode {
    private Node[] original;
    private PropertyChangeListener pcl;

    public ProxyNode(Node[] original) {
        super(Children.LEAF);
        this.original = original;
        this.pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent pce) {
                ProxyNode.this.firePropertyChange(pce.getPropertyName(), pce.getOldValue(), pce.getNewValue());
            }
        };
        for (int i = 0; i < original.length; ++i) {
            original[i].addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.pcl, (Object)original[i]));
        }
    }

    public HelpCtx getHelpCtx() {
        for (int i = 0; i < this.original.length; ++i) {
            if (this.original[i].getHelpCtx() == HelpCtx.DEFAULT_HELP) continue;
            return this.original[i].getHelpCtx();
        }
        return HelpCtx.DEFAULT_HELP;
    }

    public Node cloneNode() {
        return new ProxyNode(this.original);
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set[] computedSet = this.computePropertySets();
        for (int i = 0; i < computedSet.length; ++i) {
            sheet.put(computedSet[i]);
        }
        return sheet;
    }

    Node[] getOriginalNodes() {
        return this.original;
    }

    private Sheet.Set[] computePropertySets() {
        if (this.original.length > 0) {
            Node.PropertySet[] firstSet = this.original[0].getPropertySets();
            HashSet<Node.PropertySet> sheets = new HashSet<Node.PropertySet>(Arrays.asList(firstSet));
            for (int i = 1; i < this.original.length; ++i) {
                sheets.retainAll(new HashSet<Node.PropertySet>(Arrays.asList(this.original[i].getPropertySets())));
            }
            ArrayList<Sheet.Set> resultSheets = new ArrayList<Sheet.Set>(sheets.size());
            for (int i = 0; i < firstSet.length; ++i) {
                if (!sheets.contains(firstSet[i]) || firstSet[i].isHidden()) continue;
                Node.PropertySet current = firstSet[i];
                Sheet.Set res = new Sheet.Set();
                res.setName(current.getName());
                res.setDisplayName(current.getDisplayName());
                res.setShortDescription(current.getShortDescription());
                HashSet<Node.Property> props = new HashSet<Node.Property>(Arrays.asList(current.getProperties()));
                for (int j = 0; j < this.original.length; ++j) {
                    Node.PropertySet[] p = this.original[j].getPropertySets();
                    for (int k = 0; k < p.length; ++k) {
                        Node.Property[] arr = p[k].getProperties();
                        if (!current.getName().equals(p[k].getName())) continue;
                        props.retainAll(new HashSet<Node.Property>(Arrays.asList(p[k].getProperties())));
                    }
                }
                Node.Property[] p = current.getProperties();
                for (int j = 0; j < p.length; ++j) {
                    if (!props.contains(p[j]) || p[j].isHidden()) continue;
                    ProxyProperty pp = this.createProxyProperty(p[j].getName(), res.getName());
                    res.put((Node.Property)pp);
                }
                resultSheets.add(res);
            }
            return resultSheets.toArray(new Sheet.Set[resultSheets.size()]);
        }
        return new Sheet.Set[0];
    }

    private ProxyProperty createProxyProperty(String propName, String setName) {
        Node.Property[] arr = new Node.Property[this.original.length];
        for (int i = 0; i < this.original.length; ++i) {
            Node.PropertySet[] p = this.original[i].getPropertySets();
            for (int j = 0; j < p.length; ++j) {
                if (!p[j].getName().equals(setName)) continue;
                Node.Property[] np = p[j].getProperties();
                for (int k = 0; k < np.length; ++k) {
                    if (!np[k].getName().equals(propName)) continue;
                    arr[i] = np[k];
                }
            }
        }
        return new ProxyProperty(arr);
    }

    static class DifferentValuesException
    extends RuntimeException {
        public DifferentValuesException() {
        }

        public DifferentValuesException(String message) {
            super(message);
        }
    }

    private static class ProxyProperty
    extends Node.Property {
        private Node.Property[] original;

        public ProxyProperty(Node.Property[] original) {
            super(original[0].getValueType());
            this.original = original;
            this.setName(original[0].getName());
            this.setDisplayName(original[0].getDisplayName());
            this.setShortDescription(original[0].getShortDescription());
        }

        public boolean canWrite() {
            for (int i = 0; i < this.original.length; ++i) {
                if (this.original[i].canWrite()) continue;
                return false;
            }
            return true;
        }

        public boolean canRead() {
            for (int i = 0; i < this.original.length; ++i) {
                if (this.original[i].canRead()) continue;
                return false;
            }
            return true;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            Object o = this.original[0].getValue();
            if (o == null) {
                return null;
            }
            for (int i = 0; i < this.original.length; ++i) {
                if (o.equals(this.original[i].getValue())) continue;
                throw new DifferentValuesException();
            }
            return o;
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            for (int i = 0; i < this.original.length; ++i) {
                this.original[i].setValue(val);
            }
        }

        public Object getValue(String attributeName) {
            Object o = this.original[0].getValue(attributeName);
            if (o == null) {
                return null;
            }
            for (int i = 0; i < this.original.length; ++i) {
                if (o.equals(this.original[i].getValue(attributeName))) continue;
                ErrorManager.getDefault().notify(1, (Throwable)new DifferentValuesException("Different values in attribute " + attributeName));
                return null;
            }
            return o;
        }

        public void setValue(String attributeName, Object value) {
            for (int i = 0; i < this.original.length; ++i) {
                this.original[i].setValue(attributeName, value);
            }
        }

        public PropertyEditor getPropertyEditor() {
            return this.original[0].getPropertyEditor();
        }

        public boolean supportsDefaultValue() {
            for (int i = 0; i < this.original.length; ++i) {
                if (this.original[i].supportsDefaultValue()) continue;
                return false;
            }
            return true;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            for (int i = 0; i < this.original.length; ++i) {
                this.original[i].restoreDefaultValue();
            }
        }
    }
}

