/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.wizard;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileSystemView;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.remotefs.smb.NetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteRootVisualPanel;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.HelpCtx;

public class RemoteRootPanel
implements WizardDescriptor.Panel {
    protected Component component;
    protected Component errorComponent;
    private RemoteRuntimeType rrt;
    private ArrayList listeners = new ArrayList();
    private FileSystemView fsv = FileSystemView.getFileSystemView();
    private boolean firstTime = true;

    public RemoteRuntimeType getRemoteRuntimeType() {
        return this.rrt;
    }

    public String getRemoteDirectory(String localDirectory) {
        RemoteRuntimeType rrt = this.getRemoteRuntimeType();
        return NetworkFileSystem.getRemoteDirectoryShare(rrt, localDirectory);
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new RemoteRootVisualPanel(this, this.fsv);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        if (!(this.getComponent() instanceof RemoteRootVisualPanel)) {
            return false;
        }
        if (!((RemoteRootVisualPanel)this.getComponent()).getLocalDirectory().equals("") && !((RemoteRootVisualPanel)this.getComponent()).getRemoteDirectory().equals("")) {
            Enumeration fse = Repository.getDefault().getFileSystems();
            while (fse.hasMoreElements()) {
                String lroot;
                FileSystem fs = (FileSystem)fse.nextElement();
                if (!(fs instanceof LocalFileSystem) || !(lroot = ((LocalFileSystem)fs).getRootDirectory().getAbsolutePath()).equalsIgnoreCase(((RemoteRootVisualPanel)this.component).getLocalDirectory())) continue;
                return fs instanceof NetworkFileSystem && fs.isHidden();
            }
            return true;
        }
        return false;
    }

    public final void addChangeListener(ChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChangeState() {
        ArrayList list;
        RemoteRootPanel remoteRootPanel = this;
        synchronized (remoteRootPanel) {
            list = (ArrayList)this.listeners.clone();
        }
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < list.size(); ++i) {
            ((ChangeListener)list.get(i)).stateChanged(event);
        }
    }

    public void readSettings(Object settings) {
        WizardDescriptor wiz = (WizardDescriptor)settings;
        this.rrt = (RemoteRuntimeType)wiz.getProperty("remote_runtime");
        this.firstTime = true;
        this.fsv = FileSystemView.getFileSystemView();
    }

    public void storeSettings(Object settings) {
        WizardDescriptor wiz = (WizardDescriptor)settings;
        if (!(this.component instanceof RemoteRootVisualPanel)) {
            return;
        }
        wiz.putProperty("local_directory", (Object)((RemoteRootVisualPanel)this.component).getLocalDirectory());
        wiz.putProperty("remote_directory", (Object)((RemoteRootVisualPanel)this.component).getRemoteDirectory());
    }
}

