/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteexecute.ant;

import java.io.IOException;
import java.util.HashMap;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.netbeans.modules.distributed.common.cookies.RemoteCookie;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.remoteexecute.ant.RemoteAntExecutor;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CookieAction;
import org.w3c.dom.Element;

public final class RemoteAntExecution
extends CookieAction {
    protected void performAction(Node[] activatedNodes) {
        final Node[] anodes = activatedNodes;
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                RemoteAntExecution.doAntAction(anodes);
            }
        });
    }

    public static RemoteAntExecutor getRemoteAntExecutorType() {
        RemoteAntExecutor ex = (RemoteAntExecutor)Lookup.getDefault().lookup(RemoteAntExecutor.class);
        return ex;
    }

    public static void doAntAction(Node[] activatedNodes) {
        int i;
        if (DistributedSettings.getDefault().getSaveAll()) {
            LifecycleManager.getDefault().saveAll();
        }
        for (i = 0; i < activatedNodes.length; ++i) {
            if (activatedNodes[i].getCookie(AntProjectCookie.class) == null) continue;
            DataObject dobj = (DataObject)activatedNodes[i].getCookie(DataObject.class);
            RemoteAntExecutor ret = RemoteAntExecution.getRemoteAntExecutorType();
            if (ret == null) {
                ErrorManager.getDefault().notify((Throwable)new Exception("Remote Ant Execute Action Failed"));
                return;
            }
            try {
                String target = RemoteAntExecution.getTarget(activatedNodes[i]);
                ret.execute(dobj, target, new HashMap()).result();
                continue;
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }
        for (i = 0; i < activatedNodes.length; ++i) {
            if (activatedNodes[i].getCookie(AntProjectCookie.class) == null) continue;
            final AntProjectCookie pcookie = (AntProjectCookie)activatedNodes[i].getCookie(AntProjectCookie.class);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    FileObject script = pcookie.getFileObject();
                    if (script != null) {
                        try {
                            FileSystem fs = script.getFileSystem();
                            fs.refresh(false);
                        }
                        catch (FileStateInvalidException e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                    }
                }
            }, 1000);
        }
    }

    protected int mode() {
        return 7;
    }

    public String getName() {
        return NbBundle.getMessage(RemoteAntExecution.class, (String)"CTL_RemoteAntExecution");
    }

    protected Class[] cookieClasses() {
        return new Class[]{DataObject.class};
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    public static boolean isEnable(Node[] node) {
        for (int i = 0; i < node.length; ++i) {
            DataObject dobj = (DataObject)node[i].getCookie(DataObject.class);
            if (dobj == null) {
                return false;
            }
            if (dobj.getPrimaryFile().isFolder() || dobj.getPrimaryFile().isRoot()) {
                return false;
            }
            if (dobj.getCookie(RemoteCookie.class) != null) {
                return false;
            }
            if (node[i].getCookie(AntProjectCookie.class) == null) {
                return false;
            }
            try {
                if (dobj.getPrimaryFile().getFileSystem() instanceof AbstractNetworkFileSystem) continue;
                return false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    protected boolean enable(Node[] node) {
        return RemoteAntExecution.isEnable(node);
    }

    private static String getTarget(Node node) {
        AntProjectCookie project = (AntProjectCookie)node.getCookie(AntProjectCookie.class);
        if (project == null) {
            return null;
        }
        if (project.getParseException() != null) {
            return null;
        }
        Element pel = project.getProjectElement();
        String deftarget = pel.getAttribute("default");
        return deftarget;
    }
}

