/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteexecute;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.distributed.remoteexecute.BasicAction;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class RemoteProjectOpen
extends BasicAction {
    static final long serialVersionUID = -7910677883191530621L;
    static final String REMOTE_OPERATIONS = "Open Remote Project...";

    public RemoteProjectOpen() {
        super(REMOTE_OPERATIONS, null);
    }

    private void openProject(final Project p) {
        Project[] projects = new Project[]{p};
        OpenProjects.getDefault().open(projects, true);
        ContextAwareAction action = (ContextAwareAction)CommonProjectActions.setAsMainProjectAction();
        Lookup ctx = Lookups.singleton((Object)p);
        Action ctxAction = action.createContextAwareInstance(ctx);
        ctxAction.actionPerformed(null);
        SwingUtilities.invokeLater(new Runnable(){
            ExplorerManager.Provider ptLogial = (ExplorerManager.Provider)WindowManager.getDefault().findTopComponent("projectTab_tc");

            public void run() {
                Node root = this.ptLogial.getExplorerManager().getRootContext();
                Node projNode = root.getChildren().findChild(ProjectUtils.getInformation((Project)p).getName());
                if (projNode != null) {
                    try {
                        this.ptLogial.getExplorerManager().setSelectedNodes(new Node[]{projNode});
                        ((TopComponent)this.ptLogial).open();
                        ((TopComponent)this.ptLogial).requestActive();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void actionPerformed(ActionEvent evt) {
        JFileChooser chooser = ProjectChooser.projectChooser();
        int option = chooser.showOpenDialog(WindowManager.getDefault().getMainWindow());
        Project project = null;
        if (option == 0) {
            File projectDir = chooser.getSelectedFile();
            try {
                project = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)projectDir));
                this.openProject(project);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(16, (Throwable)e);
            }
        }
    }

    public String getName() {
        return REMOTE_OPERATIONS;
    }

    public boolean asynchronous() {
        return false;
    }
}

