/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.ideserverclient;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.dgc.VMID;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.HashMap;
import org.netbeans.modules.distributed.common.util.RMIMethodInvoker;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.rmi.impl.ServerOutputImpl;
import org.netbeans.modules.distributed.rmi.protocol.Admin;
import org.netbeans.modules.distributed.rmi.protocol.RemoteFileService;
import org.netbeans.modules.distributed.rmi.protocol.RemoteLoginServer;
import org.netbeans.modules.distributed.rmi.protocol.RemoteRuntime;
import org.netbeans.modules.distributed.rmi.protocol.SecurityContext;
import org.netbeans.modules.distributed.rmi.protocol.ServerOutput;
import org.netbeans.modules.distributed.ssl.DistNBClientSocketFactory;

public class RemoteLoginClient
implements Serializable {
    private static final int SVR_TIME_OUT = 60000;
    private static final int SVR_TIME_OUT_DELTA = 10000;
    private static final String CONNECT_FAIL_MSG = "Connection attempt timed out. Please try again.";
    private SecurityContext sci;
    private transient RemoteLoginServer loginServer;
    private transient RemoteRuntime rt;
    private transient RemoteFileService remoteFileService;
    private String server;
    private int port;
    private HashMap loginInfo;
    private transient ServerOutput svrOutput;
    private transient ArrayList extraBucket = new ArrayList(2);
    private transient boolean isTimedOut = false;
    private boolean connected = false;
    private boolean connecting = false;
    private String errorMsg;
    private final String remoteLoginServerName = System.getProperty("org.netbeans.modules.distributed.client.loginServer", "DistNBRemoteLoginServer");
    private long lastTimeServerAlive;
    private VMID uniqueID;

    public synchronized boolean isConnected() {
        return this.findRemoteRuntime() != null;
    }

    public synchronized boolean isConnecting() {
        return this.connecting;
    }

    public String authenticate(HashMap loginInfo, String server, int port) {
        try {
            Registry reg = LocateRegistry.getRegistry(server, port, new DistNBClientSocketFactory());
            RemoteLoginServer loginServer = (RemoteLoginServer)reg.lookup(this.remoteLoginServerName);
            return loginServer.authenticate(loginInfo);
        }
        catch (NotBoundException e) {
            return e.getMessage();
        }
        catch (RemoteException e) {
            return e.getMessage();
        }
    }

    public String getUserUAIInfo(HashMap loginInfo, String server, int port) {
        try {
            Registry reg = LocateRegistry.getRegistry(server, port, new DistNBClientSocketFactory());
            RemoteLoginServer loginServer = (RemoteLoginServer)reg.lookup(this.remoteLoginServerName);
            return loginServer.checkUserSysInfo(loginInfo);
        }
        catch (NotBoundException e) {
            return e.getMessage();
        }
        catch (RemoteException e) {
            return e.getMessage();
        }
    }

    public String getUserEnv(HashMap loginInfo, String server, int port) {
        try {
            Registry reg = LocateRegistry.getRegistry(server, port, new DistNBClientSocketFactory());
            RemoteLoginServer loginServer = (RemoteLoginServer)reg.lookup(this.remoteLoginServerName);
            return loginServer.checkUserEnv(loginInfo);
        }
        catch (NotBoundException e) {
            return e.getMessage();
        }
        catch (RemoteException e) {
            return e.getMessage();
        }
    }

    public String canFindLoginServer(String server, int port) {
        try {
            Registry reg = LocateRegistry.getRegistry(server, port, new DistNBClientSocketFactory());
            RemoteLoginServer loginServer = (RemoteLoginServer)reg.lookup(this.remoteLoginServerName);
        }
        catch (NotBoundException e) {
            return e.getMessage();
        }
        catch (RemoteException e) {
            return e.getMessage();
        }
        return "success";
    }

    public boolean isServerTimedOut() {
        return this.isTimedOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect(HashMap loginInfo, String server, int port) {
        RemoteLoginClient remoteLoginClient = this;
        synchronized (remoteLoginClient) {
            this.close();
            this.connecting = true;
            this.connected = false;
        }
        this.server = server;
        this.port = port;
        this.loginInfo = loginInfo;
        this.errorMsg = null;
        this.isTimedOut = false;
        try {
            Registry reg = LocateRegistry.getRegistry(server, port, new DistNBClientSocketFactory());
            try {
                this.loginServer = (RemoteLoginServer)reg.lookup(this.remoteLoginServerName);
            }
            catch (NotBoundException e) {
                this.loginServer = (RemoteLoginServer)reg.lookup("rmi://" + InetAddress.getByName(server).getHostAddress() + ":" + port + "/" + this.remoteLoginServerName);
            }
            this.svrOutput = new ServerOutputImpl();
            StringBuffer errMsg = new StringBuffer();
            if (RMIMethodInvoker.connect(this.loginServer, loginInfo, this.svrOutput, errMsg)) {
                this.sci = (SecurityContext)this.svrOutput.getOutput();
            } else {
                String msg;
                this.extraBucket.add(this.svrOutput);
                if (errMsg.length() == 0) {
                    msg = CONNECT_FAIL_MSG;
                    this.isTimedOut = true;
                } else {
                    msg = errMsg.toString();
                }
                ((ServerOutputImpl)this.svrOutput).setClientInitiatedServerError(msg);
                this.sci = null;
            }
            RemoteLoginClient remoteLoginClient2 = this;
            synchronized (remoteLoginClient2) {
                this.connecting = false;
                this.remoteFileService = null;
                if (this.sci != null) {
                    this.connected = true;
                    this.uniqueID = new VMID();
                    return true;
                }
                this.connected = false;
                this.errorMsg = this.svrOutput.getMessage();
                this.svrOutput = null;
                return false;
            }
        }
        catch (NotBoundException e) {
            this.errorMsg = e.getMessage();
            RemoteLoginClient remoteLoginClient3 = this;
            synchronized (remoteLoginClient3) {
                this.connecting = false;
            }
            return false;
        }
        catch (RemoteException e) {
            this.errorMsg = e.getMessage();
            RemoteLoginClient remoteLoginClient4 = this;
            synchronized (remoteLoginClient4) {
                this.connecting = false;
            }
            return false;
        }
        catch (UnknownHostException e) {
            this.errorMsg = e.getMessage();
            RemoteLoginClient remoteLoginClient5 = this;
            synchronized (remoteLoginClient5) {
                this.connecting = false;
            }
            return false;
        }
    }

    public RemoteFileService getRemoteFileService() {
        if (this.remoteFileService == null) {
            try {
                this.rt = this.findRemoteRuntime();
                this.remoteFileService = this.rt.getRemoteFileService();
                return this.remoteFileService;
            }
            catch (RemoteException e) {
                this.errorMsg = e.getMessage();
                return null;
            }
        }
        return this.remoteFileService;
    }

    private void sendKeepAlive() throws RemoteException {
    }

    public void keepServerAlive() {
        KeepServerAlive keepServerAlive = new KeepServerAlive(DistributedSettings.getDefault().getTimeOut());
        keepServerAlive.setDaemon(true);
        keepServerAlive.start();
    }

    private void findRemoteRuntimeImpl() throws NotBoundException, RemoteException, UnknownHostException {
        Registry reg = LocateRegistry.getRegistry(this.server, this.port, new DistNBClientSocketFactory());
        try {
            this.rt = (RemoteRuntime)reg.lookup(this.sci.getRemoteRuntimeID());
        }
        catch (NotBoundException e) {
            this.rt = (RemoteRuntime)reg.lookup("rmi://" + InetAddress.getByName(this.server).getHostAddress() + ":" + this.port + "/" + this.sci.getRemoteRuntimeID());
        }
    }

    public synchronized RemoteRuntime findRemoteRuntimeServerSafe() {
        try {
            if (this.connected) {
                this.findRemoteRuntimeImpl();
                if (this.rt != null && this.sci != null) {
                    return this.rt;
                }
            }
        }
        catch (NotBoundException e) {
            this.errorMsg = e.getMessage();
        }
        catch (RemoteException e) {
            this.errorMsg = e.getMessage();
        }
        catch (UnknownHostException e) {
            this.errorMsg = e.getMessage();
        }
        return null;
    }

    public synchronized RemoteRuntime findRemoteRuntime() {
        try {
            if (this.connected && this.rt != null) {
                return this.rt;
            }
            if (this.connected) {
                this.findRemoteRuntimeImpl();
                if (this.rt != null && this.sci != null) {
                    return this.rt;
                }
            }
        }
        catch (NotBoundException e) {
            this.errorMsg = e.getMessage();
        }
        catch (RemoteException e) {
            this.errorMsg = e.getMessage();
        }
        catch (UnknownHostException e) {
            this.errorMsg = e.getMessage();
        }
        return null;
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    public synchronized boolean close() {
        try {
            boolean ret = true;
            if (this.isConnected()) {
                this.connected = false;
                this.loginServer.logout(this.loginInfo, this.sci);
                ret = true;
                this.rt = null;
            } else {
                this.errorMsg = "Not connected";
                ret = false;
            }
            for (int i = 0; i < this.extraBucket.size(); ++i) {
                ServerOutputImpl sout = (ServerOutputImpl)this.extraBucket.get(i);
                if (sout.getOutput() == null) continue;
                this.loginServer.logout(this.loginInfo, (SecurityContext)sout.getOutput());
            }
            return ret;
        }
        catch (RemoteException e) {
            this.errorMsg = e.getMessage();
            return false;
        }
    }

    public Admin getAdminInterface(String pass) {
        try {
            if (this.isConnected()) {
                return this.loginServer.getAdminInterface(pass);
            }
        }
        catch (RemoteException e) {
            this.errorMsg = e.getMessage();
        }
        return null;
    }

    public String getServerVersionDirect(String server, int port) {
        try {
            Registry reg = LocateRegistry.getRegistry(server, port, new DistNBClientSocketFactory());
            RemoteLoginServer loginServer = (RemoteLoginServer)reg.lookup(this.remoteLoginServerName);
            return loginServer.getServerVersion();
        }
        catch (NotBoundException e) {
            return e.getMessage();
        }
        catch (RemoteException e) {
            return e.getMessage();
        }
    }

    public String getServerVersion() {
        try {
            if (this.isConnected()) {
                return this.loginServer.getServerVersion();
            }
        }
        catch (RemoteException e) {
            this.errorMsg = e.getMessage();
        }
        return "Unavailable";
    }

    public String getJDKVersion() {
        try {
            if (this.isConnected()) {
                return this.loginServer.getJDKVersion();
            }
        }
        catch (RemoteException e) {
            this.errorMsg = e.getMessage();
        }
        return "Unavailable";
    }

    public String getNetworkShareRoot(String shareName) {
        try {
            if (this.isConnected()) {
                return this.loginServer.translateNetworkShare(shareName);
            }
        }
        catch (RemoteException e) {
            this.errorMsg = e.getMessage();
        }
        return null;
    }

    public byte[] getTicket() {
        if (this.isConnected()) {
            return this.sci.getAuthenticationHash();
        }
        return null;
    }

    protected void finalize() {
        this.close();
        this.loginServer = null;
    }

    public String getID() {
        return this.sci.getRemoteRuntimeID();
    }

    public boolean isServerFailed() {
        return this.connected && this.findRemoteRuntimeServerSafe() == null;
    }

    class KeepServerAlive
    extends Thread {
        int interval;

        public KeepServerAlive(int interval) {
            this.interval = interval;
        }

        public void run() {
            try {
                while (!KeepServerAlive.interrupted()) {
                    KeepServerAlive.sleep(this.interval);
                    RemoteLoginClient.this.sendKeepAlive();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

