/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.common.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.distributed.common.util.MyMemoryHandler;
import org.netbeans.modules.distributed.common.util.MySimpleFormatter;
import org.netbeans.modules.distributed.common.util.MyStreamHandler;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Utilities;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import patchsources.OpenProjectList_Dist;

public class Utils {
    public static final String REMOTE_AWARE = "REMOTE_AWARE";
    public static String OS_VMS = "OpenVMS";
    public static String JAVA_HOME_141_OVMS = "/SYS$COMMON/java$141/jre";
    public static String JDK_HOME_141_OVMS = "/SYS$COMMON/java$141";
    public static final String PUTALL_OUTPUT_PANE = " - Put All Files To the Server";
    public static final String GETALL_OUTPUT_PANE = " - Get All Files From the Server";
    public static final String SYNC_OUTPUT_PANE = " - Synchronize";
    public static final String REFRESH_OUTPUT_PANE = " - Refresh";
    public static final String REFRESH = "refresh";
    public static final String SYNC = "sync";
    public static final String GET_ALL = "getall";
    public static final String PUT_ALL = "putall";
    public static final String REMOTE_FS = "remote_fs";
    public static final String PASCAL = "pascal";
    public static final String C = "c";
    public static final String CPP = "cpp";
    public static final String BASIC = "basic";
    public static final String FORTRAN = "fortran";
    public static final String COBOL = "cobol";
    public static final String DCL = "dcl";
    public static final String BASH = "sh";
    public static final String MMS = "mms";
    public static final String ANT = "ant";
    public static final String LOG = "log";
    public static final String GLOBAL_QUALIFIER = "global_qualifier";
    public static final String LOCAL_QUALIFIER = "local_qualifier";
    public static final String BUILD_COMMAND = "build_command";
    public static final String BUILD_DIR = "build_dir";
    public static final String USE_COMMAND_FILE = "use_command_file";
    public static final String COMPILE_COMMAND = "compile_command";
    public static final String COMPILE_PARAM = "compile_param";
    public static final String COMMAND_FILE = "command_file";
    public static final String ERROR_EXP = "error_exp";
    public static final String ERROR_EXP_OPT = "error_exp_opt";
    public static final String ERROR_EXP_ANT = "error_exp_ant";
    public static final String ERROR_EXP_OPT_ANT = "error_exp_opt_ant";
    public static final String COB_ANSI = "cobol_ansi";
    public static final String FOR_FIXED = "for_form";
    public static final String FOR_SRC_FORM = "for_src_form";
    public static final String DEFAULT_BUILD_COMMAND = "@{command file} {file}";
    public static final String DEFAULT_COMPILE_C = "cc";
    public static final String DEFAULT_COMPILE_CPP = "cxx";
    public static final String DEFAULT_COMPILE_COB = "cob";
    public static final String DEFAULT_COMPILE_PAS = "pas";
    public static final String DEFAULT_COMPILE_BAS = "bas";
    public static final String DEFAULT_COMPILE_FOR = "for";
    public static final String DEFAULT_COMPILE_DCL = "@{file}";
    public static final String DEFAULT_COMPILE_BASH = "bash {file}";
    public static final String DEFAULT_COMPILE_MMS = "mms/desc={file} {target}";
    public static final String DEFAULT_COMPILE_ANT = "pipe ant == \"@ide$ant_home:ide_ant.com\" ; ant";
    public static final String DEFAULT_ERROR_EXP = "[ \\t]*[A|a]t line number ([0-9]+) in file (.*)$";
    public static final String DEFAULT_ERROR_EXP_OPT = "2 1 -1 -1";
    public static final String DEFAULT_ERROR_EXP_ANT = "^(file\\:)?([^ ][^ ]+):([0-9]+): (.*)";
    public static final String DEFAULT_ERROR_EXP_OPT_ANT = "2 3 -1 4";
    public static final String DEFAULT_COMPILE_PARAMS = "{Global Qualifiers} {file} {Local Qualifiers}";
    public static final String DEFAULT_COMPILE_PARAMS_COB = "{Global Qualifiers} {ANSI Formatting} {file} {Local Qualifiers}";
    public static final String DEFAULT_COMPILE_PARAMS_FOR = "{Global Qualifiers} {Source Form} {Extend Source} {file} {Local Qualifiers}";
    public static final String DEFAULT_COMPILE_PARAMS_ANT = "{basedir} \"-emacs\" {file} {target}";
    public static final String DEFAULT_GLOBAL_QUALIFIER = "/optimize  /warnings";
    public static final String DEFAULT_COB_ANSI = "false";
    public static final String DEFAULT_FOR_FIXED = "false";
    public static final String DEFAULT_FOR_SRC_FORM = "false";
    public static final String DEFAULT_ANT_LOG = "Normal";
    public static final String ANT_ERROR_EXPR_NAME = "OpenVMS Compiler Errors for Ant";
    private static char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static boolean QUIETLY_SWALLOW_XML_LOAD_ERRORS = false;
    public static final String PROJECT_NS = "http://www.netbeans.org/ns/project/1";
    public static final String PRIVATE_NS = "http://www.netbeans.org/ns/project-private/1";

    public static void closeActiveEditorFile() {
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            public void run() {
                Mode mode = WindowManager.getDefault().findMode("editor");
                HashSet<TopComponent> tcs = new HashSet<TopComponent>();
                if (mode != null) {
                    tcs.add(mode.getSelectedTopComponent());
                }
                if (tcs.size() > 0) {
                    for (TopComponent tc : tcs) {
                        if (tc == null) continue;
                        tc.close();
                    }
                }
            }
        });
    }

    public static boolean closeEditorFileObj(FileObject name) {
        Mode mode = WindowManager.getDefault().findMode("editor");
        HashSet<TopComponent> tcs = new HashSet<TopComponent>();
        if (mode != null) {
            tcs.add(mode.getSelectedTopComponent());
        }
        if (tcs.size() > 0) {
            for (TopComponent tc : tcs) {
                for (int i = 0; tc.getActivatedNodes() != null && i < tc.getActivatedNodes().length; ++i) {
                    Node node = tc.getActivatedNodes()[i];
                    DataObject dobj = (DataObject)node.getCookie(DataObject.class);
                    if (!dobj.getPrimaryFile().equals(name)) continue;
                    tc.close();
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean closeEditorFile(String name) {
        Mode mode = WindowManager.getDefault().findMode("editor");
        HashSet<TopComponent> tcs = new HashSet<TopComponent>();
        if (mode != null) {
            tcs.add(mode.getSelectedTopComponent());
        }
        if (tcs.size() > 0) {
            for (TopComponent tc : tcs) {
                for (int i = 0; tc.getActivatedNodes() != null && i < tc.getActivatedNodes().length; ++i) {
                    Node node = tc.getActivatedNodes()[i];
                    DataObject dobj = (DataObject)node.getCookie(DataObject.class);
                    if (!dobj.getPrimaryFile().getPath().equals(name)) continue;
                    tc.close();
                }
            }
        }
        return false;
    }

    public static boolean isEditorFile(String name) {
        Mode mode = WindowManager.getDefault().findMode("editor");
        HashSet<TopComponent> tcs = new HashSet<TopComponent>();
        if (mode != null) {
            tcs.add(mode.getSelectedTopComponent());
        }
        if (tcs.size() > 0) {
            for (TopComponent tc : tcs) {
                if (tc == null) continue;
                for (int i = 0; tc.getActivatedNodes() != null && i < tc.getActivatedNodes().length; ++i) {
                    Node node = tc.getActivatedNodes()[i];
                    DataObject dobj = (DataObject)node.getCookie(DataObject.class);
                    if (name.endsWith(".form")) {
                        name = name.substring(0, name.lastIndexOf(46)) + ".java";
                    }
                    if (!dobj.getPrimaryFile().getPath().equals(name)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String getJavaHome() {
        return JAVA_HOME_141_OVMS;
    }

    public static String getJDKHome() {
        return JDK_HOME_141_OVMS;
    }

    public static int[] getIntIPAddress(InetAddress inetAddr) {
        String strAddr = inetAddr.toString();
        int[] ret = new int[4];
        int i = 0;
        if (strAddr.indexOf(47) >= 0) {
            strAddr = strAddr.substring(strAddr.indexOf(47) + 1);
        }
        StringTokenizer stok = new StringTokenizer(strAddr, ".");
        while (stok.hasMoreTokens()) {
            try {
                ret[i++] = Integer.parseInt(stok.nextToken());
            }
            catch (Exception e) {
                return null;
            }
        }
        return ret;
    }

    public static InetAddress findPublicInetAddress() throws SocketException, UnknownHostException {
        InetAddress faddr = InetAddress.getLocalHost();
        Enumeration<NetworkInterface> intfs = NetworkInterface.getNetworkInterfaces();
        while (intfs.hasMoreElements()) {
            NetworkInterface intf = intfs.nextElement();
            Enumeration<InetAddress> addrs = intf.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress addr = addrs.nextElement();
                int[] addrbytes = Utils.getIntIPAddress(addr);
                if (addrbytes == null || addr.isLoopbackAddress() || addrbytes[0] == 10 || addrbytes[0] == 172 && addrbytes[1] < 32 && addrbytes[1] > 15 || addrbytes[0] == 192 && addrbytes[1] == 168) continue;
                faddr = addr;
            }
        }
        return faddr;
    }

    public static String getIntendedHostAddress() {
        String ipaddr = null;
        ipaddr = System.getProperty("java.rmi.server.hostname") != null ? System.getProperty("java.rmi.server.hostname") : Utils.getUsableInetAddress();
        return ipaddr;
    }

    public static String getUsableInetAddress() {
        try {
            InetAddress faddr = Utils.findPublicInetAddress();
            String strAddr = faddr.toString();
            if (strAddr.indexOf(47) >= 0) {
                strAddr = strAddr.substring(strAddr.indexOf(47) + 1);
            }
            return strAddr;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getStatusLoggerID(String fsName, String action) {
        String fname = fsName + File.separatorChar + action;
        return fname;
    }

    public static String getStatusLoggerOutputPaneName(String fsName, String actionName) {
        if (actionName.equals(SYNC)) {
            return fsName + SYNC_OUTPUT_PANE;
        }
        if (actionName.equals(PUT_ALL)) {
            return fsName + PUTALL_OUTPUT_PANE;
        }
        if (actionName.equals(GET_ALL)) {
            return fsName + GETALL_OUTPUT_PANE;
        }
        if (actionName.equals(REFRESH)) {
            return fsName + REFRESH_OUTPUT_PANE;
        }
        return null;
    }

    public static synchronized Logger getStatusLogger(String fsName, String actionName) {
        String fname = Utils.getStatusLoggerID(fsName, actionName);
        return Logger.getLogger(fname);
    }

    public static synchronized Logger createStatusLogger(String fsName, String actionName) throws IOException {
        String fname = Utils.getStatusLoggerID(fsName, actionName);
        Logger logger = Logger.getLogger(fname);
        Handler[] handlers = logger.getHandlers();
        for (int i = 0; handlers != null && i < handlers.length; ++i) {
            logger.removeHandler(handlers[i]);
        }
        InputOutput io = null;
        String opaneName = Utils.getStatusLoggerOutputPaneName(fsName, actionName);
        if (opaneName != null) {
            io = IOProvider.getDefault().getIO(opaneName, false);
        }
        if (io != null) {
            io.getOut().reset();
            io.closeInputOutput();
        }
        logger.addHandler(new MyMemoryHandler(new MyStreamHandler(System.out, new MySimpleFormatter()), 10000, Level.SEVERE));
        logger.setUseParentHandlers(false);
        return logger;
    }

    public static String findText(Element parent) {
        NodeList l = parent.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            if (l.item(i).getNodeType() != 3) continue;
            Text text = (Text)l.item(i);
            return text.getNodeValue();
        }
        return null;
    }

    public static ErrorHandler defaultErrorHandler() {
        return new ErrHandler();
    }

    public static List findSubElements(Element parent) throws IllegalArgumentException {
        NodeList l = parent.getChildNodes();
        ArrayList<Element> elements = new ArrayList<Element>(l.getLength());
        for (int i = 0; i < l.getLength(); ++i) {
            org.w3c.dom.Node n = l.item(i);
            if (n.getNodeType() == 1) {
                elements.add((Element)n);
                continue;
            }
            if (n.getNodeType() == 3) {
                String text = ((Text)n).getNodeValue();
                if (text.trim().length() <= 0) continue;
                throw new IllegalArgumentException("non-ws text encountered in " + parent + ": " + text);
            }
            if (n.getNodeType() == 8) continue;
            throw new IllegalArgumentException("unexpected non-element child of " + parent + ": " + n);
        }
        return elements;
    }

    public static Element findElement(Element parent, String name, String namespace) {
        Element result = null;
        NodeList l = parent.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            Element el;
            if (l.item(i).getNodeType() != 1 || !name.equals((el = (Element)l.item(i)).getLocalName()) || !namespace.equals(el.getNamespaceURI())) continue;
            if (result == null) {
                result = el;
                continue;
            }
            return null;
        }
        return result;
    }

    public static List quickFilterURL(String projectPath) {
        class MyErrHandler
        implements ErrorHandler {
            private void annotate(SAXParseException exception) throws SAXException {
                ErrorManager.getDefault().annotate((Throwable)exception, 0, "Occurred at: " + exception.getSystemId() + ":" + exception.getLineNumber(), null, null, null);
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                this.annotate(exception);
                throw exception;
            }

            public void error(SAXParseException exception) throws SAXException {
                this.annotate(exception);
                throw exception;
            }

            public void warning(SAXParseException exception) throws SAXException {
                this.annotate(exception);
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
        ArrayList<String> flist = new ArrayList<String>();
        Document doc = null;
        try {
            doc = XMLUtil.parse((InputSource)new InputSource(projectPath + File.separatorChar + "NBPROJECT" + File.separatorChar + "PRIVATE" + File.separatorChar + "PRIVATE.XML"), (boolean)false, (boolean)true, (ErrorHandler)new MyErrHandler(), null);
        }
        catch (Exception e) {
            try {
                doc = XMLUtil.parse((InputSource)new InputSource(projectPath + File.separatorChar + "nbproject" + File.separatorChar + "private" + File.separatorChar + "private.xml"), (boolean)false, (boolean)true, (ErrorHandler)new MyErrHandler(), null);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        try {
            if (doc != null) {
                NodeList nlist = doc.getElementsByTagNameNS("http://www.netbeans.org/ns/remote-project/1", "remotefs");
                for (int i = 0; i < nlist.getLength(); ++i) {
                    String projDir = nlist.item(i).getAttributes().getNamedItem("name").getNodeValue();
                    flist.add(projDir.substring(projDir.indexOf(32) + 1));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return flist;
    }

    public static List findProjectRoots(Project project) {
        ArrayList<FileSystem> roots = new ArrayList<FileSystem>();
        Iterator itr = OpenProjectList_Dist.getFsSet().iterator();
        List list = Utils.quickFilterURL(FileUtil.toFile((FileObject)project.getProjectDirectory()).getAbsolutePath());
        while (itr.hasNext()) {
            FileSystem fs = (FileSystem)itr.next();
            String pRoot = FileUtil.toFile((FileObject)fs.getRoot()).getAbsolutePath();
            for (int i = 0; i < list.size(); ++i) {
                if (!((String)list.get(i)).equalsIgnoreCase(pRoot)) continue;
                roots.add(fs);
            }
        }
        return roots;
    }

    public static void removeFSFromProjectXML(Project project) throws IOException {
        AuxiliaryConfiguration ac = (AuxiliaryConfiguration)project.getLookup().lookup(AuxiliaryConfiguration.class);
        if (ac != null) {
            ac.removeConfigurationFragment("remotefs_list", "http://www.netbeans.org/ns/remote-project/1", false);
            ProjectManager.getDefault().saveProject(project);
        }
    }

    public static String serializeObj(Object fs) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream s = new ObjectOutputStream(bout);
        s.writeObject(fs);
        s.flush();
        StringBuffer b = new StringBuffer();
        byte[] ser = bout.toByteArray();
        for (int j = 0; j < ser.length; ++j) {
            int x = ser[j] + 256;
            b.append(HEX[(x & 0xF0) >> 4]);
            b.append(HEX[x & 0xF]);
        }
        return b.toString();
    }

    public static void writeDefault3GLXMLCompilerSettings(Project project) {
        Document pdoc = Utils.loadXml("nbproject/project.xml", project.getProjectDirectory());
        if (pdoc == null) {
            pdoc = Utils.loadXml("nbproject/project.xml".toUpperCase(), project.getProjectDirectory());
        }
        if (pdoc == null) {
            return;
        }
        if (Utils.createRemoteProjectSettings(pdoc)) {
            try {
                Utils.writeDefaultCompilerSettingsTo3GLXML(project, pdoc);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(16, (Throwable)e);
            }
        }
    }

    public static Map getCompilerSettingsFrom3GLXML(String filePath, String compilerNameTag) {
        class MyErrHandler
        implements ErrorHandler {
            private void annotate(SAXParseException exception) throws SAXException {
                ErrorManager.getDefault().annotate((Throwable)exception, 0, "Occurred at: " + exception.getSystemId() + ":" + exception.getLineNumber(), null, null, null);
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                this.annotate(exception);
                throw exception;
            }

            public void error(SAXParseException exception) throws SAXException {
                this.annotate(exception);
                throw exception;
            }

            public void warning(SAXParseException exception) throws SAXException {
                this.annotate(exception);
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Document doc = null;
        try {
            doc = XMLUtil.parse((InputSource)new InputSource(filePath + File.separatorChar + "NBPROJECT" + File.separatorChar + "PROJECT.XML"), (boolean)false, (boolean)true, (ErrorHandler)new MyErrHandler(), null);
        }
        catch (Exception e) {
            try {
                doc = XMLUtil.parse((InputSource)new InputSource(filePath + File.separatorChar + "nbproject" + File.separatorChar + "project.xml"), (boolean)false, (boolean)true, (ErrorHandler)new MyErrHandler(), null);
            }
            catch (Exception e1) {
                e.printStackTrace(System.err);
            }
        }
        try {
            boolean found = false;
            if (doc != null) {
                NodeList nlist = doc.getElementsByTagNameNS("http://www.netbeans.org/ns/remote-project/1", "compiler_settings");
                org.w3c.dom.Node item = nlist != null ? nlist.item(0) : null;
                NodeList children = item != null ? item.getChildNodes() : null;
                for (int j = 0; children != null && j < children.getLength(); ++j) {
                    Object nodeName = null;
                    if (!children.item(j).getNodeName().equals(compilerNameTag)) continue;
                    NamedNodeMap amap = children.item(j).getAttributes();
                    for (int i = 0; i < amap.getLength(); ++i) {
                        map.put(amap.item(i).getNodeName(), amap.item(i).getNodeValue());
                    }
                    found = true;
                }
            }
            if (!found) {
                Utils.createDefaultRemoteProjectSettings(map, compilerNameTag);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return map;
    }

    public static void writeDefaultCompilerSettingsTo3GLXML(final Project project, final Document pdoc) throws IOException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws IOException {
                    FileObject projFolder = project.getProjectDirectory();
                    FileObject projectXml = projFolder.getFileObject("nbproject/project.xml");
                    if (projectXml == null) {
                        projectXml = projFolder.getFileObject("nbproject/project.xml".toUpperCase());
                    }
                    if (projectXml == null) {
                        return null;
                    }
                    FileLock lock = projectXml.lock();
                    try {
                        OutputStream os = projectXml.getOutputStream(lock);
                        try {
                            XMLUtil.write((Document)pdoc, (OutputStream)os, (String)"UTF-8");
                        }
                        finally {
                            os.close();
                        }
                    }
                    finally {
                        lock.releaseLock();
                    }
                    return projFolder;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    public static void createDefaultRemoteProjectSettings(Map map, String type) {
        if (type.equals(PASCAL)) {
            map.put(BUILD_COMMAND, DEFAULT_BUILD_COMMAND);
            map.put(BUILD_DIR, "");
            map.put(USE_COMMAND_FILE, "false");
            map.put(COMPILE_PARAM, DEFAULT_COMPILE_PARAMS);
            map.put(COMPILE_COMMAND, DEFAULT_COMPILE_PAS);
            map.put(GLOBAL_QUALIFIER, DEFAULT_GLOBAL_QUALIFIER);
            map.put(LOCAL_QUALIFIER, "");
            map.put(COMMAND_FILE, "");
            map.put(ERROR_EXP, DEFAULT_ERROR_EXP);
            map.put(ERROR_EXP_OPT, DEFAULT_ERROR_EXP_OPT);
            map.put(COMMAND_FILE, "");
        } else if (type.equals(C)) {
            map.put(BUILD_COMMAND, DEFAULT_BUILD_COMMAND);
            map.put(BUILD_DIR, "");
            map.put(USE_COMMAND_FILE, "false");
            map.put(COMPILE_PARAM, DEFAULT_COMPILE_PARAMS);
            map.put(COMPILE_COMMAND, DEFAULT_COMPILE_C);
            map.put(GLOBAL_QUALIFIER, DEFAULT_GLOBAL_QUALIFIER);
            map.put(LOCAL_QUALIFIER, "");
            map.put(COMMAND_FILE, "");
            map.put(ERROR_EXP, DEFAULT_ERROR_EXP);
            map.put(ERROR_EXP_OPT, DEFAULT_ERROR_EXP_OPT);
        } else if (type.equals(CPP)) {
            map.put(BUILD_COMMAND, DEFAULT_BUILD_COMMAND);
            map.put(BUILD_DIR, "");
            map.put(USE_COMMAND_FILE, "false");
            map.put(COMPILE_PARAM, DEFAULT_COMPILE_PARAMS);
            map.put(COMPILE_COMMAND, DEFAULT_COMPILE_CPP);
            map.put(GLOBAL_QUALIFIER, DEFAULT_GLOBAL_QUALIFIER);
            map.put(LOCAL_QUALIFIER, "");
            map.put(COMMAND_FILE, "");
            map.put(ERROR_EXP, DEFAULT_ERROR_EXP);
            map.put(ERROR_EXP_OPT, DEFAULT_ERROR_EXP_OPT);
        } else if (type.equals(COBOL)) {
            map.put(BUILD_COMMAND, DEFAULT_BUILD_COMMAND);
            map.put(BUILD_DIR, "");
            map.put(USE_COMMAND_FILE, "false");
            map.put(COMPILE_PARAM, DEFAULT_COMPILE_PARAMS_COB);
            map.put(COMPILE_COMMAND, DEFAULT_COMPILE_COB);
            map.put(GLOBAL_QUALIFIER, DEFAULT_GLOBAL_QUALIFIER);
            map.put(LOCAL_QUALIFIER, "");
            map.put(COMMAND_FILE, "");
            map.put(ERROR_EXP, DEFAULT_ERROR_EXP);
            map.put(ERROR_EXP_OPT, DEFAULT_ERROR_EXP_OPT);
            map.put(COB_ANSI, "false");
        } else if (type.equals(FORTRAN)) {
            map.put(BUILD_COMMAND, DEFAULT_BUILD_COMMAND);
            map.put(BUILD_DIR, "");
            map.put(USE_COMMAND_FILE, "false");
            map.put(COMPILE_PARAM, DEFAULT_COMPILE_PARAMS_FOR);
            map.put(COMPILE_COMMAND, DEFAULT_COMPILE_FOR);
            map.put(GLOBAL_QUALIFIER, DEFAULT_GLOBAL_QUALIFIER);
            map.put(LOCAL_QUALIFIER, "");
            map.put(COMMAND_FILE, "");
            map.put(ERROR_EXP, DEFAULT_ERROR_EXP);
            map.put(ERROR_EXP_OPT, DEFAULT_ERROR_EXP_OPT);
        } else if (type.equals(BASIC)) {
            map.put(BUILD_COMMAND, DEFAULT_BUILD_COMMAND);
            map.put(BUILD_DIR, "");
            map.put(USE_COMMAND_FILE, "false");
            map.put(COMPILE_PARAM, DEFAULT_COMPILE_PARAMS);
            map.put(COMPILE_COMMAND, DEFAULT_COMPILE_BAS);
            map.put(GLOBAL_QUALIFIER, DEFAULT_GLOBAL_QUALIFIER);
            map.put(LOCAL_QUALIFIER, "");
            map.put(COMMAND_FILE, "");
            map.put(ERROR_EXP, DEFAULT_ERROR_EXP);
            map.put(ERROR_EXP_OPT, DEFAULT_ERROR_EXP_OPT);
        } else if (type.equals(DCL)) {
            map.put(BUILD_DIR, "");
            map.put(COMPILE_COMMAND, DEFAULT_COMPILE_DCL);
            map.put(ERROR_EXP, DEFAULT_ERROR_EXP);
            map.put(ERROR_EXP_OPT, DEFAULT_ERROR_EXP_OPT);
        } else if (type.equals(BASH)) {
            map.put(BUILD_DIR, "");
            map.put(COMPILE_COMMAND, DEFAULT_COMPILE_BASH);
            map.put(ERROR_EXP, DEFAULT_ERROR_EXP);
            map.put(ERROR_EXP_OPT, DEFAULT_ERROR_EXP_OPT);
        } else if (type.equals(MMS)) {
            map.put(BUILD_DIR, "");
            map.put(COMPILE_COMMAND, DEFAULT_COMPILE_MMS);
            map.put(ERROR_EXP, DEFAULT_ERROR_EXP);
            map.put(ERROR_EXP_OPT, DEFAULT_ERROR_EXP_OPT);
        } else if (type.equals(ANT)) {
            map.put(BUILD_DIR, "");
            map.put(COMPILE_COMMAND, DEFAULT_COMPILE_ANT);
            map.put(COMPILE_PARAM, DEFAULT_COMPILE_PARAMS_ANT);
            map.put(ERROR_EXP, DEFAULT_ERROR_EXP);
            map.put(ERROR_EXP_OPT, DEFAULT_ERROR_EXP_OPT);
            map.put(ERROR_EXP_ANT, DEFAULT_ERROR_EXP_ANT);
            map.put(ERROR_EXP_OPT_ANT, DEFAULT_ERROR_EXP_OPT_ANT);
            map.put(LOG, DEFAULT_ANT_LOG);
        }
    }

    public static boolean createRemoteProjectSettings(Document pdoc) {
        Element conf;
        NodeList nlist;
        Element existingElem = pdoc.getDocumentElement();
        boolean found = false;
        if (existingElem != null && (nlist = pdoc.getElementsByTagNameNS("http://www.netbeans.org/ns/remote-project/1", "compiler_settings")) != null && nlist.getLength() > 0) {
            return false;
        }
        Element e3 = pdoc.createElementNS("http://www.netbeans.org/ns/remote-project/1", "compiler_settings");
        Element e4 = pdoc.createElementNS("http://www.netbeans.org/ns/remote-project/1", PASCAL);
        e4.setAttribute(BUILD_COMMAND, DEFAULT_BUILD_COMMAND);
        e4.setAttribute(BUILD_DIR, "");
        e4.setAttribute(USE_COMMAND_FILE, "false");
        e4.setAttribute(COMPILE_PARAM, DEFAULT_COMPILE_PARAMS);
        e4.setAttribute(COMPILE_COMMAND, DEFAULT_COMPILE_PAS);
        e4.setAttribute(GLOBAL_QUALIFIER, DEFAULT_GLOBAL_QUALIFIER);
        e4.setAttribute(LOCAL_QUALIFIER, "");
        e4.setAttribute(COMMAND_FILE, "");
        e4.setAttribute(ERROR_EXP, DEFAULT_ERROR_EXP);
        e4.setAttribute(ERROR_EXP_OPT, DEFAULT_ERROR_EXP_OPT);
        e4.setAttribute(COMMAND_FILE, "");
        e3.appendChild(e4);
        Element e5 = pdoc.createElementNS("http://www.netbeans.org/ns/remote-project/1", C);
        e5.setAttribute(BUILD_COMMAND, DEFAULT_BUILD_COMMAND);
        e5.setAttribute(BUILD_DIR, "");
        e5.setAttribute(USE_COMMAND_FILE, "false");
        e5.setAttribute(COMPILE_PARAM, DEFAULT_COMPILE_PARAMS);
        e5.setAttribute(COMPILE_COMMAND, DEFAULT_COMPILE_C);
        e5.setAttribute(GLOBAL_QUALIFIER, DEFAULT_GLOBAL_QUALIFIER);
        e5.setAttribute(LOCAL_QUALIFIER, "");
        e5.setAttribute(COMMAND_FILE, "");
        e5.setAttribute(ERROR_EXP, DEFAULT_ERROR_EXP);
        e5.setAttribute(ERROR_EXP_OPT, DEFAULT_ERROR_EXP_OPT);
        e3.appendChild(e5);
        Element e6 = pdoc.createElementNS("http://www.netbeans.org/ns/remote-project/1", CPP);
        e6.setAttribute(BUILD_COMMAND, DEFAULT_BUILD_COMMAND);
        e6.setAttribute(BUILD_DIR, "");
        e6.setAttribute(USE_COMMAND_FILE, "false");
        e6.setAttribute(COMPILE_PARAM, DEFAULT_COMPILE_PARAMS);
        e6.setAttribute(COMPILE_COMMAND, DEFAULT_COMPILE_CPP);
        e6.setAttribute(GLOBAL_QUALIFIER, DEFAULT_GLOBAL_QUALIFIER);
        e6.setAttribute(LOCAL_QUALIFIER, "");
        e6.setAttribute(COMMAND_FILE, "");
        e6.setAttribute(ERROR_EXP, DEFAULT_ERROR_EXP);
        e6.setAttribute(ERROR_EXP_OPT, DEFAULT_ERROR_EXP_OPT);
        e3.appendChild(e6);
        Element e7 = pdoc.createElementNS("http://www.netbeans.org/ns/remote-project/1", COBOL);
        e7.setAttribute(BUILD_COMMAND, DEFAULT_BUILD_COMMAND);
        e7.setAttribute(BUILD_DIR, "");
        e7.setAttribute(USE_COMMAND_FILE, "false");
        e7.setAttribute(COMPILE_PARAM, DEFAULT_COMPILE_PARAMS_COB);
        e7.setAttribute(COMPILE_COMMAND, DEFAULT_COMPILE_COB);
        e7.setAttribute(GLOBAL_QUALIFIER, DEFAULT_GLOBAL_QUALIFIER);
        e7.setAttribute(LOCAL_QUALIFIER, "");
        e7.setAttribute(COMMAND_FILE, "");
        e7.setAttribute(ERROR_EXP, DEFAULT_ERROR_EXP);
        e7.setAttribute(ERROR_EXP_OPT, DEFAULT_ERROR_EXP_OPT);
        e7.setAttribute(COB_ANSI, "false");
        e3.appendChild(e7);
        Element e8 = pdoc.createElementNS("http://www.netbeans.org/ns/remote-project/1", FORTRAN);
        e8.setAttribute(BUILD_COMMAND, DEFAULT_BUILD_COMMAND);
        e8.setAttribute(BUILD_DIR, "");
        e8.setAttribute(USE_COMMAND_FILE, "false");
        e8.setAttribute(COMPILE_PARAM, DEFAULT_COMPILE_PARAMS_FOR);
        e8.setAttribute(COMPILE_COMMAND, DEFAULT_COMPILE_FOR);
        e8.setAttribute(GLOBAL_QUALIFIER, DEFAULT_GLOBAL_QUALIFIER);
        e8.setAttribute(LOCAL_QUALIFIER, "");
        e8.setAttribute(COMMAND_FILE, "");
        e8.setAttribute(ERROR_EXP, DEFAULT_ERROR_EXP);
        e8.setAttribute(ERROR_EXP_OPT, DEFAULT_ERROR_EXP_OPT);
        e3.appendChild(e8);
        Element e9 = pdoc.createElementNS("http://www.netbeans.org/ns/remote-project/1", BASIC);
        e9.setAttribute(BUILD_COMMAND, DEFAULT_BUILD_COMMAND);
        e9.setAttribute(BUILD_DIR, "");
        e9.setAttribute(USE_COMMAND_FILE, "false");
        e9.setAttribute(COMPILE_PARAM, DEFAULT_COMPILE_PARAMS);
        e9.setAttribute(COMPILE_COMMAND, DEFAULT_COMPILE_BAS);
        e9.setAttribute(GLOBAL_QUALIFIER, DEFAULT_GLOBAL_QUALIFIER);
        e9.setAttribute(LOCAL_QUALIFIER, "");
        e9.setAttribute(COMMAND_FILE, "");
        e9.setAttribute(ERROR_EXP, DEFAULT_ERROR_EXP);
        e9.setAttribute(ERROR_EXP_OPT, DEFAULT_ERROR_EXP_OPT);
        e3.appendChild(e9);
        Element e10 = pdoc.createElementNS("http://www.netbeans.org/ns/remote-project/1", DCL);
        e10.setAttribute(BUILD_DIR, "");
        e10.setAttribute(COMPILE_COMMAND, DEFAULT_COMPILE_DCL);
        e10.setAttribute(ERROR_EXP, DEFAULT_ERROR_EXP);
        e10.setAttribute(ERROR_EXP_OPT, DEFAULT_ERROR_EXP_OPT);
        e3.appendChild(e10);
        Element e11 = pdoc.createElementNS("http://www.netbeans.org/ns/remote-project/1", BASH);
        e11.setAttribute(BUILD_DIR, "");
        e11.setAttribute(COMPILE_COMMAND, DEFAULT_COMPILE_BASH);
        e11.setAttribute(ERROR_EXP, DEFAULT_ERROR_EXP);
        e11.setAttribute(ERROR_EXP_OPT, DEFAULT_ERROR_EXP_OPT);
        e3.appendChild(e11);
        Element e12 = pdoc.createElementNS("http://www.netbeans.org/ns/remote-project/1", MMS);
        e12.setAttribute(BUILD_DIR, "");
        e12.setAttribute(COMPILE_COMMAND, DEFAULT_COMPILE_MMS);
        e12.setAttribute(ERROR_EXP, DEFAULT_ERROR_EXP);
        e12.setAttribute(ERROR_EXP_OPT, DEFAULT_ERROR_EXP_OPT);
        e3.appendChild(e12);
        Element e13 = pdoc.createElementNS("http://www.netbeans.org/ns/remote-project/1", ANT);
        e13.setAttribute(BUILD_DIR, "");
        e13.setAttribute(COMPILE_COMMAND, DEFAULT_COMPILE_ANT);
        e13.setAttribute(COMPILE_PARAM, DEFAULT_COMPILE_PARAMS_ANT);
        e13.setAttribute(ERROR_EXP, DEFAULT_ERROR_EXP);
        e13.setAttribute(ERROR_EXP_OPT, DEFAULT_ERROR_EXP_OPT);
        e13.setAttribute(ERROR_EXP_ANT, DEFAULT_ERROR_EXP_ANT);
        e13.setAttribute(ERROR_EXP_OPT_ANT, DEFAULT_ERROR_EXP_OPT_ANT);
        e13.setAttribute(LOG, DEFAULT_ANT_LOG);
        e3.appendChild(e13);
        NodeList nlist2 = pdoc.getElementsByTagName("configuration");
        if (nlist2 == null || nlist2.getLength() == 0) {
            conf = pdoc.createElementNS(PROJECT_NS, "configuration");
            pdoc.getDocumentElement().appendChild(conf);
        } else {
            conf = (Element)nlist2.item(0);
        }
        conf.appendChild(e3);
        return true;
    }

    public static void writeCompilerSettingto3GLXML(final Project project, final String cName, final Map settings) throws IOException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws IOException {
                    FileObject projFolder;
                    FileObject projectXml;
                    Document doc = Utils.loadXml("nbproject/project.xml", project.getProjectDirectory());
                    if (doc == null) {
                        doc = Utils.loadXml("nbproject/project.xml".toUpperCase(), project.getProjectDirectory());
                    }
                    if (doc == null) {
                        return null;
                    }
                    String script = "";
                    Element existingElem = doc.getDocumentElement();
                    boolean found = false;
                    if (existingElem != null) {
                        NodeList nlist = doc.getElementsByTagNameNS("http://www.netbeans.org/ns/remote-project/1", "compiler_settings");
                        if (nlist == null || nlist.getLength() == 0) {
                            Utils.writeDefault3GLXMLCompilerSettings(project);
                            doc = Utils.loadXml("nbproject/project.xml", project.getProjectDirectory());
                            if (doc == null) {
                                doc = Utils.loadXml("nbproject/project.xml".toUpperCase(), project.getProjectDirectory());
                            }
                            nlist = doc.getElementsByTagNameNS("http://www.netbeans.org/ns/remote-project/1", "compiler_settings");
                        }
                        NodeList children = nlist.item(0).getChildNodes();
                        for (int j = 0; j < children.getLength(); ++j) {
                            Object nodeName = null;
                            if (!children.item(j).getNodeName().equals(cName)) continue;
                            NamedNodeMap amap = children.item(j).getAttributes();
                            for (int i = 0; i < amap.getLength(); ++i) {
                                String value = (String)settings.get(amap.item(i).getNodeName());
                                if (value == null) continue;
                                amap.item(i).setNodeValue(value);
                            }
                        }
                    }
                    if ((projectXml = (projFolder = project.getProjectDirectory()).getFileObject("nbproject/project.xml")) == null) {
                        projectXml = projFolder.getFileObject("nbproject/project.xml".toUpperCase());
                    }
                    if (projectXml == null) {
                        return null;
                    }
                    FileLock lock = projectXml.lock();
                    OutputStream os = null;
                    try {
                        os = projectXml.getOutputStream(lock);
                        XMLUtil.write((Document)doc, (OutputStream)os, (String)"UTF-8");
                    }
                    finally {
                        if (os != null) {
                            os.close();
                        }
                        lock.releaseLock();
                    }
                    return projFolder;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFSto3GLXML(FileSystem fs, Project project) throws IOException {
        FileObject projFolder;
        FileObject projectXml;
        Document doc = Utils.loadXml("nbproject/private/private.xml", project.getProjectDirectory());
        if (doc == null) {
            Utils.loadXml("nbproject/private/private.xml".toUpperCase(), project.getProjectDirectory());
        }
        String script = "";
        Element existingElem = doc.getDocumentElement();
        boolean found = false;
        if (existingElem != null) {
            NodeList nodeList = existingElem.getElementsByTagName("remotefs");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element _elem = (Element)nodeList.item(i);
                if (!_elem.getAttribute("name").equalsIgnoreCase(fs.getDisplayName())) continue;
                Element elem2 = _elem.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/remote-project/1", "remotefs");
                elem2.setAttribute("name", fs.getDisplayName());
                elem2.appendChild(doc.createTextNode(Utils.serializeObj(fs)));
                _elem.getParentNode().replaceChild(elem2, _elem);
                found = true;
            }
            if (!found) {
                Element elem2 = existingElem.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/remote-project/1", "remotefs");
                elem2.setAttribute("name", fs.getDisplayName());
                elem2.appendChild(existingElem.getOwnerDocument().createTextNode(Utils.serializeObj(fs)));
                existingElem.appendChild(elem2);
            }
        }
        if ((projectXml = (projFolder = project.getProjectDirectory()).getFileObject("nbproject/private/private.xml")) == null) {
            projectXml = projFolder.getFileObject("nbproject/private/private.xml".toUpperCase());
        }
        if (projectXml == null) {
            return;
        }
        FileLock lock = projectXml.lock();
        try {
            OutputStream os = projectXml.getOutputStream(lock);
            try {
                XMLUtil.write((Document)doc, (OutputStream)os, (String)"UTF-8");
            }
            finally {
                os.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFStoProjectXML(FileSystem fs, Project project) throws IOException {
        try {
            AuxiliaryConfiguration ac = (AuxiliaryConfiguration)project.getLookup().lookup(AuxiliaryConfiguration.class);
            Document xml = XMLUtil.createDocument((String)"dummy", (String)"dummy", null, null);
            Element existingElem = ac.getConfigurationFragment("remotefs_list", "http://www.netbeans.org/ns/remote-project/1", false);
            if (existingElem != null) {
                NodeList nodeList = existingElem.getElementsByTagName("remotefs");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element _elem = (Element)nodeList.item(i);
                    if (!_elem.getAttribute("name").equalsIgnoreCase(fs.getDisplayName())) continue;
                    Element elem2 = existingElem.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/remote-project/1", "remotefs");
                    elem2.setAttribute("name", fs.getDisplayName());
                    elem2.appendChild(xml.createTextNode(Utils.serializeObj(fs)));
                    existingElem.replaceChild(elem2, _elem);
                    ac.putConfigurationFragment(existingElem, false);
                    return;
                }
                Element elem2 = existingElem.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/remote-project/1", "remotefs");
                elem2.setAttribute("name", fs.getDisplayName());
                elem2.appendChild(existingElem.getOwnerDocument().createTextNode(Utils.serializeObj(fs)));
                existingElem.appendChild(elem2);
                ac.putConfigurationFragment(existingElem, false);
            } else {
                Element elem = xml.createElementNS("http://www.netbeans.org/ns/remote-project/1", "remotefs_list");
                Element elem2 = xml.createElementNS("http://www.netbeans.org/ns/remote-project/1", "remotefs");
                elem2.setAttribute("name", fs.getDisplayName());
                elem2.appendChild(xml.createTextNode(Utils.serializeObj(fs)));
                elem.appendChild(elem2);
                ac.putConfigurationFragment(elem, false);
            }
        }
        finally {
            ProjectManager.getDefault().saveProject(project);
        }
    }

    public static void writeFStoProjectXML_new(FileSystem fs, Project project) throws IOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            File pf = FileUtil.toFile((FileObject)project.getProjectDirectory());
            File f = new File(pf, "\\nbproject\\private\\private.xml");
            if (!f.exists()) {
                File pri = new File(pf, "\\nbproject\\private");
                pri.mkdir();
                Document d = documentBuilder.newDocument();
                Element e = d.createElementNS(PRIVATE_NS, "project-private");
                d.appendChild(e);
                Utils.saveDocument(d, f);
            }
            Document private_doc = documentBuilder.parse(f);
            Element remotefs_list = null;
            Element project_private = private_doc.getDocumentElement();
            if (project_private.hasChildNodes() && project_private.getElementsByTagName("remotefs_list").getLength() > 0) {
                NodeList nl = project_private.getElementsByTagName("remotefs_list");
                if (nl.getLength() > 0) {
                    remotefs_list = (Element)nl.item(0);
                    NodeList nodeList = remotefs_list.getElementsByTagName("remotefs");
                    nodeList = remotefs_list.getElementsByTagName("remotefs");
                    for (int j = 0; j < nodeList.getLength(); ++j) {
                        Element _elem = (Element)nodeList.item(j);
                        if (!_elem.getAttribute("name").equalsIgnoreCase(fs.getDisplayName())) continue;
                        Element elem2 = remotefs_list.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/remote-project/1", "remotefs");
                        elem2.setAttribute("name", fs.getDisplayName());
                        elem2.appendChild(remotefs_list.getOwnerDocument().createTextNode(Utils.serializeObj(fs)));
                        remotefs_list.replaceChild(elem2, _elem);
                        project_private.appendChild(remotefs_list);
                        Utils.saveDocument(private_doc, f);
                        return;
                    }
                    Element elem2 = remotefs_list.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/remote-project/1", "remotefs");
                    elem2.setAttribute("name", fs.getDisplayName());
                    elem2.appendChild(remotefs_list.getOwnerDocument().createTextNode(Utils.serializeObj(fs)));
                    remotefs_list.appendChild(elem2);
                    project_private.appendChild(remotefs_list);
                    Utils.saveDocument(private_doc, f);
                }
            } else {
                remotefs_list = private_doc.createElementNS("http://www.netbeans.org/ns/remote-project/1", "remotefs_list");
                if (remotefs_list != null) {
                    Element remotefs = remotefs_list.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/remote-project/1", "remotefs");
                    remotefs.setAttribute("name", fs.getDisplayName());
                    remotefs.appendChild(remotefs_list.getOwnerDocument().createTextNode(Utils.serializeObj(fs)));
                    remotefs_list.appendChild(remotefs);
                    project_private.appendChild(remotefs_list);
                    Utils.saveDocument(private_doc, f);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void saveDocument(Document document, File file) throws TransformerConfigurationException, TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(file);
        transformer.transform(source, result);
    }

    public static Document loadXml(String path, FileObject dir) {
        block6: {
            FileObject xml = dir.getFileObject(path);
            if (!(xml != null && xml.isData() || (xml = dir.getFileObject(path.toUpperCase())) != null && xml.isData())) {
                return null;
            }
            File f = FileUtil.toFile((FileObject)xml);
            assert (f != null);
            try {
                return XMLUtil.parse((InputSource)new InputSource(f.toURI().toString()), (boolean)false, (boolean)true, (ErrorHandler)Utils.defaultErrorHandler(), null);
            }
            catch (IOException e) {
                if (!QUIETLY_SWALLOW_XML_LOAD_ERRORS) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
            catch (SAXException e) {
                if (QUIETLY_SWALLOW_XML_LOAD_ERRORS) break block6;
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return null;
    }

    public static List getFreeFormProjectActions(Project dProject) {
        Iterator vit;
        Document doc = Utils.loadXml("nbproject/project.xml", dProject.getProjectDirectory());
        String script = "";
        Element project = doc.getDocumentElement();
        Element config = Utils.findElement(project, "configuration", PROJECT_NS);
        Element genldata = Utils.findElement(config, "general-data", "http://www.netbeans.org/ns/freeform-project/1");
        Element actionsEl = Utils.findElement(genldata, "ide-actions", "http://www.netbeans.org/ns/freeform-project/1");
        List actions = actionsEl != null ? Utils.findSubElements(actionsEl) : null;
        Iterator it = actions != null ? actions.iterator() : null;
        ArrayList<String> actionList = new ArrayList<String>();
        while (it != null && it.hasNext()) {
            Element action = (Element)it.next();
            actionList.add(action.getAttribute("name"));
            List subActions = Utils.findSubElements(action);
            Iterator it2 = subActions.iterator();
            String target = "";
            while (it2.hasNext()) {
                Element subAction = (Element)it2.next();
                if (!subAction.getLocalName().equals("target")) continue;
                target = target + Utils.findText(subAction);
            }
            actionList.add(target);
        }
        Element view = Utils.findElement(genldata, "view", "http://www.netbeans.org/ns/freeform-project/1");
        List viewitems = view != null ? Utils.findSubElements(view) : null;
        Iterator iterator = vit = viewitems != null ? viewitems.iterator() : null;
        while (vit != null && vit.hasNext()) {
            Element viewitem = (Element)vit.next();
            if (!viewitem.getLocalName().equals("context-menu")) continue;
            List subActions = Utils.findSubElements(viewitem);
            for (Element subAction : subActions) {
                if (!subAction.getLocalName().equals("action")) continue;
                List actionItems = Utils.findSubElements(subAction);
                for (Element actionItem : actionItems) {
                    if (actionItem.getLocalName().equals("label")) {
                        actionList.add(Utils.findText(actionItem));
                        continue;
                    }
                    if (!actionItem.getLocalName().equals("target")) continue;
                    actionList.add(Utils.findText(actionItem));
                }
            }
        }
        return actionList;
    }

    public static FileObject getFreeFormBuildFile(Project dProject) {
        Element action;
        Document doc = Utils.loadXml("nbproject/project.xml", dProject.getProjectDirectory());
        String script = "";
        Element project = doc.getDocumentElement();
        Element config = Utils.findElement(project, "configuration", PROJECT_NS);
        Element genldata = Utils.findElement(config, "general-data", "http://www.netbeans.org/ns/freeform-project/1");
        Element actionsEl = Utils.findElement(genldata, "ide-actions", "http://www.netbeans.org/ns/freeform-project/1");
        List actions = Utils.findSubElements(actionsEl);
        Iterator it = actions.iterator();
        boolean foundAction = false;
        Element scriptEl = null;
        while (it.hasNext() && (scriptEl = Utils.findElement(action = (Element)it.next(), "script", "http://www.netbeans.org/ns/freeform-project/1")) == null) {
        }
        script = scriptEl != null ? Utils.findText(scriptEl) : "build.xml";
        if (!script.equals("build.xml")) {
            Element properties = Utils.findElement(genldata, "properties", "http://www.netbeans.org/ns/freeform-project/1");
            List props = Utils.findSubElements(properties);
            for (Element prop : props) {
                if (!prop.getAttribute("name").equals("ant.script")) continue;
                script = Utils.findText(prop);
                break;
            }
        }
        if (script == null) {
            script = "build.xml";
        }
        FileObject proj = dProject.getProjectDirectory();
        FileObject buildFO = proj.getFileObject(script);
        return buildFO;
    }

    public static String decrypt(String epass) {
        StringBuffer buf = new StringBuffer();
        int seedSize = epass.charAt(0) - 48;
        int seed = Integer.parseInt(epass.substring(1, seedSize + 1), 16);
        String data = epass.substring(seedSize + 1);
        int i = 0;
        while (true) {
            int cSize = data.charAt(0) - 48;
            int cData = Integer.parseInt(data.substring(1, cSize + 1), 16) ^ seed;
            buf.append((char)cData);
            if (data.length() == cSize + 1) break;
            data = data.substring(cSize + 1);
            ++i;
        }
        return buf.toString();
    }

    public static String encrypt(String pass) {
        StringBuffer buf = new StringBuffer();
        int seed = (int)System.currentTimeMillis() & 0xF;
        buf.append(Integer.toHexString(seed).length());
        buf.append(Integer.toHexString(seed));
        for (int i = 0; i < pass.length(); ++i) {
            char c = pass.charAt(i);
            String bin = Integer.toHexString(c ^ seed);
            buf.append(bin.length());
            buf.append(bin);
        }
        return buf.toString();
    }

    public static FileSystem decodeRemoteFS(Project p) {
        Element e;
        AuxiliaryConfiguration ac = (AuxiliaryConfiguration)p.getLookup().lookup(AuxiliaryConfiguration.class);
        if (ac != null && (e = ac.getConfigurationFragment("remotefs", "http://www.netbeans.org/ns/remote-project/1", false)) != null) {
            Element e1 = Utils.findElement(e, "remotefs", "http://www.netbeans.org/ns/remote-project/1");
            String data = Utils.findText(e1);
            try {
                final FileSystem fs = (FileSystem)Utils.deSerializeObj(data);
                final Project projectFinal = p;
                fs.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        try {
                            Utils.writeFStoProjectXML_new(fs, projectFinal);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                return fs;
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
        return null;
    }

    public static Object deSerializeObj(String val) throws ClassNotFoundException, IOException {
        if (val == null || val.length() == 0) {
            return null;
        }
        byte[] bytes = new byte[val.length() / 2];
        int count = 0;
        try {
            for (int i = 0; i < val.length(); ++i) {
                if (Character.isWhitespace(val.charAt(i))) continue;
                int tempI = Integer.parseInt(val.substring(i, i + 2), 16);
                if (tempI > 127) {
                    tempI -= 256;
                }
                bytes[count++] = (byte)tempI;
                ++i;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            IOException e2 = new IOException("Cannot read value of <serialvalue> attribute from file XXXX");
            ErrorManager.getDefault().annotate((Throwable)e2, (Throwable)e);
            throw e2;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes, 0, count);
        try {
            class SpecialObjectInputStream
            extends ObjectInputStream {
                public SpecialObjectInputStream(InputStream is) throws IOException {
                    super(is);
                    try {
                        this.enableResolveObject(true);
                    }
                    catch (SecurityException ex) {
                        throw new IOException(ex.toString());
                    }
                }

                protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
                    ClassLoader cl = this.getNBClassLoader();
                    try {
                        return Class.forName(v.getName(), false, cl);
                    }
                    catch (ClassNotFoundException cnfe) {
                        String msg = "Offending classloader: " + cl;
                        ErrorManager.getDefault().annotate((Throwable)cnfe, 1, msg, null, null, null);
                        throw cnfe;
                    }
                }

                protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
                    String newN;
                    ObjectStreamClass ose = super.readClassDescriptor();
                    String name = ose.getName();
                    if (name == (newN = Utilities.translate((String)name))) {
                        return ose;
                    }
                    ClassLoader cl = this.getNBClassLoader();
                    try {
                        Class<?> origCl = Class.forName(name, false, cl);
                        return ObjectStreamClass.lookup(origCl);
                    }
                    catch (ClassNotFoundException ex) {
                        Class<?> clazz = Class.forName(newN, false, cl);
                        ObjectStreamClass newOse = ObjectStreamClass.lookup(clazz);
                        if (newOse == null) {
                            throw new NotSerializableException(newN);
                        }
                        return newOse;
                    }
                }

                private ClassLoader getNBClassLoader() {
                    ClassLoader c = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                    return c != null ? c : ClassLoader.getSystemClassLoader();
                }
            }
            SpecialObjectInputStream ois = new SpecialObjectInputStream(bis);
            return ois.readObject();
        }
        catch (Exception e) {
            IOException e2 = new IOException("Cannot read value of <serialvalue> attribute from file XXXXX");
            ErrorManager.getDefault().annotate((Throwable)e2, (Throwable)e);
            throw e2;
        }
    }

    private static final class ErrHandler
    implements ErrorHandler {
        private void annotate(SAXParseException exception) throws SAXException {
            ErrorManager.getDefault().annotate((Throwable)exception, 0, "Occurred at: " + exception.getSystemId() + ":" + exception.getLineNumber(), null, null, null);
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.annotate(exception);
            throw exception;
        }

        public void error(SAXParseException exception) throws SAXException {
            this.annotate(exception);
            throw exception;
        }

        public void warning(SAXParseException exception) throws SAXException {
            this.annotate(exception);
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
    }
}

