/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.model;

import com.hp.openvms.netbeans.debugsupport.debugger.Variable;
import com.hp.openvms.netbeans.debugsupport.debugger.VariablesFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Refreshable;
import javax.swing.Action;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.NodeModelFilter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;

public class VariablesTreeModelFilter
implements TreeModelFilter,
NodeModelFilter,
TableModelFilter,
NodeActionsProviderFilter,
Runnable {
    private ContextProvider lookupProvider;
    private final Collection modelListeners = new HashSet();
    private RequestProcessor evaluationRP = new RequestProcessor();
    private RequestProcessor.Task evaluationTask;
    private LinkedList evaluationQueue = new LinkedList();
    private HashMap typeToFilter;
    private HashMap ancestorToFilter;

    public VariablesTreeModelFilter(ContextProvider lookupProvider) {
        this.lookupProvider = lookupProvider;
    }

    public Object getRoot(TreeModel original) {
        return original.getRoot();
    }

    static boolean isEvaluated(Object o) {
        if (o instanceof Refreshable) {
            return ((Refreshable)o).isCurrent();
        }
        return true;
    }

    private static void waitToEvaluate(Object o) {
        if (o instanceof Refreshable) {
            try {
                ((Refreshable)o).refresh();
            }
            catch (RefreshFailedException exc) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postEvaluationMonitor(Object o, Runnable whenEvaluated) {
        LinkedList linkedList = this.evaluationQueue;
        synchronized (linkedList) {
            if (this.evaluationQueue.contains(o) && this.evaluationQueue.contains(whenEvaluated)) {
                return;
            }
            if (this.evaluationTask == null) {
                this.evaluationTask = this.evaluationRP.create((Runnable)this);
            }
            this.evaluationQueue.add(o);
            this.evaluationQueue.add(whenEvaluated);
            this.evaluationTask.schedule(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object node;
        do {
            node = null;
            Runnable whenEvaluated = null;
            LinkedList linkedList = this.evaluationQueue;
            synchronized (linkedList) {
                if (!this.evaluationQueue.isEmpty()) {
                    node = this.evaluationQueue.removeFirst();
                    whenEvaluated = (Runnable)this.evaluationQueue.removeFirst();
                }
            }
            if (node == null) continue;
            VariablesTreeModelFilter.waitToEvaluate(node);
            if (whenEvaluated != null) {
                whenEvaluated.run();
                continue;
            }
            this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)this, node));
        } while (node != null);
        this.evaluationTask = null;
    }

    public Object[] getChildren(TreeModel original, final Object parent, int from, int to) throws UnknownTypeException {
        VariablesFilter vf = this.getFilter(parent, true, new Runnable(){

            public void run() {
                VariablesTreeModelFilter.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)VariablesTreeModelFilter.this, parent, 8));
            }
        });
        Object[] ch = vf == null ? original.getChildren(parent, from, to) : vf.getChildren(original, (Variable)parent, from, to);
        return ch;
    }

    public int getChildrenCount(TreeModel original, Object parent) throws UnknownTypeException {
        int count = original.getChildrenCount(parent);
        return count;
    }

    public boolean isLeaf(TreeModel original, Object node) throws UnknownTypeException {
        VariablesFilter vf = this.getFilter(node, true, null);
        if (vf == null) {
            return original.isLeaf(node);
        }
        return vf.isLeaf(original, (Variable)node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener l) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener l) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelChange(ModelEvent me) {
        Object[] listeners;
        Collection collection = this.modelListeners;
        synchronized (collection) {
            listeners = this.modelListeners.toArray();
        }
        for (int i = 0; i < listeners.length; ++i) {
            ((ModelListener)listeners[i]).modelChanged(me);
        }
    }

    public String getDisplayName(final NodeModel original, final Object node) throws UnknownTypeException {
        final String[] unfilteredDisplayName = new String[]{null};
        VariablesFilter vf = this.getFilter(node, true, new Runnable(){

            public void run() {
                String filteredDisplayName;
                VariablesFilter vf = VariablesTreeModelFilter.this.getFilter(node, false, null);
                if (vf == null) {
                    return;
                }
                try {
                    filteredDisplayName = vf.getDisplayName(original, (Variable)node);
                }
                catch (UnknownTypeException utex) {
                    filteredDisplayName = utex.toString();
                }
                if (!filteredDisplayName.equals(unfilteredDisplayName[0])) {
                    VariablesTreeModelFilter.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)VariablesTreeModelFilter.this, node, 1));
                }
            }
        });
        if (vf == null) {
            String displayName;
            unfilteredDisplayName[0] = displayName = original.getDisplayName(node);
            return displayName;
        }
        return vf.getDisplayName(original, (Variable)node);
    }

    public String getIconBase(final NodeModel original, final Object node) throws UnknownTypeException {
        final String[] unfilteredIconBase = new String[]{null};
        VariablesFilter vf = this.getFilter(node, true, new Runnable(){

            public void run() {
                String filteredIconBase;
                VariablesFilter vf = VariablesTreeModelFilter.this.getFilter(node, false, null);
                if (vf == null) {
                    return;
                }
                try {
                    filteredIconBase = vf.getIconBase(original, (Variable)node);
                }
                catch (UnknownTypeException utex) {
                    filteredIconBase = utex.toString();
                }
                if (!filteredIconBase.equals(unfilteredIconBase[0])) {
                    VariablesTreeModelFilter.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)VariablesTreeModelFilter.this, node, 2));
                }
            }
        });
        if (vf == null) {
            String iconBase;
            unfilteredIconBase[0] = iconBase = original.getIconBase(node);
            return iconBase;
        }
        return vf.getIconBase(original, (Variable)node);
    }

    public String getShortDescription(final NodeModel original, final Object node) throws UnknownTypeException {
        final String[] unfilteredShortDescription = new String[]{null};
        VariablesFilter vf = this.getFilter(node, true, new Runnable(){

            public void run() {
                String filteredShortDescription;
                VariablesFilter vf = VariablesTreeModelFilter.this.getFilter(node, false, null);
                if (vf == null) {
                    return;
                }
                try {
                    filteredShortDescription = vf.getShortDescription(original, (Variable)node);
                }
                catch (UnknownTypeException utex) {
                    filteredShortDescription = utex.toString();
                }
                if (!filteredShortDescription.equals(unfilteredShortDescription[0])) {
                    VariablesTreeModelFilter.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)VariablesTreeModelFilter.this, node, 4));
                }
            }
        });
        if (vf == null) {
            return original.getShortDescription(node);
        }
        return vf.getShortDescription(original, (Variable)node);
    }

    public Action[] getActions(NodeActionsProvider original, Object node) throws UnknownTypeException {
        VariablesFilter vf = this.getFilter(node, true, null);
        if (vf == null) {
            return original.getActions(node);
        }
        return vf.getActions(original, (Variable)node);
    }

    public void performDefaultAction(NodeActionsProvider original, Object node) throws UnknownTypeException {
        VariablesFilter vf = this.getFilter(node, true, null);
        if (vf == null) {
            original.performDefaultAction(node);
        } else {
            vf.performDefaultAction(original, (Variable)node);
        }
    }

    public Object getValueAt(TableModel original, Object row, String columnID) throws UnknownTypeException {
        VariablesFilter vf = this.getFilter(row, false, null);
        Object value = vf == null ? original.getValueAt(row, columnID) : vf.getValueAt(original, (Variable)row, columnID);
        return value;
    }

    public boolean isReadOnly(TableModel original, Object row, String columnID) throws UnknownTypeException {
        VariablesFilter vf = this.getFilter(row, true, null);
        if (vf == null) {
            return original.isReadOnly(row, columnID);
        }
        return vf.isReadOnly(original, (Variable)row, columnID);
    }

    public void setValueAt(TableModel original, Object row, String columnID, Object value) throws UnknownTypeException {
        VariablesFilter vf = this.getFilter(row, false, null);
        if (vf == null) {
            original.setValueAt(row, columnID, value);
        } else {
            vf.setValueAt(original, (Variable)row, columnID, value);
        }
    }

    private VariablesFilter getFilter(Object o, boolean checkEvaluated, Runnable whenEvaluated) {
        if (this.typeToFilter == null) {
            this.typeToFilter = new HashMap();
            this.ancestorToFilter = new HashMap();
            List l = this.lookupProvider.lookup(null, VariablesFilter.class);
            int k = l.size();
            for (int i = 0; i < k; ++i) {
                int j;
                VariablesFilter f = (VariablesFilter)l.get(i);
                String[] types = f.getSupportedAncestors();
                int jj = types.length;
                for (j = 0; j < jj; ++j) {
                    this.ancestorToFilter.put(types[j], f);
                }
                types = f.getSupportedTypes();
                jj = types.length;
                for (j = 0; j < jj; ++j) {
                    this.typeToFilter.put(types[j], f);
                }
            }
        }
        if (this.typeToFilter.size() == 0) {
            return null;
        }
        if (!(o instanceof Variable)) {
            return null;
        }
        Variable v = (Variable)o;
        if (checkEvaluated && !VariablesTreeModelFilter.isEvaluated(v)) {
            if (whenEvaluated != null) {
                this.postEvaluationMonitor(o, whenEvaluated);
            }
            return null;
        }
        String type = v.getType();
        VariablesFilter vf = (VariablesFilter)this.typeToFilter.get(type);
        if (vf != null) {
            return vf;
        }
        return null;
    }
}

