/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.breakpoints;

import com.hp.openvms.netbeans.debugsupport.breakpoints.BreakpointImpl;
import com.hp.openvms.netbeans.debugsupport.breakpoints.BreakpointsReader;
import com.hp.openvms.netbeans.debugsupport.breakpoints.LineBreakpoint;
import com.hp.openvms.netbeans.debugsupport.debugger.RemoteDebugger;
import com.hp.openvms.netbeans.utils.FileUtilityLang;
import java.io.File;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.distributed.rmi.protocol.debug.DebugInfo;
import org.netbeans.modules.distributed.rmi.protocol.debug.LookupLinePacket;
import org.netbeans.modules.distributed.rmi.protocol.debug.SourceDisplayInfo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class LineBreakpointImpl
extends BreakpointImpl {
    private LineBreakpoint breakpoint;
    private int lineNumber;
    private BreakpointsReader reader;
    private boolean writeToCache;

    public LineBreakpointImpl(LineBreakpoint breakpoint, BreakpointsReader reader, RemoteDebugger debugger, Session session, boolean writeToCache) {
        super(breakpoint, reader, debugger, session);
        this.reader = reader;
        this.breakpoint = breakpoint;
        this.writeToCache = writeToCache;
        this.lineNumber = breakpoint.getLineNumber();
        this.set();
    }

    public LineBreakpointImpl(LineBreakpoint breakpoint, BreakpointsReader reader, RemoteDebugger debugger, Session session) {
        super(breakpoint, reader, debugger, session);
        this.reader = reader;
        this.breakpoint = breakpoint;
        this.writeToCache = false;
        this.lineNumber = breakpoint.getLineNumber();
        this.set();
    }

    void fixed() {
        this.lineNumber = this.breakpoint.getLineNumber();
        super.fixed();
    }

    public boolean getWriteToCache() {
        return this.writeToCache;
    }

    public void setWriteToCache(boolean writeToCache) {
        this.writeToCache = writeToCache;
    }

    private SourceDisplayInfo prepareSourceDisplayInfo() throws Exception {
        this.lineNumber = this.breakpoint.getLineNumber();
        String url = this.breakpoint.getURL();
        if (this.breakpoint.getVmsFilePath() == null) {
            FileObject retVal = URLMapper.findFileObject((URL)new URL(url));
            File file = FileUtil.toFile((FileObject)retVal);
            String vPath = FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, retVal);
            this.breakpoint.setVmsFilePath(vPath);
        }
        SourceDisplayInfo sdi = new SourceDisplayInfo(this.breakpoint.getVmsFilePath(), this.breakpoint.getLineNumber(), this.breakpoint.getLookupLinePacket() == null ? -1 : this.breakpoint.getLookupLinePacket().getLine());
        return sdi;
    }

    protected void setRequests() {
        try {
            if (this.breakpoint.getState() == 0) {
                if (this.breakpoint.isEnabled()) {
                    SourceDisplayInfo sdi = this.prepareSourceDisplayInfo();
                    if (this.writeToCache) {
                        this.getDebugger().breakpointInsertCache(sdi);
                    } else {
                        DebugInfo info = this.getDebugger().breakpointInsert(sdi);
                        this.breakpoint.setLookupLinePacket((LookupLinePacket)info.getLookupLinePackets().get(0));
                    }
                } else if (this.writeToCache) {
                    this.getDebugger().breakpointInsertCache(null);
                }
                this.breakpoint.setPending();
            } else if (this.breakpoint.getState() != 3) {
                if (this.breakpoint.isEnabled()) {
                    SourceDisplayInfo sdi = this.prepareSourceDisplayInfo();
                    DebugInfo info = this.getDebugger().breakpointInsert(sdi);
                    this.breakpoint.setLookupLinePacket((LookupLinePacket)info.getLookupLinePackets().get(0));
                } else if (this.breakpoint.getLookupLinePacket() != null) {
                    this.getDebugger().breakpointRemove(this.breakpoint.getLookupLinePacket());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String normalize(String path) {
        Pattern thisDirectoryPattern = Pattern.compile("(/|\\A)\\./");
        Pattern parentDirectoryPattern = Pattern.compile("(/|\\A)([^/]+?)/\\.\\./");
        Matcher m = thisDirectoryPattern.matcher(path);
        while (m.find()) {
            path = m.replaceAll("$1");
            m = thisDirectoryPattern.matcher(path);
        }
        m = parentDirectoryPattern.matcher(path);
        while (m.find()) {
            if (m.group(2).equals("..")) continue;
            path = path.substring(0, m.start()) + m.group(1) + path.substring(m.end());
            m = parentDirectoryPattern.matcher(path);
        }
        return path;
    }
}

