/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.cppsupport.ccpp.datasys;

import com.hp.openvms.netbeans.cppsupport.ccpp.CCppCompilerType;
import com.hp.openvms.netbeans.cppsupport.ccpp.cc.CCompilerType;
import com.hp.openvms.netbeans.cppsupport.ccpp.cpp.CppCompilerType;
import com.hp.openvms.netbeans.cppsupport.ccpp.datasys.CDataNode;
import com.hp.openvms.netbeans.cppsupport.ccpp.datasys.CppCompilerSupport;
import com.hp.openvms.netbeans.cppsupport.ccpp.datasys.CppDataNode;
import com.hp.openvms.netbeans.utils.FileUtilityLang;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.distributed.common.propertyeditors.BoolEditor;
import org.netbeans.modules.distributed.common.propertyeditors.StringEditor2;
import org.netbeans.modules.distributed.common.util.RemoteProjectSettings;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileSystem;
import org.netbeans.modules.distributed.remotefs.propertyeditor.FileEditor;
import org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteFSFile;
import org.openide.ErrorManager;
import org.openide.compiler.CompilerSupport;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public abstract class CCppCompilerSupport
extends CompilerSupport {
    public static final String PROP_EXTERNAL_COMPILER = "cpqCcppExternalCompiler";
    public static final String PROP_MAKEFILE_COMPILER = "cpqCcppMakefileCompiler";
    public static final String PROP_DEFINE = "cpqCcppDefine";
    public static final String PROP_UNDEFINE = "cpqCcppUndefine";
    public static final String PROP_INCLUDE = "cpqCppInclude";
    public static final String PROP_LIBRARY = "cpqCcppLibrary";
    public static final String PROP_OPTIMIZE = "cpqCcppOptimize";
    public static final String PROP_OBJECT = "cpqCcppObject";
    public static final String PROP_DEBUG = "cpqCcppDebug";
    public static final String PROP_WARNING = "cpqCcppWarning";
    public static final String PROP_BUILD_DIR = "cpqCcppBuildDirectory";
    public static final String PROP_BUILD_OPTION = "cpqCcppBuildOption";
    public static final String PROP_CCPP_OPTION = "cpqCcppOption";
    public static final String PROP_RESET = "cpqCcppReset";
    public static final String PROP_BUILD_COMMAND = "cpqBuildCommand";
    public static final String PROP_OUTPUT_SWITCH = "cpqOutputSwitch";
    public static final String PROP_CCPP_GLOBAL_QUALIFIER = "cpqCcppGlobalQualifier";
    public static final String PROP_CCPP_LOCAL_QUALIFIER = "cpqCcppLocalQualifier";
    public static final String UPDATED = "updated";
    protected MultiDataObject.Entry entry;
    protected static final ResourceBundle bundle = NbBundle.getBundle(CCppCompilerSupport.class);
    protected int compilerTypeEnum;

    protected CCppCompilerSupport(MultiDataObject.Entry entry, Class cookie) {
        super(entry, cookie);
        this.entry = entry;
        this.compilerTypeEnum = this instanceof CppCompilerSupport ? CCppCompilerType.CPP_TYPE : CCppCompilerType.C_TYPE;
    }

    public FileObject getFileObject() {
        return this.entry.getFile();
    }

    protected CCppCompilerType getProjCompilerType() {
        Project project = FileOwnerQuery.getOwner((FileObject)this.getFileObject());
        if (project != null) {
            RemoteProjectSettings rs = (RemoteProjectSettings)project.getLookup().lookup(RemoteProjectSettings.class);
            if (this instanceof CppCompilerSupport) {
                if (rs == null) {
                    return new CppCompilerType(this.getFileObject());
                }
                return (CCppCompilerType)((Object)rs.getCompilerSettings("cpp"));
            }
            if (rs == null) {
                return new CCompilerType(this.getFileObject());
            }
            return (CCppCompilerType)((Object)rs.getCompilerSettings("c"));
        }
        return null;
    }

    protected String getString(String s) {
        return bundle.getString(s);
    }

    public void addProperties(Sheet.Set set) {
        set.put((Node.Property)this.createCCppLocalQualifierProperty());
        set.put((Node.Property)this.createCCppGlobalQualifierProperty());
    }

    public void addRemoteProperties(Sheet.Set set) {
        set.put((Node.Property)this.createRemoteFilePathProperty());
        try {
            if (this.entry.getFile().getFileSystem() instanceof FTPFileSystem) {
                set.put((Node.Property)this.createFileResidenceProperty());
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
    }

    public void addMakefileProperty(Sheet.Set set) {
        set.put((Node.Property)this.createBuildDirectoryProperty());
        set.put((Node.Property)this.createMakefileCompilerProperty());
        set.put((Node.Property)this.createBuildCommandProperty());
        set.put((Node.Property)this.createOutputSwitchProperty());
        set.put((Node.Property)this.createXDisplayDeviceNumber());
    }

    public void addBuildOptionProperty(Sheet.Set set) {
        set.put((Node.Property)this.createBuildOptionProperty());
    }

    public void addCompilerTypeProperty(Sheet.Set set, Sheet sheet) {
        super.addProperties(set);
    }

    public abstract NbProcessDescriptor getExternalCompiler();

    private String getCurrentFileDir() {
        try {
            String rootDir = FileUtil.toFile((FileObject)this.entry.getDataObject().getPrimaryFile().getFileSystem().getRoot()).getAbsolutePath();
            String fileDir = this.entry.getDataObject().getPrimaryFile().getParent().getPath();
            Object objectDir = null;
            return rootDir + '/' + fileDir;
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getReset() {
        String reset = (String)this.entry.getFile().getAttribute(PROP_RESET);
        if (reset == null) {
            return "Reset";
        }
        return reset;
    }

    private void changeResetProp(String prop, Object value) {
        Node node = this.entry.getDataObject().getNodeDelegate();
        if (node instanceof CppDataNode) {
            ((CppDataNode)node).firePropertyChange2(prop, null, value);
        } else {
            ((CDataNode)node).firePropertyChange2(prop, null, value);
        }
    }

    protected void flagProperty(String dispProp, String prop) {
    }

    public String getGlobalQualifier() {
        String option = (String)this.entry.getFile().getAttribute(PROP_CCPP_GLOBAL_QUALIFIER);
        if (option == null) {
            return this.getProjCompilerType().getGlobalQualifier();
        }
        return option;
    }

    private void setGlobalQualifier(String option) throws IOException {
        this.entry.getFile().setAttribute(PROP_CCPP_GLOBAL_QUALIFIER, (Object)option);
    }

    public String getLocalQualifier() {
        String option = (String)this.entry.getFile().getAttribute(PROP_CCPP_LOCAL_QUALIFIER);
        if (option == null) {
            return this.getProjCompilerType().getLocalQualifier();
        }
        return option;
    }

    private void setLocalQualifier(String option) throws IOException {
        this.entry.getFile().setAttribute(PROP_CCPP_LOCAL_QUALIFIER, (Object)option);
    }

    public RemoteFSFile getBuildDirectory() {
        Object buildDir = this.entry.getFile().getAttribute(PROP_BUILD_DIR);
        if (buildDir == null || buildDir instanceof RemoteFSFile && ((RemoteFSFile)buildDir).getAbsolutePath().equals("")) {
            return this.getProjCompilerType().getBuildDirectory();
        }
        if (buildDir != null && !(buildDir instanceof RemoteFSFile)) {
            try {
                this.entry.getFile().setAttribute(PROP_BUILD_DIR, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.getProjCompilerType().getBuildDirectory();
        }
        return (RemoteFSFile)buildDir;
    }

    public String getBuildCommand() {
        String buildCommand = (String)this.entry.getFile().getAttribute(PROP_BUILD_COMMAND);
        if (buildCommand == null) {
            return this.getProjCompilerType().getBuildCommand();
        }
        return buildCommand;
    }

    private void setBuildCommand(String buildCommand) throws IOException {
        this.entry.getFile().setAttribute(PROP_BUILD_COMMAND, (Object)buildCommand);
    }

    public Boolean getOutputSwitch() {
        Boolean outputSwitch = (Boolean)this.entry.getFile().getAttribute(PROP_OUTPUT_SWITCH);
        if (outputSwitch == null) {
            return this.getProjCompilerType().outputSwitch();
        }
        return outputSwitch;
    }

    private void setOutputSwitch(Boolean outputSwitch) throws IOException {
        this.entry.getFile().setAttribute(PROP_OUTPUT_SWITCH, (Object)outputSwitch);
    }

    public Integer getXDisplayNumber() {
        Integer xSwitch = (Integer)this.entry.getFile().getAttribute("xDisplayDeviceNumber");
        if (xSwitch == null) {
            return this.getProjCompilerType().xDisplayNumber();
        }
        return xSwitch;
    }

    private synchronized void setXDisplayNumber(Integer XSwitch) throws IOException {
        this.entry.getFile().setAttribute("xDisplayDeviceNumber", (Object)XSwitch);
    }

    public Boolean getBuildOption() {
        Boolean useMakefile = (Boolean)this.entry.getFile().getAttribute(PROP_BUILD_OPTION);
        if (useMakefile == null) {
            return (Boolean)this.getProjCompilerType().getBuildOption();
        }
        return useMakefile;
    }

    private void setBuildOption(Boolean buildProperty) throws IOException {
        Node node = this.entry.getDataObject().getNodeDelegate();
        Node.PropertySet[] ps = node.getPropertySets();
        if (buildProperty == null) {
            this.entry.getFile().setAttribute(PROP_BUILD_OPTION, null);
        } else if (node instanceof CppDataNode) {
            if (buildProperty.equals(Boolean.TRUE)) {
                ps[1].setHidden(true);
                ps[2].setHidden(false);
            } else {
                ps[1].setHidden(false);
                ps[2].setHidden(true);
            }
            this.entry.getFile().setAttribute(PROP_BUILD_OPTION, (Object)buildProperty);
            ((CppDataNode)node).firePropertySetChange2(null, ps);
        } else if (node instanceof CDataNode) {
            if (buildProperty.equals(Boolean.TRUE)) {
                ps[1].setHidden(true);
                ps[2].setHidden(false);
            } else {
                ps[1].setHidden(false);
                ps[2].setHidden(true);
            }
            this.entry.getFile().setAttribute(PROP_BUILD_OPTION, (Object)buildProperty);
            ((CDataNode)node).firePropertySetChange2(null, ps);
        }
    }

    private void setBuildDirectory(RemoteFSFile buildDirectory) throws IOException {
        this.entry.getFile().setAttribute(PROP_BUILD_DIR, (Object)buildDirectory);
    }

    public RemoteFSFile getMakefileCompiler() {
        Object obj = this.entry.getFile().getAttribute(PROP_MAKEFILE_COMPILER);
        if (obj != null && obj instanceof RemoteFSFile) {
            return (RemoteFSFile)obj;
        }
        if (obj != null && obj instanceof String) {
            try {
                this.entry.getFile().setAttribute(PROP_MAKEFILE_COMPILER, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.getProjCompilerType().getMakefileCompiler();
        }
        return this.getProjCompilerType().getMakefileCompiler();
    }

    private void setMakefileCompiler(RemoteFSFile externalCompiler) throws IOException {
        this.entry.getFile().setAttribute(PROP_MAKEFILE_COMPILER, (Object)externalCompiler);
    }

    protected String getFlaggedName(String dispName, String name) {
        return dispName;
    }

    private String getFlaggedNameMakefile(String dispName, String name) {
        return dispName;
    }

    private String getFlaggedNameBuildOption(String dispName, String name) {
        return dispName;
    }

    private String getFlaggedNameOutputSwitch(String dispName, String name) {
        return dispName;
    }

    private PropertySupport createFileResidenceProperty() {
        class FileResidenceProperty
        extends PropertySupport.ReadOnly {
            public FileResidenceProperty() {
                super("File Residence", String.class, "File Residence", "Determine if the file should reside in local disk, server or both");
            }

            public Object getValue() {
                FileObject fobj = CCppCompilerSupport.this.entry.getFile();
                Object obj = fobj.getAttribute("file_residence_mode");
                try {
                    RemoteFileSystem rf = (RemoteFileSystem)fobj.getFileSystem();
                    if (rf.getServerOnlyFileExts().isRegistered(fobj.getExt())) {
                        return "Server Only";
                    }
                }
                catch (FileStateInvalidException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                if (obj != null) {
                    Integer itr = (Integer)obj;
                    String ret = "Make Client and Server";
                    switch (itr) {
                        case 1: {
                            ret = "Client Only";
                            break;
                        }
                        case 0: {
                            ret = "Server Only";
                            break;
                        }
                        case 2: {
                            ret = "Client and Server";
                        }
                    }
                    return ret;
                }
                return "Client and Server";
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new FileResidenceProperty();
    }

    private PropertySupport createRemoteFilePathProperty() {
        class RemoteFilePathPropertySupport
        extends PropertySupport.ReadOnly {
            public RemoteFilePathPropertySupport() {
                super("Remote File Path", String.class, "Remote File Path", "Remote File Path");
            }

            public Object getValue() {
                FileObject fobj = CCppCompilerSupport.this.entry.getFile();
                Object obj = fobj.getAttribute("REMOTE_FILEPATH");
                if (obj != null) {
                    return obj;
                }
                String vmsPath = fobj.getNameExt();
                try {
                    File file = FileUtil.toFile((FileObject)fobj);
                    if (Utilities.isWindows()) {
                        vmsPath = FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                    } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                        vmsPath = FileUtilityLang.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                return vmsPath;
            }

            public void setValue(Object val) throws InvocationTargetException {
                try {
                    FileObject fobj = CCppCompilerSupport.this.entry.getFile();
                    fobj.setAttribute("REMOTE_FILEPATH", val);
                }
                catch (IOException ex) {
                    throw new InvocationTargetException(ex);
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                FileObject fobj = CCppCompilerSupport.this.entry.getFile();
                String vmsPath = fobj.getNameExt();
                try {
                    File file = FileUtil.toFile((FileObject)fobj);
                    if (Utilities.isWindows()) {
                        vmsPath = FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                    } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                        vmsPath = FileUtilityLang.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                    }
                    this.setValue(vmsPath);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return new RemoteFilePathPropertySupport();
    }

    private PropertySupport createMakefileCompilerProperty() {
        class MakefileProperty
        extends PropertySupport.ReadWrite {
            public MakefileProperty() {
                super(CCppCompilerSupport.PROP_MAKEFILE_COMPILER, RemoteFSFile.class, CCppCompilerSupport.this.getFlaggedNameMakefile(CCppCompilerSupport.this.getString("PROP_MAKEFILE_COMPILER"), CCppCompilerSupport.PROP_MAKEFILE_COMPILER), CCppCompilerSupport.this.getString("HINT_MAKEFILE_COMPILER"));
                this.setValue("directories", Boolean.TRUE);
                this.setValue("files", Boolean.TRUE);
                this.setValue("3gl", Boolean.TRUE);
                this.setValue("fileName", CCppCompilerSupport.this.entry.getFile().getNameExt());
                if (CCppCompilerSupport.this.getProjCompilerType().getMakefileCompiler() != null) {
                    this.setValue("projvalue", CCppCompilerSupport.this.getProjCompilerType().getMakefileCompiler());
                }
                try {
                    if (CCppCompilerSupport.this.entry.getFile().getFileSystem() instanceof AbstractNetworkFileSystem) {
                        this.setValue("remoteFS", CCppCompilerSupport.this.entry.getFile().getFileSystem());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                CCppCompilerSupport.this.setDefaultFunction((PropertySupport)this, CCppCompilerSupport.PROP_MAKEFILE_COMPILER, "com.hp.openvms.netbeans.cppsupport.settings.CCppFileCompilerSettings");
            }

            public Object getValue() {
                return CCppCompilerSupport.this.getMakefileCompiler();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof RemoteFSFile || val == null) {
                    try {
                        CCppCompilerSupport.this.setMakefileCompiler((RemoteFSFile)val);
                        CCppCompilerSupport.this.flagProperty(CCppCompilerSupport.this.getFlaggedNameMakefile(CCppCompilerSupport.this.getString("PROP_MAKEFILE_COMPILER"), CCppCompilerSupport.PROP_MAKEFILE_COMPILER), CCppCompilerSupport.PROP_MAKEFILE_COMPILER);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(CCppCompilerSupport.this.getProjCompilerType().getMakefileCompiler());
                CCppCompilerSupport.this.changeResetProp(CCppCompilerSupport.PROP_MAKEFILE_COMPILER, this.getValue());
            }

            public PropertyEditor getPropertyEditor() {
                return new FileEditor();
            }
        }
        return new MakefileProperty();
    }

    private PropertySupport createBuildOptionProperty() {
        class BuildOptionPropertySupport
        extends PropertySupport.ReadWrite {
            public BuildOptionPropertySupport() {
                super(CCppCompilerSupport.PROP_BUILD_OPTION, Object.class, CCppCompilerSupport.this.getFlaggedNameBuildOption(CCppCompilerSupport.this.getString("PROP_BUILD_OPTION"), CCppCompilerSupport.PROP_BUILD_OPTION), CCppCompilerSupport.this.getString("HINT_BUILD_OPTION"));
                if (CCppCompilerSupport.this.getProjCompilerType().getBuildOption() != null) {
                    this.setValue("projValue", CCppCompilerSupport.this.getProjCompilerType().getBuildOption());
                }
                CCppCompilerSupport.this.setDefaultFunction((PropertySupport)this, CCppCompilerSupport.PROP_BUILD_OPTION, "com.hp.openvms.netbeans.cppsupport.settings.CCppFileCompilerSettings");
            }

            public Object getValue() {
                return CCppCompilerSupport.this.getBuildOption();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof Boolean || val == null) {
                    try {
                        CCppCompilerSupport.this.setBuildOption((Boolean)val);
                        CCppCompilerSupport.this.flagProperty(CCppCompilerSupport.this.getFlaggedNameBuildOption(CCppCompilerSupport.this.getString("PROP_BUILD_OPTION"), CCppCompilerSupport.PROP_BUILD_OPTION), CCppCompilerSupport.PROP_BUILD_OPTION);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(CCppCompilerSupport.this.getBuildOption());
            }

            public PropertyEditor getPropertyEditor() {
                return new BoolEditor();
            }
        }
        return new BuildOptionPropertySupport();
    }

    private PropertySupport createXDisplayDeviceNumber() {
        class XDisplayDeviceNumberPropertySupport
        extends PropertySupport.ReadWrite {
            public XDisplayDeviceNumberPropertySupport() {
                super("X Display Device Number", Integer.class, "X Display Device Number", "Defines the screen associated with the display device");
            }

            public Object getValue() {
                return CCppCompilerSupport.this.getXDisplayNumber();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof Integer || val == null) {
                    try {
                        CCppCompilerSupport.this.setXDisplayNumber((Integer)val);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new XDisplayDeviceNumberPropertySupport();
    }

    private PropertySupport createOutputSwitchProperty() {
        class OutputSwitchPropertySupport
        extends PropertySupport.ReadWrite {
            public OutputSwitchPropertySupport() {
                super(CCppCompilerSupport.PROP_OUTPUT_SWITCH, Object.class, CCppCompilerSupport.this.getFlaggedNameOutputSwitch(CCppCompilerSupport.this.getString("PROP_OUTPUT_SWITCH"), CCppCompilerSupport.PROP_OUTPUT_SWITCH), CCppCompilerSupport.this.getString("HINT_OUTPUT_SWITCH"));
                this.setValue("helpID", "com.hp.openvms.netbeans.cppsupport.settings.CCppFileGeneralSettings");
                CCppCompilerSupport.this.setDefaultFunction((PropertySupport)this, CCppCompilerSupport.PROP_OUTPUT_SWITCH, "com.hp.openvms.netbeans.cppsupport.settings.CCppFileCompilerSettings");
                if (CCppCompilerSupport.this.getProjCompilerType().outputSwitch() != null) {
                    this.setValue("projValue", CCppCompilerSupport.this.getProjCompilerType().outputSwitch());
                }
            }

            public Object getValue() {
                return CCppCompilerSupport.this.getOutputSwitch();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof Boolean || val == null) {
                    try {
                        CCppCompilerSupport.this.setOutputSwitch((Boolean)val);
                        CCppCompilerSupport.this.flagProperty(CCppCompilerSupport.this.getFlaggedNameOutputSwitch(CCppCompilerSupport.this.getString("PROP_OUTPUT_SWITCH"), CCppCompilerSupport.PROP_OUTPUT_SWITCH), CCppCompilerSupport.PROP_OUTPUT_SWITCH);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(CCppCompilerSupport.this.getOutputSwitch());
            }

            public PropertyEditor getPropertyEditor() {
                return new BoolEditor();
            }
        }
        return new OutputSwitchPropertySupport();
    }

    private PropertySupport createCCppLocalQualifierProperty() {
        class CppLocalQualifierPropertySupport
        extends PropertySupport.ReadWrite {
            public CppLocalQualifierPropertySupport() {
                super(CCppCompilerSupport.PROP_CCPP_LOCAL_QUALIFIER, String.class, CCppCompilerSupport.this.getFlaggedName(CCppCompilerSupport.this.getString("PROP_CCPP_LOCAL_QUALIFIER"), CCppCompilerSupport.PROP_CCPP_LOCAL_QUALIFIER), CCppCompilerSupport.this.getString("HINT_CCPP_LOCAL_QUALIFIER"));
                CCppCompilerSupport.this.setDefaultFunction((PropertySupport)this, CCppCompilerSupport.PROP_CCPP_LOCAL_QUALIFIER, "com.hp.openvms.netbeans.cppsupport.settings.CCppFileCompilerSettings");
            }

            public Object getValue() {
                return CCppCompilerSupport.this.getLocalQualifier();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof String || val == null) {
                    try {
                        CCppCompilerSupport.this.setLocalQualifier((String)val);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(CCppCompilerSupport.this.getLocalQualifier());
            }

            public PropertyEditor getPropertyEditor() {
                return new StringEditor2();
            }
        }
        return new CppLocalQualifierPropertySupport();
    }

    private PropertySupport createCCppGlobalQualifierProperty() {
        class CppGlobalQualifierPropertySupport
        extends PropertySupport.ReadWrite {
            public CppGlobalQualifierPropertySupport() {
                super(CCppCompilerSupport.PROP_CCPP_GLOBAL_QUALIFIER, String.class, CCppCompilerSupport.this.getFlaggedName(CCppCompilerSupport.this.getString("PROP_CCPP_GLOBAL_QUALIFIER"), CCppCompilerSupport.PROP_CCPP_GLOBAL_QUALIFIER), CCppCompilerSupport.this.getString("HINT_CCPP_GLOBAL_QUALIFIER"));
                CCppCompilerSupport.this.setDefaultFunction((PropertySupport)this, CCppCompilerSupport.PROP_CCPP_GLOBAL_QUALIFIER, "com.hp.openvms.netbeans.cppsupport.settings.CCppFileCompilerSettings");
            }

            public Object getValue() {
                return CCppCompilerSupport.this.getGlobalQualifier();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof String || val == null) {
                    try {
                        CCppCompilerSupport.this.setGlobalQualifier((String)val);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(CCppCompilerSupport.this.getGlobalQualifier());
            }

            public PropertyEditor getPropertyEditor() {
                return new StringEditor2();
            }
        }
        return new CppGlobalQualifierPropertySupport();
    }

    protected void setDefaultFunction(PropertySupport ps, String propName, String helpID) {
        try {
            ps.setValue("method", (Object)FileObject.class.getMethod("getAttribute", String.class));
            ps.setValue("param", (Object)propName);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        ps.setValue("object", (Object)this.entry.getFile());
        ps.setValue("helpID", (Object)helpID);
    }

    private PropertySupport createBuildDirectoryProperty() {
        class PropertySupportBuildDirectory
        extends PropertySupport.ReadWrite {
            public PropertySupportBuildDirectory() {
                super(CCppCompilerSupport.PROP_BUILD_DIR, RemoteFSFile.class, CCppCompilerSupport.this.getFlaggedName(CCppCompilerSupport.this.getString("PROP_BUILD_DIR"), CCppCompilerSupport.PROP_BUILD_DIR), CCppCompilerSupport.this.getString("HINT_BUILD_DIR"));
                this.setValue("directories", Boolean.TRUE);
                this.setValue("files", Boolean.FALSE);
                this.setValue("3gl", Boolean.TRUE);
                this.setValue("fileName", CCppCompilerSupport.this.entry.getFile().getNameExt());
                if (CCppCompilerSupport.this.getProjCompilerType().getBuildDirectory() != null) {
                    this.setValue("projvalue", CCppCompilerSupport.this.getProjCompilerType().getBuildDirectory());
                }
                try {
                    if (CCppCompilerSupport.this.entry.getFile().getFileSystem() instanceof AbstractNetworkFileSystem) {
                        this.setValue("remoteFS", CCppCompilerSupport.this.entry.getFile().getFileSystem());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                CCppCompilerSupport.this.setDefaultFunction((PropertySupport)this, CCppCompilerSupport.PROP_BUILD_DIR, "com.hp.openvms.netbeans.cppsupport.settings.CCppFileCompilerSettings");
            }

            public Object getValue() {
                return CCppCompilerSupport.this.getBuildDirectory();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof RemoteFSFile || val == null) {
                    try {
                        CCppCompilerSupport.this.setBuildDirectory((RemoteFSFile)val);
                        CCppCompilerSupport.this.flagProperty(CCppCompilerSupport.this.getFlaggedName(CCppCompilerSupport.this.getString("PROP_BUILD_DIR"), CCppCompilerSupport.PROP_BUILD_DIR), CCppCompilerSupport.PROP_BUILD_DIR);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(CCppCompilerSupport.this.getBuildDirectory());
                CCppCompilerSupport.this.changeResetProp(CCppCompilerSupport.PROP_BUILD_DIR, this.getValue());
            }

            public PropertyEditor getPropertyEditor() {
                return new FileEditor();
            }
        }
        return new PropertySupportBuildDirectory();
    }

    private PropertySupport createBuildCommandProperty() {
        class PropertySupportBuildCommand
        extends PropertySupport.ReadWrite {
            public PropertySupportBuildCommand() {
                super(CCppCompilerSupport.PROP_BUILD_COMMAND, String.class, CCppCompilerSupport.this.getFlaggedName(CCppCompilerSupport.this.getString("PROP_BUILD_COMMAND"), CCppCompilerSupport.PROP_BUILD_COMMAND), CCppCompilerSupport.this.getString("HINT_BUILD_COMMAND"));
                CCppCompilerSupport.this.setDefaultFunction((PropertySupport)this, CCppCompilerSupport.PROP_BUILD_COMMAND, "com.hp.openvms.netbeans.cppsupport.settings.CCppFileCompilerSettings");
            }

            public Object getValue() {
                return CCppCompilerSupport.this.getBuildCommand();
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof String || val == null) {
                    try {
                        CCppCompilerSupport.this.setBuildCommand((String)val);
                        CCppCompilerSupport.this.flagProperty(CCppCompilerSupport.this.getFlaggedName(CCppCompilerSupport.this.getString("PROP_BUILD_COMMAND"), CCppCompilerSupport.PROP_BUILD_COMMAND), CCppCompilerSupport.PROP_BUILD_COMMAND);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(CCppCompilerSupport.this.getBuildCommand());
                CCppCompilerSupport.this.changeResetProp(CCppCompilerSupport.PROP_BUILD_COMMAND, this.getValue());
            }

            public boolean canWrite() {
                return !CCppCompilerSupport.this.entry.getFile().isReadOnly();
            }

            public PropertyEditor getPropertyEditor() {
                return new StringEditor2();
            }
        }
        return new PropertySupportBuildCommand();
    }
}

