/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.cobolsupport.cobol.datasys;

import com.hp.openvms.netbeans.cobolsupport.cobol.datasys.CobolDataObject;
import java.io.IOException;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.windows.CloneableOpenSupport;

class CobolDataEditor
extends DataEditorSupport
implements OpenCookie,
EditCookie,
EditorCookie,
PrintCookie {
    CobolDataEditor(CobolDataObject obj) {
        super((DataObject)obj, (CloneableEditorSupport.Env)new CobolEnv(obj));
        this.setMIMEType("text/x-hp+openvms+cob");
    }

    protected boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        CobolEnv e = (CobolEnv)this.env;
        e.getCobolDataObject().addSaveCookie(e);
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        CobolEnv e = (CobolEnv)this.env;
        e.getCobolDataObject().removeSaveCookie(e);
    }

    private static class CobolEnv
    extends DataEditorSupport.Env
    implements SaveCookie {
        private static final long serialVersionUID = 1012847739803620478L;

        public CobolEnv(CobolDataObject obj) {
            super((DataObject)obj);
        }

        CobolDataObject getCobolDataObject() {
            return (CobolDataObject)this.getDataObject();
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((CobolDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public void save() throws IOException {
            ((CobolDataEditor)this.findCloneableOpenSupport()).saveDocument();
            this.getDataObject().setModified(false);
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)this.getDataObject().getCookie(EditCookie.class);
        }
    }
}

