/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.lexer.util;

import java.util.HashMap;
import java.util.Iterator;

public final class StateStack {
    private static final int DEFAULT_MAX_CACHE_SIZE = 300;
    private static int maxCacheSize = 300;
    private static final StateStack searchStack = new StateStack(null, 0);
    private static HashMap cacheMap = new HashMap(89);
    private static int statQueries;
    private static int statHits;
    private static int statResets;
    private int state;
    private StateStack parent;
    private int hash;

    public static synchronized StateStack push(StateStack stateStack, int n) {
        StateStack.searchStack.parent = stateStack;
        StateStack.searchStack.state = n;
        searchStack.updateHash();
        stateStack = (StateStack)cacheMap.get(searchStack);
        if (stateStack != null) {
            ++statHits;
        } else {
            stateStack = new StateStack(StateStack.searchStack.parent, n);
            if (cacheMap.size() >= maxCacheSize) {
                StateStack.cacheFull();
            }
            cacheMap.put(stateStack, stateStack);
        }
        ++statQueries;
        return stateStack;
    }

    private static void cacheFull() {
        cacheMap.clear();
        if (maxCacheSize < 1500) {
            maxCacheSize = maxCacheSize * 3 / 2;
        }
    }

    public static StateStack pop(StateStack stateStack) {
        if (stateStack == null) {
            throw new IllegalArgumentException("Cannot pop from null stack");
        }
        return stateStack.parent;
    }

    private StateStack(StateStack stateStack, int n) {
        this.parent = stateStack;
        this.state = n;
        this.updateHash();
    }

    public int getState() {
        return this.state;
    }

    public int hashCode() {
        return this.hash;
    }

    private void updateHash() {
        int n = this.parent != null ? this.parent.hash : 0;
        this.hash = 127 * n + this.state;
    }

    public boolean equals(Object object) {
        if (object instanceof StateStack) {
            StateStack stateStack = this;
            StateStack stateStack2 = (StateStack)object;
            do {
                if (stateStack.state != stateStack2.state) {
                    return false;
                }
                stateStack = stateStack.parent;
                stateStack2 = stateStack2.parent;
                if (stateStack != stateStack2) continue;
                return true;
            } while (stateStack != null && stateStack2 != null);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        StateStack stateStack = this;
        while (stateStack != null) {
            stringBuffer.append(stateStack.state);
            stateStack = stateStack.parent;
            if (stateStack == null) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static String toStringStatic() {
        String string = "cacheSize=" + cacheMap.size() + ", maxCacheSize=" + maxCacheSize + ", statHits=" + statHits + ", statQueries=" + statQueries;
        if (statQueries > 0) {
            string = string + ", hit ratio=" + statHits * 100 / statQueries + "%";
        }
        return string;
    }

    public static synchronized String toStringStaticDetail() {
        Iterator iterator = cacheMap.values().iterator();
        if (!iterator.hasNext()) {
            return "No stacks.";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (iterator.hasNext()) {
            StateStack stateStack = (StateStack)iterator.next();
            stringBuffer.append('[');
            stringBuffer.append(n);
            stringBuffer.append("]=");
            stringBuffer.append(stateStack);
            stringBuffer.append('\n');
            ++n;
        }
        stringBuffer.append(StateStack.toStringStatic());
        return stringBuffer.toString();
    }
}

