/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.lexer.util;

import java.util.Comparator;
import org.netbeans.spi.lexer.util.ObjectArray;

public class ObjectArrayUtilities {
    private ObjectArrayUtilities() {
    }

    public static int binarySearch(ObjectArray objectArray, Object object) {
        int n = 0;
        int n2 = objectArray.getItemCount() - 1;
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            Object object2 = objectArray.getItem(n3);
            int n4 = ((Comparable)object2).compareTo(object);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public static int binarySearch(ObjectArray objectArray, Object object, Comparator comparator) {
        int n = 0;
        int n2 = objectArray.getItemCount() - 1;
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            Object object2 = objectArray.getItem(n3);
            int n4 = comparator.compare(object2, object);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public static int findIndex(ObjectArray objectArray, Object object) {
        int n = ObjectArrayUtilities.binarySearch(objectArray, object);
        if (n < 0) {
            return -1;
        }
        if (objectArray.getItem(n) == object) {
            return n;
        }
        int n2 = objectArray.getItemCount();
        for (int i = n + 1; i < n2; ++i) {
            Object object2 = objectArray.getItem(i);
            if (object2 == object) {
                return i;
            }
            if (((Comparable)object).compareTo(object2) != 0) break;
        }
        while (--n >= 0) {
            Object object3 = objectArray.getItem(n);
            if (object3 == object) {
                return n;
            }
            if (((Comparable)object).compareTo(object3) == 0) continue;
            break;
        }
        return -1;
    }

    public static int findIndex(ObjectArray objectArray, Object object, Comparator comparator) {
        int n = ObjectArrayUtilities.binarySearch(objectArray, object, comparator);
        if (n < 0) {
            return -1;
        }
        if (objectArray.getItem(n) == object) {
            return n;
        }
        int n2 = objectArray.getItemCount();
        for (int i = n + 1; i < n2; ++i) {
            Object object2 = objectArray.getItem(i);
            if (object2 == object) {
                return i;
            }
            if (comparator.compare(object, object2) != 0) break;
        }
        while (--n >= 0) {
            Object object3 = objectArray.getItem(n);
            if (object3 == object) {
                return n;
            }
            if (comparator.compare(object, object3) == 0) continue;
            break;
        }
        return -1;
    }

    public static Object[] toArray(ObjectArray objectArray) {
        return ObjectArrayUtilities.toArray(objectArray, 0, objectArray.getItemCount());
    }

    public static Object[] toArray(ObjectArray objectArray, int n, int n2) {
        Object[] objectArray2 = new Object[n2 - n];
        ObjectArrayUtilities.copyItems(objectArray, n, n2, objectArray2, 0);
        return objectArray2;
    }

    public static void copyItems(ObjectArray objectArray, int n, int n2, Object[] objectArray2, int n3) {
        if (objectArray instanceof ObjectArray.CopyItems) {
            ((ObjectArray.CopyItems)((Object)objectArray)).copyItems(n, n2, objectArray2, n3);
        } else {
            while (n < n2) {
                objectArray2[n3++] = objectArray.getItem(n++);
            }
        }
    }

    public static void reverse(Object[] objectArray) {
        int n = 0;
        for (int i = objectArray.length - 1; n < i; ++n, --i) {
            Object object = objectArray[n];
            objectArray[n] = objectArray[i];
            objectArray[i] = object;
        }
    }
}

