/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import org.openide.awt.StatusDisplayer;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.compiler.CompilerTask;
import org.openide.cookies.CompilerCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.openide.util.enum.AlterEnumeration;
import org.openide.util.enum.ArrayEnumeration;
import org.openide.util.enum.FilterEnumeration;
import org.openide.util.enum.QueueEnumeration;
import org.openide.util.enum.SequenceEnumeration;

public abstract class AbstractCompileAction
extends NodeAction {
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Compile;

    protected void performAction(final Node[] nodeArray) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                AbstractCompileAction.this.compileNodes2(nodeArray);
            }
        });
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray.length == 0) {
            return false;
        }
        Class clazz = this.cookie();
        Compiler.Depth depth = this.depth();
        for (int i = 0; i < nodeArray.length; ++i) {
            CompilerCookie compilerCookie = (CompilerCookie)nodeArray[i].getCookie(clazz);
            if (!(compilerCookie == null ? depth.isLastDepth() || nodeArray[i].getCookie(class$org$openide$loaders$DataObject$Container == null ? AbstractCompileAction.class$("org.openide.loaders.DataObject$Container") : class$org$openide$loaders$DataObject$Container) == null : !compilerCookie.isDepthSupported(depth))) continue;
            return false;
        }
        return true;
    }

    protected abstract Compiler.Depth depth();

    protected abstract Class cookie();

    protected String message() {
        return NbBundle.getMessage((Class)Compiler.class, (String)"CTL_CompilationStarted");
    }

    public static boolean compileDataObjects(DataObject[] dataObjectArray) {
        HashSet<CompilerCookie> hashSet = new HashSet<CompilerCookie>();
        for (int i = 0; i < dataObjectArray.length; ++i) {
            CompilerCookie compilerCookie = (CompilerCookie)dataObjectArray[i].getCookie(class$org$openide$cookies$CompilerCookie$Compile == null ? AbstractCompileAction.class$("org.openide.cookies.CompilerCookie$Compile") : class$org$openide$cookies$CompilerCookie$Compile);
            if (compilerCookie == null) continue;
            hashSet.add(compilerCookie);
        }
        return AbstractCompileAction.compile(Collections.enumeration(hashSet), AbstractCompileAction.findName(dataObjectArray));
    }

    public static boolean compileNodes(Node[] nodeArray) {
        HashSet<CompilerCookie> hashSet = new HashSet<CompilerCookie>();
        for (int i = 0; i < nodeArray.length; ++i) {
            CompilerCookie compilerCookie = (CompilerCookie)nodeArray[i].getCookie(class$org$openide$cookies$CompilerCookie$Compile == null ? AbstractCompileAction.class$("org.openide.cookies.CompilerCookie$Compile") : class$org$openide$cookies$CompilerCookie$Compile);
            if (compilerCookie == null) continue;
            hashSet.add(compilerCookie);
        }
        return AbstractCompileAction.compile(Collections.enumeration(hashSet), AbstractCompileAction.findName(nodeArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compileNodes2(Node[] nodeArray) {
        boolean bl;
        DataObject[] dataObjectArray;
        CompilerJob compilerJob;
        StatusDisplayer.getDefault().setStatusText(this.message());
        try {
            compilerJob = new CompilerJob(this.depth());
            AbstractCompileAction.prepareJobFor(compilerJob, (Enumeration)new ArrayEnumeration((Object[])nodeArray), this.cookie(), this.depth());
            dataObjectArray = new DataObject[nodeArray.length];
            bl = false;
            for (int i = 0; i < nodeArray.length; ++i) {
                dataObjectArray[i] = (DataObject)nodeArray[i].getCookie(class$org$openide$loaders$DataObject == null ? AbstractCompileAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (dataObjectArray[i] != null) continue;
                bl = true;
                break;
            }
        }
        finally {
            StatusDisplayer.getDefault().setStatusText("");
        }
        compilerJob.setDisplayName(bl ? AbstractCompileAction.findName(nodeArray) : AbstractCompileAction.findName(dataObjectArray));
        compilerJob.start();
    }

    static String findName(Node[] nodeArray) {
        String string = "";
        if (nodeArray.length > 0) {
            Node node = nodeArray[0];
            Node.Cookie cookie = null;
            do {
                if ((cookie = node.getCookie(class$org$openide$loaders$DataObject == null ? AbstractCompileAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject)) == null) continue;
                DataObject dataObject = (DataObject)cookie;
                string = dataObject.isValid() ? dataObject.getNodeDelegate().getDisplayName() : "";
                break;
            } while ((node = node.getParentNode()) != null);
        }
        return NbBundle.getMessage((Class)Compiler.class, (String)"FMT_Compile", (Object)new Integer(nodeArray.length), (Object)string);
    }

    static String findName(DataObject[] dataObjectArray) {
        return NbBundle.getMessage((Class)Compiler.class, (String)"FMT_Compile", (Object)new Integer(dataObjectArray.length), (Object)(dataObjectArray.length > 0 && dataObjectArray[0].isValid() ? dataObjectArray[0].getNodeDelegate().getDisplayName() : ""));
    }

    public static CompilerJob createJob(Enumeration enumeration, Compiler.Depth depth) {
        CompilerJob compilerJob = new CompilerJob(depth);
        AbstractCompileAction.prepareJobFor(compilerJob, enumeration, CompilerCookie.class, depth, null);
        return compilerJob;
    }

    public static boolean compile(Enumeration enumeration, String string) {
        CompilerJob compilerJob = AbstractCompileAction.createJob(enumeration, Compiler.DEPTH_ZERO);
        compilerJob.setDisplayName(string);
        if (!compilerJob.isUpToDate()) {
            CompilerTask compilerTask = compilerJob.start();
            return compilerTask.isSuccessful();
        }
        return true;
    }

    private static Node.Cookie findCookie(DataObject dataObject, Class clazz) {
        if (!CompilerCookie.class.isAssignableFrom(clazz)) {
            throw new ClassCastException(clazz.getName());
        }
        Node.Cookie cookie = dataObject.getCookie(clazz);
        if (cookie != null) {
            return cookie;
        }
        if (!(dataObject instanceof DataObject.Container)) {
            return null;
        }
        if (!clazz.isAssignableFrom(Cmp.class)) {
            return null;
        }
        return new Cmp((DataObject.Container)dataObject, clazz);
    }

    private static Node.Cookie findCookie(Node node, Class clazz) {
        if (!CompilerCookie.class.isAssignableFrom(clazz)) {
            throw new ClassCastException(clazz.getName());
        }
        Node.Cookie cookie = node.getCookie(clazz);
        if (cookie != null) {
            return cookie;
        }
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null) {
            return null;
        }
        return AbstractCompileAction.findCookie(dataObject, clazz);
    }

    public static void prepareJobFor(CompilerJob compilerJob, Enumeration enumeration, Class clazz, Compiler.Depth depth) {
        AbstractCompileAction.prepareJobFor(compilerJob, enumeration, clazz, depth, null);
    }

    private static void prepareJobFor(CompilerJob compilerJob, Enumeration enumeration, Class clazz, Compiler.Depth depth, Object object) {
        HashSet<Object> hashSet = new HashSet<Object>(37);
        if (object != null) {
            hashSet.add(object);
        }
        FilterEnumeration filterEnumeration = new FilterEnumeration(AbstractCompileAction.enumerateForDepth(clazz, enumeration, depth, hashSet));
        while (filterEnumeration.hasMoreElements()) {
            CompilerCookie compilerCookie = (CompilerCookie)filterEnumeration.nextElement();
            compilerCookie.addToJob(compilerJob, depth);
        }
    }

    private static Enumeration enumerateForDepth(Class clazz, Enumeration enumeration, Compiler.Depth depth, HashSet hashSet) {
        QueueEnumeration queueEnumeration = new QueueEnumeration();
        queueEnumeration.put((Object)AbstractCompileAction.processArray(enumeration, clazz, queueEnumeration, depth, hashSet));
        return new SequenceEnumeration((Enumeration)queueEnumeration);
    }

    private static Enumeration processArray(Enumeration enumeration, final Class clazz, final QueueEnumeration queueEnumeration, final Compiler.Depth depth, final HashSet hashSet) {
        return new AlterEnumeration(enumeration){

            public Object alter(Object object) {
                return AbstractCompileAction.processObject(object, clazz, queueEnumeration, depth, hashSet);
            }
        };
    }

    private static CompilerCookie processObject(Object object, Class clazz, QueueEnumeration queueEnumeration, Compiler.Depth depth, HashSet hashSet) {
        Cmp cmp;
        if (hashSet.contains(object)) {
            return null;
        }
        CompilerCookie compilerCookie = (CompilerCookie)AbstractCompileAction.resolveCookie(object, clazz);
        if (compilerCookie != object) {
            hashSet.add(object);
        }
        if (compilerCookie instanceof Cmp && (cmp = (Cmp)compilerCookie).wasCreatedFor(object)) {
            compilerCookie = null;
        }
        if (compilerCookie != null) {
            if (hashSet.contains(compilerCookie)) {
                return null;
            }
            hashSet.add(compilerCookie);
            return compilerCookie;
        }
        if (!depth.isLastDepth() && (cmp = (DataObject.Container)AbstractCompileAction.resolveCookie(object, DataObject.Container.class)) != null) {
            Object[] objectArray = cmp.getChildren();
            ArrayEnumeration arrayEnumeration = new ArrayEnumeration(objectArray);
            queueEnumeration.put((Object)AbstractCompileAction.processArray((Enumeration)arrayEnumeration, clazz, queueEnumeration, depth.nextDepth(), hashSet));
        }
        return null;
    }

    private static Object resolveCookie(Object object, Class clazz) {
        Object object2 = null;
        if (object instanceof DataObject) {
            object2 = ((DataObject)object).getCookie(clazz);
        } else if (object instanceof Node) {
            object2 = ((Node)object).getCookie(clazz);
        } else if (clazz.isInstance(object)) {
            object2 = object;
        }
        return object2;
    }

    private static final class Cmp
    implements CompilerCookie.Compile,
    CompilerCookie.Build,
    CompilerCookie.Clean {
        private DataObject.Container folder;
        private Class cookieClass;

        public Cmp(DataObject.Container container, Class clazz) {
            this.folder = container;
            this.cookieClass = clazz;
        }

        public boolean isDepthSupported(Compiler.Depth depth) {
            return true;
        }

        public void addToJob(CompilerJob compilerJob, Compiler.Depth depth) {
            if (depth.isLastDepth()) {
                return;
            }
            depth = depth.nextDepth();
            AbstractCompileAction.prepareJobFor(compilerJob, (Enumeration)new ArrayEnumeration((Object[])this.folder.getChildren()), this.cookieClass, depth, this);
        }

        boolean wasCreatedFor(Object object) {
            if (object == this.folder) {
                return true;
            }
            return object == ((DataObject)this.folder).getNodeDelegate();
        }

        public int hashCode() {
            return this.folder.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof Cmp) {
                Cmp cmp = (Cmp)object;
                return cmp.wasCreatedFor(this.folder);
            }
            return false;
        }
    }
}

