/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.ftpfs.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JDialog;
import org.netbeans.api.project.Project;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileSystem;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.NodeAction;

public class FTPPropertiesAction
extends NodeAction {
    static final long serialVersionUID = -7910677883191530521L;
    private RemoteFileSystem fs = null;

    protected boolean enable(Node[] nodes) {
        if (nodes == null) {
            return false;
        }
        for (int i = 0; i < nodes.length; ++i) {
            DataObject df = (DataObject)nodes[i].getCookie(DataObject.class);
            if (df == null) continue;
            FileObject fo = df.getPrimaryFile();
            try {
                if (!fo.isFolder()) {
                    return false;
                }
                FileSystem fs = fo.getFileSystem();
                if (!(fs instanceof RemoteFileSystem)) {
                    return false;
                }
                Lookup lookup = nodes[0].getLookup();
                Project project = (Project)lookup.lookup(Project.class);
                if (project != null) continue;
                return false;
            }
            catch (FileStateInvalidException e) {
                // empty catch block
            }
        }
        return true;
    }

    public static void showProperties(Node[] nodes) {
        new FTPPropertiesAction().performAction(nodes);
    }

    protected void performAction(Node[] nodes) {
        if (nodes.length == 0) {
            return;
        }
        DataObject df = (DataObject)nodes[0].getCookie(DataObject.class);
        if (df != null) {
            try {
                FileObject fo = df.getPrimaryFile();
                FTPFileSystem fs = (FTPFileSystem)fo.getFileSystem();
                BeanNode mainNode = new BeanNode((Object)fs);
                PropertySheet ps = new PropertySheet();
                ps.setNodes(new Node[]{mainNode});
                JDialog d = new JDialog();
                d.setTitle("Remote Properties of " + nodes[0].getName());
                d.setModal(true);
                d.getContentPane().setLayout(new BorderLayout());
                d.getContentPane().add((Component)ps, "Center");
                d.pack();
                d.show();
                d.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void setFS(RemoteFileSystem fs) {
        this.fs = fs;
    }

    public String getName() {
        return "Remote Project Properties";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean asynchronous() {
        return false;
    }
}

