/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import javax.swing.filechooser.FileSystemView;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.property.RemoteJarRootProperty;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.JarFileSystem;
import org.openide.util.Utilities;

public class RemoteJarFileSystem
extends JarFileSystem
implements AbstractNetworkFileSystem {
    private static final long serialVersionUID = 5537839122611582551L;
    private RemoteJarRootProperty remoteJarRoot;
    private RemoteRuntimeType remoteRuntimeType;

    public RemoteJarFileSystem(RemoteRuntimeType remoteRuntime) {
        this.remoteRuntimeType = remoteRuntime;
    }

    public RemoteRuntimeType getRemoteRuntimeType() {
        RemoteRuntimeType ret = DistributedSettings.getDefault().findRemoteRuntime(this.remoteRuntimeType.getHostName(), this.remoteRuntimeType.getUserName());
        return ret;
    }

    public void setRemoteRuntimeType(RemoteRuntimeType rt) {
        this.remoteRuntimeType = rt;
    }

    public String getRemoteRoot() {
        return this.remoteJarRoot.getRemoteJarRoot();
    }

    public String getLocalRoot() {
        return this.getJarFile().getAbsolutePath();
    }

    public RemoteJarRootProperty getRemoteJarRoot() {
        return this.remoteJarRoot;
    }

    public void setRemoteJarRoot(RemoteJarRootProperty rt) {
        try {
            this.remoteJarRoot = rt;
            this.setJarFile(new File(rt.getLocalJarRoot()));
        }
        catch (PropertyVetoException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getDisplayName() {
        if (Utilities.isWindows()) {
            String rootDir = this.getJarFile().getAbsolutePath();
            rootDir = rootDir.substring(0, 2);
            String shareName = FileSystemView.getFileSystemView().getSystemDisplayName(new File(rootDir));
            if (shareName.lastIndexOf(40) > 0) {
                shareName = shareName.substring(0, shareName.lastIndexOf(40) - 1);
                return shareName + " (" + super.getDisplayName() + ")";
            }
            return " (" + super.getDisplayName() + ")";
        }
        return "(" + super.getDisplayName() + ")";
    }

    public boolean getUseXtermCompile() {
        return false;
    }

    public boolean getUseXtermExecution() {
        return false;
    }

    public int getXDisplayDeviceNumber() {
        return 0;
    }

    public void decRefCount() {
    }

    public void incRefCount() {
    }

    public FileObject getFSRoot() {
        return this.getRoot();
    }

    public int getRefCount() {
        return -1;
    }
}

