/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteexecute;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.RemoteFSUtils;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.smb.NetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.smb.NetworkJarFileSystem;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Utilities;
import patchsources.OpenProjectList_Dist;

public final class RemoteNbClassPath
implements Serializable {
    static final long serialVersionUID = 7114326612132814401L;
    private Object[] items;
    private String classpath;

    public RemoteNbClassPath(String[] classpathItems) {
        this.items = classpathItems;
    }

    public RemoteNbClassPath(File[] classpathItems) {
        this.items = classpathItems;
    }

    private RemoteNbClassPath(Object[] arr) {
        this.items = arr;
    }

    protected void finalize() throws Throwable {
    }

    public RemoteNbClassPath(NbClassPath localClassPath) {
        Vector<String> res = new Vector<String>();
        String classPath = localClassPath.getClassPath();
        StringTokenizer tok = new StringTokenizer(classPath, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            FileSystem fs;
            String s = tok.nextToken();
            if (s.startsWith("\"")) {
                s = s.substring(1);
            }
            if (s.endsWith("\"")) {
                s = s.substring(0, s.length() - 1);
            }
            if ((fs = RemoteNbClassPath.matchRemoteFS(s)) == null) continue;
            res.add(s);
        }
        this.items = res.toArray();
    }

    public RemoteNbClassPath(String path) {
        this.items = new Exception[0];
        this.classpath = path;
        if (path.indexOf(32) >= 0) {
            if (path.startsWith("\"")) {
                return;
            }
            StringBuffer buff = new StringBuffer(path);
            buff.insert(0, '\"');
            buff.append('\"');
            this.classpath = buff.toString();
        }
    }

    public static FileSystem matchRemoteFS(String localFile) {
        FileObject[] fobjs = FileUtil.fromFile((File)new File(localFile));
        for (int i = 0; i < fobjs.length; ++i) {
            try {
                if (!(fobjs[i].getFileSystem() instanceof NetworkFileSystem) && !(fobjs[i].getFileSystem() instanceof NetworkJarFileSystem) && !(fobjs[i].getFileSystem() instanceof FTPFileSystem)) continue;
                return fobjs[i].getFileSystem();
            }
            catch (FileStateInvalidException ex) {
                // empty catch block
            }
        }
        for (Object obj : OpenProjectList_Dist.getFsSet()) {
            NetworkJarFileSystem njfs;
            if (!(obj instanceof NetworkJarFileSystem) || !localFile.equals((njfs = (NetworkJarFileSystem)obj).getJarFile().getAbsolutePath())) continue;
            return njfs;
        }
        return null;
    }

    public static FileSystem[] createRemoteFSRepositryFS(String[] localFS) {
        Vector<String> res = new Vector<String>();
        for (int i = 0; i < localFS.length; ++i) {
            FileSystem fs = RemoteNbClassPath.matchRemoteFS(localFS[i]);
            if (fs == null) continue;
            res.add(localFS[i]);
        }
        if (res.size() > 0) {
            return (FileSystem[])res.toArray();
        }
        return null;
    }

    public static String[] createRemoteFSRepositry(String[] localFS) {
        Vector<String> res = new Vector<String>();
        for (int i = 0; i < localFS.length; ++i) {
            FileSystem fs = RemoteNbClassPath.matchRemoteFS(localFS[i]);
            if (fs == null) continue;
            res.add(localFS[i]);
        }
        if (res.size() > 0) {
            return (String[])res.toArray();
        }
        return null;
    }

    public static RemoteNbClassPath createRepositoryPath() {
        return RemoteNbClassPath.createRepositoryPath(FileSystemCapability.ALL);
    }

    public static RemoteNbClassPath createRepositoryPath(FileSystemCapability cap) {
        LinkedList<EnvironmentNotSupportedException> res = new LinkedList<EnvironmentNotSupportedException>();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class Env
        extends FileSystem.Environment {
            final /* synthetic */ LinkedList val$res;

            Env(LinkedList linkedList) {
                this.val$res = linkedList;
            }

            public void addClassPath(String element) {
                this.val$res.add(element);
            }
        }
        Env env = new Env(res);
        Enumeration en = cap.fileSystems();
        Object rtt = null;
        while (en.hasMoreElements()) {
            try {
                FileSystem fs = (FileSystem)en.nextElement();
                if (!(fs instanceof AbstractNetworkFileSystem) && !(fs instanceof NetworkJarFileSystem)) continue;
                fs.prepareEnvironment((FileSystem.Environment)env);
            }
            catch (EnvironmentNotSupportedException ex) {
                res.add(ex);
            }
        }
        return new RemoteNbClassPath(res.toArray());
    }

    public static RemoteNbClassPath createLibraryPath() {
        return new RemoteNbClassPath(new File[0]);
    }

    public static RemoteNbClassPath createClassPath() {
        String cp = System.getProperty("java.class.path");
        if (cp == null || cp.length() == 0) {
            return new RemoteNbClassPath("");
        }
        StringBuffer buf = new StringBuffer(cp.length());
        StringTokenizer tok = new StringTokenizer(cp, File.pathSeparator);
        boolean appended = false;
        while (tok.hasMoreTokens()) {
            String piece = tok.nextToken();
            if (piece.endsWith("openide-compat.jar")) continue;
            if (appended) {
                buf.append(File.pathSeparatorChar);
            } else {
                appended = true;
            }
            buf.append(piece);
        }
        return new RemoteNbClassPath(buf.toString());
    }

    public static RemoteNbClassPath createBootClassPath() {
        String boot = System.getProperty("sun.boot.class.path");
        StringBuffer sb = boot != null ? new StringBuffer(boot) : new StringBuffer();
        String extensions = System.getProperty("java.ext.dirs");
        if (extensions != null) {
            StringTokenizer st = new StringTokenizer(extensions, File.pathSeparator);
            while (st.hasMoreTokens()) {
                File dir = new File(st.nextToken());
                File[] entries = dir.listFiles();
                if (entries == null) continue;
                for (int i = 0; i < entries.length; ++i) {
                    String name = entries[i].getName().toLowerCase(Locale.US);
                    if (!name.endsWith(".zip") && !name.endsWith(".jar")) continue;
                    if (sb.length() > 0) {
                        sb.append(File.pathSeparatorChar);
                    }
                    sb.append(entries[i].getPath());
                }
            }
        }
        return new RemoteNbClassPath(sb.toString());
    }

    public static File toFile(FileObject fo) {
        String pne = fo.getPath().replace('/', File.separatorChar);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class Env
        extends FileSystem.Environment {
            public File found;
            final /* synthetic */ String val$pne;

            Env(String string) {
                this.val$pne = string;
            }

            public void addClassPath(String element) {
                if (this.found != null) {
                    return;
                }
                File p = new File(element);
                if (!p.isDirectory()) {
                    return;
                }
                File f = new File(p, this.val$pne);
                if (f.exists()) {
                    this.found = f;
                }
            }
        }
        Env env = new Env(pne);
        try {
            fo.getFileSystem().prepareEnvironment((FileSystem.Environment)env);
            return env.found;
        }
        catch (IOException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception[] getExceptions() {
        try {
            return (Exception[])this.items;
        }
        catch (ClassCastException classCastException) {
            RemoteNbClassPath remoteNbClassPath = this;
            synchronized (remoteNbClassPath) {
                this.getClassPath();
                int first = 0;
                for (int i = 0; i < this.items.length; ++i) {
                    if (this.items[i] == null) continue;
                    this.items[first++] = this.items[i];
                }
                Exception[] list = new Exception[first];
                System.arraycopy(this.items, 0, list, 0, first);
                this.items = list;
                return list;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRemoteClassPath(DataObject dobj) {
        RemoteNbClassPath remoteNbClassPath = this;
        synchronized (remoteNbClassPath) {
            if (this.classpath != null) {
                Vector<String> res = new Vector<String>();
                StringTokenizer tok = new StringTokenizer(this.classpath, File.pathSeparator);
                while (tok.hasMoreTokens()) {
                    String s = tok.nextToken();
                    if (s.startsWith("\"")) {
                        s = s.substring(1);
                    }
                    if (s.endsWith("\"")) {
                        s = s.substring(0, s.length() - 1);
                    }
                    res.add(s);
                }
                this.items = res.toArray();
            }
            StringBuffer sbuff = new StringBuffer();
            for (int i = 0; i < this.items.length; ++i) {
                File f = new File((String)this.items[i]);
                FileSystem fs = RemoteNbClassPath.matchRemoteFS((String)this.items[i]);
                if (fs != null) {
                    try {
                        AbstractNetworkFileSystem nfs = (AbstractNetworkFileSystem)fs;
                        RemoteRuntimeType rrt = nfs.getRemoteRuntimeType();
                        if (rrt == null || ((AbstractNetworkFileSystem)dobj.getPrimaryFile().getFileSystem()).getRemoteRuntimeType() == null || !rrt.equals(((AbstractNetworkFileSystem)dobj.getPrimaryFile().getFileSystem()).getRemoteRuntimeType())) continue;
                        String remotePath = Utilities.isWindows() ? RemoteFSUtils.__winPathToOpenVMSPath((String)this.items[i], f.isDirectory()) : RemoteFSUtils.__unixPathToOpenVMSPath((String)this.items[i], f.isDirectory());
                        remotePath = FileUtility.openVMSPathToUnixPath(remotePath, f.isDirectory());
                        sbuff.append(remotePath);
                        if (this.items.length - 1 <= i) continue;
                        sbuff.append(":");
                    }
                    catch (FileStateInvalidException e) {}
                    continue;
                }
                sbuff.append((String)this.items[i]);
                if (this.items.length - 1 <= i) continue;
                sbuff.append(":");
            }
            return sbuff.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRemoteClassPath() {
        RemoteNbClassPath remoteNbClassPath = this;
        synchronized (remoteNbClassPath) {
            if (this.classpath != null) {
                Vector<String> res = new Vector<String>();
                StringTokenizer tok = new StringTokenizer(this.classpath, File.pathSeparator);
                while (tok.hasMoreTokens()) {
                    String s = tok.nextToken();
                    if (s.startsWith("\"")) {
                        s = s.substring(1);
                    }
                    if (s.endsWith("\"")) {
                        s = s.substring(0, s.length() - 1);
                    }
                    res.add(s);
                }
                this.items = res.toArray();
            }
            StringBuffer sbuff = new StringBuffer();
            for (int i = 0; i < this.items.length; ++i) {
                File f = new File((String)this.items[i]);
                String remotePath = Utilities.isWindows() ? RemoteFSUtils.__winPathToOpenVMSPath((String)this.items[i], f.isDirectory()) : RemoteFSUtils.__unixPathToOpenVMSPath((String)this.items[i], f.isDirectory());
                remotePath = FileUtility.openVMSPathToUnixPath(remotePath, f.isDirectory());
                sbuff.append(remotePath);
                if (this.items.length - 1 <= i) continue;
                sbuff.append(":");
            }
            return sbuff.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClassPath() {
        if (this.classpath != null) {
            return this.classpath;
        }
        RemoteNbClassPath remoteNbClassPath = this;
        synchronized (remoteNbClassPath) {
            if (this.classpath != null) {
                return this.classpath;
            }
            if (this.items.length == 0) {
                this.classpath = "";
                return "";
            }
            StringBuffer sb = new StringBuffer();
            boolean haveone = false;
            for (int i = 0; i < this.items.length; ++i) {
                Object o = this.items[i];
                if (o == null || !(o instanceof String) && !(o instanceof File)) continue;
                if (haveone) {
                    sb.append(File.pathSeparatorChar);
                } else {
                    haveone = true;
                }
                sb.append(o.toString());
                this.items[i] = null;
            }
            String clsPth = sb.toString();
            if (clsPth.indexOf(32) >= 0) {
                sb.insert(0, '\"');
                sb.append('\"');
                this.classpath = sb.toString();
            } else {
                this.classpath = clsPth;
            }
            return this.classpath;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof RemoteNbClassPath)) {
            return false;
        }
        RemoteNbClassPath him = (RemoteNbClassPath)o;
        return this.getClassPath().equals(him.getClassPath());
    }
}

