/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.fortransupport.fortran;

import com.hp.openvms.netbeans.baseclasses.compiler.AlphaVMSCompilerType;
import com.hp.openvms.netbeans.baseclasses.compiler.BogusCompiler;
import com.hp.openvms.netbeans.fortransupport.fortran.FortranCompiler;
import com.hp.openvms.netbeans.fortransupport.fortran.datasys.FortranDataObject;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.distributed.common.util.Utils;
import org.openide.ErrorManager;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class FortranCompilerType
extends AlphaVMSCompilerType {
    public static final String PROP_SOURCE_FORM = "source_form";
    public static final String PROP_EXTEND_SOURCE = "extend_source";
    private Boolean updated;
    private static ResourceBundle bundle;
    private static final long serialVersionUID = 8662815563020991341L;

    public FortranCompilerType(FileObject fobj) {
        super(fobj);
        this.project = FileOwnerQuery.getOwner((FileObject)fobj);
        FileObject pdir = this.project.getProjectDirectory();
        String projectDirectory = FileUtil.toFile((FileObject)pdir).getAbsolutePath();
        this.settingsMap = Utils.getCompilerSettingsFrom3GLXML(projectDirectory, "fortran");
    }

    public static String getString(String name) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(FortranCompilerType.class);
        }
        return bundle.getString(name);
    }

    public void prepareJob(CompilerJob job, Class type, DataObject obj) {
        if (obj instanceof FortranDataObject) {
            super.prepareJob(job, type, obj);
        } else {
            String message = MessageFormat.format(FortranCompilerType.getString("MSG_InvalidCompiler"), this.getName(), obj.getPrimaryFile().toString());
            Throwable t = ErrorManager.getDefault().annotate((Throwable)new IllegalArgumentException("Invalid compiler"), 256, null, message, null, null);
            BogusCompiler compiler = new BogusCompiler(obj.getPrimaryFile(), t);
            job.add(compiler);
        }
    }

    protected Compiler createCompiler(Class type, FileObject fo) {
        return new FortranCompiler(type, fo, this.getExternalCompiler(), this.getErrorExpression(), this);
    }

    public void flushSettings() throws IOException {
        Utils.writeCompilerSettingto3GLXML(this.project, "fortran", this.settingsMap);
    }
}

