/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.cppsupport.prop;

import com.hp.openvms.netbeans.cppsupport.prop.ExPropertyModel;
import com.hp.openvms.netbeans.cppsupport.prop.PropertyEnv;
import com.hp.openvms.netbeans.cppsupport.prop.PropertyModel;
import com.hp.openvms.netbeans.cppsupport.prop.PropertyPanel;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class PropertyDialogManager
implements VetoableChangeListener {
    private PropertyChangeListener listener;
    private Object oldValue;
    private PropertyEditor editor;
    private PropertyModel model;
    private Node.Property prop;
    private boolean changed = false;
    private Component component;
    private Window dialog;
    private JButton okButton;
    private Runnable errorPerformer;
    private boolean okButtonState = true;
    private boolean defaultValue = false;
    private boolean isModal = true;
    private String title = null;
    private HelpCtx helpCtx = null;
    private Object defaultOption;
    private Object[] options;
    private Object envStateBeforeDisplay = null;
    private PropertyEnv env;
    private static ThreadLocal caller = new ThreadLocal();
    private ActionListener actionListener;
    private Object lastValueFromEditor;
    private static final String PROPERTY_DESCRIPTION = "description";
    private static Throwable doNotNotify;

    public PropertyDialogManager(String title, boolean isModal, PropertyEditor editor, PropertyModel model, PropertyEnv env) {
        Object helpID;
        this.editor = editor;
        if (env != null) {
            env.addVetoableChangeListener(this);
        }
        this.component = editor.getCustomEditor();
        this.model = model;
        this.env = env;
        this.title = title;
        this.isModal = isModal;
        this.actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PropertyDialogManager.this.doButtonPressed(evt);
            }
        };
        if (env != null && (helpID = env.getFeatureDescriptor().getValue("helpID")) != null && helpID instanceof String && this.component != null && this.component instanceof JComponent) {
            HelpCtx.setHelpIDString((JComponent)((JComponent)this.component), (String)((String)helpID));
            this.helpCtx = new HelpCtx((String)helpID);
        }
        this.createDialog();
        this.initializeListeners();
    }

    public Window getDialog() {
        return this.dialog;
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (this.env != null && "state".equals(evt.getPropertyName())) {
            boolean bl = this.okButtonState = evt.getNewValue() != PropertyEnv.STATE_INVALID;
            if (this.okButton != null) {
                this.okButton.setEnabled(this.okButtonState);
            }
        }
    }

    private void createDialog() {
        Object obj;
        FeatureDescriptor fd;
        if (this.component instanceof Window) {
            this.dialog = (Window)this.component;
            this.dialog.pack();
            return;
        }
        boolean cannotWrite = false;
        if (this.model instanceof ExPropertyModel && (fd = ((ExPropertyModel)this.model).getFeatureDescriptor()) instanceof Node.Property) {
            this.prop = (Node.Property)fd;
            cannotWrite = !this.prop.canWrite();
            this.defaultValue = this.prop.supportsDefaultValue();
        }
        if (this.editor == null || cannotWrite) {
            JButton closeButton = new JButton(PropertyDialogManager.getString("CTL_Close"));
            closeButton.getAccessibleContext().setAccessibleDescription(PropertyDialogManager.getString("ACSD_CTL_Close"));
            this.options = new Object[]{closeButton};
            this.defaultOption = closeButton;
        } else {
            this.okButton = new JButton(PropertyDialogManager.getString("CTL_OK"));
            this.okButton.getAccessibleContext().setAccessibleDescription(PropertyDialogManager.getString("ACSD_CTL_OK"));
            JButton cancelButton = new JButton(PropertyDialogManager.getString("CTL_Cancel"));
            cancelButton.setVerifyInputWhenFocusTarget(false);
            cancelButton.getAccessibleContext().setAccessibleDescription(PropertyDialogManager.getString("ACSD_CTL_Cancel"));
            cancelButton.setDefaultCapable(false);
            if (this.defaultValue) {
                JButton defaultButton = new JButton(PropertyDialogManager.getString("CTL_Default"));
                defaultButton.setMnemonic(PropertyDialogManager.getString("CTL_DefaultMnemonic").charAt(0));
                defaultButton.getAccessibleContext().setAccessibleDescription(PropertyDialogManager.getString("ACSD_CTL_Default"));
                defaultButton.setDefaultCapable(false);
                defaultButton.setVerifyInputWhenFocusTarget(false);
                this.options = new Object[]{defaultButton, this.okButton, cancelButton};
            } else {
                this.options = new Object[]{this.okButton, cancelButton};
            }
            this.defaultOption = this.okButton;
        }
        if (this.env != null && this.okButton != null) {
            boolean bl = this.okButtonState = this.env.getState() != PropertyEnv.STATE_INVALID;
            if (this.okButton != null) {
                this.okButton.setEnabled(this.okButtonState);
            }
        }
        if (this.env != null) {
            this.envStateBeforeDisplay = this.env.getState();
        }
        try {
            caller.set(this);
            Class<?> c = Class.forName("org.openide.explorer.propertysheet.PropertyDialogManager$CreateDialogInvoker");
            Runnable r = (Runnable)c.newInstance();
            r.run();
            return;
        }
        catch (Exception e) {
        }
        catch (LinkageError e) {
            // empty catch block
        }
        if (this.dialog == null) {
            JOptionPane jop = new JOptionPane(this.component, -1, 1, null, this.options, this.defaultOption);
            if (this.okButton != null) {
                this.okButton.addActionListener(this.actionListener);
            }
            this.dialog = jop.createDialog(null, this.title);
        }
        if (this.env != null && (obj = this.env.getFeatureDescriptor().getValue(PROPERTY_DESCRIPTION)) instanceof String) {
            this.dialog.getAccessibleContext().setAccessibleDescription((String)obj);
        }
    }

    private void initializeListeners() {
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (PropertyDialogManager.this.editor != null && !(PropertyDialogManager.this.component instanceof Window)) {
                    PropertyDialogManager.this.cancelValue();
                }
                if (PropertyDialogManager.this.env != null) {
                    PropertyDialogManager.this.env.removeVetoableChangeListener(PropertyDialogManager.this);
                }
                PropertyDialogManager.this.dialog.dispose();
            }

            public void windowClosed(WindowEvent e) {
                if (PropertyDialogManager.this.component instanceof Window) {
                    if (PropertyDialogManager.this.component instanceof EnhancedCustomPropertyEditor) {
                        try {
                            Object newValue = ((EnhancedCustomPropertyEditor)PropertyDialogManager.this.component).getPropertyValue();
                            PropertyDialogManager.this.model.setValue(newValue);
                        }
                        catch (InvocationTargetException ite) {
                            PropertyPanel.notifyUser(ite, PropertyDialogManager.this.prop == null ? "" : PropertyDialogManager.this.prop.getDisplayName());
                        }
                        catch (IllegalStateException ise) {
                            PropertyDialogManager.notifyUser(ise);
                        }
                    } else if (PropertyDialogManager.this.env != null && !PropertyDialogManager.this.env.isChangeImmediate()) {
                        try {
                            PropertyDialogManager.this.model.setValue(PropertyDialogManager.this.lastValueFromEditor);
                        }
                        catch (InvocationTargetException ite) {
                            PropertyPanel.notifyUser(ite, PropertyDialogManager.this.prop == null ? "" : PropertyDialogManager.this.prop.getDisplayName());
                        }
                        catch (IllegalStateException ise) {
                            PropertyDialogManager.notifyUser(ise);
                        }
                    }
                }
                if (PropertyDialogManager.this.listener != null) {
                    PropertyDialogManager.this.editor.removePropertyChangeListener(PropertyDialogManager.this.listener);
                }
                PropertyDialogManager.this.dialog.removeWindowListener(this);
            }
        });
        if (this.editor != null) {
            try {
                this.oldValue = this.model.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.lastValueFromEditor = this.editor.getValue();
            this.listener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    PropertyDialogManager.this.changed = true;
                    PropertyDialogManager.this.lastValueFromEditor = PropertyDialogManager.this.editor.getValue();
                    if ("propertyValueValid".equals(e.getPropertyName()) && PropertyDialogManager.this.okButton != null && e.getNewValue() instanceof Boolean) {
                        Boolean newButtonState = (Boolean)e.getNewValue();
                        PropertyDialogManager.this.okButtonState = newButtonState;
                        if (PropertyDialogManager.this.env != null) {
                            PropertyDialogManager.this.env.setState(PropertyDialogManager.this.okButtonState ? PropertyEnv.STATE_VALID : PropertyEnv.STATE_INVALID);
                        } else {
                            PropertyDialogManager.this.okButton.setEnabled(PropertyDialogManager.this.okButtonState);
                        }
                        if (e.getOldValue() instanceof Runnable) {
                            PropertyDialogManager.this.errorPerformer = (Runnable)e.getOldValue();
                        } else {
                            PropertyDialogManager.this.errorPerformer = null;
                        }
                    }
                }
            };
            this.editor.addPropertyChangeListener(this.listener);
            this.listener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if ("helpCtx".equals(e.getPropertyName()) && PropertyDialogManager.this.dialog instanceof PropertyChangeListener) {
                        ((PropertyChangeListener)((Object)PropertyDialogManager.this.dialog)).propertyChange(e);
                    }
                }
            };
            this.component.addPropertyChangeListener(this.listener);
        }
    }

    private void cancelValue() {
        if (!this.changed || this.component instanceof EnhancedCustomPropertyEditor || this.env != null && !this.env.isChangeImmediate()) {
            if (this.env != null && this.envStateBeforeDisplay != null) {
                this.env.setState(this.envStateBeforeDisplay);
            }
            return;
        }
        try {
            this.model.setValue(this.oldValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doButtonPressed(ActionEvent evt) {
        String label = evt.getActionCommand();
        if (label.equals(PropertyDialogManager.getString("CTL_Cancel"))) {
            this.cancelValue();
        }
        if (label.equals(PropertyDialogManager.getString("CTL_Default")) && this.prop != null) {
            try {
                this.prop.restoreDefaultValue();
            }
            catch (IllegalAccessException iae) {
                PropertyPanel.notifyUser(iae, this.prop.getDisplayName());
            }
            catch (InvocationTargetException ite) {
                PropertyPanel.notifyUser(ite, this.prop.getDisplayName());
            }
        }
        if (label.equals(PropertyDialogManager.getString("CTL_OK"))) {
            if (this.env != null && this.env.getState() == PropertyEnv.STATE_NEEDS_VALIDATION) {
                this.env.setState(PropertyEnv.STATE_VALID);
                if (this.env.getState() != PropertyEnv.STATE_VALID) {
                    return;
                }
            }
            if (this.component instanceof EnhancedCustomPropertyEditor) {
                try {
                    Object newValue = ((EnhancedCustomPropertyEditor)this.component).getPropertyValue();
                    this.model.setValue(newValue);
                }
                catch (InvocationTargetException ite) {
                    PropertyPanel.notifyUser(ite, this.prop == null ? "" : this.prop.getDisplayName());
                    return;
                }
                catch (IllegalStateException ise) {
                    PropertyDialogManager.notifyUser(ise);
                    return;
                }
            }
            if (this.env != null && !this.env.isChangeImmediate()) {
                try {
                    this.model.setValue(this.lastValueFromEditor);
                }
                catch (InvocationTargetException ite) {
                    PropertyPanel.notifyUser(ite, this.prop == null ? "" : this.prop.getDisplayName());
                    return;
                }
                catch (IllegalStateException ise) {
                    PropertyDialogManager.notifyUser(ise);
                    return;
                }
            }
            if (!this.okButtonState) {
                if (this.errorPerformer != null) {
                    this.errorPerformer.run();
                }
                return;
            }
        }
        this.changed = false;
        if (this.env != null) {
            this.env.removeVetoableChangeListener(this);
        }
        this.dialog.dispose();
    }

    private static String getString(String key) {
        return NbBundle.getBundle(PropertyDialogManager.class).getString(key);
    }

    static void doNotNotify(Throwable ex) {
        doNotNotify = ex;
    }

    static void notify(Throwable ex) {
        Throwable d = doNotNotify;
        doNotNotify = null;
        if (d == ex) {
            return;
        }
        ErrorManager.getDefault().notify(ex);
    }

    static void notify(int severity, Throwable ex) {
        Throwable d = doNotNotify;
        doNotNotify = null;
        if (d == ex) {
            return;
        }
        ErrorManager.getDefault().notify(severity, ex);
    }

    private static void notifyUser(Exception e) {
        ErrorManager em = ErrorManager.getDefault();
        ErrorManager.Annotation[] an = em.findAnnotations((Throwable)e);
        String userMessage = null;
        if (an != null) {
            for (int i = 0; i < an.length; ++i) {
                String msg = an[i].getLocalizedMessage();
                if (msg == null) continue;
                userMessage = msg;
                break;
            }
        }
        if (userMessage == null) {
            userMessage = e.getLocalizedMessage();
        }
        if (userMessage != null) {
            Throwable t = em.annotate((Throwable)e, userMessage);
            em.notify(256, t);
        } else {
            em.notify(1, (Throwable)e);
        }
    }

    static Throwable annotate(Throwable t, int severity, String message, String localizedMessage, Throwable stackTrace, Date date) {
        return ErrorManager.getDefault().annotate(t, severity, message, localizedMessage, stackTrace, date);
    }

    static class CreateDialogInvoker
    implements Runnable {
        CreateDialogInvoker() {
        }

        public void run() {
            PropertyDialogManager pdm = (PropertyDialogManager)caller.get();
            caller.set(null);
            if (pdm == null) {
                throw new IllegalStateException("Parameter caller not passed.");
            }
            DialogDescriptor descriptor = new DialogDescriptor((Object)pdm.component, pdm.title, pdm.isModal, pdm.options, pdm.defaultOption, 0, pdm.helpCtx, pdm.actionListener);
            pdm.dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        }
    }
}

