/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.baseclasses.compiler;

import com.hp.openvms.netbeans.utils.FileUtilityLang;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.smb.NetworkFileSystem;
import org.openide.compiler.ExternalCompilerGroup;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.Utilities;

public abstract class AlphaVMSCompilerGroup
extends ExternalCompilerGroup {
    public abstract boolean getIsRemote();

    protected void notifyError(String file, int line, int column, String message, String ref) {
        if (file == null) {
            super.notifyError(file, line, column, message, ref);
        } else {
            AbstractNetworkFileSystem nfs = null;
            if (this.getIsRemote()) {
                Enumeration col = Repository.getDefault().getFileSystems();
                while (col.hasMoreElements()) {
                    Object fs = col.nextElement();
                    if (!(fs instanceof AbstractNetworkFileSystem)) continue;
                    nfs = (AbstractNetworkFileSystem)fs;
                    String remoteRoot = nfs.getRemoteRoot();
                    boolean match = false;
                    if (remoteRoot.endsWith(":")) {
                        if (remoteRoot.regionMatches(true, 0, file, 0, remoteRoot.length())) {
                            match = true;
                        }
                    } else if (remoteRoot.regionMatches(true, 0, file, 0, remoteRoot.length() - 1) && (file.charAt(remoteRoot.length() - 1) == '.' || file.charAt(remoteRoot.length() - 1) == ']')) {
                        match = true;
                    }
                    if (!match) continue;
                    file = Utilities.isWindows() ? FileUtilityLang.openVMSPathToWinPath(file, false, nfs.getLocalRoot(), remoteRoot) : FileUtilityLang.openVMSPathToUnixPath(file, false, nfs.getLocalRoot(), remoteRoot);
                    break;
                }
            } else {
                file = FileUtilityLang.openVMSPathToUnixPath(file, false);
            }
            file = nfs instanceof NetworkFileSystem ? this.normalizeFileName(file, (FileSystem)((NetworkFileSystem)nfs)) : this.normalizeFileName(file, (FileSystem)((FTPFileSystem)nfs));
            super.notifyError(file, line, column, message, ref);
        }
    }

    private String normalizeFileName(String fileName, FileSystem fs) {
        String repPath = NbClassPath.createRepositoryPath((FileSystemCapability)FileSystemCapability.COMPILE).getClassPath();
        if (repPath.charAt(0) == '\"') {
            repPath = repPath.substring(1, repPath.length() - 1);
        }
        char[] delim = new char[]{File.pathSeparatorChar};
        StringTokenizer stok = new StringTokenizer(repPath, new String(delim));
        while (stok.hasMoreElements()) {
            String parent;
            FileObject pfo;
            String repPath2 = stok.nextToken();
            if (repPath2.length() <= 0 || !fileName.toLowerCase().startsWith(repPath2.toLowerCase()) || fileName.charAt(repPath2.length()) != File.separatorChar) continue;
            if (fileName.length() > repPath2.length() && fs != null && (pfo = fs.findResource(parent = (parent = fileName.substring(repPath2.length() + 1)).lastIndexOf(File.separatorChar) > 0 ? parent.substring(0, parent.lastIndexOf(File.separatorChar)).replace(File.separatorChar, '/') : "")) != null) {
                pfo.refresh();
            }
            StringBuffer sb = new StringBuffer(fileName);
            sb.replace(0, repPath2.length(), new String(repPath2));
            return sb.toString();
        }
        return fileName;
    }

    private void mountFS(String dirName) {
        try {
            File f = new File(dirName);
            if (f != null && !f.isDirectory()) {
                return;
            }
            Repository r = Repository.getDefault();
            Enumeration fileSystemList = r.getFileSystems();
            while (fileSystemList.hasMoreElements()) {
                FileSystem fs = (FileSystem)fileSystemList.nextElement();
                File rootFile = FileUtil.toFile((FileObject)fs.getRoot());
                if (rootFile == null || !rootFile.getAbsolutePath().equalsIgnoreCase(f.getAbsolutePath())) continue;
                return;
            }
            LocalFileSystem localFS = new LocalFileSystem();
            localFS.setHidden(false);
            localFS.setRootDirectory(f);
            r.addFileSystem((FileSystem)localFS);
        }
        catch (IOException ex) {
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }
}

