/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteproject.wizard;

import java.awt.Component;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.smb.NetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.smb.property.RemoteRootProperty;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteFSChooserPanel;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteFTPSelectPanelMultiple;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteFTPSelectVisualPanel;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteMultipleRootPanel;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteRuntimePanel;
import org.netbeans.modules.distributed.remoteproject.RemoteProjectFactory;
import org.netbeans.modules.distributed.remoteproject.wizard.PanelConfigureProject;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;
import patchsources.OpenProjectList_Dist;

public class NewProjectIterator
implements TemplateWizard.Iterator {
    private static String TYPE_STRING_3GL = "3GL";
    String targetName = null;
    private List listeners = new ArrayList();
    static final int TYPE_3GL = 0;
    static final int TYPE_JAVA = 1;
    static final int TYPE_WSIT = 2;
    static final String PROP_NAME_INDEX = "nameIndex";
    private static final long serialVersionUID = 1L;
    private static final int PROJ_ROOT = 0;
    private int type;
    private transient WizardDescriptor wiz;
    private transient WizardDescriptor.Panel[] panels;
    private transient int index;
    private transient int panelIndex;

    public NewProjectIterator() {
        this(0);
    }

    public NewProjectIterator(int type) {
        this.type = type;
    }

    public static NewProjectIterator project3GL() {
        return new NewProjectIterator(0);
    }

    public static NewProjectIterator projectWSIT() {
        return new NewProjectIterator(2);
    }

    public static NewProjectIterator projectJava() {
        return new NewProjectIterator(1);
    }

    public static NewProjectIterator iterator() {
        return new NewProjectIterator();
    }

    private WizardDescriptor.Panel[] createPanels() {
        ArrayList<Object> pList = new ArrayList<Object>();
        pList.add(new PanelConfigureProject(this.type));
        pList.add(new RemoteRuntimePanel());
        pList.add(new RemoteFSChooserPanel());
        pList.add(new RemoteMultipleRootPanel("", "", this.panelIndex, true));
        pList.add(new RemoteFTPSelectPanelMultiple("", true, NbBundle.getMessage(RemoteFTPSelectVisualPanel.class, (String)"TITLE_RemoteFTPSelectVisualPanelSrcRoot"), this.panelIndex++, true));
        WizardDescriptor.Panel[] panels = pList.toArray(new WizardDescriptor.Panel[0]);
        return panels;
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage(NewProjectIterator.class, (String)"LAB_ConfigureProject"), NbBundle.getMessage(NewProjectIterator.class, (String)"TITLE_RemoteRuntimePanel"), NbBundle.getMessage(NewProjectIterator.class, (String)"TITLE_RemoteFTPSelectVisualPanel"), NbBundle.getMessage(NewProjectIterator.class, (String)"TITLE_RemoteFTPSelectVisualPanel"), NbBundle.getMessage(RemoteFTPSelectVisualPanel.class, (String)"TITLE_RemoteFTPSelectVisualPanelSrcRoot")};
    }

    private ArrayList mountFS(WizardDescriptor wiz) throws IOException {
        ArrayList<Object> fsToMount = new ArrayList<Object>();
        ArrayList flist = (ArrayList)wiz.getProperty("remotefs_list");
        for (FileSystem fs : OpenProjectList_Dist.getFsSet()) {
            String lroot = ((AbstractNetworkFileSystem)fs).getLocalRoot();
            Iterator itr = flist.iterator();
            while (itr.hasNext()) {
                HashMap map = (HashMap)itr.next();
                if (!lroot.equalsIgnoreCase((String)map.get("local_directory"))) continue;
                itr.remove();
                fsToMount.add(fs);
            }
        }
        for (HashMap map : flist) {
            int port = 21;
            try {
                Integer portN = (Integer)map.get("FTP_PORT");
                if (portN != null) {
                    port = portN;
                }
            }
            catch (NumberFormatException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                throw e;
            }
            try {
                AbstractNetworkFileSystem fs;
                if ((String)map.get("local_directory") == null || (String)map.get("remote_directory") == null || ((String)map.get("local_directory")).trim().length() == 0 || ((String)map.get("remote_directory")).trim().length() == 0) continue;
                String selectedFS = (String)this.wiz.getProperty("SELECTED_FS");
                if (selectedFS.equals("NETWORK_SHARE")) {
                    fs = new NetworkFileSystem((RemoteRuntimeType)wiz.getProperty("remote_runtime"));
                    RemoteRootProperty rrp = new RemoteRootProperty((NetworkFileSystem)fs, (String)map.get("remote_directory"), (String)map.get("local_directory"), false);
                    fs.setRemoteRoot(rrp);
                } else {
                    fs = new FTPFileSystem(((RemoteRuntimeType)wiz.getProperty("remote_runtime")).getHostName(), ((RemoteRuntimeType)wiz.getProperty("remote_runtime")).getUserName(), port, (String)map.get("local_directory"), (String)map.get("remote_directory"), ((Boolean)map.get("SSH_FORWARD")).equals(Boolean.TRUE), ((Boolean)map.get("IS_PASSIVE")).equals(Boolean.TRUE));
                    ((FTPFileSystem)fs).setReadOnly(((Boolean)map.get("READ_ONLY")).equals(Boolean.TRUE));
                    ((FTPFileSystem)fs).setAutoSync(((Boolean)map.get("AUTO_SYNC")).equals(Boolean.TRUE));
                }
                fsToMount.add(fs);
                OpenProjectList_Dist.getFsSet().add(fs);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                throw e;
            }
        }
        return fsToMount;
    }

    public Set instantiate(TemplateWizard wiz) throws IOException {
        String name = (String)wiz.getProperty("targetName");
        DataObject template = wiz.getTemplate();
        ArrayList flist = this.mountFS((WizardDescriptor)wiz);
        FileSystem fobj = (FileSystem)flist.get(0);
        DataFolder dest = DataFolder.findFolder((FileObject)fobj.getRoot());
        return Collections.singleton(RemoteProjectFactory.createNewPovrayProject(name, template, dest, flist));
    }

    public void initialize(TemplateWizard wiz) {
        this.wiz = wiz;
        this.targetName = wiz.getTargetName();
        wiz.putProperty("remotefs_list", null);
        DataFolder tfld = wiz.getTemplatesFolder();
        DataObject template = wiz.getTemplate();
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(TemplateWizard wiz) {
        this.wiz.putProperty("projdir", null);
        this.wiz.putProperty("name", null);
        this.wiz.putProperty("mainClass", null);
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format(NbBundle.getMessage(NewProjectIterator.class, (String)"LAB_IteratorName"), new Integer(this.index + 1), new Integer(this.panels.length));
    }

    public boolean hasNext() {
        return true;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        String selectedFS;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
        if (this.index == 4 && (selectedFS = (String)this.wiz.getProperty("SELECTED_FS")).equals("NETWORK_SHARE")) {
            ++this.index;
        }
        if (this.index >= this.panels.length) {
            WizardDescriptor.Panel[] _panels = new WizardDescriptor.Panel[this.panels.length + 1];
            System.arraycopy(this.panels, 0, _panels, 0, this.panels.length);
            String selectedFS2 = (String)this.wiz.getProperty("SELECTED_FS");
            _panels[this.panels.length] = !selectedFS2.equals("NETWORK_SHARE") ? new RemoteFTPSelectPanelMultiple("", true, NbBundle.getMessage(RemoteFTPSelectVisualPanel.class, (String)"TITLE_RemoteFTPSelectVisualPanelSrcRoot"), this.panelIndex++, true) : new RemoteMultipleRootPanel("", "", this.panelIndex++, true);
            Component c = _panels[this.panels.length].getComponent();
            String[] steps = this.createSteps();
            if (c instanceof JComponent) {
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(this.panels.length - 1));
                jc.putClientProperty("WizardPanel_contentData", steps);
            }
            this.panels = _panels;
        }
        if (this.index == 3 && !(selectedFS = (String)this.wiz.getProperty("SELECTED_FS")).equals("NETWORK_SHARE")) {
            ++this.index;
        }
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        String selectedFS = (String)this.wiz.getProperty("SELECTED_FS");
        if (this.index == 4) {
            if (!selectedFS.equals("NETWORK_SHARE")) {
                --this.index;
            }
        } else if (this.index == 5 && selectedFS.equals("NETWORK_SHARE")) {
            --this.index;
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    private void fire() {
        ChangeEvent ce = new ChangeEvent(this);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((ChangeListener)i.next()).stateChanged(ce);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }
}

