/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.smb;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.loaders.ExtensionList;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class ExLocalFileSystem
extends LocalFileSystem
implements Runnable {
    private static final long serialVersionUID = -6117993653210115798L;
    private static final ExtensionList DEFAULT_EXTENSIONS = new ExtensionList();
    private static final String BACKUP_EXT = System.getProperty("org.netbeans.core.ExLocalFileSystem.BACKUP_EXT", "~");
    private ExtensionList backupExtensions;
    private String ignoredFiles = "";
    private transient Pattern ignoredRE = null;
    private static final Object ignoredRELock = new String("org.netbeans.core.ExLocalFileSystem.ignoredRELock");
    private String relativeName;
    private boolean relativeFlag = false;

    public OutputStream outputStream(String name) throws IOException {
        this.backupIfNecessary(name);
        return super.outputStream(name);
    }

    boolean isLastModifiedCacheEnabled() {
        return false;
    }

    protected void delete(String name) throws IOException {
        this.backupIfNecessary(name);
        super.delete(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupIfNecessary(String name) throws IOException {
        ExtensionList b;
        ExtensionList extensionList = b = this.backupExtensions == null ? DEFAULT_EXTENSIONS : this.backupExtensions;
        if (b.isRegistered(name)) {
            InputStream is = null;
            try {
                is = super.inputStream(name);
                OutputStream os = super.outputStream(name + BACKUP_EXT);
                try {
                    FileUtil.copy((InputStream)is, (OutputStream)os);
                }
                finally {
                    os.close();
                }
            }
            catch (FileNotFoundException fex) {
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] children(String name) {
        String[] arr = super.children(name);
        if (arr == null) {
            return null;
        }
        Object object = ignoredRELock;
        synchronized (object) {
            for (int i = 0; i < arr.length; ++i) {
                if (Utilities.getOperatingSystem() == 16384 && arr[i].endsWith(".java_")) {
                    try {
                        String newBackupFile = arr[i].substring(0, arr[i].length() - 1) + BACKUP_EXT;
                        super.rename(name + "/" + arr[i], name + "/" + newBackupFile);
                        arr[i] = newBackupFile;
                    }
                    catch (IOException fex) {
                        // empty catch block
                    }
                }
                if (!arr[i].endsWith(BACKUP_EXT) && (this.ignoredRE == null || !this.ignoredRE.matcher(arr[i]).matches())) continue;
                arr[i] = null;
            }
        }
        return arr;
    }

    public void setRefreshTime2(int ms) {
        int old = super.getRefreshTime();
        super.setRefreshTime(ms);
        if (old != ms) {
            this.firePropertyChange("refreshTime", new Integer(old), new Integer(ms));
        }
    }

    public int getRefreshTime2() {
        return super.getRefreshTime();
    }

    public void setSystemName2(String name) throws PropertyVetoException {
        try {
            super.setSystemName(name);
        }
        catch (PropertyVetoException pvx) {
            ErrorManager.getDefault().annotate((Throwable)pvx, pvx.getMessage());
            throw pvx;
        }
    }

    public void setBackupExtensions(ExtensionList l) {
        this.backupExtensions = l;
        this.firePropertyChange("backupExtensions", null, null);
    }

    public ExtensionList getBackupExtensions() {
        if (this.backupExtensions == null) {
            return (ExtensionList)DEFAULT_EXTENSIONS.clone();
        }
        return this.backupExtensions;
    }

    public String getIgnoredFiles() {
        return this.ignoredFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setIgnoredFiles(String nue) throws IllegalArgumentException {
        if (!nue.equals(this.ignoredFiles)) {
            block7: {
                if (nue.length() > 0) {
                    try {
                        Object object = ignoredRELock;
                        synchronized (object) {
                            this.ignoredRE = Pattern.compile(nue);
                            break block7;
                        }
                    }
                    catch (PatternSyntaxException rese) {
                        IllegalArgumentException iae = new IllegalArgumentException();
                        ErrorManager.getDefault().annotate((Throwable)iae, 256, null, NbBundle.getMessage(ExLocalFileSystem.class, (String)"EXC_InvalidRegularExpressionForIgnoredFiles", (Object)rese.getLocalizedMessage()), (Throwable)rese, new Date());
                        throw iae;
                    }
                }
                this.ignoredRE = null;
            }
            this.ignoredFiles = nue;
            this.firePropertyChange("ignoredFiles", null, null);
            RequestProcessor.getDefault().post((Runnable)this);
        }
    }

    public void run() {
        Enumeration e = this.existingFileObjects(this.getRoot());
        while (e.hasMoreElements()) {
            FileObject fo = (FileObject)e.nextElement();
            if (!fo.isFolder()) continue;
            fo.refresh(true);
        }
    }

    public void setRelativeDirectory(String relativeName) throws PropertyVetoException, IOException {
        String oldRelative = this.relativeName;
        try {
            this.relativeName = relativeName;
            this.relativeFlag = true;
            String file = System.getProperty("netbeans.user") + File.separatorChar + relativeName;
            File f = new File(file);
            try {
                f = f.getCanonicalFile();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.setRootDirectory(f);
        }
        catch (PropertyVetoException ex) {
            this.relativeName = oldRelative;
            throw ex;
        }
        catch (IOException ex) {
            this.relativeName = oldRelative;
            throw ex;
        }
        finally {
            this.relativeFlag = false;
        }
    }

    public String getRelativeDirectory() {
        return this.relativeName;
    }

    protected String computeSystemName(File rootFile) {
        if (this.relativeName != null) {
            return "{netbeans.user}/" + this.relativeName;
        }
        return super.computeSystemName(rootFile);
    }

    public synchronized void setRootDirectory(File r) throws PropertyVetoException, IOException {
        String oldRelative = this.relativeName;
        if (!this.relativeFlag) {
            this.relativeName = null;
        }
        try {
            super.setRootDirectory(r);
        }
        catch (PropertyVetoException ex) {
            this.relativeName = oldRelative;
            throw ex;
        }
        catch (IOException ex) {
            this.relativeName = oldRelative;
            throw ex;
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.ignoredFiles == null) {
            this.ignoredFiles = "";
        } else if (this.ignoredFiles.length() > 0) {
            try {
                this.ignoredRE = Pattern.compile(this.ignoredFiles);
            }
            catch (PatternSyntaxException rese) {
                ErrorManager.getDefault().notify((Throwable)rese);
            }
        }
        if (this.relativeName != null) {
            try {
                this.setRelativeDirectory(this.relativeName);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }
}

