/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.propertyeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import org.netbeans.modules.distributed.common.propertyeditors.StringCustomEditorPlain;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient.FTPClient;
import org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient.FTPException;
import org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient.FTPFile;
import org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient.FTPFileName;
import org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteFSFile;
import org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteFSNode;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import patchsources.OpenProjectList_Dist;

public class FileEditor
extends PropertyEditorSupport
implements ExPropertyEditor,
PropertyChangeListener {
    private PropertyEnv env;
    static final String PROPERTY_SHOW_DIRECTORIES = "directories";
    public static final String PROPERTY_SHOW_FILES = "files";
    public static final String PROPERTY_FILTER = "filter";
    static final String PROPERTY_CURRENT_DIR = "currentDir";
    static final String PROPERTY_BASE_DIR = "baseDir";
    static final String PROPERTY_FILE_HIDING = "file_hiding";
    private int mode = 2;
    private boolean directories = true;
    private boolean files = true;
    private boolean fileHiding = false;
    private javax.swing.filechooser.FileFilter fileFilter;
    private File currentDirectory;
    private File baseDirectory;
    private JFileChooser chooser;
    private boolean editable = true;
    private boolean inherited = false;
    private JPanel jPanel1;
    private JCheckBox jButton1;
    private static String fileName = "";

    public void attachEnv(PropertyEnv env) {
        Object baseDir;
        Object filter;
        Object fil;
        this.env = env;
        this.directories = true;
        this.files = true;
        this.fileFilter = null;
        this.fileHiding = false;
        Object dirs = env.getFeatureDescriptor().getValue(PROPERTY_SHOW_DIRECTORIES);
        if (dirs instanceof Boolean) {
            this.directories = (Boolean)dirs;
        }
        if ((fil = env.getFeatureDescriptor().getValue(PROPERTY_SHOW_FILES)) instanceof Boolean) {
            this.files = (Boolean)fil;
        }
        if ((filter = env.getFeatureDescriptor().getValue(PROPERTY_FILTER)) instanceof FilenameFilter) {
            this.fileFilter = new DelegatingFilenameFilter((FilenameFilter)filter);
        } else if (filter instanceof javax.swing.filechooser.FileFilter) {
            this.fileFilter = (javax.swing.filechooser.FileFilter)filter;
        } else if (filter instanceof FileFilter) {
            this.fileFilter = new DelegatingFileFilter((FileFilter)filter);
        }
        Object curDir = env.getFeatureDescriptor().getValue(PROPERTY_CURRENT_DIR);
        if (curDir instanceof File) {
            this.currentDirectory = (File)curDir;
            if (!this.currentDirectory.isDirectory()) {
                ErrorManager.getDefault().log(16, "java.io.File will not accept currentDir=" + this.currentDirectory);
                this.currentDirectory = null;
            }
        }
        if ((baseDir = env.getFeatureDescriptor().getValue(PROPERTY_BASE_DIR)) instanceof File) {
            this.baseDirectory = (File)baseDir;
            if (!this.baseDirectory.isDirectory() || !this.baseDirectory.isAbsolute()) {
                ErrorManager.getDefault().log(16, "java.io.File will not accept baseDir=" + this.baseDirectory);
                this.baseDirectory = null;
            }
        }
        this.mode = this.files ? (this.directories ? 2 : 0) : (this.directories ? 1 : 2);
        Object fileHide = env.getFeatureDescriptor().getValue(PROPERTY_FILE_HIDING);
        if (fileHide instanceof Boolean) {
            this.fileHiding = (Boolean)fileHide;
        }
        if (env.getFeatureDescriptor() instanceof Node.Property) {
            Node.Property prop = (Node.Property)env.getFeatureDescriptor();
            this.editable = prop.canWrite();
        }
        if ((fileName = (String)env.getFeatureDescriptor().getValue("fileName")) == null) {
            fileName = "";
        }
    }

    public String getAsText() {
        RemoteFSFile file = (RemoteFSFile)this.getValue();
        if (file == null) {
            return "";
        }
        String path = file.getPath();
        if (path.equals("")) {
            path = "";
        }
        return path;
    }

    public void setAsText(String str) throws IllegalArgumentException {
        if (str == null) {
            throw new IllegalArgumentException("null");
        }
        RemoteFSFile rfs = null;
        if (str.equals(".")) {
            str = "";
            rfs = new RemoteFSFile(str);
        } else {
            rfs = str.startsWith("/") ? new RemoteFSFile(str) : new RemoteFSFile(str, true);
        }
        this.setValue(rfs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recursiveDisableComponent(JComponent comp, boolean enable) {
        JComponent jComponent = comp;
        synchronized (jComponent) {
            if (!comp.equals(this.jButton1)) {
                comp.setEnabled(enable);
            }
            for (int index = 0; index < comp.getComponentCount(); ++index) {
                Component c = comp.getComponent(index);
                if (!(c instanceof JComponent)) continue;
                this.recursiveDisableComponent((JComponent)c, enable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recursiveDisableComponentStatic(JComponent comp, boolean enable) {
        JComponent jComponent = comp;
        synchronized (jComponent) {
            if (!(comp instanceof JButton) || ((JButton)comp).getText() == null || !((JButton)comp).getText().equals("Cancel")) {
                comp.setEnabled(enable);
            }
            for (int index = 0; index < comp.getComponentCount(); ++index) {
                Component c = comp.getComponent(index);
                if (!(c instanceof JComponent)) continue;
                FileEditor.recursiveDisableComponentStatic((JComponent)c, enable);
            }
        }
    }

    public Object getObject() {
        return this.env.getFeatureDescriptor().getValue("object");
    }

    public Method getMethod() {
        return (Method)this.env.getFeatureDescriptor().getValue("method");
    }

    public String getParam() {
        return (String)this.env.getFeatureDescriptor().getValue("param");
    }

    public String getContext() {
        return (String)this.env.getFeatureDescriptor().getValue("context");
    }

    public File getInherit() {
        Method m = this.getMethod();
        Object obj = this.getObject();
        String param = this.getParam();
        Object value = null;
        try {
            Object tmp = m.invoke(obj, param);
            value = tmp instanceof String ? (tmp.equals("") ? null : new File((String)tmp)) : (File)tmp;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public Component getCustomEditor() {
        if (!this.editable) {
            String info = "";
            Object curVal = this.getValue();
            if (curVal instanceof File) {
                info = ((File)curVal).getAbsolutePath();
            }
            return new StringCustomEditorPlain(info, false);
        }
        if (this.chooser == null) {
            Object obj = this.env.getFeatureDescriptor().getValue("3gl");
            Object object = obj = obj == null ? this.env.getFeatureDescriptor().getValue("context") : obj;
            if (obj != null) {
                HashSet rrts = DistributedSettings.getDefault().getRemoteRuntimes();
                Iterator itr = rrts.iterator();
                RemoteRuntimeType rrt = null;
                boolean isConnected = false;
                while (itr.hasNext()) {
                    rrt = (RemoteRuntimeType)itr.next();
                    rrt.getRemoteRuntimeServerSafe();
                    if (!rrt.isConnected()) continue;
                    isConnected = true;
                }
                rrt = null;
                AbstractNetworkFileSystem nfs = (AbstractNetworkFileSystem)this.env.getFeatureDescriptor().getValue("remoteFS");
                if (nfs != null) {
                    rrt = nfs.getRemoteRuntimeType();
                }
                RemoteFileSystemView rfv = rrt == null ? new RemoteFileSystemView() : new RemoteFileSystemView(rrt);
                this.chooser = FileEditor.createHackedFileChooser(rfv);
                if (!isConnected) {
                    this.chooser = FileEditor.createHackedFileChooser(false);
                    JTextArea jTextArea = new JTextArea();
                    jTextArea.setEditable(false);
                    jTextArea.setText("No Remote IDE Server is connected. Please go to the Services Tab and make a connection");
                    jTextArea.setBackground(new Color(236, 233, 216));
                    jTextArea.setLineWrap(true);
                    jTextArea.setWrapStyleWord(true);
                    jTextArea.setLocation((int)(jTextArea.getLocation().getX() - 14.0), (int)jTextArea.getLocation().getY());
                    jTextArea.setMargin(new Insets(2, 11, 2, 11));
                    this.recursiveDisableComponent(this.chooser, false);
                    this.chooser.setAccessory(jTextArea);
                    return this.chooser;
                }
            } else {
                this.chooser = FileEditor.createHackedFileChooser();
            }
            if (obj == null) {
                File originalFile = (File)this.getValue();
                if (originalFile != null && !originalFile.isAbsolute() && this.baseDirectory != null) {
                    originalFile = new File(this.baseDirectory, originalFile.getPath());
                }
                if (this.currentDirectory != null) {
                    this.chooser.setCurrentDirectory(this.currentDirectory);
                } else if (originalFile != null && originalFile.getParentFile() != null) {
                    this.chooser.setCurrentDirectory(originalFile.getParentFile());
                    this.chooser.setSelectedFile(originalFile);
                }
            }
            this.chooser.setFileSelectionMode(this.mode);
            if (this.fileFilter != null) {
                this.chooser.setFileFilter(this.fileFilter);
            }
            switch (this.mode) {
                case 2: {
                    this.chooser.setDialogTitle(FileEditor.getString("CTL_DialogTitleFilesAndDirs"));
                    break;
                }
                case 0: {
                    this.chooser.setDialogTitle(FileEditor.getString("CTL_DialogTitleFiles"));
                    break;
                }
                case 1: {
                    this.chooser.setDialogTitle(FileEditor.getString("CTL_DialogTitleDirs"));
                }
            }
            this.chooser.setFileHidingEnabled(this.fileHiding);
            this.chooser.setControlButtonsAreShown(false);
            this.chooser.addPropertyChangeListener("SelectedFileChangedProperty", this);
            this.chooser.addPropertyChangeListener("directoryChanged", this);
            HelpCtx.setHelpIDString((JComponent)this.chooser, (String)this.getHelpCtx().getHelpID());
            if (obj != null) {
                this.jButton1 = new JCheckBox("");
                this.jButton1.setToolTipText("");
                this.jButton1.setText("Inherit from Project");
                this.jButton1.setMaximumSize(new Dimension(180, 27));
                this.jButton1.setPreferredSize(new Dimension(180, 27));
                this.jButton1.setLocation((int)(this.jButton1.getLocation().getX() - 14.0), (int)this.jButton1.getLocation().getY());
                this.jButton1.setMargin(new Insets(2, 11, 2, 11));
                this.jButton1.setFocusPainted(false);
                if (this.getContext() == null) {
                    if (this.getInherit() == null) {
                        this.jButton1.setSelected(true);
                        this.recursiveDisableComponent(this.chooser, false);
                        this.inherited = true;
                    } else {
                        this.jButton1.setSelected(false);
                        this.recursiveDisableComponent(this.chooser, true);
                        this.inherited = false;
                    }
                } else {
                    this.jButton1.setVisible(false);
                    this.inherited = false;
                }
                this.chooser.setAccessory(this.jButton1);
                this.jButton1.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        FileEditor.this.jButton1ActionPerformed(evt);
                    }
                });
            }
        }
        return this.chooser;
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            JCheckBox jb = (JCheckBox)evt.getSource();
            if (jb.isSelected()) {
                RemoteFSFile value = (RemoteFSFile)this.env.getFeatureDescriptor().getValue("projvalue");
                this.setValue(value);
                if (value != null) {
                    if (value != null && !value.getAbsolutePath().equals(".") && !value.getAbsolutePath().equals("")) {
                        this.chooser.setSelectedFile(value);
                    } else if (value != null && (value.getAbsolutePath().equals(".") || value.getAbsolutePath().equals(""))) {
                        this.chooser.setSelectedFile(value);
                    }
                    this.setValue(null);
                }
                this.recursiveDisableComponent(this.chooser, false);
                this.jButton1.setEnabled(true);
                this.inherited = true;
            } else {
                this.recursiveDisableComponent(this.chooser, true);
                if (this.chooser.getSelectedFile() == null) {
                    if (this.files) {
                        if (this.getValue() == null || this.getValue().equals("")) {
                            this.setValue(null);
                            this.setAsText("");
                        } else {
                            RemoteFSFile oldValue = new RemoteFSFile(null, null, ((RemoteFSFile)this.getValue()).getAbsolutePath(), ((RemoteFSFile)this.getValue()).getRemoteRuntimeType());
                            this.setValue(null);
                            this.setValue(oldValue);
                        }
                    } else {
                        this.setValue((RemoteFSFile)this.chooser.getCurrentDirectory());
                    }
                } else {
                    String filePath = this.chooser.getSelectedFile().getAbsolutePath();
                    this.setValue(null);
                    this.setValue(this.chooser.getSelectedFile());
                }
                this.inherited = false;
            }
        }
        catch (Exception nsme) {
            nsme.printStackTrace();
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public String getJavaInitializationString() {
        File value = (File)this.getValue();
        if (value == null) {
            return "null";
        }
        if (this.baseDirectory != null && !value.isAbsolute()) {
            return "new java.io.File(" + FileEditor.stringify(this.baseDirectory.getPath()) + ", " + FileEditor.stringify(value.getPath()) + ")";
        }
        return "new java.io.File(" + FileEditor.stringify(value.getAbsolutePath()) + ")";
    }

    static String stringify(String in) {
        StringBuffer buf = new StringBuffer(in.length() * 2 + 2);
        buf.append('\"');
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c == '\\' || c == '\"') {
                buf.append('\\');
            }
            buf.append(c);
        }
        buf.append('\"');
        return buf.toString();
    }

    private HelpCtx getHelpCtx() {
        return new HelpCtx(FileEditor.class);
    }

    private static String getString(String key) {
        return NbBundle.getBundle(FileEditor.class).getString(key);
    }

    static String getChildRelativePath(File baseDir, File file) {
        if (file.equals(baseDir)) {
            return "";
        }
        StringBuffer buf = new StringBuffer(file.getPath().length());
        buf.append(file.getName());
        for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (parent.equals(baseDir)) {
                return buf.toString();
            }
            buf.insert(0, File.separatorChar);
            buf.insert(0, parent.getName());
        }
        return null;
    }

    private void setTitle(JComponent comp, String title) {
        UIManager.put("FileChooser.lookInLabelText", title);
    }

    private static String makeNewTitle(String oldTitle, String fname, String rsvrName, boolean changedTitle) {
        String propName = !changedTitle ? oldTitle.substring(oldTitle.lastIndexOf("-") + 1) : oldTitle.substring(0, oldTitle.lastIndexOf("-")).trim();
        String pInfo = " on " + rsvrName;
        if (propName.trim().endsWith(pInfo)) {
            propName = oldTitle.substring(0, oldTitle.indexOf("-"));
        }
        return propName.trim() + " - " + fname + pInfo;
    }

    private static void changeTitle(JFileChooser chooser, boolean changedTitle) {
        for (Container ctn = chooser.getParent(); ctn != null; ctn = ctn.getParent()) {
            if (!(ctn instanceof Dialog)) continue;
            String rsvrName = ((RemoteFSFile)chooser.getCurrentDirectory()).getRemoteRuntimeType().getHostName() + ":" + ((RemoteFSFile)chooser.getCurrentDirectory()).getRemoteRuntimeType().getUserName();
            ((Dialog)ctn).setTitle(FileEditor.makeNewTitle(((Dialog)ctn).getTitle(), fileName, rsvrName, changedTitle));
            break;
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        String rel;
        JFileChooser chooser = (JFileChooser)e.getSource();
        if (chooser.getCurrentDirectory() instanceof RemoteFSFile) {
            // empty if block
        }
        if (e.getPropertyName().equals("directoryChanged")) {
            if (chooser.getCurrentDirectory() instanceof RemoteFSFile) {
                this.setValue(chooser.getCurrentDirectory());
                FileEditor.changeTitle(chooser, true);
            }
            return;
        }
        File f = chooser.getSelectedFile();
        if (f == null) {
            return;
        }
        if (!this.files && f.isFile()) {
            return;
        }
        if (!this.directories && f.isDirectory()) {
            return;
        }
        if (this.baseDirectory != null && (rel = FileEditor.getChildRelativePath(this.baseDirectory, f)) != null) {
            f = new File(rel);
        }
        this.setValue(f);
    }

    private static FileSystemView getFileSystemView(ArrayList roots, FTPClient ftpClient, boolean useFTP) {
        if (useFTP) {
            if (ftpClient == null) {
                return new FTPFileSystemView();
            }
            return new FTPFileSystemView(roots, ftpClient);
        }
        return FileSystemView.getFileSystemView();
    }

    private static JFileChooser createChooser(final FileSystemView fv) {
        ActionMap parent;
        ActionMap map;
        KeyStroke enter;
        Object value;
        final JFileChooser chooser = new JFileChooser(fv);
        if (Utilities.getOperatingSystem() == 4096) {
            class MyFileView
            extends FileView {
                MyFileView() {
                }

                public String getDescription(File f) {
                    return super.getDescription(f);
                }

                public Icon getIcon(File f) {
                    if (f instanceof RemoteFSNode) {
                        return UIManager.getIcon("FileView.computerIcon");
                    }
                    return UIManager.getIcon(f.isDirectory() ? "FileView.directoryIcon" : "FileView.fileIcon");
                }

                public String getName(File f) {
                    return f.getName();
                }

                public String getTypeDescription(File f) {
                    return super.getTypeDescription(f);
                }

                public Boolean isTraversable(File f) {
                    return f.isDirectory() || f instanceof RemoteFSNode ? Boolean.TRUE : Boolean.FALSE;
                }
            }
            chooser.setFileView(new MyFileView());
        }
        fileName = "";
        chooser.setFileHidingEnabled(false);
        chooser.getAccessibleContext().setAccessibleDescription(FileEditor.getString("ACSD_FileEditor"));
        chooser.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent event) {
                if (fv instanceof RemoteFileSystemView) {
                    FileEditor.changeTitle(chooser, false);
                }
            }

            public void ancestorMoved(AncestorEvent event) {
            }

            public void ancestorRemoved(AncestorEvent event) {
            }
        });
        InputMap im = chooser.getInputMap(1);
        if (im != null && (value = im.get(enter = KeyStroke.getKeyStroke(10, 0))) == null) {
            im.put(enter, "approveSelection");
        }
        if ((map = chooser.getActionMap()) != null && (parent = map.getParent()) != null) {
            final Action original = parent.get("approveSelection");
            parent.put("approveSelection", new AbstractAction(){

                public void actionPerformed(ActionEvent evt) {
                    File file = chooser.getSelectedFile();
                    if (file != null && file.isDirectory()) {
                        try {
                            file = file.getCanonicalFile();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        chooser.setCurrentDirectory(file);
                    } else if (original != null) {
                        original.actionPerformed(evt);
                    }
                }
            });
        }
        return chooser;
    }

    public static JFileChooser createRemoteFileChooser(RemoteRuntimeType rrt) {
        JFileChooser chooser = FileEditor.createChooser(new RemoteFileSystemView(rrt));
        chooser.putClientProperty("FileSystemViewChanged", Boolean.TRUE);
        return chooser;
    }

    public static JFileChooser createRemoteFileChooser() {
        JFileChooser chooser = FileEditor.createChooser(new RemoteFileSystemView());
        chooser.putClientProperty("FileSystemViewChanged", Boolean.TRUE);
        return chooser;
    }

    public static JFileChooser createHackedFileChooser() {
        return FileEditor.createHackedFileChooser(false);
    }

    public static JFileChooser createHackedFileChooserSafe(FileSystemView fsv) {
        HashSet rrts = DistributedSettings.getDefault().getRemoteRuntimes();
        Iterator itr = rrts.iterator();
        RemoteRuntimeType rrt = null;
        boolean isConnected = false;
        while (itr.hasNext()) {
            rrt = (RemoteRuntimeType)itr.next();
            rrt.getRemoteRuntimeServerSafe();
            if (!rrt.isConnected()) continue;
            isConnected = true;
        }
        if (!isConnected) {
            JFileChooser chooser = FileEditor.createHackedFileChooser(false);
            JTextArea jTextArea = new JTextArea();
            jTextArea.setEditable(false);
            jTextArea.setText("No Remote IDE Server is connected. Please go to the Services Tab and make a connection");
            jTextArea.setBackground(new Color(236, 233, 216));
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setLocation((int)(jTextArea.getLocation().getX() - 14.0), (int)jTextArea.getLocation().getY());
            jTextArea.setMargin(new Insets(2, 11, 2, 11));
            FileEditor.recursiveDisableComponentStatic(chooser, false);
            chooser.setAccessory(jTextArea);
            return chooser;
        }
        return FileEditor.createHackedFileChooser(fsv);
    }

    public static JFileChooser createHackedFileChooser(FileSystemView fsv) {
        JFileChooser chooser = FileEditor.createChooser(fsv);
        chooser.putClientProperty("FileSystemViewChanged", Boolean.TRUE);
        return chooser;
    }

    public static JFileChooser createHackedFileChooser(boolean useFTPView, FTPClient ftpClient, ArrayList roots) {
        FileSystemView fv = FileEditor.getFileSystemView(roots, ftpClient, useFTPView);
        return FileEditor.createChooser(fv);
    }

    public static JFileChooser createHackedFileChooser(boolean useFTPView) {
        FileSystemView fv = FileEditor.getFileSystemView(null, null, useFTPView);
        return FileEditor.createChooser(fv);
    }

    public static class FTPFileSystemView
    extends FileSystemView {
        private FTPClient ftpClient;
        private HashMap ftpClientMap = new HashMap();
        private boolean ftpOnly = false;
        private ArrayList roots;

        private List getRoots(FTPFileSystem fs) {
            return fs.getRemoteRuntimeType().listRoots();
        }

        public FTPFileSystemView() {
            Iterator fss = OpenProjectList_Dist.getFsSet().iterator();
            this.roots = new ArrayList();
            while (fss.hasNext()) {
                FileSystem fs = (FileSystem)fss.next();
                if (!(fs instanceof FTPFileSystem)) continue;
                try {
                    if (!((FTPFileSystem)fs).getClient().isConnected()) {
                        ((FTPFileSystem)fs).getClient().connect();
                    }
                    List list = this.getRoots((FTPFileSystem)fs);
                    this.ftpClientMap.put(((FTPFileSystem)fs).getClient(), list == null ? new ArrayList() : list);
                }
                catch (IOException e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 2));
                        }
                    });
                }
            }
        }

        public FTPFileSystemView(ArrayList roots, FTPClient client) {
            this.ftpOnly = true;
            this.ftpClient = client;
            this.roots = roots;
            try {
                if (!this.ftpClient.isConnected()) {
                    this.ftpClient.connect();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public File createFileObject(File dir, String filename) {
            if (dir instanceof FTPFile) {
                return new FTPFile(dir.getAbsolutePath(), filename, ((FTPFile)dir).getFTPClient());
            }
            return super.createFileObject(dir, filename);
        }

        public File createFileObject(String path) {
            if (path.charAt(0) == '/') {
                if (this.ftpOnly && this.ftpClient.getRoot().getFullName().equalsIgnoreCase(path)) {
                    return this.getFTPDirectory();
                }
                Set set = this.ftpClientMap.entrySet();
                for (FTPClient fTPClient : set) {
                    if (!fTPClient.getRoot().getFullName().equalsIgnoreCase(path)) continue;
                    return this.getFTPDirectory(fTPClient);
                }
                String string = path.substring(path.lastIndexOf(47) + 1, path.length());
                String pParent = path.substring(0, path.lastIndexOf(47) < 0 ? 0 : path.lastIndexOf(47));
                return new FTPFile(pParent, string, this.ftpClient);
            }
            return super.createFileObject(path);
        }

        protected File createFileSystemRoot(File f) {
            if (f instanceof FTPFile) {
                return this.createFileObject(f.getParentFile(), f.getName());
            }
            return super.createFileSystemRoot(f);
        }

        public File createNewFolder(File containingDir) throws IOException {
            if (containingDir instanceof FTPFile) {
                int i = 0;
                String newDirName = null;
                for (i = 0; i < 100; ++i) {
                    newDirName = "New_Folder_" + i;
                    try {
                        ((FTPFile)containingDir).getFTPClient().mkdir(new FTPFileName(containingDir.getAbsolutePath(), newDirName, true));
                        break;
                    }
                    catch (IOException e) {
                        if (((FTPException)e).getResponse().getCode() == 550) continue;
                        throw e;
                    }
                }
                if (i == 100) {
                    throw new IOException("Directory already exists:" + newDirName);
                }
                return this.createFileObject(containingDir, newDirName);
            }
            if (containingDir == null) {
                throw new IOException("Containing directory is null:");
            }
            File newFolder = null;
            String newFolderNextString = "New Folder";
            newFolder = this.createFileObject(containingDir, newFolderNextString);
            for (int i = 2; newFolder.exists() && i < 100; ++i) {
                newFolder = this.createFileObject(containingDir, MessageFormat.format(newFolderNextString, new Integer(i)));
            }
            if (newFolder.exists()) {
                throw new IOException("Directory already exists:" + newFolder.getAbsolutePath());
            }
            newFolder.mkdirs();
            return newFolder;
        }

        public File getChild(File parent, String fileName) {
            if (parent instanceof FTPFile) {
                return this.createFileObject(parent, fileName);
            }
            return super.createFileObject(parent, fileName);
        }

        public File getFTPDirectory() {
            String path = this.ftpClient.getRoot().getFullName();
            String pName = path.substring(path.lastIndexOf(47) + 1, path.length());
            String pParent = "";
            return new FTPFile(true, true, true, false, path, path, "", 0L, 0L, this.ftpClient);
        }

        public File[] getFTPDirectories(ArrayList list, FTPClient ftpClient) {
            File[] roots = new File[list.size() + 1];
            for (int i = 0; i < list.size(); ++i) {
                String path = (String)list.get(i);
                String pName = path.substring(path.lastIndexOf(47) + 1, path.length());
                String pParent = "";
                roots[i] = new FTPFile(true, true, true, false, path, path, "", 0L, 0L, ftpClient);
            }
            roots[roots.length - 1] = this.getFTPDirectory(ftpClient);
            return roots;
        }

        public File getFTPDirectory(FTPClient fclient) {
            String path = fclient.getRoot().getFullName();
            String pName = path.substring(path.lastIndexOf(47) + 1, path.length());
            String pParent = "";
            return new FTPFile(true, true, true, false, path, path, "", 0L, 0L, fclient);
        }

        public File getDefaultDirectory() {
            if (this.ftpOnly) {
                return this.getFTPDirectory();
            }
            return super.getDefaultDirectory();
        }

        public File[] getFiles(File dir, boolean useFileHiding) {
            return dir.listFiles();
        }

        public File getHomeDirectory() {
            return this.getFTPDirectory();
        }

        public File getParentDirectory(File dir) {
            if (dir instanceof FTPFile) {
                return ((FTPFile)dir).getParentFile();
            }
            return super.getParentDirectory(dir);
        }

        public File[] getRoots() {
            if (this.ftpOnly) {
                File[] allRoots = this.roots == null ? new File[]{this.getFTPDirectory()} : this.getFTPDirectories(this.roots, this.ftpClient);
                return allRoots;
            }
            ArrayList<File> cList = new ArrayList<File>();
            File[] roots = super.getRoots();
            for (int i = 0; i < roots.length; ++i) {
                cList.add(roots[i]);
            }
            Set set = this.ftpClientMap.keySet();
            for (FTPClient fclient : set) {
                ArrayList rts = (ArrayList)this.ftpClientMap.get(fclient);
                File[] allrts = this.getFTPDirectories(rts, fclient);
                for (int i = 0; i < allrts.length; ++i) {
                    cList.add(allrts[i]);
                }
            }
            return cList.toArray(new File[0]);
        }

        public String getSystemDisplayName(File f) {
            if (f instanceof FTPFile) {
                return f.getName();
            }
            return super.getSystemDisplayName(f);
        }

        public Icon getSystemIcon(File f) {
            if (f instanceof FTPFile) {
                return UIManager.getIcon(f.isDirectory() ? "FileView.directoryIcon" : "FileView.fileIcon");
            }
            return super.getSystemIcon(f);
        }

        public String getSystemTypeDescription(File f) {
            if (f instanceof FTPFile) {
                return super.getSystemTypeDescription(f);
            }
            return super.getSystemTypeDescription(f);
        }

        public boolean isComputerNode(File dir) {
            if (dir instanceof FTPFile) {
                return false;
            }
            return super.isComputerNode(dir);
        }

        public boolean isDrive(File dir) {
            if (dir instanceof FTPFile) {
                return false;
            }
            return super.isDrive(dir);
        }

        public boolean isFileSystem(File f) {
            if (f instanceof FTPFile) {
                return true;
            }
            return super.isFileSystem(f);
        }

        public boolean isFileSystemRoot(File dir) {
            if (dir instanceof FTPFile) {
                return dir.getAbsolutePath().equalsIgnoreCase(((FTPFile)dir).getFTPClient().getRoot().getFullName());
            }
            return super.isFileSystemRoot(dir);
        }

        public boolean isFloppyDrive(File dir) {
            if (dir instanceof FTPFile) {
                return false;
            }
            return super.isFloppyDrive(dir);
        }

        public boolean isHiddenFile(File f) {
            if (f instanceof FTPFile) {
                return false;
            }
            return super.isHiddenFile(f);
        }

        public boolean isParent(File folder, File file) {
            if (file instanceof FTPFile) {
                return file.getParent().equalsIgnoreCase(folder.getAbsolutePath());
            }
            return super.isParent(folder, file);
        }

        public boolean isRoot(File f) {
            if (f instanceof FTPFile) {
                for (int i = 0; this.roots != null && i < this.roots.size(); ++i) {
                    if (!f.getAbsolutePath().equalsIgnoreCase((String)this.roots.get(i))) continue;
                    return true;
                }
                return false;
            }
            return super.isRoot(f);
        }

        public Boolean isTraversable(File f) {
            if (f instanceof FTPFile) {
                return f.isDirectory() ? Boolean.TRUE : Boolean.FALSE;
            }
            return super.isTraversable(f);
        }
    }

    public static class RemoteFileSystemView
    extends FileSystemView {
        private HashSet rrts;
        private ArrayList roots;
        private JFileChooser chooser;
        private File defaultDir;

        public RemoteFileSystemView() {
            this.rrts = DistributedSettings.getDefault().getRemoteRuntimes();
            Iterator itr = this.rrts.iterator();
            RemoteRuntimeType rrt = null;
            while (itr.hasNext()) {
                rrt = (RemoteRuntimeType)itr.next();
                rrt.getRemoteRuntimeServerSafe();
            }
        }

        public RemoteFileSystemView(RemoteRuntimeType rrt) {
            this.rrts = new HashSet();
            rrt.getRemoteRuntimeServerSafe();
            this.rrts.add(rrt);
        }

        public File createFileObject(File dir, String filename) {
            if (dir instanceof RemoteFSFile) {
                return new RemoteFSFile(dir.getAbsolutePath(), dir, filename, ((RemoteFSFile)dir).getRemoteRuntimeType());
            }
            return new RemoteFSFile(dir.getAbsolutePath(), dir, filename, ((RemoteFSNode)dir).getRemoteRuntimeType());
        }

        public File createFileObject(String path) {
            String parent = null;
            this.defaultDir = this.getDefaultDirectory();
            if (path.equalsIgnoreCase(this.defaultDir.getAbsolutePath())) {
                parent = this.defaultDir.getParent();
            } else if (path.startsWith("(")) {
                parent = null;
            } else {
                String[] roots = this.defaultDir.getParentFile().list();
                for (int i = 0; i < roots.length; ++i) {
                    if (!path.equalsIgnoreCase(roots[i])) continue;
                    parent = this.defaultDir.getParent();
                    break;
                }
                if (parent == null && path.lastIndexOf(47) > 0) {
                    parent = path.substring(0, path.lastIndexOf(47));
                }
            }
            return new RemoteFSFile(path, parent, true, (RemoteRuntimeType)this.rrts.iterator().next());
        }

        protected File createFileSystemRoot(File f) {
            return this.createFileObject(f.getParentFile(), f.getName());
        }

        public File createNewFolder(File containingDir) throws IOException {
            int i = 0;
            String newDirName = null;
            for (i = 0; i < 100; ++i) {
                newDirName = "New_Folder_" + i;
                try {
                    String name = containingDir.getAbsolutePath();
                    name = name.endsWith("/") ? name + newDirName : name + "/" + newDirName;
                    RemoteRuntimeType rrt = ((RemoteFSFile)containingDir).getRemoteRuntimeType();
                    boolean bool = rrt.getRemoteFileService().mkdirs(name);
                    if (bool) break;
                    continue;
                }
                catch (RemoteException e) {
                    throw new IOException(e.getMessage());
                }
            }
            if (i == 100) {
                throw new IOException("Directory already exists:" + newDirName);
            }
            return this.createFileObject(containingDir, newDirName);
        }

        public File getChild(File parent, String fileName) {
            return this.createFileObject(parent, fileName);
        }

        public File getDefaultDirectory() {
            try {
                if (this.defaultDir != null) {
                    return this.defaultDir;
                }
                Iterator itr = this.rrts.iterator();
                RemoteRuntimeType rrt = null;
                while (itr.hasNext() && !(rrt = (RemoteRuntimeType)itr.next()).isConnected()) {
                }
                if (rrt == null || !rrt.isConnected()) {
                    return null;
                }
                String remoteRootDir = rrt.getRemoteFileService().getDefaultDirectory();
                RemoteFSFile rf = new RemoteFSFile("(" + rrt.getHostName() + ":" + rrt.getUserName() + ")", new RemoteFSNode(rrt), remoteRootDir, rrt, true, 0L, 0L);
                return rf;
            }
            catch (RemoteException e) {
                return null;
            }
        }

        public File[] getFiles(File dir, boolean useFileHiding) {
            return dir.listFiles();
        }

        public File getHomeDirectory() {
            return this.getDefaultDirectory();
        }

        public File getParentDirectory(File dir) {
            return dir.getParentFile();
        }

        public File[] getRoots() {
            if (this.roots != null) {
                return this.roots.toArray(new File[0]);
            }
            Iterator itr = this.rrts.iterator();
            this.roots = new ArrayList();
            while (itr.hasNext()) {
                RemoteRuntimeType rrt = (RemoteRuntimeType)itr.next();
                if (rrt == null || rrt.getRemoteRuntime() == null) continue;
                RemoteFSNode rn = new RemoteFSNode(rrt);
                this.roots.add(rn);
            }
            return this.roots.toArray(new File[0]);
        }

        public String getSystemDisplayName(File f) {
            return f.getName();
        }

        public Icon getSystemIcon(File f) {
            if (f instanceof RemoteFSNode) {
                return UIManager.getIcon("FileView.computerIcon");
            }
            return UIManager.getIcon(f.isDirectory() ? "FileView.directoryIcon" : "FileView.fileIcon");
        }

        public String getSystemTypeDescription(File f) {
            return super.getSystemTypeDescription(f);
        }

        public boolean isComputerNode(File dir) {
            return dir instanceof RemoteFSNode;
        }

        public boolean isDrive(File dir) {
            return false;
        }

        public boolean isFileSystem(File f) {
            return true;
        }

        public boolean isFileSystemRoot(File dir) {
            if (dir instanceof RemoteFSNode) {
                return true;
            }
            File[] roots = this.getRoots();
            for (int i = 0; i < roots.length; ++i) {
                if (!roots[i].getAbsolutePath().equalsIgnoreCase(dir.getAbsolutePath())) continue;
                return true;
            }
            return false;
        }

        public boolean isFloppyDrive(File dir) {
            return false;
        }

        public boolean isHiddenFile(File f) {
            return false;
        }

        public boolean isParent(File folder, File file) {
            return file.getParent().equalsIgnoreCase(folder.getAbsolutePath());
        }

        public boolean isRoot(File f) {
            return this.isFileSystemRoot(f);
        }

        public Boolean isTraversable(File f) {
            return f.isDirectory() || f instanceof RemoteFSNode ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    static class DelegatingFilenameFilter
    extends javax.swing.filechooser.FileFilter {
        private FilenameFilter filter;

        public DelegatingFilenameFilter(FilenameFilter f) {
            this.filter = f;
        }

        public boolean accept(File f) {
            return this.filter.accept(f.getParentFile(), f.getName());
        }

        public String getDescription() {
            return null;
        }
    }

    static class DelegatingFileFilter
    extends javax.swing.filechooser.FileFilter {
        private FileFilter filter;

        public DelegatingFileFilter(FileFilter f) {
            this.filter = f;
        }

        public boolean accept(File f) {
            return this.filter.accept(f);
        }

        public String getDescription() {
            return null;
        }
    }
}

