/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.ftpfs;

import java.awt.Image;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public abstract class FileStatusInfo {
    public static final FileStatusInfo LOCAL = new DefaultFileStatusInfo("Local", NbBundle.getMessage(FileStatusInfo.class, (String)"FileStatusInfo.local"), null);
    public static final FileStatusInfo UP_TO_DATE = new DefaultFileStatusInfo("Up To Date", NbBundle.getMessage(FileStatusInfo.class, (String)"FileStatusInfo.up_to_date"), "org/netbeans/modules/distributed/remotefs/resources/badgeUpToDate.gif");
    public static final FileStatusInfo OUT_OF_DATE = new DefaultFileStatusInfo("Out Of Date", NbBundle.getMessage(FileStatusInfo.class, (String)"FileStatusInfo.out_of_date"), "org/netbeans/modules/distributed/remotefs/resources/badgeOutOfDate.gif");
    public static final FileStatusInfo MODIFIED = new DefaultFileStatusInfo("Modified", NbBundle.getMessage(FileStatusInfo.class, (String)"FileStatusInfo.modified"), "org/netbeans/api/vcs/resources/badgeLocModified.gif");
    public static final FileStatusInfo MISSING = new DefaultFileStatusInfo("Missing", NbBundle.getMessage(FileStatusInfo.class, (String)"FileStatusInfo.missing"), null);
    public static final FileStatusInfo REMOTE_PRJ = new DefaultFileStatusInfo("RemotePrj", NbBundle.getMessage(FileStatusInfo.class, (String)"FileStatusInfo.RemotePrj"), "org/netbeans/modules/distributed/remotefs/resources/remoteProject.gif");
    public static final FileStatusInfo REMOTE_PRJ_GREY = new DefaultFileStatusInfo("RemotePrj", NbBundle.getMessage(FileStatusInfo.class, (String)"FileStatusInfo.RemotePrj"), "org/netbeans/modules/distributed/remotefs/resources/remoteProjectGrey.gif");
    private String status;

    public FileStatusInfo(String status) {
        this.status = status;
    }

    public final String getName() {
        return this.status;
    }

    public abstract String getDisplayName();

    public abstract Image getIcon();

    public boolean equals(Object obj) {
        if (!(obj instanceof FileStatusInfo)) {
            return false;
        }
        FileStatusInfo statusInfo = (FileStatusInfo)obj;
        return this.status.equals(statusInfo.status);
    }

    public boolean represents(FileStatusInfo info) {
        return this.equals(info);
    }

    private static final class DefaultFileStatusInfo
    extends FileStatusInfo {
        private String status;
        private String displayedStatus;
        private String iconResource;

        public DefaultFileStatusInfo(String status, String displayedStatus, String iconResource) {
            super(status);
            this.displayedStatus = displayedStatus;
            this.iconResource = iconResource;
        }

        public String getDisplayName() {
            return this.displayedStatus;
        }

        public Image getIcon() {
            return this.iconResource != null ? Utilities.loadImage((String)this.iconResource) : null;
        }
    }
}

