/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.common.util;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class SimpleMessageDialog
extends JDialog {
    private static final Object synchronizedObject = new Object();
    private static SimpleMessageDialog msgDialog;
    private Label label;
    private static AWTEventListener listener;

    public SimpleMessageDialog(Frame frame, boolean modal) {
        super(frame, modal);
        msgDialog = this;
        listener = new AWTEventListener(){

            public void eventDispatched(AWTEvent ae) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                msgDialog.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
    }

    private void myInitComponents(String title, String msg) {
        Dimension dim = this.getToolkit().getScreenSize();
        this.setTitle(title);
        this.setBounds(dim.width / 2 - msg.length(), dim.height / 2 - 100, dim.width / 2 + msg.length() * 2, dim.height / 2 + 100);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                e.getWindow().setVisible(false);
                e.getWindow().dispose();
                Toolkit.getDefaultToolkit().removeAWTEventListener(listener);
                msgDialog.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        this.setLayout(new BorderLayout());
        this.label = new Label(msg);
        this.label.setAlignment(1);
        this.add((Component)this.label, "Center");
        this.pack();
    }

    public static synchronized void showMessage(final boolean modal, final String title, final String msg) {
        try {
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = synchronizedObject;
                    synchronized (object) {
                        if (msgDialog == null) {
                            Frame frame = WindowManager.getDefault().getMainWindow();
                            msgDialog = new SimpleMessageDialog(frame, modal);
                        }
                        msgDialog.myInitComponents(title, msg);
                        msgDialog.pack();
                        msgDialog.setVisible(true);
                        msgDialog.setCursor(Cursor.getPredefinedCursor(3));
                        Toolkit.getDefaultToolkit().addAWTEventListener(listener, 1L);
                    }
                }
            });
        }
        catch (Exception e) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 0));
        }
    }

    public void closeDialog() {
        if (msgDialog == null) {
            return;
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(listener);
        msgDialog.setCursor(Cursor.getPredefinedCursor(0));
        msgDialog.setVisible(false);
        msgDialog.dispose();
        msgDialog = null;
    }
}

