/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.fortransupport.fortran;

import com.hp.openvms.netbeans.baseclasses.compiler.AlphaVMSCompilerGroup;
import com.hp.openvms.netbeans.fortransupport.fortran.FortranCompiler;
import com.hp.openvms.netbeans.fortransupport.fortran.FortranCompilerType;
import com.hp.openvms.netbeans.fortransupport.fortran.datasys.FortranCompilerSupport;
import com.hp.openvms.netbeans.utils.FileUtilityLang;
import com.hp.openvms.netbeans.utils.OrderedMap;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openide.compiler.Compiler;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.MapFormat;
import org.openide.util.Utilities;

public class FortranCompilerGroup
extends AlphaVMSCompilerGroup {
    private FortranCompilerType compilerSvcType = null;
    protected boolean isRemote = false;

    public boolean getIsRemote() {
        return this.isRemote;
    }

    public void add(Compiler c) throws IllegalArgumentException {
        super.add(c);
        this.compilerSvcType = ((FortranCompiler)c).getCompilerSvcType();
        this.isRemote = ((FortranCompiler)c).isRemote();
    }

    public void makeAbstract() {
    }

    public static class FortranFormat
    extends MapFormat {
        public static final String TAG_OPTIMIZE = "optimize";
        public static final String TAG_BUILD_DIRECTORY = "buildDirectory";
        public static final String TAG_F77 = "f77";
        public static final String TAG_OBJECT_DIRECTORY = "objectDirectory";
        public static final String TAG_ANALYSIS_DATA = "analysisData";
        public static final String TAG_INCLUDE = "include";
        public static final String TAG_LIBRARY = "library";
        public static final String TAG_DEBUG = "debug";
        public static final String TAG_INTEGER_SIZE = "integerSize";
        public static final String TAG_FLOAT = "float";
        public static final String TAG_MODULE = "module";
        public static final String TAG_OTHER_OPTIONS = "otherOptions";
        public static final String TAG_SOURCE_FORM = "Source Form";
        public static final String TAG_EXTEND_SOURCE = "Extend Source";
        public static final String TAG_FILE = "file";
        public static final String TAG_MAKEFILE = "command file";
        public static final String TAG_GLOBAL_QUALIFIER = "Global Qualifiers";
        public static final String TAG_LOCAL_QUALIFIER = "Local Qualifiers";
        public static final String TAG_FILENAME = "file name";
        public static final String TAG_EXT = "file extension";
        public static final String TAG_DEVICE = "device";
        public static final String TAG_DIRECTORY = "directory";
        String[] FortranCmds;
        private boolean useDECterm = false;
        private boolean isRemote;

        public FortranFormat(boolean isRemote) {
            super(new HashMap(7));
            this.isRemote = isRemote;
        }

        public FortranFormat(DataObject[] files, String[] fnames, boolean isRemote) {
            super(new HashMap(7));
            this.isRemote = isRemote;
            this.composeCmds(files, fnames);
        }

        private void fillMap(FortranCompilerSupport fortranSupport, String vmsPath, String unixPath, DataObject dobj) {
            Map map = this.getMap();
            map.put(TAG_SOURCE_FORM, fortranSupport.getSourceForm().toUpperCase().equals("FIXED") ? "/SOURCE_FORM=FIXED" : "/SOURCE_FORM=FREE");
            map.put(TAG_EXTEND_SOURCE, fortranSupport.getExtendSource().equals(Boolean.TRUE) && fortranSupport.getSourceForm().toUpperCase().equals("FIXED") ? "/EXTEND_SOURCE" : "");
            String makefileString = fortranSupport.getMakefileCompiler() == null ? "" : fortranSupport.getMakefileCompiler().getAbsolutePath();
            if (makefileString != null && makefileString.length() > 0) {
                makefileString = this.isRemote ? FileUtilityLang.unixPathToOpenVMSPath(makefileString, false) : FileUtilityLang.unixPathToOpenVMSPath(makefileString, false);
            }
            String ext = dobj.getPrimaryFile().getExt();
            map.put(TAG_EXT, ext);
            String fname = vmsPath.substring(0, vmsPath.length() - ext.length());
            if (fname.endsWith(".")) {
                fname = fname.substring(0, fname.length() - 1);
            }
            map.put(TAG_FILENAME, fname);
            map.put(TAG_DEVICE, vmsPath.substring(0, vmsPath.indexOf(":")));
            map.put(TAG_DIRECTORY, vmsPath.substring(0, vmsPath.length() - dobj.getPrimaryFile().getNameExt().length()));
            map.put(TAG_FILE, vmsPath);
            map.put(TAG_MAKEFILE, makefileString);
            map.put(TAG_GLOBAL_QUALIFIER, fortranSupport.getGlobalQualifier());
            map.put(TAG_LOCAL_QUALIFIER, fortranSupport.getLocalQualifier());
        }

        private String calculateObjectDir(String buildDir, DataObject dobj, String filePath) {
            String buildDirectory = buildDir.trim();
            FileObject fobj = dobj.getPrimaryFile();
            if ((buildDirectory.equals("") || buildDirectory.equals(".")) && filePath != null && !filePath.equals("")) {
                if (this.isRemote && Utilities.isWindows()) {
                    String curDir = (String)fobj.getAttribute("REMOTE_FILEPATH");
                    if (curDir == null || curDir.length() == 0) {
                        File pfile = FileUtil.toFile((FileObject)fobj.getParent());
                        return FileUtilityLang._winPathToOpenVMSPath(pfile.getAbsolutePath(), true, fobj.getParent());
                    }
                } else if (this.isRemote) {
                    String curDir = (String)fobj.getAttribute("REMOTE_FILEPATH");
                    if (curDir == null || curDir.length() == 0) {
                        File pfile = FileUtil.toFile((FileObject)fobj.getParent());
                        return FileUtilityLang.unixPathToOpenVMSPath(pfile.getAbsolutePath(), true, fobj.getParent());
                    }
                } else {
                    int slashIndex = filePath.lastIndexOf(47);
                    if (slashIndex > 0) {
                        return FileUtilityLang.unixPathToOpenVMSPath(filePath.substring(0, slashIndex), true);
                    }
                }
            } else if (this.isRemote) {
                if (buildDirectory.startsWith("/")) {
                    buildDirectory = FileUtilityLang.unixPathToOpenVMSPath(buildDirectory, true);
                }
            } else {
                buildDirectory = FileUtilityLang.unixPathToOpenVMSPath(buildDirectory, true);
            }
            return buildDirectory;
        }

        private String createArguments(String arguments) {
            return this.format(arguments);
        }

        private String createProcessName(String procNameString) {
            String procName = this.format(procNameString);
            if (procName.indexOf(47) >= 0) {
                if (procName.charAt(0) == '@') {
                    procName = procName.substring(1);
                    procName = "@" + FileUtilityLang.unixPathToOpenVMSPath(procName, false);
                } else {
                    procName = FileUtilityLang.unixPathToOpenVMSPath(procName, false);
                }
            }
            return procName;
        }

        private String createDCLProcessName(String procNameString) {
            String procName = this.format(procNameString);
            return procName;
        }

        protected void composeCmds(DataObject[] files, String[] fnames) {
            OrderedMap oMap = new OrderedMap();
            for (int i = 0; i < files.length; ++i) {
                boolean useMakefile = false;
                FileObject fobj = files[i].getPrimaryFile();
                File file = FileUtil.toFile((FileObject)fobj);
                String filePath = this.isRemote ? (Utilities.getOperatingSystem() == 16384 || Utilities.isUnix() ? FileUtilityLang.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fobj) : FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, fobj)) : fnames[i];
                Node.Cookie cookie = files[i].getCookie(FortranCompilerSupport.class);
                if (cookie == null && (cookie = files[i].getCookie(FortranCompilerSupport.class)) == null) continue;
                FortranCompilerSupport fortranSupport = (FortranCompilerSupport)cookie;
                NbProcessDescriptor desc = null;
                if (fortranSupport.getBuildOption().equals(Boolean.TRUE)) {
                    desc = new NbProcessDescriptor(fortranSupport.getBuildCommand(), "");
                    useMakefile = true;
                } else {
                    desc = fortranSupport.getExternalCompiler();
                }
                this.fillMap(fortranSupport, filePath, fnames[i], files[i]);
                String procName = useMakefile ? this.createDCLProcessName(desc.getProcessName()) : this.createProcessName(desc.getProcessName());
                String arguments = this.createArguments(desc.getArguments());
                String cmdLine = procName + " " + arguments;
                cmdLine = cmdLine.trim();
                if (cmdLine.length() == 0) continue;
                String buildDirectory = null;
                buildDirectory = this.calculateObjectDir(fortranSupport.getBuildDirectory() == null ? "" : fortranSupport.getBuildDirectory().getAbsolutePath(), files[i], fnames[i]);
                oMap.put(cmdLine, buildDirectory);
            }
            Iterator itr = oMap.iterator();
            this.FortranCmds = new String[oMap.size() * 2];
            int i = 0;
            while (itr.hasNext()) {
                OrderedMap.Pair mapEntry = (OrderedMap.Pair)itr.next();
                String key = (String)mapEntry.getKey();
                if (mapEntry.getValue() != null) {
                    this.FortranCmds[i++] = "set default " + mapEntry.getValue();
                    this.FortranCmds[i] = key;
                } else {
                    this.FortranCmds[i] = (String)mapEntry.getKey();
                }
                ++i;
            }
        }

        public String[] getCmds() {
            return this.FortranCmds;
        }
    }
}

