/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.model;

import com.hp.openvms.netbeans.debugsupport.debugger.Field;
import com.hp.openvms.netbeans.debugsupport.debugger.LocalVariable;
import com.hp.openvms.netbeans.debugsupport.debugger.RemoteDebugger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class VariablesNodeModel
implements NodeModel {
    public static final String FIELD = "org/netbeans/modules/debugger/resources/watchesView/Field";
    public static final String LOCAL = "org/netbeans/modules/debugger/resources/localsView/LocalVariable";
    public static final String STATIC_FIELD = "org/netbeans/modules/debugger/resources/watchesView/StaticField";
    public static final String SUPER = "org/netbeans/modules/debugger/resources/watchesView/SuperVariable";
    private RemoteDebugger debugger;
    private ContextProvider lookupProvider;
    private RequestProcessor evaluationRP = new RequestProcessor();
    private final Collection modelListeners = new HashSet();
    private Map shortDescriptionMap = new HashMap();

    public VariablesNodeModel(ContextProvider lookupProvider) {
        this.lookupProvider = lookupProvider;
        this.debugger = (RemoteDebugger)lookupProvider.lookupFirst(null, RemoteDebugger.class);
    }

    public String getDisplayName(Object o) throws UnknownTypeException {
        if (o == "Root") {
            return NbBundle.getBundle(VariablesNodeModel.class).getString("CTL_LocalsModel_Column_Name_Name");
        }
        if (o instanceof Field) {
            return ((Field)o).getName();
        }
        if (o instanceof LocalVariable) {
            return ((LocalVariable)o).getName();
        }
        if (o == "NoInfo") {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"CTL_No_Info");
        }
        if (o == "No current thread") {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"NoCurrentThreadVar");
        }
        String str = o.toString();
        if (str.startsWith("SubArray")) {
            int index = str.indexOf(45);
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"CTL_LocalsModel_Column_Name_SubArray", (Object)str.substring(8, index), (Object)str.substring(index + 1));
        }
        throw new UnknownTypeException(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShortDescription(final Object o) throws UnknownTypeException {
        Map map = this.shortDescriptionMap;
        synchronized (map) {
            Object shortDescription = this.shortDescriptionMap.remove(o);
            if (shortDescription instanceof String) {
                return (String)shortDescription;
            }
            if (shortDescription instanceof UnknownTypeException) {
                throw (UnknownTypeException)shortDescription;
            }
        }
        this.testKnown(o);
        this.evaluationRP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String shortDescription = VariablesNodeModel.this.getShortDescriptionSynch(o);
                if (shortDescription != null && !"".equals(shortDescription)) {
                    Map map = VariablesNodeModel.this.shortDescriptionMap;
                    synchronized (map) {
                        VariablesNodeModel.this.shortDescriptionMap.put(o, shortDescription);
                    }
                    VariablesNodeModel.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)VariablesNodeModel.this, o, 4));
                }
            }
        });
        return "";
    }

    private String getShortDescriptionSynch(Object o) {
        if (o == "Root") {
            return NbBundle.getBundle(VariablesNodeModel.class).getString("CTL_LocalsModel_Column_Name_Desc");
        }
        if (o instanceof LocalVariable) {
            return "(" + ((LocalVariable)o).getDeclaredType() + ") " + ((LocalVariable)o).getValue();
        }
        String str = o.toString();
        if (str.startsWith("SubArray")) {
            int index = str.indexOf(45);
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"CTL_LocalsModel_Column_Descr_SubArray", (Object)str.substring(8, index), (Object)str.substring(index + 1));
        }
        if (o == "NoInfo") {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"CTL_No_Info_descr");
        }
        if (o == "No current thread") {
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"NoCurrentThreadVar");
        }
        return "";
    }

    private void testKnown(Object o) throws UnknownTypeException {
        if (o == "Root") {
            return;
        }
        if (o instanceof Field) {
            return;
        }
        if (o instanceof LocalVariable) {
            return;
        }
        String str = o.toString();
        if (str.startsWith("SubArray")) {
            return;
        }
        if (o == "NoInfo") {
            return;
        }
        if (o == "No current thread") {
            return;
        }
        throw new UnknownTypeException(o);
    }

    public String getIconBase(Object o) throws UnknownTypeException {
        if (o == "Root") {
            return FIELD;
        }
        if (o instanceof Field) {
            if (((Field)o).isStatic()) {
                return STATIC_FIELD;
            }
            return FIELD;
        }
        if (o instanceof LocalVariable) {
            return LOCAL;
        }
        if (o.toString().startsWith("SubArray")) {
            return LOCAL;
        }
        if (o == "NoInfo" || o == "No current thread") {
            return null;
        }
        throw new UnknownTypeException(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener l) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener l) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelChange(ModelEvent me) {
        Object[] listeners;
        Collection collection = this.modelListeners;
        synchronized (collection) {
            listeners = this.modelListeners.toArray();
        }
        for (int i = 0; i < listeners.length; ++i) {
            ((ModelListener)listeners[i]).modelChanged(me);
        }
    }
}

