/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.breakpoints;

import com.hp.openvms.netbeans.debugsupport.breakpoints.BreakpointAnnotationListener;
import com.hp.openvms.netbeans.debugsupport.breakpoints.LineBreakpoint;
import com.hp.openvms.netbeans.debugsupport.breakpoints.RemoteBreakpoint;
import com.hp.openvms.netbeans.debugsupport.debugger.EditorContextBridge;
import com.hp.openvms.netbeans.debugsupport.debugger.RemoteDebugger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.NbBundle;

public class RemoteBreakpointActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private RemoteDebugger debugger;
    private BreakpointAnnotationListener breakpointAnnotationListener;

    public RemoteBreakpointActionProvider() {
        EditorContextBridge.getContext().addPropertyChangeListener(this);
    }

    public RemoteBreakpointActionProvider(ContextProvider lookupProvider) {
        this.debugger = (RemoteDebugger)lookupProvider.lookupFirst(null, RemoteDebugger.class);
        EditorContextBridge.getContext().addPropertyChangeListener(this);
    }

    public void doAction(Object o) {
        DebuggerManager d = DebuggerManager.getDebuggerManager();
        int ln = EditorContextBridge.getContext().getCurrentLineNumber();
        String url = EditorContextBridge.getContext().getCurrentURL();
        if (url.trim().equals("")) {
            return;
        }
        RemoteBreakpoint lb = this.getBreakpointAnnotationListener().findBreakpoint(url, ln);
        if (lb != null) {
            d.removeBreakpoint((Breakpoint)lb);
            return;
        }
        lb = LineBreakpoint.create(url, ln);
        lb.setPrintText(NbBundle.getBundle(RemoteBreakpointActionProvider.class).getString("CTL_Line_Breakpoint_Print_Text"));
        d.addBreakpoint((Breakpoint)lb);
    }

    private BreakpointAnnotationListener getBreakpointAnnotationListener() {
        if (this.breakpointAnnotationListener == null) {
            this.breakpointAnnotationListener = (BreakpointAnnotationListener)((Object)DebuggerManager.getDebuggerManager().lookupFirst(null, BreakpointAnnotationListener.class));
        }
        return this.breakpointAnnotationListener;
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        int lnum = EditorContextBridge.getContext().getCurrentLineNumber();
        String mimeType = EditorContextBridge.getContext().getCurrentMIMEType();
        boolean isValid = mimeType.startsWith("text/x-hp+openvms");
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, isValid);
    }
}

