/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.cppsupport.prop;

import com.hp.openvms.netbeans.cppsupport.prop.DefaultPropertyModel;
import com.hp.openvms.netbeans.cppsupport.prop.ExPropertyEditor;
import com.hp.openvms.netbeans.cppsupport.prop.ExPropertyModel;
import com.hp.openvms.netbeans.cppsupport.prop.IndexedPropertyEditor;
import com.hp.openvms.netbeans.cppsupport.prop.NamesPanel;
import com.hp.openvms.netbeans.cppsupport.prop.PropertyDialogManager;
import com.hp.openvms.netbeans.cppsupport.prop.PropertyEnv;
import com.hp.openvms.netbeans.cppsupport.prop.PropertyModel;
import com.hp.openvms.netbeans.cppsupport.prop.PropertySheetSettings;
import com.hp.openvms.netbeans.cppsupport.prop.PropertyShow;
import com.hp.openvms.netbeans.cppsupport.prop.ProxyNode;
import com.hp.openvms.netbeans.cppsupport.prop.SheetButton;
import com.hp.openvms.netbeans.cppsupport.prop.SheetButtonListener;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.WeakHashMap;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.Document;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.explorer.propertysheet.editors.EnhancedPropertyEditor;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class PropertyPanel
extends JComponent
implements Accessible {
    public static final int PREF_READ_ONLY = 1;
    public static final int PREF_CUSTOM_EDITOR = 2;
    public static final int PREF_INPUT_STATE = 4;
    public static final String PROP_PREFERENCES = "preferences";
    public static final String PROP_MODEL = "model";
    public static final String PROP_PROPERTY_EDITOR = "propertyEditor";
    public static final String PROP_STATE = "state";
    private static final String PROP_CAN_EDIT_AS_TEXT = "canEditAsText";
    private static final PropertyModel EMPTY_MODEL = new EmptyModel();
    private int preferences;
    private PropertyModel model;
    private PropertyEditor editor;
    private PropertyEnv env;
    private FeatureDescriptor descriptor = new FeatureDescriptor();
    private int paintingStyle;
    private Color foregroundColor;
    private Color disabledColor;
    private boolean plastic;
    static ThreadLocal current = new ThreadLocal();
    private boolean canWrite = true;
    private boolean canRead = true;
    private SheetButton readComponent;
    private SheetButton textView;
    private PropertyShow propertyShow;
    private SheetButton paintView;
    private SheetButton customizeButton;
    private boolean isReadState;
    private boolean isWriteState;
    private boolean ignoreEvents;
    private boolean customDialogShown;
    private boolean differentValues;
    private JTextField textField;
    private JComboBox comboBox;
    private ReadComponentListener readComponentListener;
    private WriteComponentListener writeComponentListener;
    private PropertyChangeListener modelListener;
    private PropertyChangeListener editorListener;
    private PropertyChangeListener weakEditorListener;
    private SheetButtonListener sheetButtonListener;
    private VetoableChangeListener envListener;
    private static final WeakHashMap envCache = new WeakHashMap();
    private boolean changeImmediate = true;

    public PropertyPanel() {
        this(EMPTY_MODEL, 0);
    }

    public PropertyPanel(Object bean, String propertyName, int preferences) {
        this(new DefaultPropertyModel(bean, propertyName), preferences);
    }

    public PropertyPanel(PropertyModel model, int preferences) {
        this.model = model;
        this.preferences = preferences;
        this.setLayout(new BorderLayout());
        boolean problem = false;
        try {
            Class<?> c = Class.forName("org.openide.explorer.propertysheet.PropertyPanel$PropertySheetSettingsInvoker");
            Runnable r = (Runnable)c.newInstance();
            current.set(this);
            r.run();
        }
        catch (Exception e) {
            problem = true;
        }
        catch (LinkageError e) {
            problem = true;
        }
        if (problem) {
            this.paintingStyle = 3;
            this.plastic = false;
            this.disabledColor = UIManager.getColor("textInactiveText");
            this.foregroundColor = new Color(0, 0, 128);
        }
        model.addPropertyChangeListener(this.getModelListener());
        this.updateEditor();
        this.reset();
    }

    PropertyPanel(Node.Property p, Object[] beans) {
        this(new SimpleModel(p, beans), 0);
    }

    public int getPreferences() {
        return this.preferences;
    }

    public void setPreferences(int preferences) {
        int oldPreferences = this.preferences;
        this.preferences = preferences;
        this.readComponent = null;
        this.reset();
        this.firePropertyChange(PROP_PREFERENCES, new Integer(oldPreferences), new Integer(preferences));
    }

    public PropertyModel getModel() {
        return this.model;
    }

    public void setModel(PropertyModel model) {
        PropertyModel oldModel = this.model;
        this.model = model;
        oldModel.removePropertyChangeListener(this.getModelListener());
        model.addPropertyChangeListener(this.getModelListener());
        this.updateEditor();
        this.reset();
        this.firePropertyChange(PROP_MODEL, oldModel, model);
    }

    public final Object getState() {
        PropertyEnv e = this.env;
        return e == null ? PropertyEnv.STATE_VALID : e.getState();
    }

    public void updateValue() {
        Component customEditor;
        if (this.editor == null) {
            return;
        }
        PropertyEnv e = this.env;
        if (e != null && e.getState() == PropertyEnv.STATE_NEEDS_VALIDATION) {
            e.setState(PropertyEnv.STATE_VALID);
        }
        if (this.editor.supportsCustomEditor() && (customEditor = this.editor.getCustomEditor()) instanceof EnhancedCustomPropertyEditor) {
            try {
                Object value = ((EnhancedCustomPropertyEditor)customEditor).getPropertyValue();
                this.editor.setValue(value);
            }
            catch (IllegalStateException ise) {
                PropertyDialogManager.notify(ise);
            }
        }
    }

    public PropertyEditor getPropertyEditor() {
        return this.editor;
    }

    public void setEnabled(boolean enabled) {
        Component[] comp = this.getComponents();
        if (comp != null) {
            for (int i = 0; i < comp.length; ++i) {
                this.setComponentEnabled(comp[i], enabled);
            }
        }
        super.setEnabled(enabled);
    }

    public boolean isChangeImmediate() {
        return this.changeImmediate;
    }

    public void setChangeImmediate(boolean changeImmediate) {
        if (this.changeImmediate == changeImmediate) {
            return;
        }
        this.changeImmediate = changeImmediate;
        if (this.env != null) {
            this.env.setChangeImmediate(changeImmediate);
        }
        this.firePropertyChange("changeImmediate", changeImmediate ? Boolean.FALSE : Boolean.TRUE, changeImmediate ? Boolean.TRUE : Boolean.FALSE);
    }

    SheetButton getReadComponent() {
        return this.readComponent;
    }

    void setWriteState() {
        if (this.isWriteState) {
            return;
        }
        if ((this.preferences & 1) != 0) {
            return;
        }
        if ((this.preferences & 2) != 0) {
            return;
        }
        this.isReadState = false;
        this.isWriteState = false;
        this.removeAll();
        JComponent c = this.getWriterComponent();
        c.setToolTipText(this.getPanelToolTipText());
        this.add((Component)c, "Center");
        this.updateNeighbourPanels();
        this.revalidate();
        this.repaint();
        Component focused = PropertyPanel.getDefaultFocusComponent(c);
        if (focused != null) {
            WriteComponentListener l = this.getWriteComponentListener();
            focused.requestFocus();
            focused.removeFocusListener(l);
            focused.removeKeyListener(l);
            focused.addFocusListener(l);
            focused.addKeyListener(l);
        }
        this.isReadState = false;
        this.isWriteState = true;
    }

    private static Component getDefaultFocusComponent(JComponent container) {
        Component[] ca = container.getComponents();
        for (int i = 0; i < ca.length; ++i) {
            Component res;
            if (ca[i].isFocusTraversable()) {
                return ca[i];
            }
            if (!(ca[i] instanceof JComponent) || ((JComponent)ca[i]).isManagingFocus() || (res = PropertyPanel.getDefaultFocusComponent((JComponent)ca[i])) == null) continue;
            return res;
        }
        return null;
    }

    void setPlastic(boolean plastic) {
        this.plastic = plastic;
        this.reset();
    }

    boolean getPlastic() {
        return this.plastic;
    }

    void setForegroundColor(Color color) {
        this.foregroundColor = color;
        this.reset();
    }

    void setDisabledColor(Color color) {
        this.disabledColor = color;
        this.reset();
    }

    void setPaintingStyle(int style) {
        this.paintingStyle = style;
        this.reset();
    }

    void addSheetButtonListener(SheetButtonListener list) {
        this.sheetButtonListener = list;
        if (this.readComponent != null) {
            this.readComponent.addSheetButtonListener(list);
        }
    }

    boolean isWriteState() {
        return this.isWriteState;
    }

    private void updateNeighbourPanels() {
        Container c;
        for (c = this.getParent(); c != null && !(c instanceof NamesPanel); c = c.getParent()) {
        }
        if (c instanceof NamesPanel) {
            NamesPanel np = (NamesPanel)c;
            np.reset();
        }
    }

    private void updateEditor() {
        Class propertyTypeClass;
        Class editorClass;
        if (this.model == EMPTY_MODEL) {
            return;
        }
        PropertyEditor oldEditor = this.editor;
        if (this.editor != null) {
            this.editor.removePropertyChangeListener(this.getEditorListener());
        }
        this.editor = null;
        if (this.env != null) {
            this.env.removePropertyChangeListener(this.getEditorListener());
        }
        this.env = null;
        if (this.model instanceof ExPropertyModel) {
            this.descriptor = ((ExPropertyModel)this.model).getFeatureDescriptor();
            if (this.descriptor instanceof Node.Property) {
                this.canWrite = ((Node.Property)this.descriptor).canWrite();
                this.canRead = ((Node.Property)this.descriptor).canRead();
                this.editor = ((Node.Property)this.descriptor).getPropertyEditor();
                if (this.editor == null && this.descriptor instanceof Node.IndexedProperty) {
                    this.editor = new IndexedPropertyEditor();
                    this.descriptor.setValue("changeImmediate", Boolean.FALSE);
                }
            }
        }
        if (this.editor == null && (editorClass = this.model.getPropertyEditorClass()) != null) {
            try {
                Constructor c = editorClass.getConstructor(new Class[0]);
                c.setAccessible(true);
                this.editor = (PropertyEditor)c.newInstance(new Object[0]);
            }
            catch (Exception e) {
                PropertyDialogManager.notify(e);
            }
        }
        if (this.editor == null && (propertyTypeClass = this.model.getPropertyType()) != null) {
            this.editor = PropertyEditorManager.findEditor(propertyTypeClass);
        }
        if (this.editor != null) {
            if (this.editor instanceof ExPropertyEditor) {
                Reference ref = (Reference)envCache.get(this.editor);
                if (ref != null) {
                    this.env = (PropertyEnv)ref.get();
                }
                if (this.env == null) {
                    this.env = new PropertyEnv();
                    envCache.put(this.editor, new WeakReference<PropertyEnv>(this.env));
                }
                this.setChangeImmediate(true);
                if (this.model instanceof ExPropertyModel) {
                    ExPropertyModel epm = (ExPropertyModel)this.model;
                    this.env.setFeatureDescriptor(epm.getFeatureDescriptor());
                    this.env.setBeans(epm.getBeans());
                }
                this.envListener = new VetoableChangeListener(){

                    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                        PropertyPanel.this.refresh();
                    }
                };
                this.env.addVetoableChangeListener(WeakListeners.vetoableChange((VetoableChangeListener)this.envListener, (Object)this.env));
                this.env.addPropertyChangeListener(this.getEditorListener());
                ((ExPropertyEditor)this.editor).attachEnv(this.env);
            }
            try {
                if (this.canRead) {
                    this.editor.setValue(this.model.getValue());
                }
            }
            catch (ProxyNode.DifferentValuesException dve) {
                this.differentValues = true;
            }
            catch (Exception e) {
                this.processThrowable(e);
            }
            if (this.canWrite) {
                this.editor.addPropertyChangeListener(this.getEditorListener());
            }
        }
        this.firePropertyChange(PROP_PROPERTY_EDITOR, oldEditor, this.editor);
    }

    private void reset() {
        Component c;
        this.isWriteState = false;
        this.isReadState = false;
        if ((this.preferences & 4) != 0) {
            this.setWriteState();
            return;
        }
        if ((this.preferences & 2) != 0 && this.editor != null && (c = this.editor.getCustomEditor()) != null && c.getParent() != this) {
            this.removeAll();
            this.add(c, "Center");
            this.validate();
            return;
        }
        this.setReadState();
    }

    void refresh() {
        if (this.customDialogShown) {
            return;
        }
        if (this.isReadState) {
            // empty if block
        }
        if (this.isWriteState && (this.preferences & 4) == 0) {
            return;
        }
        this.reset();
    }

    void setReadState() {
        if (this.isReadState) {
            return;
        }
        if ((this.preferences & 4) != 0) {
            return;
        }
        if ((this.preferences & 2) != 0) {
            return;
        }
        this.isWriteState = false;
        this.isReadState = false;
        this.removeAll();
        this.readComponent = this.getReaderComponent();
        this.readComponent.addSheetButtonListener(this.getReadComponentListener());
        this.setComponentEnabled(this.readComponent, this.isEnabled());
        this.readComponent.setToolTipText(this.getPanelToolTipText());
        this.updateSheetButtonVisually();
        this.add((Component)this.readComponent, "Center");
        this.revalidate();
        this.repaint();
        this.isReadState = true;
        this.isWriteState = false;
    }

    private ReadComponentListener getReadComponentListener() {
        if (this.readComponentListener == null) {
            this.readComponentListener = new ReadComponentListener();
        }
        return this.readComponentListener;
    }

    private WriteComponentListener getWriteComponentListener() {
        if (this.writeComponentListener == null) {
            this.writeComponentListener = new WriteComponentListener();
        }
        return this.writeComponentListener;
    }

    private PropertyChangeListener getModelListener() {
        if (this.modelListener == null) {
            this.modelListener = new ModelListener();
        }
        return this.modelListener;
    }

    private PropertyChangeListener getEditorListener() {
        if (this.editorListener == null) {
            this.editorListener = new EditorListener();
            this.weakEditorListener = WeakListeners.propertyChange((PropertyChangeListener)this.editorListener, (Object)this.editor);
        }
        return this.weakEditorListener;
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.updateSheetButtonVisually();
    }

    private SheetButton getReaderComponent() {
        String stringValue = null;
        SheetButton c = null;
        if (this.editor == null) {
            return this.getTextView(NbBundle.getMessage(PropertyPanel.class, (String)"CTL_No_property_editor"));
        }
        try {
            if (!this.differentValues && this.canRead) {
                stringValue = this.editor.getAsText();
            }
            c = this.editor.isPaintable() && (this.paintingStyle == 3 || this.paintingStyle == 2 && stringValue == null) ? (this.differentValues ? this.getTextView(NbBundle.getMessage(PropertyPanel.class, (String)"CTL_Different_Values")) : this.getPaintView()) : (stringValue == null ? (this.differentValues ? this.getTextView(NbBundle.getMessage(PropertyPanel.class, (String)"CTL_Different_Values")) : this.getTextView(this.getTypeString(this.model.getPropertyType()))) : this.getTextView(stringValue));
        }
        catch (Exception e) {
            ErrorManager.getDefault().annotate((Throwable)e, PropertyPanel.getString("PS_ExcIn") + " " + this.editor.getClass().getName() + " " + PropertyPanel.getString("PS_Editor") + ".");
            c = this.getTextView(this.getExceptionString(e));
        }
        if (c == null) {
            c = this.getTextView("null");
        }
        return c;
    }

    private SheetButton getTextView(String str) {
        this.textView = new PropertySheetButton(str, this.plastic, this.plastic);
        this.textView.setFocusTraversable(true);
        if (this.sheetButtonListener != null) {
            this.textView.addSheetButtonListener(this.sheetButtonListener);
        }
        if (this.env != null && this.env.getState() != PropertyEnv.STATE_NEEDS_VALIDATION && !this.customDialogShown) {
            Node.Property np;
            this.textView.setInvalidMark(this.env.getState() == PropertyEnv.STATE_INVALID);
            if (this.descriptor instanceof Node.Property && (np = (Node.Property)this.descriptor).supportsDefaultValue()) {
                this.textView.setModifiedMark(!np.isDefaultValue());
            }
        }
        if (this.canWrite) {
            this.textView.setActiveForeground(this.foregroundColor);
        } else {
            this.textView.setActiveForeground(this.disabledColor);
        }
        return this.textView;
    }

    private SheetButton getPaintView() {
        if (this.propertyShow == null) {
            this.propertyShow = new PropertyShow(this.editor);
        } else {
            this.propertyShow.setEditor(this.editor);
        }
        if (this.paintView == null) {
            this.paintView = new PropertySheetButton();
            this.paintView.add(this.propertyShow);
        }
        if (this.sheetButtonListener != null) {
            this.paintView.addSheetButtonListener(this.sheetButtonListener);
        }
        this.paintView.setLabel(this.editor.getAsText());
        this.paintView.setFocusTraversable(true);
        if (this.canWrite) {
            this.paintView.setActiveForeground(this.foregroundColor);
            this.propertyShow.setForeground(this.foregroundColor);
        } else {
            this.paintView.setActiveForeground(this.disabledColor);
            this.propertyShow.setForeground(this.disabledColor);
        }
        if (this.env != null && this.env.getState() != PropertyEnv.STATE_NEEDS_VALIDATION && !this.customDialogShown) {
            Node.Property np;
            this.paintView.setInvalidMark(this.env.getState() == PropertyEnv.STATE_INVALID);
            if (this.descriptor instanceof Node.Property && (np = (Node.Property)this.descriptor).supportsDefaultValue()) {
                this.paintView.setModifiedMark(!np.isDefaultValue());
            }
        }
        this.paintView.setPlastic(this.plastic);
        this.paintView.setToolTipText(this.getPanelToolTipText());
        return this.paintView;
    }

    private JComponent getWriterComponent() {
        Node.Property np;
        if (this.editor == null) {
            return this.getDisabledWriterComponent();
        }
        String stringValue = null;
        boolean canEditAsText = true;
        Object customEditAsText = this.descriptor.getValue(PROP_CAN_EDIT_AS_TEXT);
        if (customEditAsText instanceof Boolean) {
            canEditAsText = (Boolean)customEditAsText;
        }
        try {
            if (this.canRead) {
                stringValue = !this.differentValues ? this.editor.getAsText() : NbBundle.getMessage(PropertyPanel.class, (String)"CTL_Different_Values");
            }
        }
        catch (Exception x) {
            this.processThrowable(x);
        }
        if (stringValue == null && customEditAsText == null) {
            canEditAsText = false;
        }
        this.getWriteComponentListener().setOldValue(this.editor.getValue());
        boolean existsCustomEditor = this.editor.supportsCustomEditor();
        if (this.editor instanceof EnhancedPropertyEditor && ((EnhancedPropertyEditor)this.editor).hasInPlaceCustomEditor()) {
            return this.getInput(this.getInPlace(), existsCustomEditor);
        }
        if (this.descriptor instanceof Node.Property && !(np = (Node.Property)this.descriptor).canWrite()) {
            if (existsCustomEditor) {
                return this.getInput(this.getDisabledWriterComponent(), true);
            }
            return this.getDisabledWriterComponent();
        }
        boolean editable = this.editor instanceof EnhancedPropertyEditor && ((EnhancedPropertyEditor)this.editor).supportsEditingTaggedValues();
        String[] tags = this.editor.getTags();
        if (tags != null) {
            return this.getInput(this.getInputTag(tags, stringValue, editable), existsCustomEditor);
        }
        if (canEditAsText) {
            return this.getInput(this.getInputLine(stringValue == null ? "???" : stringValue, true), existsCustomEditor);
        }
        if (existsCustomEditor) {
            return this.getInput(this.getDisabledWriterComponent(), true);
        }
        return this.getDisabledWriterComponent();
    }

    private JComponent getDisabledWriterComponent() {
        SheetButton c = this.getReaderComponent();
        if (this.descriptor instanceof Node.Property && !((Node.Property)this.descriptor).canWrite()) {
            c.setActiveForeground(this.disabledColor);
        }
        c.addFocusListener(this.getWriteComponentListener());
        return c;
    }

    private JComponent getInputTag(String[] tags, String selected, boolean editable) {
        this.comboBox = new PropertyComboBox();
        this.comboBox.setModel(new DefaultComboBoxModel<String>(tags));
        this.comboBox.setMaximumRowCount(tags.length <= 12 ? tags.length : 8);
        if (selected != null) {
            for (int i = 0; i < tags.length; ++i) {
                if (!tags[i].equals(selected)) continue;
                this.comboBox.setSelectedIndex(i);
                break;
            }
        }
        if (editable) {
            this.comboBox.setEditable(true);
            this.comboBox.setSelectedItem(selected);
            this.comboBox.getEditor().setItem(selected);
            this.comboBox.getEditor().getEditorComponent().addFocusListener(this.getWriteComponentListener());
            this.comboBox.getEditor().getEditorComponent().addKeyListener(this.getWriteComponentListener());
        }
        this.comboBox.addActionListener(this.getWriteComponentListener());
        this.comboBox.setToolTipText(this.getPanelToolTipText());
        return this.comboBox;
    }

    void tryToSelectNextTag() {
        if (this.comboBox == null) {
            return;
        }
        this.setWriteState();
        int index = this.comboBox.getSelectedIndex();
        if (++index >= this.comboBox.getItemCount()) {
            index = 0;
        }
        this.comboBox.setSelectedIndex(index);
    }

    private Component getInPlace() {
        Component c = ((EnhancedPropertyEditor)this.editor).getInPlaceCustomEditor();
        c.addFocusListener(this.getWriteComponentListener());
        c.addKeyListener(this.getWriteComponentListener());
        if (c instanceof JComponent) {
            ((JComponent)c).setToolTipText(this.getPanelToolTipText());
        }
        return c;
    }

    private JComponent getInputLine(String propertyStringValue, boolean editable) {
        this.textField = new PropertyTextField();
        this.textField.addActionListener(this.getWriteComponentListener());
        this.textField.addKeyListener(this.getWriteComponentListener());
        this.textField.addFocusListener(this.getWriteComponentListener());
        this.textField.setText(propertyStringValue);
        this.textField.setEditable(editable);
        this.textField.setToolTipText(this.getPanelToolTipText());
        if (!this.isWriteState) {
            this.textField.selectAll();
        }
        return this.textField;
    }

    private String getExceptionString(Throwable exception) {
        if (exception instanceof InvocationTargetException) {
            exception = ((InvocationTargetException)exception).getTargetException();
        }
        return "<" + exception.getClass().getName() + ">";
    }

    private String getTypeString(Class clazz) {
        if (clazz == null) {
            return PropertyPanel.getString("CTL_NoPropertyEditor");
        }
        if (clazz.isArray()) {
            return "[" + PropertyPanel.getString("PS_ArrayOf") + " " + this.getTypeString(clazz.getComponentType()) + "]";
        }
        return "[" + clazz.getName() + "]";
    }

    private JComponent getInput(Component leftComponent, boolean existsCustomEditor) {
        JPanel panel = leftComponent == null && this.editor != null && this.editor.isPaintable() && this.paintingStyle != 1 ? new PropertyShow(this.editor) : new JPanel();
        panel.setLayout(new BorderLayout());
        if (leftComponent != null) {
            panel.add(leftComponent, "Center");
        }
        if (existsCustomEditor) {
            panel.add((Component)this.getCustomizeButton(), "East");
        }
        panel.setToolTipText(this.getPanelToolTipText());
        panel.addFocusListener(this.getWriteComponentListener());
        panel.addKeyListener(this.getWriteComponentListener());
        return panel;
    }

    private SheetButton getCustomizeButton() {
        if (this.customizeButton == null) {
            this.customizeButton = new SheetButton("...", this.plastic, this.plastic);
            this.customizeButton.setFocusTraversable(true);
            Font currentFont = this.customizeButton.getFont();
            this.customizeButton.setFont(new Font(currentFont.getName(), currentFont.getStyle() | 1, currentFont.getSize()));
            this.customizeButton.addFocusListener(this.getWriteComponentListener());
            this.customizeButton.addSheetButtonListener(new CustomizeListener());
            this.customizeButton.setToolTipText(PropertyPanel.getString("CTL_ElipsisHint"));
        }
        if (this.canWrite) {
            this.customizeButton.setActiveForeground(this.foregroundColor);
        } else {
            this.customizeButton.setActiveForeground(this.disabledColor);
        }
        return this.customizeButton;
    }

    private void notifyExceptionWhileSettingProperty(Exception iae) {
        if (this.getPreferences() == 0 || this.getPreferences() == 4) {
            PropertyPanel.notifyUser(iae, this.descriptor.getDisplayName());
        } else {
            ErrorManager.getDefault().notify(1, (Throwable)iae);
        }
    }

    static void notifyUser(Exception e, String propertyName) {
        String userMessage = PropertyPanel.extractLocalizedMessage(e);
        if (userMessage == null && e instanceof InvocationTargetException) {
            userMessage = PropertyPanel.extractLocalizedMessage(((InvocationTargetException)e).getTargetException());
        }
        ErrorManager em = ErrorManager.getDefault();
        if (userMessage != null) {
            em.annotate((Throwable)e, NbBundle.getMessage(PropertyPanel.class, (String)"FMT_ErrorSettingProperty", (Object)userMessage, (Object)propertyName));
            em.notify(256, (Throwable)e);
        } else {
            em.notify(1, (Throwable)e);
        }
    }

    private static String extractLocalizedMessage(Throwable t) {
        ErrorManager em = ErrorManager.getDefault();
        ErrorManager.Annotation[] an = em.findAnnotations(t);
        String message = null;
        if (an != null) {
            for (int i = 0; i < an.length; ++i) {
                String msg = an[i].getLocalizedMessage();
                if (msg == null) continue;
                message = msg;
                break;
            }
        }
        if (message == null) {
            message = t.getLocalizedMessage();
        }
        return message;
    }

    private void processThrowable(Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
        ErrorManager em = ErrorManager.getDefault();
        em.annotate(throwable, NbBundle.getMessage(PropertyPanel.class, (String)"FMT_ErrorSettingProperty", (Object)throwable.getLocalizedMessage(), (Object)this.descriptor.getDisplayName()));
        em.notify(throwable);
    }

    private void setComponentEnabled(Component cmp, boolean enabled) {
        cmp.setEnabled(enabled);
        if (Container.class.isAssignableFrom(cmp.getClass())) {
            Container cont = (Container)cmp;
            Component[] comp = cont.getComponents();
            for (int i = 0; i < comp.length; ++i) {
                comp[i].setEnabled(enabled);
                this.setComponentEnabled(comp[i], enabled);
            }
        }
    }

    private String getPanelToolTipText() {
        String toolTip = this.getToolTipText();
        if (toolTip != null) {
            return toolTip;
        }
        if (this.editor == null) {
            return null;
        }
        if (this.differentValues) {
            return NbBundle.getMessage(PropertyPanel.class, (String)"CTL_Desc_Different_Values");
        }
        if (this.canRead) {
            return this.editor.getAsText();
        }
        return null;
    }

    private void updateSheetButtonVisually() {
        boolean flat = false;
        Object f = this.getClientProperty("flat");
        if (f instanceof Boolean) {
            flat = (Boolean)f;
        }
        if (this.readComponent != null) {
            this.readComponent.setFlat(flat);
            this.readComponent.setBackground(this.getBackground());
        }
        if (this.propertyShow != null) {
            this.propertyShow.setBackground(this.getBackground());
        }
    }

    private static String getString(String key) {
        return NbBundle.getMessage(PropertyPanel.class, (String)key);
    }

    public void requestFocus() {
        this.requestDefaultFocus();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessiblePropertyPanel();
        }
        return this.accessibleContext;
    }

    private String getWriteComponentAccessibleName() {
        String name = this.getAccessibleContext().getAccessibleName();
        if (name == null) {
            return null;
        }
        return NbBundle.getMessage(PropertyPanel.class, (String)"ACS_PropertyPanelWriteComponent", (Object)name, (Object)(this.editor == null ? PropertyPanel.getString("CTL_No_value") : this.editor.getAsText()));
    }

    private String getWriteComponentAccessibleDescription() {
        String description = this.getAccessibleContext().getAccessibleDescription();
        if (description == null) {
            return null;
        }
        return NbBundle.getMessage(PropertyPanel.class, (String)"ACSD_PropertyPanelWriteComponent", (Object)description, (Object)this.getPanelToolTipText());
    }

    private class PropertySheetButton
    extends SheetButton {
        PropertySheetButton() {
        }

        PropertySheetButton(String aLabel, boolean isPlasticButton, boolean plasticActionNotify) {
            super(aLabel, isPlasticButton, plasticActionNotify);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessiblePropertySheetButton();
            }
            return this.accessibleContext;
        }

        private class AccessiblePropertySheetButton
        extends SheetButton.AccessibleSheetButton {
            AccessiblePropertySheetButton() {
                super(PropertySheetButton.this);
            }

            public String getAccessibleName() {
                return this.getReadComponentAccessibleName();
            }

            public String getAccessibleDescription() {
                return this.getReadComponentAccessibleDescription();
            }

            private String getReadComponentAccessibleName() {
                String name = PropertyPanel.this.getAccessibleContext().getAccessibleName();
                if (name == null) {
                    return null;
                }
                return NbBundle.getMessage(PropertyPanel.class, (String)"ACS_PropertyPanelReadComponent", (Object)name, (Object)super.getAccessibleName());
            }

            private String getReadComponentAccessibleDescription() {
                String description = PropertyPanel.this.getAccessibleContext().getAccessibleDescription();
                if (description == null) {
                    return null;
                }
                String beansList = null;
                int j = 0;
                if (PropertyPanel.this.model instanceof ExPropertyModel) {
                    Object[] beans = ((ExPropertyModel)PropertyPanel.this.model).getBeans();
                    String delimiter = PropertyPanel.getString("ACSD_BeanListDelimiter");
                    for (int i = 0; i < beans.length; ++i) {
                        if (!(beans[i] instanceof Node)) continue;
                        Node n = (Node)beans[i];
                        beansList = (beansList == null ? "" : beansList + delimiter) + n.getDisplayName();
                        ++j;
                    }
                }
                Class clazz = PropertyPanel.this.model.getPropertyType();
                return NbBundle.getMessage(PropertyPanel.class, (String)"ACSD_PropertyPanelReadComponent", (Object[])new Object[]{description, clazz == null ? PropertyPanel.getString("CTL_No_type") : clazz.getName(), new Integer(j), beansList});
            }
        }
    }

    private class PropertyComboBox
    extends JComboBox {
        PropertyComboBox() {
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessiblePropertyComboBox();
            }
            return this.accessibleContext;
        }

        private class AccessiblePropertyComboBox
        extends JComboBox.AccessibleJComboBox {
            AccessiblePropertyComboBox() {
                super(PropertyComboBox.this);
            }

            public String getAccessibleName() {
                return PropertyPanel.this.getWriteComponentAccessibleName();
            }

            public String getAccessibleDescription() {
                return PropertyPanel.this.getWriteComponentAccessibleDescription();
            }
        }
    }

    private class PropertyTextField
    extends JTextField {
        PropertyTextField() {
        }

        public void setDocument(Document doc) {
            super.setDocument(doc);
            if (doc != null) {
                doc.putProperty("filterNewlines", null);
            }
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessiblePropertyTextField();
            }
            return this.accessibleContext;
        }

        private class AccessiblePropertyTextField
        extends JTextField.AccessibleJTextField {
            private AccessiblePropertyTextField() {
                super(PropertyTextField.this);
            }

            public String getAccessibleName() {
                return PropertyPanel.this.getWriteComponentAccessibleName();
            }

            public String getAccessibleDescription() {
                return PropertyPanel.this.getWriteComponentAccessibleDescription();
            }
        }
    }

    private class AccessiblePropertyPanel
    extends JComponent.AccessibleJComponent {
        AccessiblePropertyPanel() {
            super(PropertyPanel.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }

        public String getAccessibleName() {
            String name = super.getAccessibleName();
            if (name == null && PropertyPanel.this.model instanceof ExPropertyModel) {
                FeatureDescriptor fd = ((ExPropertyModel)PropertyPanel.this.model).getFeatureDescriptor();
                name = NbBundle.getMessage(PropertyPanel.class, (String)"ACS_PropertyPanel", (Object)fd.getDisplayName());
            }
            return name;
        }

        public String getAccessibleDescription() {
            String description = super.getAccessibleDescription();
            if (description == null && PropertyPanel.this.model instanceof ExPropertyModel) {
                FeatureDescriptor fd = ((ExPropertyModel)PropertyPanel.this.model).getFeatureDescriptor();
                description = NbBundle.getMessage(PropertyPanel.class, (String)"ACSD_PropertyPanel", (Object)fd.getShortDescription());
            }
            return description;
        }
    }

    private class EditorListener
    implements PropertyChangeListener {
        EditorListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof PropertyEnv) {
                if (PropertyPanel.PROP_STATE.equals(evt.getPropertyName())) {
                    PropertyPanel.this.firePropertyChange(PropertyPanel.PROP_STATE, evt.getOldValue(), evt.getNewValue());
                }
                return;
            }
            if (PropertyPanel.this.ignoreEvents) {
                return;
            }
            if (!PropertyPanel.this.isWriteState && !PropertyPanel.this.customDialogShown && PropertyPanel.this.preferences < 2) {
                return;
            }
            if (PropertyPanel.this.env != null && !PropertyPanel.this.env.isChangeImmediate() && PropertyPanel.this.customDialogShown) {
                return;
            }
            if ("propertyValueValid".equals(evt.getPropertyName())) {
                return;
            }
            if (PropertyPanel.this.editor != null) {
                try {
                    PropertyPanel.this.ignoreEvents = true;
                    Object newValue = PropertyPanel.this.editor.getValue();
                    Object oldValue = null;
                    try {
                        if (PropertyPanel.this.canRead) {
                            oldValue = PropertyPanel.this.model.getValue();
                        }
                    }
                    catch (ProxyNode.DifferentValuesException dve) {
                        // empty catch block
                    }
                    if (newValue != null && !newValue.equals(oldValue) || newValue == null && oldValue != null) {
                        PropertyPanel.this.model.setValue(newValue);
                    }
                }
                catch (InvocationTargetException e) {
                    PropertyPanel.this.notifyExceptionWhileSettingProperty(e);
                    try {
                        if (PropertyPanel.this.canRead) {
                            PropertyPanel.this.editor.setValue(PropertyPanel.this.model.getValue());
                        }
                    }
                    catch (ProxyNode.DifferentValuesException dve) {
                    }
                    catch (Exception ex) {
                        PropertyDialogManager.notify(ex);
                    }
                }
                finally {
                    PropertyPanel.this.ignoreEvents = false;
                }
            }
        }
    }

    private class ModelListener
    implements PropertyChangeListener {
        ModelListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("value".equals(evt.getPropertyName()) && PropertyPanel.this.editor != null) {
                Mutex.EVENT.readAccess(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            PropertyPanel.this.ignoreEvents = true;
                            PropertyPanel.this.differentValues = false;
                            Object newValue = PropertyPanel.this.model.getValue();
                            Object oldValue = PropertyPanel.this.editor.getValue();
                            if (newValue != null && !newValue.equals(oldValue) || newValue == null && oldValue != null) {
                                PropertyPanel.this.editor.setValue(newValue);
                            }
                            PropertyPanel.this.refresh();
                        }
                        catch (ProxyNode.DifferentValuesException dve) {
                            PropertyPanel.this.differentValues = true;
                        }
                        catch (InvocationTargetException e) {
                            PropertyPanel.this.notifyExceptionWhileSettingProperty(e);
                        }
                        finally {
                            PropertyPanel.this.ignoreEvents = false;
                        }
                    }
                });
            }
        }
    }

    private final class CustomizeListener
    implements SheetButtonListener {
        CustomizeListener() {
        }

        public void sheetButtonExited(ActionEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sheetButtonClicked(ActionEvent e) {
            String title = PropertyPanel.this.descriptor.getDisplayName();
            PropertyPanel.this.customDialogShown = true;
            if (PropertyPanel.this.textField != null) {
                try {
                    if (PropertyPanel.this.editor.getValue() == null || !PropertyPanel.this.textField.getText().equals(PropertyPanel.this.editor.getAsText())) {
                        PropertyPanel.this.editor.setAsText(PropertyPanel.this.textField.getText());
                    }
                }
                catch (ProxyNode.DifferentValuesException dve) {
                }
                catch (Exception ite) {
                    // empty catch block
                }
            }
            final Container w = PropertyPanel.this.getTopLevelAncestor();
            w.setCursor(Cursor.getPredefinedCursor(3));
            AWTEventListener listener = new AWTEventListener(){

                public void eventDispatched(AWTEvent ae) {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                    w.setCursor(Cursor.getPredefinedCursor(0));
                }
            };
            try {
                PropertyDialogManager pdm = new PropertyDialogManager(NbBundle.getMessage(PropertyPanel.class, (String)"PS_EditorTitle", (Object)(title == null ? "" : title), (Object)PropertyPanel.this.model.getPropertyType()), true, PropertyPanel.this.editor, PropertyPanel.this.model, PropertyPanel.this.env);
                Window wd = pdm.getDialog();
                Toolkit.getDefaultToolkit().addAWTEventListener(listener, 1L);
                wd.show();
            }
            finally {
                Toolkit.getDefaultToolkit().removeAWTEventListener(listener);
                w.setCursor(Cursor.getPredefinedCursor(0));
            }
            if (PropertyPanel.this.canRead) {
                try {
                    PropertyPanel.this.ignoreEvents = true;
                    Object newValue = PropertyPanel.this.model.getValue();
                    Object oldValue = PropertyPanel.this.editor.getValue();
                    if (newValue != null && !newValue.equals(oldValue) || newValue == null && oldValue != null) {
                        PropertyPanel.this.editor.setValue(newValue);
                    }
                }
                catch (ProxyNode.DifferentValuesException dve) {
                    PropertyPanel.this.differentValues = true;
                }
                catch (Exception ite) {
                    PropertyPanel.this.processThrowable(ite);
                }
                finally {
                    PropertyPanel.this.ignoreEvents = false;
                }
            }
            PropertyPanel.this.reset();
            PropertyPanel.this.requestFocus();
            PropertyPanel.this.customDialogShown = false;
        }

        public void sheetButtonEntered(ActionEvent e) {
        }
    }

    private final class ReadComponentListener
    implements SheetButtonListener {
        ReadComponentListener() {
        }

        public void sheetButtonExited(ActionEvent e) {
        }

        public void sheetButtonClicked(ActionEvent e) {
            if ("rightMouseActionCommand".equals(e.getActionCommand()) || PropertyPanel.this.isWriteState) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PropertyPanel.this.setWriteState();
                }
            });
        }

        public void sheetButtonEntered(ActionEvent e) {
        }
    }

    private final class WriteComponentListener
    extends KeyAdapter
    implements ActionListener,
    FocusListener {
        private Object oldValue;
        private Runnable comboActionTask;
        private Runnable requestFocusTask;

        WriteComponentListener() {
        }

        private void setOldValue(Object oldValue) {
            this.oldValue = oldValue;
        }

        public void actionPerformed(ActionEvent e) {
            if (!PropertyPanel.this.isWriteState) {
                return;
            }
            if (e.getSource() == PropertyPanel.this.comboBox) {
                SwingUtilities.invokeLater(this.getComboActionTask());
            } else {
                if (e.getSource() == PropertyPanel.this.textField) {
                    String val = PropertyPanel.this.textField.getText();
                    this.changeValue(val);
                }
                this.prepareReadState();
            }
        }

        public void keyPressed(KeyEvent e) {
            Object source = e.getSource();
            if (e.getKeyCode() == 27) {
                if (PropertyPanel.this.comboBox != null && PropertyPanel.this.comboBox.isPopupVisible() && source instanceof Component && SwingUtilities.isDescendingFrom((Component)source, PropertyPanel.this.comboBox)) {
                    this.resetOldValue();
                } else if (source == PropertyPanel.this.textField) {
                    this.resetOldValue();
                    e.consume();
                }
                this.prepareReadState();
            } else if (e.getKeyCode() == 10 && PropertyPanel.this.comboBox != null && source instanceof Component && SwingUtilities.isDescendingFrom((Component)source, PropertyPanel.this.comboBox) && !PropertyPanel.this.comboBox.isEditable() && (PropertyPanel.this.preferences & 4) == 0) {
                this.changeValue((String)PropertyPanel.this.comboBox.getSelectedItem());
                this.prepareReadState();
            }
        }

        public void focusLost(final FocusEvent e) {
            boolean supportsCustom;
            if (!PropertyPanel.this.isWriteState) {
                return;
            }
            if (PropertyPanel.this.comboBox != null && e.isTemporary()) {
                return;
            }
            final boolean differentValuesNoChange = PropertyPanel.this.differentValues && e.getSource().equals(PropertyPanel.this.textField) && NbBundle.getMessage(PropertyPanel.class, (String)"CTL_Different_Values").equals(PropertyPanel.this.textField.getText());
            boolean bl = supportsCustom = PropertyPanel.this.editor != null && PropertyPanel.this.editor.supportsCustomEditor();
            if (supportsCustom || PropertyPanel.this.comboBox != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (e.getSource().equals(PropertyPanel.this.textField) && !differentValuesNoChange) {
                            WriteComponentListener.this.changeValue(PropertyPanel.this.textField.getText());
                            if (PropertyPanel.this.editor != null && !PropertyPanel.this.editor.getAsText().equals(PropertyPanel.this.textField.getText())) {
                                PropertyPanel.this.textField.setText(PropertyPanel.this.editor.getAsText());
                            }
                        }
                        if (SwingUtilities.findFocusOwner(PropertyPanel.this) == null && PropertyPanel.this.isWriteState) {
                            if (!differentValuesNoChange) {
                                WriteComponentListener.this.resetReadState(e);
                            } else {
                                PropertyPanel.this.setReadState();
                            }
                        }
                    }
                });
            } else if (!differentValuesNoChange) {
                this.resetReadState(e);
            } else {
                PropertyPanel.this.setReadState();
            }
        }

        public void focusGained(FocusEvent e) {
            if (e.getSource() == PropertyPanel.this.textField) {
                PropertyPanel.this.textField.selectAll();
            } else if (PropertyPanel.this.comboBox != null && PropertyPanel.this.comboBox.isEditable()) {
                PropertyPanel.this.comboBox.getEditor().selectAll();
            }
        }

        public void changeValue(String s) {
            if (!(s == null || PropertyPanel.this.editor.getValue() != null && s.equals(PropertyPanel.this.editor.getAsText()) || this.setAsText(s))) {
                this.resetOldValue();
            }
        }

        private synchronized Runnable getComboActionTask() {
            if (this.comboActionTask == null) {
                this.comboActionTask = new Runnable(){

                    public void run() {
                        if (PropertyPanel.this.comboBox.isPopupVisible() || !PropertyPanel.this.isWriteState) {
                            return;
                        }
                        WriteComponentListener.this.changeValue((String)PropertyPanel.this.comboBox.getSelectedItem());
                        WriteComponentListener.this.prepareReadState();
                    }
                };
            }
            return this.comboActionTask;
        }

        private synchronized Runnable getRequestFocusTask() {
            if (this.requestFocusTask == null) {
                this.requestFocusTask = new Runnable(){

                    public void run() {
                        Component focused = PropertyPanel.getDefaultFocusComponent(PropertyPanel.this);
                        if (focused != null) {
                            focused.requestFocus();
                        }
                    }
                };
            }
            return this.requestFocusTask;
        }

        private void prepareReadState() {
            boolean hasFocus = SwingUtilities.findFocusOwner(PropertyPanel.this) != null;
            PropertyPanel.this.setReadState();
            if (hasFocus) {
                SwingUtilities.invokeLater(this.getRequestFocusTask());
            }
        }

        private void resetReadState(FocusEvent e) {
            if (e.getSource() == PropertyPanel.this.customizeButton && PropertyPanel.this.textField != null) {
                this.changeValue(PropertyPanel.this.textField.getText());
            } else if (e.getSource() == PropertyPanel.this.textField) {
                this.changeValue(PropertyPanel.this.textField.getText());
            } else if (PropertyPanel.this.comboBox != null && PropertyPanel.this.comboBox.isEditable()) {
                this.changeValue((String)PropertyPanel.this.comboBox.getEditor().getItem());
            }
            PropertyPanel.this.setReadState();
        }

        private void resetOldValue() {
            try {
                if (!PropertyPanel.this.differentValues) {
                    PropertyPanel.this.editor.setValue(this.oldValue);
                }
            }
            catch (IllegalArgumentException iae) {
                PropertyPanel.this.notifyExceptionWhileSettingProperty(iae);
            }
            catch (RuntimeException throwable) {
                PropertyPanel.this.processThrowable(throwable);
            }
        }

        private boolean setAsText(String value) {
            try {
                PropertyPanel.this.editor.setAsText(value);
                return true;
            }
            catch (IllegalArgumentException iae) {
                PropertyPanel.this.notifyExceptionWhileSettingProperty(iae);
            }
            catch (RuntimeException throwable) {
                PropertyPanel.this.processThrowable(throwable);
            }
            return false;
        }
    }

    static class SimpleModel
    implements ExPropertyModel {
        private Node.Property prop;
        private Object[] beans;
        private PropertyChangeSupport sup = new PropertyChangeSupport(this);

        public SimpleModel(Node.Property property, Object[] beans) {
            this.prop = property;
            this.beans = beans;
        }

        public Object getValue() throws InvocationTargetException {
            try {
                return this.prop.getValue();
            }
            catch (IllegalAccessException iae) {
                throw this.annotateException(iae);
            }
            catch (InvocationTargetException ite) {
                throw this.annotateException(ite);
            }
        }

        public void setValue(Object v) throws InvocationTargetException {
            try {
                this.prop.setValue(v);
                this.sup.firePropertyChange("value", null, null);
            }
            catch (IllegalAccessException iae) {
                throw this.annotateException(iae);
            }
            catch (IllegalArgumentException iaae) {
                throw this.annotateException(iaae);
            }
            catch (InvocationTargetException ite) {
                throw this.annotateException(ite);
            }
        }

        private InvocationTargetException annotateException(Exception exception) {
            if (exception instanceof InvocationTargetException) {
                return (InvocationTargetException)exception;
            }
            return new InvocationTargetException(exception);
        }

        public Class getPropertyType() {
            return this.prop.getValueType();
        }

        public Class getPropertyEditorClass() {
            PropertyEditor ed = this.prop.getPropertyEditor();
            if (ed != null) {
                return ed.getClass();
            }
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.sup.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.sup.removePropertyChangeListener(l);
        }

        public Object[] getBeans() {
            return this.beans;
        }

        public FeatureDescriptor getFeatureDescriptor() {
            return this.prop;
        }

        void fireValueChanged() {
            this.sup.firePropertyChange("value", null, null);
        }
    }

    private static class EmptyModel
    implements PropertyModel {
        EmptyModel() {
        }

        public Object getValue() throws InvocationTargetException {
            return null;
        }

        public void setValue(Object v) throws InvocationTargetException {
        }

        public Class getPropertyType() {
            return Object.class;
        }

        public Class getPropertyEditorClass() {
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }
    }

    static class PropertySheetSettingsInvoker
    implements Runnable {
        PropertySheetSettingsInvoker() {
        }

        public void run() {
            PropertyPanel instance = (PropertyPanel)current.get();
            current.set(null);
            if (instance == null) {
                throw new IllegalStateException();
            }
            PropertySheetSettings pss = PropertySheetSettings.getDefault();
            instance.paintingStyle = pss.getPropertyPaintingStyle();
            instance.plastic = pss.getPlastic();
            instance.disabledColor = pss.getDisabledPropertyColor();
            instance.foregroundColor = pss.getValueColor();
        }
    }
}

