/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.project.Project;
import org.netbeans.spi.project.ProjectFactory;
import org.netbeans.spi.project.ProjectState;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public final class ProjectManager {
    private static final ErrorManager ERR = ErrorManager.getDefault().getInstance(ProjectManager.class.getName());
    private static final int ERR_LVL = Boolean.getBoolean(ProjectManager.class.getName() + ".LOG_WARN") ? 16 : 1;
    private static final Lookup.Result factories = Lookup.getDefault().lookup(new Lookup.Template(ProjectFactory.class));
    private static final ProjectManager DEFAULT = new ProjectManager();
    private static final Mutex MUTEX = new Mutex();
    private static final Object NO_SUCH_PROJECT = "NO_SUCH_PROJECT";
    private static final Object SOME_SUCH_PROJECT = "SOME_SUCH_PROJECT";
    private static final Object LOADING_PROJECT = "LOADING_PROJECT";
    private final Map dir2Proj = new WeakHashMap();
    private final Set modifiedProjects = new HashSet();
    private final Map proj2Factory = new WeakHashMap();
    private final FileChangeListener projectDeletionListener = new ProjectDeletionListener();
    private Thread loadingThread = null;
    static boolean quiet = false;

    private ProjectManager() {
        factories.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent e) {
                ProjectManager.this.clearNonProjectCache();
            }
        });
    }

    public static ProjectManager getDefault() {
        return DEFAULT;
    }

    public static Mutex mutex() {
        return MUTEX;
    }

    void reset() {
        this.dir2Proj.clear();
        this.modifiedProjects.clear();
        this.proj2Factory.clear();
    }

    public Project findProject(final FileObject projectDirectory) throws IOException, IllegalArgumentException {
        if (projectDirectory == null) {
            throw new IllegalArgumentException("Attempted to pass a null directory to findProject");
        }
        if (!projectDirectory.isFolder()) {
            throw new IllegalArgumentException("Attempted to pass a non-directory to findProject: " + projectDirectory);
        }
        try {
            return (Project)ProjectManager.mutex().readAccess(new Mutex.ExceptionAction(){

                /*
                 * Exception decompiling
                 */
                public Object run() throws IOException {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 3[TRYBLOCK]], but top level block is 7[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    private Project createProject(FileObject dir) throws IOException {
        assert (dir != null);
        assert (dir.isFolder());
        assert (ProjectManager.mutex().isReadAccess());
        ProjectStateImpl state = new ProjectStateImpl();
        for (ProjectFactory factory : factories.allInstances()) {
            Project p = factory.loadProject(dir, (ProjectState)state);
            if (p == null) continue;
            this.proj2Factory.put(p, factory);
            state.attach(p);
            return p;
        }
        return null;
    }

    public boolean isProject(final FileObject projectDirectory) throws IllegalArgumentException {
        if (projectDirectory == null) {
            throw new IllegalArgumentException("Attempted to pass a null directory to isProject");
        }
        if (!projectDirectory.isFolder()) {
            throw new IllegalArgumentException("Attempted to pass a non-directory to isProject: " + projectDirectory);
        }
        return (Boolean)ProjectManager.mutex().readAccess(new Mutex.Action(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object run() {
                Boolean bl;
                boolean resetLP;
                block19: {
                    Boolean bl2;
                    block17: {
                        block18: {
                            Map map = ProjectManager.this.dir2Proj;
                            synchronized (map) {
                                Object o;
                                do {
                                    if ((o = ProjectManager.this.dir2Proj.get(projectDirectory)) != LOADING_PROJECT) continue;
                                    try {
                                        ProjectManager.this.dir2Proj.wait();
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                    }
                                } while (o == LOADING_PROJECT);
                                assert (o != LOADING_PROJECT);
                                if (o == NO_SUCH_PROJECT) {
                                    return Boolean.FALSE;
                                }
                                if (o != null) {
                                    return Boolean.TRUE;
                                }
                                ProjectManager.this.dir2Proj.put(projectDirectory, LOADING_PROJECT);
                            }
                            resetLP = false;
                            try {
                                boolean p = ProjectManager.this.checkForProject(projectDirectory);
                                Map map2 = ProjectManager.this.dir2Proj;
                                synchronized (map2) {
                                    resetLP = true;
                                    ProjectManager.this.dir2Proj.notifyAll();
                                    if (p) {
                                        ProjectManager.this.dir2Proj.put(projectDirectory, SOME_SUCH_PROJECT);
                                        bl2 = Boolean.TRUE;
                                        // MONITOREXIT @DISABLED, blocks:[16, 2, 6] lbl33 : MonitorExitStatement: MONITOREXIT : var3_6
                                        Object var7_9 = null;
                                        if (resetLP) return bl2;
                                        if ($assertionsDisabled) break block17;
                                        break block18;
                                    }
                                    ProjectManager.this.dir2Proj.put(projectDirectory, NO_SUCH_PROJECT);
                                    bl = Boolean.FALSE;
                                }
                                break block19;
                            }
                            catch (Throwable throwable) {
                                Object var7_11 = null;
                                if (resetLP) throw throwable;
                                assert (ProjectManager.this.dir2Proj.get(projectDirectory) == LOADING_PROJECT);
                                ProjectManager.this.dir2Proj.remove(projectDirectory);
                                throw throwable;
                            }
                        }
                        if (ProjectManager.this.dir2Proj.get(projectDirectory) != LOADING_PROJECT) {
                            throw new AssertionError();
                        }
                    }
                    ProjectManager.this.dir2Proj.remove(projectDirectory);
                    return bl2;
                }
                Object var7_10 = null;
                if (resetLP) return bl;
                assert (ProjectManager.this.dir2Proj.get(projectDirectory) == LOADING_PROJECT);
                ProjectManager.this.dir2Proj.remove(projectDirectory);
                return bl;
            }
        });
    }

    private boolean checkForProject(FileObject dir) {
        assert (dir != null);
        assert (dir.isFolder()) : dir;
        assert (ProjectManager.mutex().isReadAccess());
        for (ProjectFactory factory : factories.allInstances()) {
            if (!factory.isProject(dir)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearNonProjectCache() {
        Map map = this.dir2Proj;
        synchronized (map) {
            this.dir2Proj.values().removeAll(Arrays.asList(NO_SUCH_PROJECT, SOME_SUCH_PROJECT));
        }
    }

    public Set getModifiedProjects() {
        return (Set)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                return new HashSet(ProjectManager.this.modifiedProjects);
            }
        });
    }

    public boolean isModified(final Project p) throws IllegalArgumentException {
        return (Boolean)ProjectManager.mutex().readAccess(new Mutex.Action(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                Map map = ProjectManager.this.dir2Proj;
                synchronized (map) {
                    if (!ProjectManager.this.proj2Factory.containsKey(p)) {
                        throw new IllegalArgumentException("Project " + p + " not created by " + ProjectManager.this + " or was already deleted");
                    }
                }
                return ProjectManager.this.modifiedProjects.contains(p);
            }
        });
    }

    public void saveProject(final Project p) throws IOException, IllegalArgumentException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    if (!ProjectManager.this.proj2Factory.containsKey(p)) {
                        throw new IllegalArgumentException("Project " + p + " not created by " + ProjectManager.this + " or was already deleted");
                    }
                    if (ProjectManager.this.modifiedProjects.contains(p)) {
                        ProjectFactory f = (ProjectFactory)ProjectManager.this.proj2Factory.get(p);
                        f.saveProject(p);
                        ProjectManager.this.modifiedProjects.remove(p);
                    }
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    public void saveAllProjects() throws IOException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    Iterator it = ProjectManager.this.modifiedProjects.iterator();
                    while (it.hasNext()) {
                        Project p = (Project)it.next();
                        ProjectFactory f = (ProjectFactory)ProjectManager.this.proj2Factory.get(p);
                        assert (f != null) : p;
                        f.saveProject(p);
                        it.remove();
                    }
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    public boolean isValid(final Project p) {
        return (Boolean)ProjectManager.mutex().readAccess(new Mutex.Action(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                Map map = ProjectManager.this.dir2Proj;
                synchronized (map) {
                    return ProjectManager.this.proj2Factory.containsKey(p);
                }
            }
        });
    }

    static /* synthetic */ Thread access$200(ProjectManager x0) {
        return x0.loadingThread;
    }

    static /* synthetic */ int access$300() {
        return ERR_LVL;
    }

    static /* synthetic */ ErrorManager access$400() {
        return ERR;
    }

    static /* synthetic */ Thread access$202(ProjectManager x0, Thread x1) {
        x0.loadingThread = x1;
        return x0.loadingThread;
    }

    static /* synthetic */ Project access$700(ProjectManager x0, FileObject x1) throws IOException {
        return x0.createProject(x1);
    }

    static /* synthetic */ FileChangeListener access$800(ProjectManager x0) {
        return x0.projectDeletionListener;
    }

    private final class ProjectDeletionListener
    extends FileChangeAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileDeleted(FileEvent fe) {
            Map map = ProjectManager.this.dir2Proj;
            synchronized (map) {
                ProjectManager.this.dir2Proj.remove(fe.getFile());
            }
        }
    }

    private final class ProjectStateImpl
    implements ProjectState {
        private Project p;

        private ProjectStateImpl() {
        }

        void attach(Project p) {
            assert (p != null);
            assert (this.p == null);
            this.p = p;
        }

        public void markModified() {
            assert (this.p != null);
            ProjectManager.mutex().writeAccess(new Mutex.Action(){

                public Object run() {
                    if (!ProjectManager.this.proj2Factory.containsKey(ProjectStateImpl.this.p)) {
                        throw new IllegalStateException("An attempt to call ProjectState.markModified on a deleted project: " + ProjectStateImpl.this.p.getProjectDirectory());
                    }
                    ProjectManager.this.modifiedProjects.add(ProjectStateImpl.this.p);
                    return null;
                }
            });
        }

        public void notifyDeleted() throws IllegalStateException {
            assert (this.p != null);
            ProjectManager.mutex().writeAccess(new Mutex.Action(){

                public Object run() {
                    if (ProjectManager.this.proj2Factory.get(ProjectStateImpl.this.p) == null) {
                        throw new IllegalStateException("An attempt to call notifyDeleted more than once. Project: " + ProjectStateImpl.this.p.getProjectDirectory());
                    }
                    ProjectManager.this.dir2Proj.remove(ProjectStateImpl.this.p.getProjectDirectory());
                    ProjectManager.this.proj2Factory.remove(ProjectStateImpl.this.p);
                    ProjectManager.this.modifiedProjects.remove(ProjectStateImpl.this.p);
                    return null;
                }
            });
        }
    }
}

