/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.lexer.inc;

import org.netbeans.api.lexer.LexerInput;
import org.netbeans.api.lexer.Token;
import org.netbeans.spi.lexer.inc.AbstractTokenUpdater;
import org.netbeans.spi.lexer.inc.OffsetToken;
import org.netbeans.spi.lexer.util.Compatibility;

public abstract class OffsetTokenUpdater
extends AbstractTokenUpdater {
    private int nextOffset;

    protected abstract LexerInput createInput(int var1);

    protected final int getNextOffset() {
        return this.nextOffset;
    }

    protected LexerInput createInput() {
        return this.createInput(this.nextOffset);
    }

    public int relocate(int n) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("offset=" + n);
        }
        if (n == 0) {
            this.nextOffset = 0;
            this.setNextIndex(0);
            return 0;
        }
        int n3 = this.getTokenCount();
        if (n3 == 0) {
            this.nextOffset = 0;
            this.setNextIndex(0);
            return n;
        }
        int n4 = 0;
        int n5 = n3 - 1;
        while (n4 <= n5) {
            int n6 = (n4 + n5) / 2;
            n2 = this.findTokenOffset(n6);
            if (n2 < n) {
                n4 = n6 + 1;
                continue;
            }
            if (n2 > n) {
                n5 = n6 - 1;
                continue;
            }
            this.nextOffset = n2;
            this.setNextIndex(n6);
            return 0;
        }
        if (n4 == n3) {
            Token token = this.getToken(n5);
            n2 = this.findTokenOffset(n5) + Compatibility.getLength(token);
            if (n >= n2) {
                this.nextOffset = n2;
                this.setNextIndex(n3);
                return n - n2;
            }
        }
        this.nextOffset = this.findTokenOffset(n5);
        this.setNextIndex(n5);
        return n - this.nextOffset;
    }

    protected void nextUpdate(Token token) {
        this.nextOffset += Compatibility.getLength(token);
    }

    protected void previousUpdate(Token token) {
        this.nextOffset -= Compatibility.getLength(token);
    }

    protected int findTokenOffset(int n) {
        Token token;
        if (n < this.getTokenCount() && (token = this.getToken(n)) instanceof OffsetToken) {
            return ((OffsetToken)token).getOffset();
        }
        int n2 = 0;
        while (--n >= 0) {
            Token token2 = this.getToken(n);
            n2 += token2.getText().length();
            if (!(token2 instanceof OffsetToken)) continue;
            n2 += ((OffsetToken)token2).getOffset();
            break;
        }
        return n2;
    }

    protected int findTokenIndex(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("offset=" + n);
        }
        int n2 = 0;
        int n3 = this.getTokenCount() - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            int n5 = this.findTokenOffset(n4);
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            this.nextOffset = n5;
            return n4;
        }
        return n3;
    }
}

