/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.lexer;

import org.netbeans.api.lexer.SampleTextMatcher;

public final class MatcherFactory {
    public static SampleTextMatcher createNoCheckMatcher(String string) {
        return new NoCheckMatcher(string);
    }

    public static SampleTextMatcher createLengthCheckMatcher(String string) {
        return new LengthCheckMatcher(string);
    }

    public static SampleTextMatcher createTextCheckMatcher(String string) {
        return new TextCheckMatcher(string);
    }

    public static SampleTextMatcher createMultiMatcher(String[] stringArray) {
        return new MultiMatcher(stringArray);
    }

    static final class MultiMatcher
    implements SampleTextMatcher {
        private final String[] sampleTexts;

        MultiMatcher(String[] stringArray) {
            this.sampleTexts = stringArray;
        }

        public String match(CharSequence charSequence) {
            int n = this.sampleTexts.length;
            int n2 = charSequence.length();
            for (int i = 0; i < n; ++i) {
                int n3;
                String string = this.sampleTexts[i];
                if (string.length() != n2) continue;
                for (n3 = 0; n3 < n2 && charSequence.charAt(n3) == string.charAt(n3); ++n3) {
                }
                if (n3 != n2) continue;
                return string;
            }
            return null;
        }
    }

    static final class TextCheckMatcher
    implements SampleTextMatcher {
        private final String sampleText;

        TextCheckMatcher(String string) {
            this.sampleText = string;
        }

        public String match(CharSequence charSequence) {
            int n = charSequence.length();
            if (n != this.sampleText.length()) {
                return null;
            }
            for (int i = 0; i < n; ++i) {
                if (charSequence.charAt(i) == this.sampleText.charAt(i)) continue;
                return null;
            }
            return this.sampleText;
        }
    }

    static final class LengthCheckMatcher
    implements SampleTextMatcher {
        private final String sampleText;

        LengthCheckMatcher(String string) {
            this.sampleText = string;
        }

        public String match(CharSequence charSequence) {
            return charSequence.length() == this.sampleText.length() ? this.sampleText : null;
        }
    }

    static final class NoCheckMatcher
    implements SampleTextMatcher {
        private final String sampleText;

        NoCheckMatcher(String string) {
            this.sampleText = string;
        }

        public String match(CharSequence charSequence) {
            return this.sampleText;
        }
    }
}

