/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.Util;
import org.openide.util.Utilities;

final class ChangeFirer {
    private final ModuleManager mgr;
    private final Set changes = new LinkedHashSet(100);
    private final Set modulesCreated = new HashSet(100);
    private final Set modulesDeleted = new HashSet(10);

    public ChangeFirer(ModuleManager mgr) {
        this.mgr = mgr;
    }

    public void change(Change c) {
        this.changes.add(c);
    }

    public void created(Module m) {
        this.modulesCreated.add(m);
    }

    public void deleted(Module m) {
        if (!this.modulesCreated.remove((Object)m)) {
            this.modulesDeleted.add(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fire() {
        this.mgr.readOnly(true);
        try {
            Iterator it = this.changes.iterator();
            while (it.hasNext()) {
                Change c = (Change)it.next();
                if (c.source instanceof Module) {
                    ((Module)((Object)c.source)).firePropertyChange0(c.prop, c.old, c.nue);
                    continue;
                }
                if (c.source == this.mgr) {
                    this.mgr.firePropertyChange(c.prop, c.old, c.nue);
                    continue;
                }
                throw new IllegalStateException("Strange source: " + c.source);
            }
            this.changes.clear();
            if (!this.modulesCreated.isEmpty() || !this.modulesDeleted.isEmpty()) {
                this.mgr.fireModulesCreatedDeleted(this.modulesCreated, this.modulesDeleted);
            }
            this.modulesCreated.clear();
            this.modulesDeleted.clear();
        }
        catch (RuntimeException e) {
            Util.err.notify((Throwable)e);
        }
        finally {
            this.mgr.readOnly(false);
        }
    }

    public static final class Change {
        public final String prop;
        public final Object source;
        public final Object old;
        public final Object nue;

        public Change(Object source, String prop, Object old, Object nue) {
            this.source = source;
            this.prop = prop;
            this.old = old;
            this.nue = nue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Change)) {
                return false;
            }
            Change c = (Change)o;
            return Utilities.compareObjects((Object)this.prop, (Object)c.prop) && Utilities.compareObjects((Object)this.source, (Object)c.source) && Utilities.compareObjects((Object)this.old, (Object)c.old) && Utilities.compareObjects((Object)this.nue, (Object)c.nue);
        }

        public int hashCode() {
            return this.source.hashCode() ^ (this.prop == null ? 0 : this.prop.hashCode());
        }

        public String toString() {
            return "Change[" + this.source + ":" + this.prop + ";" + this.old + "->" + this.nue + "]";
        }
    }
}

