/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.ideserverclient.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.modules.distributed.ideserverclient.diagnose.GatherInfo;
import org.netbeans.modules.distributed.ideserverclient.diagnose.GatherInfoPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class RemoteDiagnosticAction
extends CallableSystemAction {
    private Dialog myDialog;
    private GatherInfoPanel panel;

    private void displayReport() {
        InputOutput inputOutput = IOProvider.getDefault().getIO("Remote Server Diagnostics Report", true);
        inputOutput.closeInputOutput();
        inputOutput.select();
        inputOutput.setFocusTaken(true);
        inputOutput.setErrVisible(false);
        inputOutput.setErrSeparated(false);
        GatherInfo gatherInfo = new GatherInfo();
        inputOutput.getOut().println("Remote Server Diagnostics Report");
        inputOutput.getOut().println("=================================\n");
        inputOutput.getOut().println("Distributed NetBeans Client Info");
        inputOutput.getOut().println("--------------------------------");
        ArrayList arrayList = gatherInfo.getClientVersions();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            inputOutput.getOut().println((String)iterator.next());
        }
        inputOutput.getOut().println();
        inputOutput.getOut().println("NetBeans Environment");
        inputOutput.getOut().println("--------------------");
        arrayList = gatherInfo.getClientEnv();
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            inputOutput.getOut().println((String)iterator.next());
        }
        inputOutput.getOut().println();
        inputOutput.getOut().println("Remote Connection Tests");
        inputOutput.getOut().println("-----------------------");
        inputOutput.getOut().println(GatherInfo.padString("Server Name/IP Address") + this.panel.getHostName());
        inputOutput.getOut().println(GatherInfo.padString("OpenVMS Username") + this.panel.getUserName());
        inputOutput.getOut().print(GatherInfo.padString("Server host Connectivity"));
        if (!gatherInfo.isHostReachable(this.panel.getHostName(), this.panel.getRMIPort())) {
            inputOutput.getOut().println("FAIL\n" + gatherInfo.getLastErrorMsg());
            inputOutput.getOut().println("\nFinished");
            inputOutput.getOut().close();
            return;
        }
        inputOutput.getOut().println("PASS");
        inputOutput.getOut().print(GatherInfo.padString("IDE$SERVER Availability"));
        if (!gatherInfo.isIdeServerRunning(this.panel.getHostName(), this.panel.getRMIPort())) {
            inputOutput.getOut().println("FAIL\n" + gatherInfo.getLastErrorMsg());
            inputOutput.getOut().println("\nFinished");
            inputOutput.getOut().close();
            return;
        }
        inputOutput.getOut().println("PASS");
        inputOutput.getOut().println("\tServer version is " + gatherInfo.getServerVersion(this.panel.getHostName(), this.panel.getRMIPort()));
        inputOutput.getOut().print(GatherInfo.padString("User Authentication"));
        if (!gatherInfo.authenUser(this.panel.getHostName(), this.panel.getUserName(), this.panel.getPassword(), this.panel.getRMIPort())) {
            inputOutput.getOut().println("FAIL\n" + gatherInfo.getLastErrorMsg());
            inputOutput.getOut().println("\nFinished");
            inputOutput.getOut().close();
            return;
        }
        inputOutput.getOut().println("PASS");
        inputOutput.getOut().print(GatherInfo.padString("Quota Checks"));
        String[] stringArray = gatherInfo.getUserUAI(this.panel.getHostName(), this.panel.getUserName(), this.panel.getPassword(), this.panel.getRMIPort());
        if (stringArray[0].length() > 0) {
            inputOutput.getOut().println("FAIL\n" + stringArray[0]);
        } else {
            inputOutput.getOut().println("PASS");
        }
        inputOutput.getOut().println();
        inputOutput.getOut().print(stringArray[1].substring(0, stringArray[1].indexOf(10)) + "\n");
        inputOutput.getOut().print(stringArray[1].substring(stringArray[1].indexOf(10) + 1, stringArray[1].length()) + "\n");
        inputOutput.getOut().println();
        inputOutput.getOut().println();
        inputOutput.getOut().println("User Login Environment");
        inputOutput.getOut().println("----------------------");
        inputOutput.getOut().println(gatherInfo.getUserEnv(this.panel.getHostName(), this.panel.getUserName(), this.panel.getPassword(), this.panel.getRMIPort()));
        inputOutput.getOut().println("\nFinished");
        inputOutput.getOut().close();
    }

    public void performAction() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoteDiagnosticAction.this.myDialog.dispose();
                if (actionEvent.getSource() == DialogDescriptor.OK_OPTION) {
                    RemoteDiagnosticAction.this.panel;
                    GatherInfoPanel.setUserName(RemoteDiagnosticAction.this.panel.getUserName());
                    RemoteDiagnosticAction.this.panel;
                    GatherInfoPanel.setHostName(RemoteDiagnosticAction.this.panel.getHostName());
                    Thread thread = new Thread(new Runnable(){

                        public void run() {
                            RemoteDiagnosticAction.this.displayReport();
                        }
                    });
                    thread.start();
                }
            }
        };
        this.panel = new GatherInfoPanel();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.panel, NbBundle.getMessage((Class)RemoteDiagnosticAction.class, (String)"LBL_RemoteDiagnosticAction"), false, actionListener);
        dialogDescriptor.setValid(false);
        this.panel.setDialogDescriptor(dialogDescriptor);
        this.myDialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        this.myDialog.show();
    }

    public String getName() {
        return NbBundle.getMessage((Class)RemoteDiagnosticAction.class, (String)"LBL_RemoteDiagnosticAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void initialize() {
        super.initialize();
    }
}

