/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.netbeans.modules.masterfs.filebasedfs.FileBasedFileSystem;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public final class FileBasedURLMapper
extends URLMapper {
    public final URL getURL(FileObject fo, int type) {
        URL retVal = null;
        try {
            if (fo instanceof BaseFileObj) {
                BaseFileObj bfo = (BaseFileObj)fo;
                retVal = FileBasedURLMapper.fileToURL(bfo.getFileName().getFile(), fo);
            }
        }
        catch (MalformedURLException e) {
            retVal = null;
        }
        return retVal;
    }

    public final FileObject[] getFileObjects(URL url) {
        File file;
        FileObject retVal;
        block4: {
            if (!"file".equals(url.getProtocol())) {
                return null;
            }
            retVal = null;
            try {
                String host = url.getHost();
                String f = url.getFile();
                file = host != null && host.trim().length() != 0 ? new File("////" + host + f) : (f.startsWith("//") ? new File(f) : FileUtil.normalizeFile((File)new File(URI.create(url.toExternalForm()))));
            }
            catch (IllegalArgumentException e) {
                file = new File(url.getFile());
                if (file.exists()) break block4;
                StringBuffer sb = new StringBuffer();
                sb.append(e.getLocalizedMessage()).append(" [").append(url.toExternalForm()).append(']');
                ErrorManager.getDefault().notify((Throwable)new IllegalArgumentException(sb.toString()));
                return null;
            }
        }
        FileBasedFileSystem instance = FileBasedFileSystem.getInstance(file);
        if (instance != null) {
            retVal = instance.findFileObject(file);
        }
        return new FileObject[]{retVal};
    }

    private static URL fileToURL(File file, FileObject fo) throws MalformedURLException {
        URL retVal = null;
        if (fo.isFolder() && (!fo.isValid() || fo.isVirtual())) {
            String urlDef = file.toURI().toURL().toExternalForm();
            String pathSeparator = "/";
            if (!urlDef.endsWith("/")) {
                retVal = new URL(urlDef + "/");
            }
        }
        retVal = retVal == null ? file.toURI().toURL() : retVal;
        return retVal;
    }
}

