/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.breakpoints;

import com.hp.openvms.netbeans.debugsupport.breakpoints.ActionsPanel;
import com.hp.openvms.netbeans.debugsupport.breakpoints.FunctionBreakpoint;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class FunctionBreakpointPanel
extends JPanel
implements Controller,
HelpCtx.Provider {
    private ActionsPanel actionsPanel;
    private FunctionBreakpoint breakpoint;
    private boolean createBreakpoint = false;
    private JLabel jLabel1;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel pActions;
    private JPanel pSettings;
    private JScrollPane spCondition;
    private JEditorPane tfCondition;
    private JTextField tfLineNumber;

    private static FunctionBreakpoint createBreakpoint() {
        FunctionBreakpoint functionBreakpoint = FunctionBreakpoint.create("main");
        functionBreakpoint.setPrintText(NbBundle.getBundle((Class)FunctionBreakpointPanel.class).getString("CTL_Function_Breakpoint_Print_Text"));
        return functionBreakpoint;
    }

    public FunctionBreakpointPanel() {
        this(FunctionBreakpointPanel.createBreakpoint());
        this.createBreakpoint = true;
    }

    public FunctionBreakpointPanel(FunctionBreakpoint functionBreakpoint) {
        this.breakpoint = functionBreakpoint;
        this.initComponents();
        String string = functionBreakpoint.getURL();
        this.tfCondition.setText(functionBreakpoint.getCondition());
        this.setupConditionPane();
        this.actionsPanel = new ActionsPanel(functionBreakpoint);
        this.pActions.add((Component)this.actionsPanel, "Center");
    }

    private static int findNumLines(String string) {
        DataObject dataObject;
        FileObject fileObject;
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            return 0;
        }
        if (fileObject == null) {
            return 0;
        }
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return 0;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return 0;
        }
        editorCookie.prepareDocument().waitFinished();
        StyledDocument styledDocument = editorCookie.getDocument();
        if (!(styledDocument instanceof StyledDocument)) {
            return 0;
        }
        StyledDocument styledDocument2 = styledDocument;
        return NbDocument.findLineNumber((StyledDocument)styledDocument2, (int)styledDocument2.getLength());
    }

    private void setupConditionPane() {
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerBreakpointLineJPDA");
    }

    private void initComponents() {
        this.pSettings = new JPanel();
        this.jLabel5 = new JLabel();
        this.jLabel1 = new JLabel();
        this.tfLineNumber = new JTextField();
        this.spCondition = new JScrollPane();
        this.tfCondition = new JEditorPane();
        this.pActions = new JPanel();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.pSettings.setLayout(new GridBagLayout());
        this.pSettings.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("L_Function_Breakpoint_BorderTitle")));
        this.jLabel5.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("MN_L_Function_Breakpoint_Condition").charAt(0));
        this.jLabel5.setLabelFor(this.tfCondition);
        this.jLabel5.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("L_Function_Breakpoint_Condition"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel5.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("ACSD_L_Function_Breakpoint_Condition"));
        this.jLabel1.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("MN_L_Function_Breakpoint_Function_Name").charAt(0));
        this.jLabel1.setLabelFor(this.tfLineNumber);
        this.jLabel1.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("L_Function_Breakpoint_Function_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("ACSD_L_Function_Breakpoint_Function_Name"));
        this.tfLineNumber.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("TTT_TF_Function_Breakpoint_Function_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfLineNumber, gridBagConstraints);
        this.tfLineNumber.getAccessibleContext().setAccessibleName("Line number");
        this.tfLineNumber.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("ACSD_TF_Function_Breakpoint_Function_Name"));
        this.spCondition.setHorizontalScrollBarPolicy(31);
        this.spCondition.setToolTipText(NbBundle.getMessage((Class)FunctionBreakpointPanel.class, (String)"ACSD_TF_Function_Breakpoint_Condition"));
        this.tfCondition.setEditable(false);
        this.tfCondition.setText("Not implemented yet.");
        this.tfCondition.setToolTipText(NbBundle.getMessage((Class)FunctionBreakpointPanel.class, (String)"HINT_UnimplementedCondition"));
        this.tfCondition.setContentType("text/x-java");
        this.spCondition.setViewportView(this.tfCondition);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.spCondition, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pSettings, gridBagConstraints);
        this.pActions.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pActions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    public boolean ok() {
        String string = this.valiadateMsg();
        if (string != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string));
            return false;
        }
        this.actionsPanel.ok();
        String string2 = this.tfLineNumber.getText().trim();
        String string3 = this.tfCondition.getText();
        this.breakpoint.setFunctionName(string2);
        this.breakpoint.setCondition(string3);
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        Breakpoint[] breakpointArray = debuggerManager.getBreakpoints();
        int n = breakpointArray.length;
        for (int i = 0; i < n; ++i) {
            String string4;
            FunctionBreakpoint functionBreakpoint;
            if (!(breakpointArray[i] instanceof FunctionBreakpoint) || !string2.equals((functionBreakpoint = (FunctionBreakpoint)breakpointArray[i]).getFunctionName()) || ((string4 = this.breakpoint.getCondition()) == null ? functionBreakpoint.getCondition() != null : !string4.equals(functionBreakpoint.getCondition()))) continue;
            if (!functionBreakpoint.isEnabled()) {
                breakpointArray[i].enable();
            }
            return true;
        }
        if (this.createBreakpoint) {
            debuggerManager.addBreakpoint((Breakpoint)this.breakpoint);
        }
        return true;
    }

    public boolean cancel() {
        return true;
    }

    public boolean isValid() {
        return true;
    }

    private String valiadateMsg() {
        String string = this.tfLineNumber.getText().trim();
        if (string == null || string.equals("")) {
            return NbBundle.getBundle((Class)FunctionBreakpointPanel.class).getString("MSG_No_Function_Name_Spec");
        }
        return null;
    }
}

