/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.dclsupport.dcl;

import com.hp.openvms.netbeans.dclsupport.dcl.datasys.DCLBuildSupport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.netbeans.modules.distributed.remotefs.RemoteFSUtils;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileSystem;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Utilities;

class SurrogateNode
extends AbstractNode {
    private Node realNode;
    static /* synthetic */ Class class$java$lang$String;

    public SurrogateNode(Children children, Node node) {
        super(children);
        this.realNode = node;
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("Remote Settings");
        set.setDisplayName("Remote Settings");
        set.setShortDescription("Settings for remote operations on a remote host");
        DataObject dataObject = (DataObject)this.realNode.getCookie(DataObject.class);
        ((DCLBuildSupport)dataObject.getCookie(DCLBuildSupport.class)).addProperties(set);
        set.put((Node.Property)this.createRemoteFilePathProperty());
        try {
            if (dataObject.getPrimaryFile().getFileSystem() instanceof FTPFileSystem) {
                set.put((Node.Property)this.createFileResidenceProperty());
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        sheet.put(set);
        return sheet;
    }

    private PropertySupport createRemoteFilePathProperty() {
        class RemoteFilePathPropertySupport
        extends PropertySupport.ReadOnly {
            public RemoteFilePathPropertySupport() {
                super("Remote File Path", class$java$lang$String == null ? (class$java$lang$String = SurrogateNode.class$("java.lang.String")) : class$java$lang$String, "Remote File Path", "Remote File Path");
            }

            public Object getValue() {
                DataObject dataObject = (DataObject)SurrogateNode.this.realNode.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = SurrogateNode.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                FileObject fileObject = dataObject.getPrimaryFile();
                Object object = dataObject.getPrimaryFile().getAttribute("REMOTE_FILEPATH");
                if (object != null) {
                    return object;
                }
                String string = fileObject.getNameExt();
                try {
                    File file = FileUtil.toFile((FileObject)fileObject);
                    if (Utilities.isWindows()) {
                        string = RemoteFSUtils._winPathToOpenVMSPath((String)file.getAbsolutePath(), (boolean)false, (FileObject)fileObject);
                    } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                        string = RemoteFSUtils.unixPathToOpenVMSPath((String)file.getAbsolutePath(), (boolean)false, (FileObject)fileObject);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return string;
            }

            public void setValue(Object object) throws InvocationTargetException {
                try {
                    DataObject dataObject = (DataObject)SurrogateNode.this.realNode.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = SurrogateNode.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                    dataObject.getPrimaryFile().setAttribute("REMOTE_FILEPATH", object);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                DataObject dataObject = (DataObject)SurrogateNode.this.realNode.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = SurrogateNode.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                FileObject fileObject = dataObject.getPrimaryFile();
                String string = fileObject.getNameExt();
                try {
                    File file = FileUtil.toFile((FileObject)fileObject);
                    if (Utilities.isWindows()) {
                        string = RemoteFSUtils._winPathToOpenVMSPath((String)file.getAbsolutePath(), (boolean)false, (FileObject)fileObject);
                    } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                        string = RemoteFSUtils.unixPathToOpenVMSPath((String)file.getAbsolutePath(), (boolean)false, (FileObject)fileObject);
                    }
                    this.setValue(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return new RemoteFilePathPropertySupport();
    }

    private PropertySupport createRemoteArgumentsProperty() {
        class RemoteArgumentsPropertySupport
        extends PropertySupport.ReadWrite {
            public RemoteArgumentsPropertySupport() {
                super("Remote Arguments", class$java$lang$String == null ? (class$java$lang$String = SurrogateNode.class$("java.lang.String")) : class$java$lang$String, "Remote Arguments", "Remote Arguments");
            }

            public Object getValue() {
                DataObject dataObject = (DataObject)SurrogateNode.this.realNode.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = SurrogateNode.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                FileObject fileObject = dataObject.getPrimaryFile();
                Object object = dataObject.getPrimaryFile().getAttribute("REMOTE_ARGUMENT");
                if (object != null) {
                    return object;
                }
                return "";
            }

            public void setValue(Object object) throws InvocationTargetException {
                try {
                    DataObject dataObject = (DataObject)SurrogateNode.this.realNode.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = SurrogateNode.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                    dataObject.getPrimaryFile().setAttribute("REMOTE_ARGUMENT", object);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new RemoteArgumentsPropertySupport();
    }

    private PropertySupport createFileResidenceProperty() {
        class FileResidenceProperty
        extends PropertySupport.ReadOnly {
            public FileResidenceProperty() {
                super("File Residence", class$java$lang$String == null ? (class$java$lang$String = SurrogateNode.class$("java.lang.String")) : class$java$lang$String, "File Residence", "Determine if the file should reside in local disk, server or both");
            }

            public Object getValue() {
                Object object;
                DataObject dataObject = (DataObject)SurrogateNode.this.realNode.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = SurrogateNode.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                FileObject fileObject = dataObject.getPrimaryFile();
                try {
                    object = (RemoteFileSystem)fileObject.getFileSystem();
                    if (object.getServerOnlyFileExts().isRegistered(fileObject.getExt())) {
                        return "Server Only";
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
                }
                object = fileObject.getAttribute("file_residence_mode");
                if (object != null) {
                    Integer n = (Integer)object;
                    String string = "Make Client and Server";
                    switch (n) {
                        case 1: {
                            string = "Client Only";
                            break;
                        }
                        case 0: {
                            string = "Server Only";
                            break;
                        }
                        case 2: {
                            string = "Client and Server";
                        }
                    }
                    return string;
                }
                return "Client and Server";
            }

            public void setValue(Object object) throws InvocationTargetException {
                try {
                    DataObject dataObject = (DataObject)SurrogateNode.this.realNode.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = SurrogateNode.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                    dataObject.getPrimaryFile().setAttribute("file_residence_mode", object);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new FileResidenceProperty();
    }
}

