/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteexecute.generic;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.remoteexecute.RemoteExecutor;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.RemoteFSUtils;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.MapFormat;
import org.openide.util.Utilities;

public class RemoteGenericExecutor
extends RemoteExecutor {
    private String target = "";
    private static final long serialVersionUID = 4921782425419448322L;
    public static final String PROP_USE_XTERM = "useXterm";
    public static final String PROP_FILE_EXTENSION = "includeFileExtension";
    public static final String PROP_FILE_UNIX_PATH = "useUnixFilePath";
    public static final String PROP_USE_FILENAME_ONLY = "useFileNameOnly";
    public static final String TAG_FILE = "file";
    public static final String TAG_CURRENT_DIR = "current dir";
    public static final String TAG_ARGUMENTS = "arguments";
    public static final String TAG_ROOT_DIR = "root dir";

    public RemoteGenericExecutor() {
        this.setUseUnixFilePath(false);
        this.setUseFileNameOnly(false);
        this.setIncludeFileExtension(true);
        this.setChangeWorkingDir(true);
        this.setRemoteExecutor(this.getExternalExecutor());
    }

    public boolean isRemoteJavaCompile() {
        return false;
    }

    protected void createDefaultMapFormat(DataObject dataObject) throws IOException {
        AbstractNetworkFileSystem abstractNetworkFileSystem = null;
        try {
            abstractNetworkFileSystem = (AbstractNetworkFileSystem)dataObject.getPrimaryFile().getFileSystem();
            MapFormat mapFormat = super.createMapFormat(dataObject, abstractNetworkFileSystem);
            Map map = mapFormat.getMap();
            FileObject fileObject = dataObject.getPrimaryFile();
            String string = (String)map.get(TAG_FILE);
            String string2 = (String)map.get(TAG_CURRENT_DIR);
            String string3 = (String)map.get(TAG_ROOT_DIR);
            if (this.getUseUnixFilePath()) {
                if (!this.getUseFileNameOnly()) {
                    string = FileUtility.openVMSPathToUnixPath((String)string, (boolean)false);
                }
                map.put(TAG_CURRENT_DIR, FileUtility.openVMSPathToUnixPath((String)string2, (boolean)true));
                map.put(TAG_ROOT_DIR, FileUtility.openVMSPathToUnixPath((String)string3, (boolean)true));
            }
            if (this.getUseFileNameOnly()) {
                string = fileObject.getNameExt();
            }
            if (!this.getIncludeFileExtension() && fileObject.getExt().length() != 0) {
                string = string.substring(0, string.lastIndexOf(46));
            }
            map.put(TAG_FILE, string);
            this.format = mapFormat;
        }
        catch (FileStateInvalidException fileStateInvalidException) {
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    public boolean getUseXterm() {
        return this.useXterm;
    }

    public void setUseXterm(boolean bl) {
        boolean bl2 = this.useXterm;
        this.useXterm = bl;
    }

    public boolean getChangeWorkingDir() {
        return this.changeWorkingDir;
    }

    public void setChangeWorkingDir(boolean bl) {
        boolean bl2 = this.changeWorkingDir;
        this.changeWorkingDir = bl;
    }

    public boolean getUseFileNameOnly() {
        return this.useFileNameOnly;
    }

    public void setUseFileNameOnly(boolean bl) {
        boolean bl2 = this.useFileNameOnly;
        this.useFileNameOnly = bl;
    }

    public String getTarget() {
        return this.target;
    }

    public synchronized void setTarget(String string) {
        String string2 = this.target;
        this.target = string;
    }

    public boolean getIncludeFileExtension() {
        return this.includeFileExtension;
    }

    public void setIncludeFileExtension(boolean bl) {
        boolean bl2 = this.includeFileExtension;
        this.includeFileExtension = bl;
    }

    public boolean getUseUnixFilePath() {
        return this.useUnixFilePath;
    }

    public void setUseUnixFilePath(boolean bl) {
        boolean bl2 = this.useUnixFilePath;
        this.useUnixFilePath = bl;
    }

    public ExecutorTask execute(DataObject dataObject) throws IOException {
        this.createDefaultMapFormat(dataObject);
        return super.execute(dataObject);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.distributed.RemoteExecutor");
    }

    public String getWorkingDirectory(File file, DataObject dataObject) {
        String string = null;
        if (this.workingDirectory != null) {
            if (Utilities.isWindows()) {
                string = RemoteFSUtils.__winPathToOpenVMSPath((String)this.workingDirectory.getAbsolutePath(), (boolean)true);
                string = FileUtility.openVMSPathToUnixPath((String)string, (boolean)true);
            } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                string = FileUtility.unixPathToOpenVMSPath((String)this.workingDirectory.getAbsolutePath(), (boolean)true);
            }
        } else if (Utilities.isWindows()) {
            string = RemoteFSUtils._winPathToOpenVMSPath((String)file.getAbsolutePath(), (boolean)true, (FileObject)dataObject.getPrimaryFile().getParent());
        } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
            string = RemoteFSUtils.unixPathToOpenVMSPath((String)file.getAbsolutePath(), (boolean)true, (FileObject)dataObject.getPrimaryFile().getParent());
        }
        return string;
    }
}

