/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteexecute;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.text.Format;
import java.util.List;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.remoteexecute.OutputWriterOutputStream;
import org.netbeans.modules.distributed.remoteexecute.ReaderCharSequence;
import org.netbeans.modules.distributed.remoteexecute.RemoteExecute;
import org.netbeans.modules.distributed.remoteexecute.RemoteProcessDescriptor;
import org.netbeans.modules.distributed.remotefs.smb.NetworkFileSystem;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.compiler.ExternalCompiler;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class TargetExecutor
implements Runnable {
    private RemoteRuntimeType rrt;
    private RemoteProcessDescriptor rpd;
    private InputOutput io;
    private MapFormat format;
    private boolean ok = false;
    private boolean useXterm = false;
    private List targetNames;
    private boolean switchWorkspace = false;
    private ExternalCompiler.ErrorExpression errExp;
    private String cwd;
    private String name;
    private DataObject dobj;
    private int displayNumber;

    public TargetExecutor(RemoteRuntimeType remoteRuntimeType, RemoteProcessDescriptor remoteProcessDescriptor, ExternalCompiler.ErrorExpression errorExpression, boolean bl, MapFormat mapFormat, String string, DataObject dataObject, int n) {
        this.rrt = remoteRuntimeType;
        this.rpd = remoteProcessDescriptor;
        this.errExp = errorExpression;
        this.format = mapFormat;
        this.useXterm = bl;
        this.cwd = string;
        this.dobj = dataObject;
        this.displayNumber = n;
    }

    public void setSwitchWorkspace(boolean bl) {
        this.switchWorkspace = bl;
    }

    public ExecutorTask execute() throws IOException {
        return this.execute(null);
    }

    public ExecutorTask execute(String string) throws IOException {
        this.name = string;
        this.io = IOProvider.getDefault().getIO(string, false);
        this.io.getOut().reset();
        this.io.select();
        this.io.setFocusTaken(true);
        this.io.setErrVisible(false);
        this.io.setErrSeparated(false);
        try {
            if (this.dobj.getPrimaryFile().getFileSystem() instanceof NetworkFileSystem) {
                Thread.currentThread();
                Thread.sleep(3000L);
            } else {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        StatusDisplayer.getDefault().setStatusText("Starting (" + string + ")");
        ExecutorTask executorTask = this.createExecutorTask(string, new PERunnable(string));
        return executorTask;
    }

    ExecutorTask createExecutorTask(String string, PERunnable pERunnable) throws IOException {
        PERunnable pERunnable2 = pERunnable;
        synchronized (pERunnable2) {
            ExecutorTask executorTask = ExecutionEngine.getDefault().execute(string, (Runnable)pERunnable, this.io);
            pERunnable.setExecutorTask(executorTask);
            try {
                pERunnable.wait();
                Throwable throwable = pERunnable.getException();
                if (throwable != null) {
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    if (throwable instanceof IOException) {
                        throw (IOException)throwable;
                    }
                    IOException iOException = new IOException(throwable.getMessage());
                    ErrorManager.getDefault().copyAnnotation((Throwable)iOException, throwable);
                    throw iOException;
                }
                return pERunnable.getExecutorTask();
            }
            catch (InterruptedException interruptedException) {
                IOException iOException = new IOException(interruptedException.getMessage());
                StatusDisplayer.getDefault().setStatusText("Error (" + string + ") : " + interruptedException.getMessage());
                ErrorManager.getDefault().copyAnnotation((Throwable)iOException, (Throwable)interruptedException);
                throw iOException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        this.io.setFocusTaken(true);
        this.io.setErrVisible(false);
        this.io.setErrSeparated(false);
        try {
            this.ok = true;
        }
        catch (ThreadDeath threadDeath) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)TargetExecutor.class, (String)"MSG_target_failed_status"));
            return;
        }
        catch (Exception exception) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)TargetExecutor.class, (String)"MSG_target_failed_status"));
        }
    }

    private static class WrapperRunnable
    implements Runnable {
        private ExecutorTask task;

        public WrapperRunnable(ExecutorTask executorTask) {
            this.task = executorTask;
        }

        public void run() {
            this.task.waitFinished();
        }
    }

    private class WrapperExecutorTask
    extends ExecutorTask {
        private ExecutorTask task;

        public WrapperExecutorTask(ExecutorTask executorTask) {
            super((Runnable)new WrapperRunnable(executorTask));
            this.task = executorTask;
        }

        public void stop() {
            this.task.stop();
        }

        public int result() {
            return this.task.result() + (TargetExecutor.this.ok ? 0 : 1);
        }

        public InputOutput getInputOutput() {
            return TargetExecutor.this.io;
        }
    }

    private class CopyMaker
    extends Thread {
        final Writer os;
        final Reader is;
        final boolean autoflush;
        final String permName;
        private boolean done = false;
        private ExternalCompiler.ErrorExpression errExp;
        boolean streamDone = false;

        CopyMaker(Reader reader, Writer writer, boolean bl, String string, ExternalCompiler.ErrorExpression errorExpression) {
            this.os = writer;
            this.is = reader;
            this.errExp = errorExpression;
            this.autoflush = bl;
            this.permName = string;
        }

        public boolean isDone() {
            return this.streamDone;
        }

        public void run() {
            char c;
            BufferedReader bufferedReader = new BufferedReader(this.is);
            StringBuffer stringBuffer = new StringBuffer();
            PrintStream printStream = new PrintStream(new OutputWriterOutputStream(TargetExecutor.this.io.getOut(), this.errExp));
            ReaderCharSequence readerCharSequence = new ReaderCharSequence(bufferedReader, 4096, Integer.MAX_VALUE, 1.3333334f);
            for (int i = 0; i < readerCharSequence.length() && (c = readerCharSequence.charAt(i)) != '\uffff'; ++i) {
                printStream.print(c);
                if (c != '\n') continue;
                printStream.flush();
            }
            this.streamDone = true;
            printStream.flush();
        }

        public void interrupt() {
            super.interrupt();
            this.done = true;
        }

        private int read(Reader reader, char[] cArray, int n, int n2) throws InterruptedException, IOException {
            return reader.read();
        }
    }

    static class ExternalExecutorTask
    extends ExecutorTask
    implements RemoteExecute {
        Process proc;
        Thread[] copyMakers;
        ExecutorTask foreign;

        ExternalExecutorTask(Runnable runnable, ExecutorTask executorTask, Process process, Thread[] threadArray) {
            super(runnable);
            this.proc = process;
            this.copyMakers = threadArray;
            this.foreign = executorTask;
            TaskListener taskListener = new TaskListener(){

                public void taskFinished(Task task) {
                    ExternalExecutorTask.this.stop();
                }
            };
            executorTask.addTaskListener(taskListener);
            new Thread(){

                public void run() {
                    ExternalExecutorTask.this.result();
                }
            }.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            try {
                this.copyMakers[0].interrupt();
                this.copyMakers[1].interrupt();
            }
            finally {
                this.proc.destroy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int result() {
            try {
                int n = this.proc.waitFor();
                while (!((CopyMaker)this.copyMakers[0]).isDone() || !((CopyMaker)this.copyMakers[1]).isDone()) {
                    Thread.sleep(2000L);
                }
                int n2 = n;
                return n2;
            }
            catch (InterruptedException interruptedException) {
                int n = 1;
                return n;
            }
            finally {
                this.stop();
                this.notifyFinished();
            }
        }

        public InputOutput getInputOutput() {
            return this.foreign.getInputOutput();
        }

        public void run() {
        }
    }

    private class PERunnable
    implements Runnable,
    TaskListener {
        private DataObject obj;
        private ExecutorTask fromEngine;
        ExecutorTask fromMe;
        private Throwable t;
        private String name;

        PERunnable(String string) {
            this.name = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            try {
                String string = this.name;
                String string2 = Utils.getIntendedHostAddress();
                if (TargetExecutor.this.useXterm) {
                    string2 = string2 + ":" + TargetExecutor.this.displayNumber;
                }
                Process process = TargetExecutor.this.rpd.getProcessName().equals("") ? TargetExecutor.this.rpd.exec(TargetExecutor.this.rpd.getCmds(), TargetExecutor.this.rrt, null, null, TargetExecutor.this.useXterm, string2, TargetExecutor.this.rrt.getSecurityContext()) : TargetExecutor.this.rpd.exec((Format)TargetExecutor.this.format, TargetExecutor.this.rrt, TargetExecutor.this.useXterm, TargetExecutor.this.cwd, string2);
                Thread[] threadArray = new Thread[2];
                threadArray[0] = new CopyMaker(new InputStreamReader(process.getInputStream()), (Writer)this.fromEngine.getInputOutput().getOut(), false, string, TargetExecutor.this.errExp);
                threadArray[0].start();
                threadArray[1] = new CopyMaker(new InputStreamReader(process.getErrorStream()), (Writer)this.fromEngine.getInputOutput().getErr(), false, string, TargetExecutor.this.errExp);
                threadArray[1].start();
                this.fromMe = new ExternalExecutorTask(this, this.fromEngine, process, threadArray);
                TaskListener taskListener = new TaskListener(){

                    public void taskFinished(Task task) {
                        StatusDisplayer.getDefault().setStatusText("Finished (" + PERunnable.this.name + ")");
                        PERunnable.this.fromEngine.getInputOutput().getOut().print("Finished (" + PERunnable.this.name + ")");
                        TargetExecutor.this.dobj.getPrimaryFile().getParent().refresh();
                    }
                };
                this.fromEngine.addTaskListener(taskListener);
            }
            catch (Exception exception) {
                this.t = exception;
                StatusDisplayer.getDefault().setStatusText("Error (" + this.name + ") : " + exception.getMessage());
            }
            finally {
                this.notifyAll();
            }
        }

        public void setExecutorTask(ExecutorTask executorTask) {
            this.fromEngine = executorTask;
            executorTask.addTaskListener((TaskListener)this);
        }

        public ExecutorTask getExecutorTask() {
            return this.fromMe;
        }

        public Throwable getException() {
            return this.t;
        }

        public void taskFinished(Task task) {
            if (this.fromMe != null) {
                this.fromMe.stop();
            }
        }
    }
}

