/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteexecute;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.RemoteFSUtils;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.smb.NetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.smb.NetworkJarFileSystem;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Utilities;

public final class RemoteNbClassPath
implements Serializable {
    static final long serialVersionUID = 7114326612132814401L;
    private Object[] items;
    private String classpath;

    public RemoteNbClassPath(String[] stringArray) {
        this.items = stringArray;
    }

    public RemoteNbClassPath(File[] fileArray) {
        this.items = fileArray;
    }

    private RemoteNbClassPath(Object[] objectArray) {
        this.items = objectArray;
    }

    protected void finalize() throws Throwable {
    }

    public RemoteNbClassPath(NbClassPath nbClassPath) {
        Vector<String> vector = new Vector<String>();
        String string = nbClassPath.getClassPath();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            FileSystem fileSystem;
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("\"")) {
                string2 = string2.substring(1);
            }
            if (string2.endsWith("\"")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if ((fileSystem = RemoteNbClassPath.matchRemoteFS(string2)) == null) continue;
            vector.add(string2);
        }
        this.items = vector.toArray();
    }

    public RemoteNbClassPath(String string) {
        this.items = new Exception[0];
        this.classpath = string;
        if (string.indexOf(32) >= 0) {
            if (string.startsWith("\"")) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.insert(0, '\"');
            stringBuffer.append('\"');
            this.classpath = stringBuffer.toString();
        }
    }

    public static FileSystem matchRemoteFS(String string) {
        FileObject[] fileObjectArray = FileUtil.fromFile((File)new File(string));
        for (int i = 0; i < fileObjectArray.length; ++i) {
            try {
                if (!(fileObjectArray[i].getFileSystem() instanceof NetworkFileSystem) && !(fileObjectArray[i].getFileSystem() instanceof NetworkJarFileSystem) && !(fileObjectArray[i].getFileSystem() instanceof FTPFileSystem)) continue;
                return fileObjectArray[i].getFileSystem();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        Iterator iterator = OpenProjectList.getFsSet().iterator();
        while (iterator.hasNext()) {
            NetworkJarFileSystem networkJarFileSystem;
            Object e = iterator.next();
            if (!(e instanceof NetworkJarFileSystem) || !string.equals((networkJarFileSystem = (NetworkJarFileSystem)e).getJarFile().getAbsolutePath())) continue;
            return networkJarFileSystem;
        }
        return null;
    }

    public static FileSystem[] createRemoteFSRepositryFS(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            FileSystem fileSystem = RemoteNbClassPath.matchRemoteFS(stringArray[i]);
            if (fileSystem == null) continue;
            vector.add(stringArray[i]);
        }
        if (vector.size() > 0) {
            return (FileSystem[])vector.toArray();
        }
        return null;
    }

    public static String[] createRemoteFSRepositry(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            FileSystem fileSystem = RemoteNbClassPath.matchRemoteFS(stringArray[i]);
            if (fileSystem == null) continue;
            vector.add(stringArray[i]);
        }
        if (vector.size() > 0) {
            return (String[])vector.toArray();
        }
        return null;
    }

    public static RemoteNbClassPath createRepositoryPath() {
        return RemoteNbClassPath.createRepositoryPath(FileSystemCapability.ALL);
    }

    public static RemoteNbClassPath createRepositoryPath(FileSystemCapability fileSystemCapability) {
        LinkedList<EnvironmentNotSupportedException> linkedList = new LinkedList<EnvironmentNotSupportedException>();
        final class Env
        extends FileSystem.Environment {
            private final /* synthetic */ LinkedList val$res;

            Env(LinkedList linkedList) {
                this.val$res = linkedList;
            }

            public void addClassPath(String string) {
                this.val$res.add(string);
            }
        }
        Env env = new Env(linkedList);
        Enumeration enumeration = fileSystemCapability.fileSystems();
        Object var4_4 = null;
        while (enumeration.hasMoreElements()) {
            try {
                FileSystem fileSystem = (FileSystem)enumeration.nextElement();
                if (!(fileSystem instanceof AbstractNetworkFileSystem) && !(fileSystem instanceof NetworkJarFileSystem)) continue;
                fileSystem.prepareEnvironment((FileSystem.Environment)env);
            }
            catch (EnvironmentNotSupportedException environmentNotSupportedException) {
                linkedList.add(environmentNotSupportedException);
            }
        }
        return new RemoteNbClassPath(linkedList.toArray());
    }

    public static RemoteNbClassPath createLibraryPath() {
        return new RemoteNbClassPath(new File[0]);
    }

    public static RemoteNbClassPath createClassPath() {
        String string = System.getProperty("java.class.path");
        if (string == null || string.length() == 0) {
            return new RemoteNbClassPath("");
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.endsWith("openide-compat.jar")) continue;
            if (bl) {
                stringBuffer.append(File.pathSeparatorChar);
            } else {
                bl = true;
            }
            stringBuffer.append(string2);
        }
        return new RemoteNbClassPath(stringBuffer.toString());
    }

    public static RemoteNbClassPath createBootClassPath() {
        String string = System.getProperty("sun.boot.class.path");
        StringBuffer stringBuffer = string != null ? new StringBuffer(string) : new StringBuffer();
        String string2 = System.getProperty("java.ext.dirs");
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                File file = new File(stringTokenizer.nextToken());
                File[] fileArray = file.listFiles();
                if (fileArray == null) continue;
                for (int i = 0; i < fileArray.length; ++i) {
                    String string3 = fileArray[i].getName().toLowerCase(Locale.US);
                    if (!string3.endsWith(".zip") && !string3.endsWith(".jar")) continue;
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(File.pathSeparatorChar);
                    }
                    stringBuffer.append(fileArray[i].getPath());
                }
            }
        }
        return new RemoteNbClassPath(stringBuffer.toString());
    }

    public static File toFile(FileObject fileObject) {
        String string = fileObject.getPath().replace('/', File.separatorChar);
        final class Env
        extends FileSystem.Environment {
            public File found;
            private final /* synthetic */ String val$pne;

            Env(String string) {
                this.val$pne = string;
            }

            public void addClassPath(String string) {
                if (this.found != null) {
                    return;
                }
                File file = new File(string);
                if (!file.isDirectory()) {
                    return;
                }
                File file2 = new File(file, this.val$pne);
                if (file2.exists()) {
                    this.found = file2;
                }
            }
        }
        Env env = new Env(string);
        try {
            fileObject.getFileSystem().prepareEnvironment((FileSystem.Environment)env);
            return env.found;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception[] getExceptions() {
        try {
            return (Exception[])this.items;
        }
        catch (ClassCastException classCastException) {
            RemoteNbClassPath remoteNbClassPath = this;
            synchronized (remoteNbClassPath) {
                this.getClassPath();
                int n = 0;
                for (int i = 0; i < this.items.length; ++i) {
                    if (this.items[i] == null) continue;
                    this.items[n++] = this.items[i];
                }
                Exception[] exceptionArray = new Exception[n];
                System.arraycopy(this.items, 0, exceptionArray, 0, n);
                this.items = exceptionArray;
                return exceptionArray;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRemoteClassPath(DataObject dataObject) {
        RemoteNbClassPath remoteNbClassPath = this;
        synchronized (remoteNbClassPath) {
            Object object;
            Serializable serializable;
            if (this.classpath != null) {
                serializable = new Vector();
                StringTokenizer stringTokenizer = new StringTokenizer(this.classpath, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                    if (((String)object).startsWith("\"")) {
                        object = ((String)object).substring(1);
                    }
                    if (((String)object).endsWith("\"")) {
                        object = ((String)object).substring(0, ((String)object).length() - 1);
                    }
                    ((Vector)serializable).add(object);
                }
                this.items = ((Vector)serializable).toArray();
            }
            serializable = new StringBuffer();
            for (int i = 0; i < this.items.length; ++i) {
                object = new File((String)this.items[i]);
                FileSystem fileSystem = RemoteNbClassPath.matchRemoteFS((String)this.items[i]);
                if (fileSystem != null) {
                    try {
                        AbstractNetworkFileSystem abstractNetworkFileSystem = (AbstractNetworkFileSystem)fileSystem;
                        RemoteRuntimeType remoteRuntimeType = abstractNetworkFileSystem.getRemoteRuntimeType();
                        if (remoteRuntimeType == null || ((AbstractNetworkFileSystem)dataObject.getPrimaryFile().getFileSystem()).getRemoteRuntimeType() == null || !remoteRuntimeType.equals((Object)((AbstractNetworkFileSystem)dataObject.getPrimaryFile().getFileSystem()).getRemoteRuntimeType())) continue;
                        String string = Utilities.isWindows() ? RemoteFSUtils.__winPathToOpenVMSPath((String)((String)this.items[i]), (boolean)((File)object).isDirectory()) : RemoteFSUtils.__unixPathToOpenVMSPath((String)((String)this.items[i]), (boolean)((File)object).isDirectory());
                        string = FileUtility.openVMSPathToUnixPath((String)string, (boolean)((File)object).isDirectory());
                        ((StringBuffer)serializable).append(string);
                        if (this.items.length - 1 <= i) continue;
                        ((StringBuffer)serializable).append(":");
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {}
                    continue;
                }
                ((StringBuffer)serializable).append((String)this.items[i]);
                if (this.items.length - 1 <= i) continue;
                ((StringBuffer)serializable).append(":");
            }
            return ((StringBuffer)serializable).toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRemoteClassPath() {
        RemoteNbClassPath remoteNbClassPath = this;
        synchronized (remoteNbClassPath) {
            Object object;
            Serializable serializable;
            if (this.classpath != null) {
                serializable = new Vector();
                StringTokenizer stringTokenizer = new StringTokenizer(this.classpath, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                    if (((String)object).startsWith("\"")) {
                        object = ((String)object).substring(1);
                    }
                    if (((String)object).endsWith("\"")) {
                        object = ((String)object).substring(0, ((String)object).length() - 1);
                    }
                    ((Vector)serializable).add(object);
                }
                this.items = ((Vector)serializable).toArray();
            }
            serializable = new StringBuffer();
            for (int i = 0; i < this.items.length; ++i) {
                object = new File((String)this.items[i]);
                String string = Utilities.isWindows() ? RemoteFSUtils.__winPathToOpenVMSPath((String)((String)this.items[i]), (boolean)((File)object).isDirectory()) : RemoteFSUtils.__unixPathToOpenVMSPath((String)((String)this.items[i]), (boolean)((File)object).isDirectory());
                string = FileUtility.openVMSPathToUnixPath((String)string, (boolean)((File)object).isDirectory());
                ((StringBuffer)serializable).append(string);
                if (this.items.length - 1 <= i) continue;
                ((StringBuffer)serializable).append(":");
            }
            return ((StringBuffer)serializable).toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClassPath() {
        if (this.classpath != null) {
            return this.classpath;
        }
        RemoteNbClassPath remoteNbClassPath = this;
        synchronized (remoteNbClassPath) {
            if (this.classpath != null) {
                return this.classpath;
            }
            if (this.items.length == 0) {
                this.classpath = "";
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            for (int i = 0; i < this.items.length; ++i) {
                Object object = this.items[i];
                if (object == null || !(object instanceof String) && !(object instanceof File)) continue;
                if (bl) {
                    stringBuffer.append(File.pathSeparatorChar);
                } else {
                    bl = true;
                }
                stringBuffer.append(object.toString());
                this.items[i] = null;
            }
            String string = stringBuffer.toString();
            if (string.indexOf(32) >= 0) {
                stringBuffer.insert(0, '\"');
                stringBuffer.append('\"');
                this.classpath = stringBuffer.toString();
            } else {
                this.classpath = string;
            }
            return this.classpath;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof RemoteNbClassPath)) {
            return false;
        }
        RemoteNbClassPath remoteNbClassPath = (RemoteNbClassPath)object;
        return this.getClassPath().equals(remoteNbClassPath.getClassPath());
    }
}

