/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteexecute;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.distributed.common.propertyeditors.ErrorExpressionEditor2;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.remoteexecute.RemoteProcessDescriptor;
import org.netbeans.modules.distributed.remoteexecute.TargetExecutor;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.RemoteFSUtils;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.compiler.ExternalCompiler;
import org.openide.execution.ExecutorTask;
import org.openide.execution.NbClassPath;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public abstract class RemoteExecutor {
    private static final long serialVersionUID = 4921782425419448313L;
    public static final String PROP_REMOTE_EXECUTOR = "remoteExecutor";
    public static final String TAG_FILE = "file";
    public static final String TAG_CURRENT_DIR = "current dir";
    public static final String TAG_ARGUMENTS = "arguments";
    public static final String TAG_ROOT_DIR = "root dir";
    public static final String TAG_FILENAME = "file name";
    public static final String TAG_EXT = "file extension";
    public static final String TAG_DEVICE = "device";
    public static final String TAG_DIRECTORY = "directory";
    public static final String TAG_JAVA_CLASSNAME = "java class";
    public static final String PROP_ERROR_EXPRESSION = "errorExpression";
    public static final String PROP_CHANGE_WORKING_DIR = "changeWorkingDir";
    protected ExternalCompiler.ErrorExpression errorExpression = ErrorExpressionEditor2.errorExpression;
    protected RemoteProcessDescriptor remoteExecutor;
    protected boolean useXterm;
    protected boolean includeFileExtension;
    protected boolean useUnixFilePath;
    protected boolean changeWorkingDir;
    protected boolean useFileNameOnly;
    protected File workingDirectory = null;
    protected MapFormat format;
    private static final ResourceBundle bundle = NbBundle.getBundle((Class)RemoteExecutor.class);

    public ExternalCompiler.ErrorExpression getErrorExpression() {
        return this.errorExpression;
    }

    public void setErrorExpression(ExternalCompiler.ErrorExpression errorExpression) {
        if (errorExpression == null) {
            throw new IllegalArgumentException();
        }
        ExternalCompiler.ErrorExpression errorExpression2 = this.errorExpression;
        this.errorExpression = errorExpression;
    }

    public boolean getChangeWorkingDir() {
        return this.changeWorkingDir;
    }

    public void setChangeWorkingDir(boolean bl) {
        boolean bl2 = this.changeWorkingDir;
        this.changeWorkingDir = bl;
    }

    public RemoteProcessDescriptor getRemoteExecutor() {
        return this.getExternalExecutor();
    }

    public synchronized RemoteProcessDescriptor getExternalExecutor() {
        if (this.remoteExecutor == null) {
            this.remoteExecutor = new RemoteProcessDescriptor("run ", " {arguments} {file}", NbBundle.getBundle((Class)RemoteExecutor.class).getString("MSG_RemoteExecutorHint"));
        }
        return this.remoteExecutor;
    }

    public void setRemoteExecutor(RemoteProcessDescriptor remoteProcessDescriptor) {
        this.setExternalExecutor(remoteProcessDescriptor);
    }

    public void setExternalExecutor(RemoteProcessDescriptor remoteProcessDescriptor) {
        this.remoteExecutor = remoteProcessDescriptor;
    }

    protected MapFormat createMapFormat(DataObject dataObject, AbstractNetworkFileSystem abstractNetworkFileSystem) throws IOException {
        Object object;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        FileObject fileObject = dataObject.getPrimaryFile();
        String string = (String)fileObject.getAttribute("REMOTE_ARGUMENT");
        if (string != null && string.length() > 0) {
            hashMap.put(TAG_ARGUMENTS, string);
        } else {
            hashMap.put(TAG_ARGUMENTS, "");
        }
        String string2 = fileObject.getPath();
        string2 = string2.replace('/', '.');
        if (string2.lastIndexOf(46) > 0) {
            string2 = string2.substring(0, string2.lastIndexOf(46));
        }
        hashMap.put(TAG_JAVA_CLASSNAME, string2);
        File file = FileUtil.toFile((FileObject)fileObject);
        String string3 = "";
        if (Utilities.isWindows()) {
            string3 = RemoteFSUtils._winPathToOpenVMSPath((String)file.getAbsolutePath(), (boolean)false, (FileObject)fileObject);
        } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
            string3 = RemoteFSUtils.unixPathToOpenVMSPath((String)file.getAbsolutePath(), (boolean)false, (FileObject)fileObject);
        }
        String string4 = (String)fileObject.getAttribute("REMOTE_FILEPATH");
        if (string4 == null || string4.length() == 0) {
            object = FileUtil.toFile((FileObject)fileObject.getParent());
            if (Utilities.isWindows()) {
                string4 = RemoteFSUtils._winPathToOpenVMSPath((String)((File)object).getAbsolutePath(), (boolean)true, (FileObject)fileObject.getParent());
            } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                string4 = RemoteFSUtils.unixPathToOpenVMSPath((String)((File)object).getAbsolutePath(), (boolean)true, (FileObject)fileObject.getParent());
            }
        }
        hashMap.put(TAG_CURRENT_DIR, string4);
        object = abstractNetworkFileSystem.getRemoteRoot();
        hashMap.put(TAG_ROOT_DIR, object);
        hashMap.put(TAG_FILE, string3);
        String string5 = string4 + fileObject.getName();
        String string6 = string3.indexOf(":") > 0 ? string3.substring(0, string3.indexOf(":")) : string3;
        hashMap.put(TAG_FILENAME, string5);
        hashMap.put(TAG_EXT, fileObject.getExt());
        hashMap.put(TAG_DEVICE, string6);
        hashMap.put(TAG_DIRECTORY, string4);
        MapFormat mapFormat = new MapFormat(hashMap);
        mapFormat.setLeftBrace("{");
        mapFormat.setRightBrace("}");
        return mapFormat;
    }

    public abstract boolean isRemoteJavaCompile();

    public ExecutorTask execute(DataObject dataObject) throws IOException {
        NbProcessDescriptor nbProcessDescriptor;
        Object object;
        AbstractNetworkFileSystem abstractNetworkFileSystem = null;
        RemoteRuntimeType remoteRuntimeType = null;
        try {
            abstractNetworkFileSystem = (AbstractNetworkFileSystem)dataObject.getPrimaryFile().getFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        remoteRuntimeType = abstractNetworkFileSystem.getRemoteRuntimeType();
        if (abstractNetworkFileSystem == null || !(abstractNetworkFileSystem instanceof AbstractNetworkFileSystem)) {
            IOException iOException = new IOException("The file " + dataObject.getNodeDelegate().getDisplayName() + " is not a remote file");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)bundle.getString("EXC_no_remote_execution"), 2));
            ErrorManager.getDefault().annotate((Throwable)iOException, 1, null, null, null, null);
            throw iOException;
        }
        if (remoteRuntimeType == null) {
            IOException iOException = new IOException("");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"No matching remote server is found.\n Please go to Runtime Tab and create remote server", 2));
            ErrorManager.getDefault().annotate((Throwable)iOException, 1, null, null, null, null);
            throw iOException;
        }
        if (remoteRuntimeType.getRemoteRuntime() == null) {
            IOException iOException = new IOException("");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"Remote server is diconnected.\n Please go to Runtime Tab and make connection", 2));
            ErrorManager.getDefault().annotate((Throwable)iOException, 1, null, null, null, null);
            throw iOException;
        }
        File file = FileUtil.toFile((FileObject)dataObject.getPrimaryFile().getParent());
        String string = null;
        if (this.getChangeWorkingDir()) {
            string = this.getWorkingDirectory(file, dataObject);
        }
        boolean bl = false;
        Boolean bl2 = null;
        int n = 0;
        bl2 = this.isRemoteJavaCompile() ? (Boolean)dataObject.getPrimaryFile().getAttribute("useXtermCompile") : (Boolean)dataObject.getPrimaryFile().getAttribute("useXtermExecution");
        bl = bl2 != null ? bl2 : (this.isRemoteJavaCompile() ? abstractNetworkFileSystem.getUseXtermCompile() : abstractNetworkFileSystem.getUseXtermExecution());
        if (bl) {
            object = (Integer)dataObject.getPrimaryFile().getAttribute("xDisplayDeviceNumber");
            n = object != null ? ((Integer)object).intValue() : abstractNetworkFileSystem.getXDisplayDeviceNumber();
        }
        if (bl && Utilities.isWindows() && (object = DistributedSettings.getDefault().getXServer()) != null && ((String)object).length() > 0) {
            try {
                Runtime.getRuntime().exec((String)object);
            }
            catch (IOException iOException) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"Problem launching X Window sever on your desktop.", 2));
                ErrorManager.getDefault().annotate((Throwable)iOException, 1, null, null, null, null);
                throw iOException;
            }
        }
        object = dataObject.getPrimaryFile().getMIMEType().endsWith("ant+xml") ? ((nbProcessDescriptor = (NbProcessDescriptor)dataObject.getPrimaryFile().getAttribute("externalCompiler")) != null ? new RemoteProcessDescriptor(nbProcessDescriptor.getProcessName(), nbProcessDescriptor.getArguments(), "") : this.getRemoteExecutor()) : this.getRemoteExecutor();
        nbProcessDescriptor = FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile());
        String string2 = "";
        if (nbProcessDescriptor != null) {
            string2 = ProjectUtils.getInformation((Project)nbProcessDescriptor).getDisplayName();
        }
        TargetExecutor targetExecutor = new TargetExecutor(remoteRuntimeType, (RemoteProcessDescriptor)object, this.getErrorExpression(), bl, this.format, string, dataObject, n);
        return targetExecutor.execute(string2 + " (" + dataObject.getPrimaryFile().getNameExt() + ")");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.distributed.RemoteExecutor");
    }

    public String getWorkingDirectory(File file, DataObject dataObject) {
        String string = null;
        if (this.workingDirectory != null) {
            if (Utilities.isWindows()) {
                string = RemoteFSUtils.__winPathToOpenVMSPath((String)this.workingDirectory.getAbsolutePath(), (boolean)true);
                string = FileUtility.openVMSPathToUnixPath((String)string, (boolean)true);
            } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                string = FileUtility.unixPathToOpenVMSPath((String)this.workingDirectory.getAbsolutePath(), (boolean)true);
            }
        } else if (Utilities.isWindows()) {
            string = RemoteFSUtils._winPathToOpenVMSPath((String)file.getAbsolutePath(), (boolean)true, (FileObject)dataObject.getPrimaryFile().getParent());
        } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
            string = RemoteFSUtils.unixPathToOpenVMSPath((String)file.getAbsolutePath(), (boolean)true, (FileObject)dataObject.getPrimaryFile().getParent());
        }
        return string;
    }

    public static void disconnectRemoteProcesses() {
    }

    public static class Format
    extends MapFormat {
        public static final String TAG_CLASSPATH = "classpath";
        public static final String TAG_BOOTCLASSPATH = "bootclasspath";
        public static final String TAG_REPOSITORY = "filesystems";
        public static final String TAG_LIBRARY = "library";
        public static final String TAG_CLASSNAME = "classname";
        public static final String TAG_ARGUMENTS = "arguments";
        public static final String TAG_JAVAHOME = "java.home";
        public static final String TAG_JDKHOME = "jdk.home";
        public static final String TAG_SEPARATOR = "/";
        public static final String TAG_PATHSEPARATOR = ":";
        static final long serialVersionUID = 1105067849363827986L;

        public Format() {
            this(NbClassPath.createClassPath(), NbClassPath.createBootClassPath(), NbClassPath.createRepositoryPath((FileSystemCapability)FileSystemCapability.EXECUTE), NbClassPath.createLibraryPath());
        }

        public Format(NbClassPath nbClassPath, NbClassPath nbClassPath2, NbClassPath nbClassPath3, NbClassPath nbClassPath4) {
            super(new HashMap(7));
            Map map = this.getMap();
            map.put(TAG_CLASSPATH, nbClassPath.getClassPath());
            map.put(TAG_BOOTCLASSPATH, nbClassPath2.getClassPath());
            map.put(TAG_REPOSITORY, nbClassPath3.getClassPath());
            map.put(TAG_LIBRARY, nbClassPath4.getClassPath());
            map.put(TAG_JAVAHOME, System.getProperty(TAG_JAVAHOME));
            map.put(TAG_JDKHOME, System.getProperty(TAG_JDKHOME));
            map.put(TAG_SEPARATOR, File.separator);
            map.put(TAG_PATHSEPARATOR, File.pathSeparator);
        }
    }
}

