/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.debugger;

import com.hp.openvms.netbeans.debugsupport.breakpoints.DebuggerAnnotation;
import com.hp.openvms.netbeans.debugsupport.debugger.EditorContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Caret;
import javax.swing.text.StyledDocument;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public class EditorContextImpl
extends EditorContext {
    private static String fronting;
    private PropertyChangeSupport pcs;
    private Map annotationToURL = new HashMap();
    private ChangeListener changedFilesListener;
    private Map timeStampToRegistry = new HashMap();
    private Set modifiedDataObjects;
    private PropertyChangeListener editorObservableListener;
    private Lookup.Result resDataObject;
    private Lookup.Result resEditorCookie;
    private Lookup.Result resNode;
    private Object currentLock = new Object();
    private String currentURL = null;
    private EditorCookie currentEditorCookie = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EditorContextImpl() {
        this.pcs = new PropertyChangeSupport(this);
        this.resDataObject = Utilities.actionsGlobalContext().lookup(new Lookup.Template(DataObject.class));
        this.resDataObject.addLookupListener((LookupListener)new EditorLookupListener(DataObject.class));
        this.resEditorCookie = Utilities.actionsGlobalContext().lookup(new Lookup.Template(EditorCookie.class));
        this.resEditorCookie.addLookupListener((LookupListener)new EditorLookupListener(EditorCookie.class));
        this.resNode = Utilities.actionsGlobalContext().lookup(new Lookup.Template(Node.class));
        this.resNode.addLookupListener((LookupListener)new EditorLookupListener(Node.class));
    }

    public boolean showSource(String string, int n, Object object) {
        Line line = this.getLine(string, n, object);
        if (line == null) {
            return false;
        }
        if (fronting != null) {
            if (fronting.equals("true")) {
                line.show(3);
            } else {
                line.show(2);
            }
            return true;
        }
        if (Utilities.isWindows()) {
            line.show(3);
        } else {
            line.show(2);
        }
        return true;
    }

    public void createTimeStamp(Object object) {
        this.modifiedDataObjects = new HashSet(DataObject.getRegistry().getModifiedSet());
        Registry registry = new Registry();
        this.timeStampToRegistry.put(object, registry);
        Iterator iterator = this.modifiedDataObjects.iterator();
        while (iterator.hasNext()) {
            registry.register((DataObject)iterator.next());
        }
        if (this.changedFilesListener == null) {
            this.changedFilesListener = new ChangedFilesListener();
            DataObject.getRegistry().addChangeListener(this.changedFilesListener);
        }
    }

    public void disposeTimeStamp(Object object) {
        this.timeStampToRegistry.remove(object);
        if (this.timeStampToRegistry.isEmpty()) {
            DataObject.getRegistry().removeChangeListener(this.changedFilesListener);
            this.changedFilesListener = null;
        }
    }

    public Object annotate(String string, int n, String string2, Object object) {
        Line line = this.getLine(string, n, object);
        if (line == null) {
            return null;
        }
        DebuggerAnnotation debuggerAnnotation = new DebuggerAnnotation(string2, line);
        this.annotationToURL.put(debuggerAnnotation, string);
        return debuggerAnnotation;
    }

    public void removeAnnotation(Object object) {
        DebuggerAnnotation debuggerAnnotation = (DebuggerAnnotation)((Object)object);
        debuggerAnnotation.detach();
        if (this.annotationToURL.remove((Object)debuggerAnnotation) == null) {
            return;
        }
    }

    public int getLineNumber(Object object, Object object2) {
        DebuggerAnnotation debuggerAnnotation = (DebuggerAnnotation)((Object)object);
        if (object2 == null) {
            return debuggerAnnotation.getLine().getLineNumber() + 1;
        }
        String string = (String)this.annotationToURL.get((Object)debuggerAnnotation);
        Line.Set set = this.getLineSet(string, object2);
        return set.getOriginalLineNumber(debuggerAnnotation.getLine()) + 1;
    }

    public void updateTimeStamp(Object object, String string) {
        Registry registry = (Registry)this.timeStampToRegistry.get(object);
        registry.register(EditorContextImpl.getDataObject(string));
    }

    public int getCurrentLineNumber() {
        EditorCookie editorCookie = this.getCurrentEditorCookie();
        if (editorCookie == null) {
            return -1;
        }
        JEditorPane jEditorPane = this.getCurrentEditor();
        if (jEditorPane == null) {
            return -1;
        }
        StyledDocument styledDocument = editorCookie.getDocument();
        if (styledDocument == null) {
            return -1;
        }
        Caret caret = jEditorPane.getCaret();
        if (caret == null) {
            return -1;
        }
        int n = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)caret.getDot());
        return n + 1;
    }

    public int getMostRecentLineNumber() {
        EditorCookie editorCookie = this.getMostRecentEditorCookie();
        if (editorCookie == null) {
            return -1;
        }
        JEditorPane jEditorPane = this.getMostRecentEditor();
        if (jEditorPane == null) {
            return -1;
        }
        StyledDocument styledDocument = editorCookie.getDocument();
        if (styledDocument == null) {
            return -1;
        }
        Caret caret = jEditorPane.getCaret();
        if (caret == null) {
            return -1;
        }
        int n = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)caret.getDot());
        return n + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentURL() {
        Object object = this.currentLock;
        synchronized (object) {
            if (this.currentURL == null) {
                DataObject[] dataObjectArray = this.resDataObject.allInstances().toArray(new DataObject[0]);
                this.currentURL = "";
                if (dataObjectArray.length != 1) {
                    return this.currentURL;
                }
                DataObject dataObject = dataObjectArray[0];
                if (dataObject instanceof DataShadow) {
                    dataObject = ((DataShadow)dataObject).getOriginal();
                }
                try {
                    this.currentURL = dataObject.getPrimaryFile().getURL().toString();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
            return this.currentURL;
        }
    }

    public String getMostRecentURL() {
        Node[] nodeArray;
        String string = this.getCurrentURL();
        if (string.length() == 0 && (nodeArray = TopComponent.getRegistry().getActivatedNodes()) != null) {
            for (int i = 0; i < nodeArray.length; ++i) {
                DataObject dataObject = (DataObject)nodeArray[i].getCookie(class$org$openide$loaders$DataObject == null ? EditorContextImpl.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (dataObject == null) continue;
                try {
                    string = dataObject.getPrimaryFile().getURL().toExternalForm();
                    break;
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
        }
        return string;
    }

    public String getCurrentFunctionName() {
        return "";
    }

    public String getSelectedFunctionName() {
        EditorCookie editorCookie = this.getCurrentEditorCookie();
        if (editorCookie == null) {
            return "";
        }
        JEditorPane jEditorPane = this.getCurrentEditor();
        if (jEditorPane == null) {
            return "";
        }
        StyledDocument styledDocument = editorCookie.getDocument();
        if (styledDocument == null) {
            return "";
        }
        int n = jEditorPane.getCaret().getDot();
        Object var5_5 = null;
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        int n3 = NbDocument.findLineColumn((StyledDocument)styledDocument, (int)n);
        return "";
    }

    public int getFieldLineNumber(String string, String string2, String string3) {
        DataObject dataObject = EditorContextImpl.getDataObject(string);
        if (dataObject == null) {
            return -1;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentMIMEType() {
        Object object = this.currentLock;
        synchronized (object) {
            FileObject fileObject;
            DataObject[] dataObjectArray = this.resDataObject.allInstances().toArray(new DataObject[0]);
            if (dataObjectArray.length != 1) {
                return "";
            }
            DataObject dataObject = dataObjectArray[0];
            if (dataObject instanceof DataShadow) {
                dataObject = ((DataShadow)dataObject).getOriginal();
            }
            try {
                fileObject = URLMapper.findFileObject((URL)dataObject.getPrimaryFile().getURL());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                fileObject = null;
            }
            return fileObject != null ? fileObject.getMIMEType() : "";
        }
    }

    public String getMostRecentMIMEType() {
        Node[] nodeArray;
        String string = this.getCurrentMIMEType();
        if (string.length() == 0 && (nodeArray = TopComponent.getRegistry().getActivatedNodes()) != null) {
            for (int i = 0; i < nodeArray.length; ++i) {
                DataObject dataObject = (DataObject)nodeArray[i].getCookie(class$org$openide$loaders$DataObject == null ? EditorContextImpl.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (dataObject == null) continue;
                if (dataObject instanceof DataShadow) {
                    dataObject = ((DataShadow)dataObject).getOriginal();
                }
                try {
                    FileObject fileObject = URLMapper.findFileObject((URL)dataObject.getPrimaryFile().getURL());
                    string = fileObject.getMIMEType();
                    break;
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
        }
        return string;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    private JEditorPane getCurrentEditor() {
        EditorCookie editorCookie = this.getCurrentEditorCookie();
        if (editorCookie == null) {
            return null;
        }
        JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
        if (jEditorPaneArray == null || jEditorPaneArray.length < 1) {
            return null;
        }
        return jEditorPaneArray[0];
    }

    private JEditorPane getMostRecentEditor() {
        EditorCookie editorCookie = this.getMostRecentEditorCookie();
        if (editorCookie == null) {
            return null;
        }
        JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
        if (jEditorPaneArray == null || jEditorPaneArray.length < 1) {
            return null;
        }
        return jEditorPaneArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EditorCookie getCurrentEditorCookie() {
        Object object = this.currentLock;
        synchronized (object) {
            if (this.currentEditorCookie == null) {
                TopComponent topComponent = TopComponent.getRegistry().getActivated();
                if (topComponent != null) {
                    this.currentEditorCookie = (EditorCookie)topComponent.getLookup().lookup(EditorCookie.class);
                }
                if (this.currentEditorCookie instanceof EditorCookie.Observable) {
                    if (this.editorObservableListener == null) {
                        this.editorObservableListener = new EditorLookupListener(EditorCookie.Observable.class);
                    }
                    ((EditorCookie.Observable)this.currentEditorCookie).addPropertyChangeListener(this.editorObservableListener);
                }
            }
            return this.currentEditorCookie;
        }
    }

    private EditorCookie getMostRecentEditorCookie() {
        Node[] nodeArray;
        EditorCookie editorCookie = this.getCurrentEditorCookie();
        if (editorCookie == null && (nodeArray = TopComponent.getRegistry().getActivatedNodes()) != null) {
            for (int i = 0; i < nodeArray.length; ++i) {
                editorCookie = (EditorCookie)nodeArray[i].getCookie(class$org$openide$cookies$EditorCookie == null ? EditorContextImpl.class$("org.openide.cookies.EditorCookie") : class$org$openide$cookies$EditorCookie);
                if (editorCookie == null) continue;
                System.err.println("Got it!");
            }
        }
        return editorCookie;
    }

    private Line.Set getLineSet(String string, Object object) {
        Registry registry;
        DataObject dataObject = EditorContextImpl.getDataObject(string);
        if (dataObject == null) {
            return null;
        }
        if (object != null) {
            registry = (Registry)this.timeStampToRegistry.get(object);
            Line.Set set = null;
            try {
                set = registry.getLineSet(dataObject);
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
            }
            if (set != null) {
                return set;
            }
        }
        if ((registry = (LineCookie)dataObject.getCookie(LineCookie.class)) == null) {
            return null;
        }
        return registry.getLineSet();
    }

    private Line getLine(String string, int n, Object object) {
        Line.Set set = this.getLineSet(string, object);
        if (set == null) {
            return null;
        }
        try {
            if (object == null) {
                return set.getCurrent(n - 1);
            }
            return set.getOriginal(n - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    private static DataObject getDataObject(String string) {
        FileObject fileObject;
        if (!($assertionsDisabled || string != null && string.startsWith("file:") || !Boolean.getBoolean("gdb.assertions.enabled"))) {
            throw new AssertionError();
        }
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            if (!$assertionsDisabled && Boolean.getBoolean("gdb.assertions.enabled")) {
                throw new AssertionError();
            }
            return null;
        }
        catch (Exception exception) {
            if (!$assertionsDisabled && Boolean.getBoolean("gdb.assertions.enabled")) {
                throw new AssertionError();
            }
            return null;
        }
        if (fileObject == null) {
            return null;
        }
        try {
            return DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
    }

    static {
        $assertionsDisabled = !EditorContextImpl.class.desiredAssertionStatus();
        fronting = System.getProperty("netbeans.debugger.fronting");
    }

    private class EditorLookupListener
    implements LookupListener,
    PropertyChangeListener {
        private Class type;

        public EditorLookupListener(Class clazz) {
            this.type = clazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent lookupEvent) {
            if (this.type == (class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = EditorContextImpl.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject)) {
                Object object = EditorContextImpl.this.currentLock;
                synchronized (object) {
                    EditorContextImpl.this.currentURL = null;
                    if (EditorContextImpl.this.currentEditorCookie instanceof EditorCookie.Observable) {
                        ((EditorCookie.Observable)EditorContextImpl.this.currentEditorCookie).removePropertyChangeListener(EditorContextImpl.this.editorObservableListener);
                    }
                    EditorContextImpl.this.currentEditorCookie = null;
                }
                EditorContextImpl.this.pcs.firePropertyChange("currentNodes", null, null);
            } else if (this.type == (class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = EditorContextImpl.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie)) {
                Object object = EditorContextImpl.this.currentLock;
                synchronized (object) {
                    EditorContextImpl.this.currentURL = null;
                    if (EditorContextImpl.this.currentEditorCookie instanceof EditorCookie.Observable) {
                        ((EditorCookie.Observable)EditorContextImpl.this.currentEditorCookie).removePropertyChangeListener(EditorContextImpl.this.editorObservableListener);
                    }
                    EditorContextImpl.this.currentEditorCookie = null;
                }
                EditorContextImpl.this.pcs.firePropertyChange("currentNodes", null, null);
            } else if (this.type == (class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = EditorContextImpl.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node)) {
                EditorContextImpl.this.pcs.firePropertyChange("currentNodes", null, null);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("openedPanes")) {
                EditorContextImpl.this.pcs.firePropertyChange("openedPanes", null, null);
            }
        }
    }

    private class ChangedFilesListener
    implements ChangeListener {
        private ChangedFilesListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            HashSet hashSet = new HashSet(DataObject.getRegistry().getModifiedSet());
            hashSet.removeAll(EditorContextImpl.this.modifiedDataObjects);
            Iterator iterator = EditorContextImpl.this.timeStampToRegistry.values().iterator();
            while (iterator.hasNext()) {
                Registry registry = (Registry)iterator.next();
                Iterator iterator2 = hashSet.iterator();
                while (iterator2.hasNext()) {
                    registry.register((DataObject)iterator2.next());
                }
            }
            EditorContextImpl.this.modifiedDataObjects = new HashSet(DataObject.getRegistry().getModifiedSet());
        }
    }

    private static class Registry {
        private Map dataObjectToLineSet = new HashMap();

        private Registry() {
        }

        void register(DataObject dataObject) {
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(class$org$openide$cookies$LineCookie == null ? (class$org$openide$cookies$LineCookie = EditorContextImpl.class$("org.openide.cookies.LineCookie")) : class$org$openide$cookies$LineCookie);
            if (lineCookie == null) {
                return;
            }
            this.dataObjectToLineSet.put(dataObject, lineCookie.getLineSet());
        }

        Line.Set getLineSet(DataObject dataObject) {
            return (Line.Set)this.dataObjectToLineSet.get(dataObject);
        }
    }
}

